<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Download'][$lang['Acat']] = "$file?category=add";
	$module['Download'][$lang['Ecat']] = "$file?category=edit";
	$module['Download'][$lang['Dcat']] = "$file?category=delete";
	$module['Download'][$lang['Rcat']] = "$file?category=order";
	return;
}

$phpbb_root_path = "./../";

require($phpbb_root_path . 'extension.inc');

require('./pagestart.' . $phpEx);

include($phpbb_root_path . 'pafiledb/pafiledb_common.'.$phpEx);




if( isset($HTTP_GET_VARS['category']) || isset($HTTP_POST_VARS['category']) )
{
	$category = (isset($HTTP_POST_VARS['category'])) ? $HTTP_POST_VARS['category'] : $HTTP_GET_VARS['category'];

	switch($category)
	{

		case 'add':
		{

			$template->set_filenames(array(
				'admin' => 'admin/pa_admin_cat_edit.tpl')
			);
        
			if (isset($HTTP_POST_VARS['submit'])) 
			{
				$cat_name = ( isset($HTTP_POST_VARS['cat_name']) ) ? $HTTP_POST_VARS['cat_name'] : '';
				$cat_desc = ( isset($HTTP_POST_VARS['cat_desc']) ) ? $HTTP_POST_VARS['cat_desc'] : '';
				$cat_parent = ( isset($HTTP_POST_VARS['cat_parent']) ) ? intval($HTTP_POST_VARS['cat_parent']) : 0;
				$cat_allow_file = ( isset($HTTP_POST_VARS['cat_allow_file']) ) ? intval($HTTP_POST_VARS['cat_allow_file']) : 0;
				
				if(empty($cat_name))
				{
					message_die(GENERAL_ERROR, $lang['Cat_name_missing']);
				}
				$sql = "SELECT cat_allow_file
					FROM " . PA_CATEGORY_TABLE . "
					WHERE cat_id = $cat_parent";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldn\'t add a new category', '', __LINE__, __FILE__, $sql);
				}

				$row = $db->sql_fetchrow($result);

				if(!$row['cat_allow_file'] && !$cat_allow_file)
				{
					message_die(GENERAL_ERROR, $lang['Cat_conflict']);
				}

				$sql = "INSERT INTO " . PA_CATEGORY_TABLE . " (cat_name, cat_desc, cat_parent, cat_order, cat_allow_file) 
						VALUES('" . str_replace("\'", "''", $cat_name) . "', '" . str_replace("\'", "''", $cat_desc) . "', '" . $cat_parent . "', '0', '" . $cat_allow_file . "')";

				if ( !($db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldn\'t add a new category', '', __LINE__, __FILE__, $sql);
				}

				$cat_id = $db->sql_nextid();

				$sql = "UPDATE " . PA_CATEGORY_TABLE . " 
						SET cat_order = '" . $cat_id . "' 
						WHERE cat_id = '" . $cat_id . "'";

				if ( !($db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Update the order for this category', '', __LINE__, __FILE__, $sql);
				}

				$message = $lang['Catadded'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_category.$phpEx?category=add") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_edit_permissions'], '<a href="' . append_sid("admin_pa_catauth.$phpEx?cat_id=$cat_id") . '">', '</a>');

				message_die(GENERAL_MESSAGE, $message);
			}

			$cat_list .= '<option value="0" selected>' . $lang['None'] . '</option>';
			$cat_list .= jumpmenu('', 'admin', '', 'none_cat');

			$template->assign_block_vars('edit_form', array());

			$template->assign_vars(array(
				'S_CAT_ACTION' => append_sid("admin_pa_category.$phpEx"),
				'ACTION' => $category,
				'CHECKED_YES' => ' checked',
				'L_CAT_TITLE' => $lang['Acattitle'],
				'L_CAT_EXPLAIN' => $lang['Catexplain'],
				'L_CAT_NAME' => $lang['Catname'],
				'L_CAT_NAME_INFO' => $lang['Catnameinfo'],
				'L_CAT_DESC' => $lang['Catdesc'],
				'L_CAT_DESC_INFO' => $lang['Catdescinfo'],
				'L_CAT_PARENT' => $lang['Catparent'],
				'L_CAT_PARENTINFO' => $lang['Catparentinfo'],
				'L_CAT_ALLOWFILE' => $lang['Allow_file'],
				'L_CAT_ALLOWFILE_INFO' => $lang['Allow_file_info'],
				'L_NONE' => $lang['None'],
				'L_YES' => $lang['Yes'],
				'L_NO' => $lang['No'],
				'L_CAT_NAME_FIELD_EMPTY' => $lang['Cat_name_missing'],
				'S_CAT_LIST' => $cat_list)
			); 

			$template->pparse('admin');

			break;
		}
        
		case 'edit':
		{

			$template->set_filenames(array(
				'admin' => 'admin/pa_admin_cat_edit.tpl')
			);
			
			if ( isset($HTTP_GET_VARS['edit']) || isset($HTTP_POST_VARS['edit']) )
			{
				$edit = ( isset($HTTP_GET_VARS['edit']) ) ? intval($HTTP_GET_VARS['edit']) : intval($HTTP_POST_VARS['edit']);
			}

			if (isset($HTTP_POST_VARS['submit']) &&  $edit != 'form')
			{

				$cat_name = ( isset($HTTP_POST_VARS['cat_name']) ) ? $HTTP_POST_VARS['cat_name'] : '';
				$cat_desc = ( isset($HTTP_POST_VARS['cat_desc']) ) ? $HTTP_POST_VARS['cat_desc'] : '';
				$cat_parent = ( isset($HTTP_POST_VARS['cat_parent']) ) ? intval($HTTP_POST_VARS['cat_parent']) : 0;
				$cat_allow_file = ( isset($HTTP_POST_VARS['cat_allow_file']) ) ? intval($HTTP_POST_VARS['cat_allow_file']) : 0;
				
				if(empty($cat_name))
				{
					message_die(GENERAL_ERROR, $lang['Cat_name_missing']);
				}
				
				$sql = "SELECT cat_allow_file
					FROM " . PA_CATEGORY_TABLE . "
					WHERE cat_id = $cat_parent";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldn\'t add a new category', '', __LINE__, __FILE__, $sql);
				}

				$row = $db->sql_fetchrow($result);

				if(!$row['cat_allow_file'] && !$cat_allow_file)
				{
					message_die(GENERAL_ERROR, $lang['Cat_conflict']);
				}

				if ( isset($HTTP_GET_VARS['cat_id']) || isset($HTTP_POST_VARS['cat_id']) )
				{
					$cat_id = ( isset($HTTP_GET_VARS['cat_id']) ) ? intval($HTTP_GET_VARS['cat_id']) : intval($HTTP_POST_VARS['cat_id']);
				}
				else
				{
					message_die(GENERAL_ERROR, $lang['Cat_id_missing']);
				}

				$sql = "UPDATE " . PA_CATEGORY_TABLE . " 
						SET cat_name = '" . str_replace("\'", "''", $cat_name) . "', cat_desc = '" . str_replace("\'", "''", $cat_desc) . "', cat_parent = '" . $cat_parent . "', cat_allow_file = '" . $cat_allow_file . "' 
						WHERE cat_id = '" . $cat_id . "'";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt update category info', '', __LINE__, __FILE__, $sql);
				}

				$message = $lang['Catedited'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_category.$phpEx?category=edit") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

				message_die(GENERAL_MESSAGE, $message);
			}

			if (isset($HTTP_POST_VARS['submit']) && $edit == 'form')
			{

				if ( isset($HTTP_GET_VARS['cat_id']) || isset($HTTP_POST_VARS['cat_id']) )
				{
					$cat_id = ( isset($HTTP_GET_VARS['cat_id']) ) ? intval($HTTP_GET_VARS['cat_id']) : intval($HTTP_POST_VARS['cat_id']);
				}

				$sql = "SELECT * 
						FROM " . PA_CATEGORY_TABLE . " 
						WHERE cat_id = '" . $cat_id . "'";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);
				}

				$cat = $db->sql_fetchrow($result);

				if (!$cat['cat_parent']) 
				{
					$cat_list .= '<option value="0" selected>' . $lang['None'] . '</option>\n';
				}
				else
				{
					$cat_list .= '<option value="0">' . $lang['None'] . '</option>\n';
				}

				$cat_list .= jumpmenu('', 'admin', array($cat['cat_parent']=>1), 'none_cat');
				
				if($cat['cat_allow_file'])
				{
					$checked_yes = ' checked';
					$checked_no = '';
				}
				else
				{
					$checked_yes = '';
					$checked_no = ' checked';
				}				

				$template->assign_block_vars("edit_form", array());

				$template->assign_vars(array(
					'S_EDIT_CAT_ACTION' => append_sid("admin_pa_category.$phpEx"),
					'S_CAT_LIST' => $cat_list,					
					'L_CAT_TITLE' => $lang['Ecattitle'],
					'L_CAT_EXPLAIN' => $lang['Catexplain'],
					'L_CAT_NAME' => $lang['Catname'],
					'L_CAT_NAME_INFO' => $lang['Catnameinfo'],
					'L_CAT_DESC' => $lang['Catdesc'],
					'L_CAT_DESC_INFO' => $lang['Catdescinfo'],
					'L_CAT_PARENT' => $lang['Catparent'],
					'L_CAT_ALLOWFILE' => $lang['Allow_file'],
					'L_CAT_ALLOWFILE_INFO' => $lang['Allow_file_info'],
					'L_CATPARENTINFO' => $lang['Catparentinfo'],					
					'L_YES' => $lang['Yes'],
					'L_NO' => $lang['No'],
					'L_CAT_NAME_FIELD_EMPTY' => $lang['Cat_name_missing'],
					'ACTION' => $category,
					'CAT_NAME' => $cat['cat_name'],
					'CAT_DESC' => $cat['cat_desc'],					
					'CAT_ID' => $cat_id,
					'CHECKED_YES' => $checked_yes,
					'CHECKED_NO' => $checked_no)
				);

			}

			if (empty($edit) && !isset($HTTP_POST_VARS['submit']) )
			{

				$select_cat = jumpmenu('', 'admin', '', 'none_cat');

				$template->assign_block_vars("edit", array());

				$template->assign_vars(array(
					'S_EDIT_CAT_ACTION' => append_sid("admin_pa_category.$phpEx"),
					'L_CAT_TITLE' => $lang['Ecattitle'],
					'L_CAT_EXPLAIN' => $lang['Catexplain'],
					'ACTION' => $category,
					'S_SELECT_CAT' => $select_cat)
				);
			}

			$template->pparse('admin');

			break;
		} 

		case 'delete':
		{

			$template->set_filenames(array(
				'admin' => 'admin/pa_admin_cat_delete.tpl')
			);

			if ( isset($HTTP_GET_VARS['delete']) || isset($HTTP_POST_VARS['delete']) )
			{
				$delete = ( isset($HTTP_GET_VARS['delete']) ) ? $HTTP_GET_VARS['delete'] : $HTTP_POST_VARS['delete'];
			}

			if (isset($HTTP_POST_VARS['submit']))
			{
				$cat_id = ( isset($HTTP_POST_VARS['cat_id']) ) ? intval($HTTP_POST_VARS['cat_id']) : '';
				$file_to_cat_id = ( isset($HTTP_POST_VARS['file_to_cat_id']) ) ? intval($HTTP_POST_VARS['file_to_cat_id']) : '';
				$subcat_to_cat_id = ( isset($HTTP_POST_VARS['subcat_to_cat_id']) ) ? intval($HTTP_POST_VARS['subcat_to_cat_id']) : '';
				$file_mode = ( isset($HTTP_POST_VARS['file_mode']) ) ? $HTTP_POST_VARS['file_mode'] : 'move';
				$subcat_mode = ( isset($HTTP_POST_VARS['subcat_mode']) ) ? $HTTP_POST_VARS['subcat_mode'] : 'move';

				if (empty($cat_id))
				{
					message_die(GENERAL_MESSAGE, $lang['Cdelerror']);
				}
				else
				{
					if ( ($file_to_cat_id == -1 || empty($file_to_cat_id)) && $file_mode == 'move')
					{
						message_die(GENERAL_MESSAGE, $lang['Cdelerror']);
					}

					if($subcat_mode == 'move' && empty($subcat_to_cat_id))
					{
						message_die(GENERAL_MESSAGE, $lang['Cdelerror']);
					}

					$sql = "DELETE FROM " . PA_CATEGORY_TABLE . " 
							WHERE cat_id = '" . $cat_id . "'";

					if ( !($db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);
					}

					if ($file_mode == 'delete')
					{
						delete_files($cat_id, 'category');
					}
					else
					{
						move_files($cat_id, $file_to_cat_id);
					}
					
					if($subcat_mode == 'delete')
					{
						delete_subcat($cat_id, $file_mode, $file_to_cat_id);
					}
					else
					{
						move_subcat($cat_id, $subcat_to_cat_id);
					}

					$message = $lang['Catsdeleted'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_category.$phpEx?category=delete") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

					message_die(GENERAL_MESSAGE, $message);
				}
	
			}

			if (!isset($HTTP_POST_VARS['submit']))
			{
				$select_cat = jumpmenu('', 'admin', '', 'none_cat');
				$file_to_select_cat = jumpmenu('', 'admin', '');

				$template->assign_vars(array(
					'S_DELETE_CAT_ACTION' => append_sid("admin_pa_category.$phpEx"),
					'L_DCATTITLE' => $lang['Dcattitle'],
					'L_CATEXPLAIN' => $lang['Catexplain'],
					'L_DELETE'=> $lang['Delete'],
					'S_SELECT_CAT' => $select_cat,
					'S_FILE_SELECT_CAT' => $file_to_select_cat,
					'L_DO_FILE' => $lang['Delfiles'],
					'L_DO_CAT' => $lang['Do_cat'],
					'L_MOVE_TO' => $lang['Move_to'],
					'L_SELECT_CAT' => $lang['Select_a_Category'],
					'L_DELETE' => $lang['Delete'],
					'L_MOVE' => $lang['Move'])
				);
			}

			$template->pparse('admin');

			break;
		} 

		case 'order':
		{

			$template->set_filenames(array(
				'admin' => 'admin/pa_admin_cat_order.tpl')
			);
    
			if ( isset($HTTP_GET_VARS['order']) || isset($HTTP_POST_VARS['order']) )
			{
				$order = ( isset($HTTP_GET_VARS['order']) ) ? $HTTP_GET_VARS['order'] : $HTTP_POST_VARS['order'];
			}
    
			if (isset($HTTP_POST_VARS['submit']))
			{

				if ( isset($HTTP_GET_VARS['num']) || isset($HTTP_POST_VARS['num']) )
				{
					$num = ( isset($HTTP_GET_VARS['num']) ) ? $HTTP_GET_VARS['num'] : $HTTP_POST_VARS['num'];
				}

				foreach($num as $key => $value)
				{
					$sql = "UPDATE " . PA_CATEGORY_TABLE . " 
							SET cat_order = '" . $value . "' 
							WHERE cat_id = '" . $key . "'";

					if ( !($db->sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);
					}
				}

				$message = $lang['Rcatdone'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_category.$phpEx?category=order") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

				message_die(GENERAL_MESSAGE, $message);
		
			}

			if (!isset($HTTP_POST_VARS['submit']))
			{
				if ( isset($HTTP_GET_VARS['cat_id']) || isset($HTTP_POST_VARS['cat_id']) )
				{
					$cat_id = ( isset($HTTP_GET_VARS['cat_id']) ) ? intval($HTTP_GET_VARS['cat_id']) : intval($HTTP_POST_VARS['cat_id']);
				}

				if (!$cat_id)
				{
					$cat_id = 0;
				}

				$sql = "SELECT c.cat_id, c.cat_order, c.cat_name, c.cat_desc, c.cat_allow_file, c2.cat_id as cat_id2, c2.cat_order as cat_order2, c2.cat_name as cat_name2, c2.cat_desc as cat_desc2, c2.cat_allow_file as cat_allow_file2
						FROM " . PA_CATEGORY_TABLE . " AS c
						LEFT JOIN " . PA_CATEGORY_TABLE . " AS c2 ON c.cat_id = c2.cat_parent
						WHERE c.cat_parent = '" . $cat_id . "' 
						ORDER BY c.cat_order ASC";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);	
				}
				$sub_cat_rowset = array();
				$catrowset = array();
				while($row = $db->sql_fetchrow($result))
				{
					if(!empty($row['cat_id2']))
					{
						$sub_cat_rowset[$row['cat_id']][$row['cat_id2']]['cat_id'] = $row['cat_id2'];
						$sub_cat_rowset[$row['cat_id']][$row['cat_id2']]['cat_name'] = $row['cat_name2'];
						$sub_cat_rowset[$row['cat_id']][$row['cat_id2']]['cat_desc'] = $row['cat_desc2'];
						$sub_cat_rowset[$row['cat_id']][$row['cat_id2']]['cat_order'] = $row['cat_order2'];
						$sub_cat_rowset[$row['cat_id']]['total_subcat']++;
					}
					$catrowset[$row['cat_id']] = $row;
				}				

				foreach($catrowset as $cat_id => $cat)
				{
					$cat_url = ($sub_cat_rowset[$cat['cat_id']]['total_subcat'] && $cat['cat_allow_file']) ? '<a href="' . append_sid("admin_pa_category.$phpEx?category=order&amp;cat_id=" . $cat['cat_id']) . '">' . $cat['cat_name'] . '</a>' : $cat['cat_name'];					
					
					$template->assign_block_vars("cat_order", array(
						'CLASS' => (!$cat['cat_allow_file']) ? 'cat' : 'row1',
						'CAT_ID' => $cat['cat_id'],
						'CAT_ORDER' => $cat['cat_order'],
						'CAT_URL' => $cat_url,
						'CAT_NAME' => $cat['cat_name'],
						'CAT_DESC' => $cat['cat_desc'])
					);
					
					if($sub_cat_rowset[$cat['cat_id']]['total_subcat'] && !$cat['cat_allow_file'])
					{
						
						foreach($sub_cat_rowset[$cat['cat_id']] as $sub_cat_id => $sub_cat)
						{
							if($sub_cat_id == 'total_subcat')
							{
								continue;
							}
							$sql = "SELECT cat_id
								FROM " . PA_CATEGORY_TABLE . "
								WHERE cat_parent = " . $sub_cat_id;
							if ( !($result = $db->sql_query($sql)) )
							{
								message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);	
							}

							$cat_url = ($db->sql_numrows($result)) ? '<a href="' . append_sid("admin_pa_category.$phpEx?category=order&amp;cat_id=" . $sub_cat['cat_id']) . '">' . $sub_cat['cat_name'] . '</a>' : $sub_cat['cat_name'];

							$template->assign_block_vars("cat_order.subcat_order", array(
								'CAT_ID' => $sub_cat_id,
								'CAT_ORDER' => $sub_cat['cat_order'],
								'CAT_URL' => $cat_url,
								'CAT_NAME' => $sub_cat['cat_name'],
								'CAT_DESC' => $sub_cat['cat_desc'])
							);							
						}
					}
				}

				$template->assign_vars(array(
					'S_ORDER_CAT_ACTION' => append_sid("admin_pa_category.$phpEx"),
					'L_RCATTITLE' => $lang['Rcattitle'],
					'L_RCATEXPLAIN' => $lang['Rcatexplain'],
					'L_RCATINFO' => $lang['Rcatinfo'])
				);
			}

			$template->pparse('admin');

			break; 
		}
	}
}

include('./page_footer_admin.'.$phpEx);

function delete_files($id, $mode = 'file')
{
	global $db;

	if($mode = 'category')
	{
		$file_ids = array();

		$sql = "SELECT file_id FROM " . PA_FILES_TABLE . "
			WHERE file_catid = '" . $id . "'";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not select files', '', __LINE__, __FILE__, $sql);
		}

		while($row = $db->sql_fetchrow($result))
		{
			$file_ids[] = $row['file_id'];
		}

		$where_sql = "WHERE file_catid = '" . $id . "'";
	}
	else
	{
		$where_sql = "WHERE file_id = '" . $id . "'";
	}
	
	$sql = "DELETE FROM " . PA_FILES_TABLE . "
		$where_sql";
	
	unset($where_sql);

	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt delete files', '', __LINE__, __FILE__, $sql);
	}
	if(!empty($file_ids) && $mode = 'file')
	{
		$where_sql = ($mode = 'category') ? " IN (" . implode(", ", $file_ids) . ") " : " = '" . $id . "'";
	
		$sql = "DELETE FROM " . PA_CUSTOM_DATA_TABLE . "
			WHERE customdata_file$where_sql";
		if ( !($db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt delete custom data', '', __LINE__, __FILE__, $sql);
		}
	}
	return;
}

function delete_subcat($cat_id, $file_mode = 'delete', $to_cat = false)
{
	global $db;
	
	$sql = "SELECT cat_id FROM " . PA_CATEGORY_TABLE . "
		WHERE cat_parent = '" . $cat_id . "'";
		
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);
	}
	
	while($row = $db->sql_fetchrow($result))
	{
		delete_subcat($row['cat_id']);

		$sql = "DELETE FROM " . PA_CATEGORY_TABLE . " 
			WHERE cat_id = '" . $row['cat_id'] . "'";

		if ( !($db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);
		}
		
		if($file_mode == 'delete')
		{
			delete_files($row['cat_id'], 'category');
		}
		else
		{
			move_files($row['cat_id'], $to_cat);
		}
	}

	return;
}

function move_files($from_cat, $to_cat)
{
	global $db;

	$sql = "UPDATE " . PA_FILES_TABLE . "
		SET file_catid = " . $to_cat . "
		WHERE file_catid = " . $from_cat;
		
	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt move files', '', __LINE__, __FILE__, $sql);
	}
	return;
	
}

function move_subcat($from_cat, $to_cat)
{
	global $db;

	$sql = "UPDATE " . PA_CATEGORY_TABLE . "
		SET cat_parent = " . $to_cat . "
		WHERE cat_parent = " . $from_cat;

	if ( !($db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt move Sub Category', '', __LINE__, __FILE__, $sql);
	}
	return;	
}
?>
