<?php
/***************************************************************************
 *                             admin_kb_cat.php
 *                            -------------------
 *   begin                : Monday, Mar 31, 2003
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: admin_kb_cat.php,v 1.0.0 2003/01/05 02:36:00 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['KB_title']['Cat_man'] = $file;
	return;
}

function get_list($id, $select)
{
 	global $db;

    $idfield = 'category_id';
	$namefield = 'category_name';

	$sql = "SELECT *
		FROM " . KB_CATEGORIES_TABLE;
	
	if( $select == 0 )
	{
		$sql .= " WHERE $idfield <> $id";
	}
	
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Couldn't get list of Categories", "", __LINE__, __FILE__, $sql);
	}

	$cat_list = "";

	while( $row = $db->sql_fetchrow($result) )
	{
		$catlist .= "<option value=\"$row[$idfield]\"$s>" . $row[$namefield] . "</option>\n";
	}

	return($catlist);
}

//
// Load default header
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'config.'.$phpEx);
include($phpbb_root_path . 'includes/functions_admin.'.$phpEx);

if ( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	if ( $create )
	{
		$mode = 'create';
	}
	else if ( $edit )
	{
		$mode = 'edit';
	}
	else if ( $delete )
	{
		$mode = 'delete';
	}
	else
	{
		$mode = '';
	}
}

switch( $mode )
{

  case ('create'):
	  
  if ( !$HTTP_POST_VARS['submit'] )
  {
   	   $new_cat_name = $HTTP_POST_VARS['new_cat_name'];
  
	   //
 	   // Generate page
  	   //
  	   $template->set_filenames(array(
			'body' => 'admin/kb_cat_edit_body.tpl')
       );

	   $template->assign_block_vars('switch_add_category', array());
	   
  	   $template->assign_vars(array( 
	        'L_EDIT_TITLE' => $lang['Create_cat'],
			'L_EDIT_DESCRIPTION' => $lang['Create_description'],
			'L_CATEGORY' => $lang['Article_category'],
			'L_DESCRIPTION' => $lang['Article_description'],
			'L_NUMBER_ARTICLES' => $lang['Articles'],
			'L_CAT_SETTINGS' => $lang['Cat_settings'],
			'L_CREATE' => $lang['Create'],
			
			'S_ACTION' => append_sid($phpbb_root_path . "admin/admin_kb_cat.$phpEx?mode=create"),
			'CAT_NAME' => $new_cat_name,
			'DESC' => '',
			'NUMBER_ARTICLES' => '0')
		);
  }
  else if ($HTTP_POST_VARS['submit'] )
  {
   	   $cat_name = $HTTP_POST_VARS['catname'];
	   
	   if ( !$cat_name )
	   {
	   	  echo "Please put a category name in!";
	   }
	   
	   $cat_desc = $HTTP_POST_VARS['catdesc'];
	   
	   $sql = "INSERT INTO " . KB_CATEGORIES_TABLE . " (category_name, category_details, number_articles)" . 
	   		   " VALUES ('$cat_name', ' $cat_desc', '0')";
			   
	   if ( !($results = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not create category", '', __LINE__, __FILE__, $sql);
	   }

	   $message = $lang['Cat_created'] . '<br /><br />' . sprintf($lang['Click_return_cat_manager'], '<a href="' . append_sid("admin_kb_cat.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

	message_die(GENERAL_MESSAGE, $message);	
  }
  break;

  case ('edit'):
  
  if ( !$HTTP_POST_VARS['submit'] )
  {
   	   $cat_id = $HTTP_GET_VARS['cat'];
	   
	   $sql = "SELECT * FROM " . KB_CATEGORIES_TABLE . " WHERE category_id = " . $cat_id;
		 
	   if ( !($results = $db->sql_query($sql)) )
	   {
   	  	  message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	   }
	   if ( $cat = $db->sql_fetchrow($results) )
	   {
	  	  $cat_name = $cat['category_name'];
		  $cat_desc = $cat['category_details'];
		  $number_articles = $cat['number_articles'];
	   }
  
	   //
 	   // Generate page
  	   //
  	   $template->set_filenames(array(
			'body' => 'admin/kb_cat_edit_body.tpl')
       );

  	   $template->assign_vars(array( 
	        'L_EDIT_TITLE' => $lang['Edit_cat'],
			'L_EDIT_DESCRIPTION' => $lang['Edit_description'],
			'L_CATEGORY' => $lang['Article_category'],
			'L_DESCRIPTION' => $lang['Article_description'],
			'L_NUMBER_ARTICLES' => $lang['Articles'],
			'L_CAT_SETTINGS' => $lang['Cat_settings'],
			'L_CREATE' => $lang['Edit'],
			
			'S_ACTION' => append_sid($phpbb_root_path . "admin/admin_kb_cat.$phpEx?mode=edit"),
			'CAT_NAME' => $cat_name,
			'CAT_DESCRIPTION' => $cat_desc,
			'NUMBER_ARTICLES' => $number_articles,
			
			'S_HIDDEN' => '<input type="hidden" name="catid" value="' . $cat_id . '">')
		);
  }
  else if ($HTTP_POST_VARS['submit'] )
  {
   	   $cat_id = $HTTP_POST_VARS['catid'];
	   $cat_name = $HTTP_POST_VARS['catname'];
	   $cat_desc = $HTTP_POST_VARS['catdesc'];
	   $number_articles = $HTTP_POST_VARS['number_articles'];
	   
	   if ( !$cat_name )
	   {
	   	  echo "Please put a category name in!";
	   }
	   
	   $sql = "UPDATE " . KB_CATEGORIES_TABLE .
	   		" SET category_name = '" . $cat_name .
			"', category_details = '" . $cat_desc .
			"', number_articles = '" . $number_articles .
			"' WHERE category_id = " . $cat_id;
		   
	   if ( !($results = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not update category", '', __LINE__, __FILE__, $sql);
	   }

	   $message = $lang['Cat_edited'] . '<br /><br />' . sprintf($lang['Click_return_cat_manager'], '<a href="' . append_sid("admin_kb_cat.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

	   message_die(GENERAL_MESSAGE, $message);	
  }
  break;
  
  case ('delete'):

  if ( !$HTTP_POST_VARS['submit'] )
  {
   	   $cat_id = $HTTP_GET_VARS['cat'];
  
  	   $sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE . 
			" WHERE category_id = '" . $cat_id . "'";
	
	   if ( !($cat_result = $db->sql_query($sql)) )
	   {
	   	  message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $category = $db->sql_fetchrow($cat_result) )
	   {
	   	  $cat_name = $category['category_name'];
	   }
  
  	   //
 	   // Generate page
  	   //
  	   $template->set_filenames(array(
			'body' => 'admin/kb_cat_del_body.tpl')
       );

  	   $template->assign_vars(array(
	       'L_DELETE_TITLE' => $lang['Cat_delete_title'],
		   'L_DELETE_DESCRIPTION' => $lang['Cat_delete_desc'],
		   'L_CAT_DELETE' => $lang['Cat_delete_title'],
		   
		   'L_CAT_NAME' => $lang['Article_category'],
		   'L_MOVE_CONTENTS' => $lang['Move_contents'],
		   'L_DELETE' => $lang['Move_and_Delete'],
		   
		   'S_HIDDEN_FIELDS' => '<input type="hidden" name="catid" value="' . $cat_id .'">',
		   'S_SELECT_TO' => get_list($cat_id, 0),
		   'S_ACTION' => append_sid($phpbb_root_path . "admin/admin_kb_cat.$phpEx?mode=delete"),
		   
		   'CAT_NAME' => $cat_name)
	);  
  }
  else if ( $HTTP_POST_VARS['submit'] )
  {
   	   $new_category = $HTTP_POST_VARS['move_id'];
	   $old_category = $HTTP_POST_VARS['catid'];
  
  	   if ( $new_category )
	   {
  
   	      $sql = "UPDATE " . KB_ARTICLES_TABLE .
	   		   " SET article_category_id = '$new_category' 
			   WHERE article_category_id = '$old_category'";
			
	      if ( !($move_result = $db->sql_query($sql)) )
	      {
	   	     message_die(GENERAL_ERROR, "Could not move articles", '', __LINE__, __FILE__, $sql);
	      }
	   
	      $sql = "SELECT *  
       		   FROM " . KB_CATEGORIES_TABLE . 
			   " WHERE category_id = '$new_category'";
			
	     if ( !($cat_result = $db->sql_query($sql)) )
	      {
	   	     message_die(GENERAL_ERROR, "Could not get category data", '', __LINE__, __FILE__, $sql);
	      }
	   
	      if( $new_cat = $db->sql_fetchrow($cat_result) )
	      {
	         $new_articles = $new_cat['number_articles'];
	      }
	   
	      $sql = "SELECT *  
       		   FROM " . KB_CATEGORIES_TABLE . 
			   " WHERE category_id = '$old_category'";
			
	      if ( !($oldcat_result = $db->sql_query($sql)) )
	      {
	   	     message_die(GENERAL_ERROR, "Could not get category data", '', __LINE__, __FILE__, $sql);
	      }
	   
	      if( $old_cat = $db->sql_fetchrow($oldcat_result) )
	      {
	         $old_articles = $old_cat['number_articles'];
	      }
	   
	      $number_articles = $new_articles + $old_articles;
	   
	   	  $sql = "UPDATE " . KB_CATEGORIES_TABLE .
	   		  " SET number_articles = '" . $number_articles .
			  "' WHERE category_id = " . $new_category;
	   
	   	  if ( !($number_result = $db->sql_query($sql)) )
	   	  {
	   	   	 message_die(GENERAL_ERROR, "Could not update articles number", '', __LINE__, __FILE__, $sql);
	   	  }
	   }
	   $sql = "DELETE FROM " . KB_CATEGORIES_TABLE .
	   		  " WHERE category_id = $old_category";
			 
	   if ( !($delete_result = $db->sql_query($sql)) )
	   {
	   	  message_die(GENERAL_ERROR, "Could not delete category", '', __LINE__, __FILE__, $sql);
	   }
	   	
	   $message = $lang['Cat_deleted'] . '<br /><br />' . sprintf($lang['Click_return_cat_manager'], '<a href="' . append_sid("admin_kb_cat.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

	   message_die(GENERAL_MESSAGE, $message);
  }
  break;
  
  default:
 
  //
  // Generate page
  //
  $template->set_filenames(array(
		'body' => 'admin/kb_cat_admin_body.tpl')
  );

  $template->assign_vars(array(
      'L_KB_CAT_TITLE' => $lang['Cat_man'],
  	  'L_KB_CAT_DESCRIPTION' => $lang['KB_cat_description'],
  
  	  'L_CREATE_CAT' => $lang['Create_cat'],
	  'L_CREATE' => $lang['Create'],
  	  'L_CATEGORY' => $lang['Article_category'],
  	  'L_ACTION' => $lang['Art_action'],
	  'L_ARTICLES' => $lang['Articles'],
	  
	  'S_ACTION' => append_sid($phpbb_root_path . "admin/admin_kb_cat.$phpEx?mode=create"))
   );
  
  //get categories
  $sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE;
	
	if ( !($cat_result = $db->sql_query($sql)) )
	{
	   message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	}

	while ( $category = $db->sql_fetchrow($cat_result) )
	{	
		
		$category_details = $category['category_details'];
		$category_articles = $category['number_articles'];
		
		$category_id = $category['category_id'];
		$category_name = $category['category_name'];
		$temp_url = append_sid($phpbb_root_path . "kb.$phpEx?mode=cat&amp;cat=$category_id");
	   	$category = '<a href="' . $temp_url . '" class="gen">' . $category_name . '</a>';
		
		$temp_url = append_sid($phpbb_root_path . "admin/admin_kb_cat.$phpEx?mode=edit&amp;cat=$category_id");
	   	$edit = '<a href="' . $temp_url . '"><img src="../' . $images['icon_edit'] . '" border="0" alt="' . $lang['Edit'] . '"></a>';
		
		$temp_url = append_sid($phpbb_root_path . "admin/admin_kb_cat.$phpEx?mode=delete&amp;cat=$category_id");
	   	$delete = '<a href="' . $temp_url . '" class="gen"><img src="../' . $images['icon_delpost'] . '" border="0" alt="' . $lang['Delete'] . '"></a>';
		
		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];
		
		$template->assign_block_vars('catrow', array(
			'CATEGORY' => $category,
			'CAT_DESCRIPTION' => $category_details,
			'CAT_ARTICLES' => $category_articles,
			
			'U_EDIT' => $edit,
			'U_DELETE' => $delete,
			
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class)
		);
		$i++;
	}
	break;
}

$template->pparse('body');

include('./page_footer_admin.'.$phpEx);

?>