<?php
/***************************************************************************
 *                             admin_im_s2s.php
 *                            -------------------
 *   begin                : Friday, May 16, 2003
 *   version              : 0.1.0
 *   date                 : 2003/06/08 16:32
 ***************************************************************************/

define('IN_PHPBB', 1);
define('IN_PRILLIAN', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Prillian']['Site to Site'] = $filename;
	return;
}

$phpbb_root_path = './../';
$phpbb_im_path = $phpbb_root_path . 'mods/prillian/';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
require($phpbb_root_path . 'includes/bbcode.'.$phpEx);
require($phpbb_root_path . 'includes/functions_post.'.$phpEx);
require($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
require($phpbb_root_path . 'includes/functions_validate.'.$phpEx);
require($phpbb_im_path . 'functions_im.'.$phpEx);

if ( !defined('IN_PRILLIAN_LANG') )
{
	include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_prillian.' . $phpEx);
}


$confirm = ( isset($HTTP_POST_VARS['confirm']) ) ? TRUE : FALSE;
$cancel = ( isset($HTTP_POST_VARS['cancel']) ) ? TRUE : FALSE;

if ($cancel)
{
	thoul_redirect('admin/' . append_sid('admin_im_s2s.' . $phpEx, true));
}

if( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_GET_VARS['mode']) ) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];
}
else 
{
	$mode = '';
}

$s_hidden_fields = '';

switch($mode)
{
	case 'save':
		$new_site = ( isset($HTTP_POST_VARS['type']) || isset($HTTP_GET_VARS['type']) ) ? true : false;

		$site_id = ( !empty( $HTTP_POST_VARS['site_id'] )) ? intval($HTTP_POST_VARS['site_id']): intval($HTTP_GET_VARS['site_id']);
		$site_name = ( isset( $HTTP_POST_VARS['site_name'] )) ? trim($HTTP_POST_VARS['site_name']): trim($HTTP_GET_VARS['site_name']);
		$site_url = ( isset( $HTTP_POST_VARS['site_url'] )) ? trim($HTTP_POST_VARS['site_url']): trim($HTTP_GET_VARS['site_url']);
		$site_phpex = ( isset( $HTTP_POST_VARS['site_phpex'] )) ? trim($HTTP_POST_VARS['site_phpex']): trim($HTTP_GET_VARS['site_phpex']);
		$site_ppu = ( isset( $HTTP_POST_VARS['site_ppu'] )) ? trim($HTTP_POST_VARS['site_ppu']): trim($HTTP_GET_VARS['site_ppu']);
		$site_puu = ( isset( $HTTP_POST_VARS['site_puu'] )) ? trim($HTTP_POST_VARS['site_puu']): trim($HTTP_GET_VARS['site_puu']);
		$site_profile = ( isset( $HTTP_POST_VARS['site_profile'] )) ? trim($HTTP_POST_VARS['site_profile']): trim($HTTP_GET_VARS['site_profile']);

		// If no nam or url were entered complain ...
		if ($site_name == '' || $site_url == '' )
		{
			message_die(MESSAGE, $lang['Fields_empty']);
		}

		$site_name = str_replace("\'", "''", addslashes($site_name));
		$site_url = str_replace("\'", "''", addslashes($site_url));
		$site_phpex = str_replace("\'", "''", addslashes($site_phpex));
		$site_ppu = str_replace("\'", "''", addslashes($site_ppu));
		$site_puu = str_replace("\'", "''", addslashes($site_puu));
		$site_profile = str_replace("\'", "''", addslashes($site_profile));

		if( $new_site )
		{
			$error_msg = 'Could not insert site-to-site data';
			$name_sql = '';
			$val_sql = '';

			if( $site_phpex )
			{
				$name_sql .= ', site_phpex';
				$val_sql .= ", '$site_phpex'";
			}
			if( $site_ppu )
			{
				$name_sql .= ', site_ppu';
				$val_sql .= ", '$site_ppu'";
			}
			if( $site_puu )
			{
				$name_sql .= ', site_puu';
				$val_sql .= ", '$site_puu'";
			}
			if( $site_profile )
			{
				$name_sql .= ', site_profile';
				$val_sql .= ", '$site_profile'";
			}

			$sql = 'INSERT INTO ' . IM_SITES_TABLE . ' (site_name, site_url' . $name_sql . ') VALUES (' . "'$site_name', '$site_url' $val_sql)";
		}
		else
		{
			$error_msg = 'Could not update site-to-site data';
			$sql = 'UPDATE ' . IM_SITES_TABLE . " SET site_name='$site_name', site_url='$site_url', site_phpex='$site_phpex', site_ppu='$site_ppu', site_puu='$site_puu', site_profile='$site_profile' WHERE site_id = $site_id";
		}

		if(!$db->sql_query($sql))
		{
			message_die(CRITICAL_ERROR, $error_msg, '', __LINE__, __FILE__, $sql);
		}

		$message = $lang['s2s_add_success'] . '<br /><br />' . sprintf($lang['Click_return_s2s'], '<a href="' . append_sid('admin_im_s2s.' . $phpEx) . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

		message_die(GENERAL_MESSAGE, $message);
		break;
	case 'edit':
		// Edit a site
		$site_id = ( isset( $HTTP_POST_VARS['site_id'] )) ? intval($HTTP_POST_VARS['site_id']): intval($HTTP_GET_VARS['site_id']);

		$sql = 'SELECT * FROM ' . IM_SITES_TABLE . ' WHERE site_id = ' . $site_id;
		if(!$result = $db->sql_query($sql))
		{
			message_die(CRITICAL_ERROR, 'Could not query site-to-site table for editing in admin_im_s2s', '', __LINE__, __FILE__, $sql);
		}
		
		if(!$row = $db->sql_fetchrow($result) )
		{
			message_die(CRITICAL_ERROR, 'Could not get site information in admin_im_s2s', '', __LINE__, __FILE__, $sql);
		}

		$s_hidden_fields = '<input type="hidden" name="site_id" value="' . $row['site_id'] . '" />';

		// No break - we continue this under add
	case 'add':
		// Add a site

		if( !isset($row))
		{
			$row = '';
		}

		$s_hidden_fields .= '<input type="hidden" name="mode" value="save" /><input type="hidden" name="type" value="add" />';
		
		$template->set_filenames(array(
			'body' => 'admin/s2s_edit_body.tpl')
		);

		$template->assign_vars(array(
			'L_SUBMIT' => $lang['Submit'],
			'L_SITE_CONFIG' => $lang['s2s_config'],
			'L_S2S_TITLE' => $lang['s2s_title'],
			'L_S2S_TEXT' => $lang['s2s_explain'],
			'L_SITENAME' => $lang['Site_name'],
			'L_URL' => $lang['URL'],
			'L_EXT' => $lang['Extension'],
			'L_PUU' => $lang['PUU_Constant'],
			'L_PPU' => $lang['PPU_Constant'],
			'L_PROFILE_PATH' => $lang['Profile_path'],
			'L_PUU_EXPLAIN' => $lang['PUU_Constant_explain'],
			'L_PPU_EXPLAIN' => $lang['PPU_Constant_explain'],
			'L_PROFILE_PATH_EXPLAIN' => $lang['Profile_path_explain'],
			'L_EXT_EXPLAIN' => $lang['Extension_explain'],

			'S_HIDDEN_FIELDS' => $s_hidden_fields, 
			'S_FORM_ACTION' => append_sid('admin_im_s2s.'.$phpEx),

			'NAME' => $row['site_name'],
			'URL' => $row['site_url'],
			'EXT' => $row['site_phpex'],
			'PPU' => $row['site_ppu'],
			'PUU' => $row['site_puu'],
			'PROFILE_PATH' => $row['site_profile']
		));
		
		break;
	case 'delete':
		// Delete a site from the list

		$site_id = ( isset( $HTTP_POST_VARS['site_id'] )) ? intval($HTTP_POST_VARS['site_id']): intval($HTTP_GET_VARS['site_id']);

		$sql = 'DELETE FROM ' . IM_SITES_TABLE . ' WHERE site_id = ' . $site_id;
		if( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not delete site', '', __LINE__, __FILE__, $sql);
		}

		$message = $lang['s2s_del_success'] . '<br /><br />' . sprintf($lang['Click_return_s2s'], '<a href="' . append_sid('admin_im_s2s.' . $phpEx) . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

		message_die(GENERAL_MESSAGE, $message);
		break;
	default:
		$sql = 'SELECT * FROM ' . IM_SITES_TABLE;
		if(!$result = $db->sql_query($sql))
		{
			message_die(CRITICAL_ERROR, 'Could not query site-to-site table in admin_im_s2s', '', __LINE__, __FILE__, $sql);
		}
		
		if(!$sites = $db->sql_fetchrowset($result) )
		{
			message_die(CRITICAL_ERROR, 'Could not get site-to-site list in admin_im_s2s', '', __LINE__, __FILE__, $sql);
		}

		$s_hidden_fields = '<input type="hidden" name="mode" value="add" />';

		$template->set_filenames(array(
			'body' => 'admin/s2s_list_body.tpl')
		);

		$template->assign_vars(array(
			'L_ACTION' => $lang['Action'],
			'L_DELETE' => $lang['Delete'],
			'L_EDIT' => $lang['Edit'],
			'L_S2S_TITLE' => $lang['s2s_title'],
			'L_S2S_TEXT' => $lang['s2s_explain'],
			'L_SITENAME' => $lang['Site_name'],
			'L_URL' => $lang['URL'],
			'L_EXT' => $lang['Extension'],
			'L_S2S_ADD' => $lang['s2s_add'],

			'S_HIDDEN_FIELDS' => $s_hidden_fields, 
			'S_FORM_ACTION' => append_sid('admin_im_s2s.'.$phpEx))
		);

		for($i = 0; $i < count($sites); $i++)
		{
			$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
			$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

			$template->assign_block_vars('sites', array(
				'ROW_CLASS' => $row_class,
				'ROW_COLOR' => $row_color,
				'NAME' => $sites[$i]['site_name'],
				'URL' => $sites[$i]['site_url'],
				'EXT' => $sites[$i]['site_phpex'],

				'U_SITE_EDIT' => append_sid('admin_im_s2s.' . $phpEx . '?mode=edit&amp;site_id=' . $sites[$i]['site_id']),
				'U_SITE_DELETE' => append_sid('admin_im_s2s.' . $phpEx . '?mode=delete&amp;site_id=' . $sites[$i]['site_id']))
			);
		}
		
		break;
}

$template->pparse('body');	
include('./page_footer_admin.'.$phpEx);

?>