<?php
/***************************************************************************
 *                            admin_im_config.php
 *                            -------------------
 *   begin                : Thursday, Jan 23, 2003
 *   version              : 0.3.0
 *   date                 : 2003/06/08 16:30
 ***************************************************************************/

define('IN_PHPBB', 1);
define('IN_PRILLIAN', 1);


if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Prillian']['Configuration'] = "$file?mode=config";
	return;
}

$phpbb_root_path = './../';
$phpbb_im_path = $phpbb_root_path . 'mods/prillian/';
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
require($phpbb_root_path . 'includes/bbcode.'.$phpEx);
require($phpbb_root_path . 'includes/functions_post.'.$phpEx);
require($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
require($phpbb_root_path . 'includes/functions_validate.'.$phpEx);
require($phpbb_im_path . 'functions_im.'.$phpEx);

if ( !defined('IN_PRILLIAN_LANG') )
{
	include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_prillian.' . $phpEx);
}

$admin_defaults = array(
	'im_refresh_rate' => '60',
	'im_flood_interval' => '15',
	'im_success_close' => '1',
	'im_refresh_method' => '2',
	'im_auto_launch' => '0',
	'im_popup_ims' => '1',
	'im_list_ims' => '0',
	'im_main_height' => '400',
	'im_main_width' => '225',
	'im_online_height' => '225',
	'im_online_width' => '400',
	'im_read_height' => '225',
	'im_read_width' => '400',
	'im_send_height' => '365',
	'im_send_width' => '460',
	'im_list_all_online' => '1',
	'im_show_controls' => '1',
	'im_allow_ims' => '1',
	'im_allow_shout' => '1',
	'im_allow_chat' => '1',
	'im_override_users' => '0',
	'im_enable_flood' => '1',
	'im_box_limit' => '25',
	'im_refresh_drop' => '1',
	'im_allow_sound' => '1',
	'im_sound_name' => '',
	'im_default_sound' => '0',
	'im_themes_allow' => '1',
	'im_themes_id' => '1',
	'im_allow_s2s' => '1',
	'im_session_length' => '120',
	'im_enable_im_limit' => '1',
	'im_auto_delete' => '1',
	'im_open_pms' => '0',
	'im_s2s_user_list' => '1',
	'im_version' => '0.6.0'
);

//
// Pull all config data
//
$sql = 'SELECT * FROM ' . CONFIG_TABLE . ' WHERE config_name LIKE \'im_%\'';
if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, 'Could not query config information in admin_im_config', '', __LINE__, __FILE__, $sql);
}
else
{
	$row = $db->sql_fetchrowset($result);
	reset($admin_defaults);
	while(list($var, $param) = each($admin_defaults))
	{
		$pos_num = false;
		$pos_num = in_m_array($var, $row, true, 'config_name');
		if( $pos_num )
		{
			// Variable is already installed, we update
			$config_name = $row[$pos_num[1]]['config_name'];
			$config_value = $row[$pos_num[1]]['config_value'];
			$default_config[$config_name] = $config_value;

			$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

			if( isset($HTTP_POST_VARS['submit']) )
			{
				$sql = 'UPDATE ' . CONFIG_TABLE . " SET
					config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
					WHERE config_name = '$config_name'";
				if( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Failed to update general configuration for ' . $config_name, '', __LINE__, __FILE__, $sql);
				}
			}
		}
		elseif( isset($HTTP_POST_VARS['submit']) )
		{
			// Variable is not installed, we insert
			$config_value = $row[$pos_num[1]]['config_value'];
			$default_config[$var] = $param;

			$new[$var] = ( isset($HTTP_POST_VARS[$var]) ) ? $HTTP_POST_VARS[$var] : $default_config[$var];

			$sql = 'INSERT INTO ' . CONFIG_TABLE . ' (config_name, config_value) VALUES (\'' . $var . '\', \'' . str_replace("\'", "''", $new[$var]) . '\')';
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Failed to insert general configuration for ' . $config_name, '', __LINE__, __FILE__, $sql);
			}
		}
	}

	if( isset($HTTP_POST_VARS['submit']) )
	{
		$message = $lang['Config_updated'] . '<br /><br />' . sprintf($lang['Click_return_config'], '<a href="' . append_sid("admin_im_config.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

		message_die(GENERAL_MESSAGE, $message);
	}
}

$im_success_close_yes = ( $new['im_success_close'] ) ? 'checked="checked"' : '';
$im_success_close_no = ( !$new['im_success_close'] ) ? 'checked="checked"' : '';
$im_auto_launch_yes = ( $new['im_auto_launch'] ) ? 'checked="checked"' : '';
$im_auto_launch_no = ( !$new['im_auto_launch'] ) ? 'checked="checked"' : '';
$im_refresh_method_no = ( !$new['im_refresh_method'] ) ? 'checked="checked"' : '';
$im_refresh_method_yes = ( $new['im_refresh_method'] == 1 ) ? 'checked="checked"' : '';
$im_refresh_method_both =( $new['im_refresh_method'] == 2 ) ? 'checked="checked"' : '';
$im_popup_ims_yes = ( $new['im_popup_ims'] ) ? 'checked="checked"' : '';
$im_popup_ims_no = ( !$new['im_popup_ims'] ) ? 'checked="checked"' : '';
$im_list_ims_yes = ( $new['im_list_ims'] ) ? 'checked="checked"' : '';
$im_list_ims_no = ( !$new['im_list_ims'] ) ? 'checked="checked"' : '';
$im_allow_sound_yes = ( $new['im_allow_sound'] ) ? 'checked="checked"' : '';
$im_allow_sound_no = ( !$new['im_allow_sound'] ) ? 'checked="checked"' : '';
$im_default_sound_yes = ( $new['im_default_sound'] ) ? 'checked="checked"' : '';
$im_default_sound_no = ( !$new['im_default_sound'] ) ? 'checked="checked"' : '';
$im_allow_ims_yes = ( $new['im_allow_ims'] ) ? 'checked="checked"' : '';
$im_allow_ims_no = ( !$new['im_allow_ims'] ) ? 'checked="checked"' : '';
$im_override_users_yes = ( $new['im_override_users'] ) ? 'checked="checked"' : '';
$im_override_users_no = ( !$new['im_override_users'] ) ? 'checked="checked"' : '';
$im_enable_flood_yes = ( $new['im_enable_flood'] ) ? 'checked="checked"' : '';
$im_enable_flood_no = ( !$new['im_enable_flood'] ) ? 'checked="checked"' : '';
$im_allow_shout_yes = ( $new['im_allow_shout'] ) ? 'checked="checked"' : '';
$im_allow_shout_no = ( !$new['im_allow_shout'] ) ? 'checked="checked"' : '';
$im_allow_chat_yes = ( $new['im_allow_chat'] ) ? 'checked="checked"' : '';
$im_allow_chat_no = ( !$new['im_allow_chat'] ) ? 'checked="checked"' : '';
$im_refresh_drop_yes = ( $new['im_refresh_drop'] ) ? 'checked="checked"' : '';
$im_refresh_drop_no = ( !$new['im_refresh_drop'] ) ? 'checked="checked"' : '';
$im_style_allow_yes = ( $new['im_themes_allow'] ) ? 'checked="checked"' : '';
$im_style_allow_no = ( !$new['im_themes_allow'] ) ? 'checked="checked"' : '';
$im_allow_s2s_yes = ( $new['im_allow_s2s'] ) ? 'checked="checked"' : '';
$im_allow_s2s_no = ( !$new['im_allow_s2s'] ) ? 'checked="checked"' : '';
$im_open_pms_yes = ( $new['im_open_pms'] ) ? 'checked="checked"' : '';
$im_open_pms_no = ( !$new['im_open_pms'] ) ? 'checked="checked"' : '';
$im_auto_delete_yes = ( $new['im_auto_delete'] ) ? 'checked="checked"' : '';
$im_auto_delete_no = ( !$new['im_auto_delete'] ) ? 'checked="checked"' : '';
$im_enable_im_limit_yes = ( $new['im_enable_im_limit'] ) ? 'checked="checked"' : '';
$im_enable_im_limit_no = ( !$new['im_enable_im_limit'] ) ? 'checked="checked"' : '';


$im_show_controls = generic_select($new['im_show_controls'], 'im_show_controls', 'Controls_select');
$im_list_all_online = generic_select($new['im_list_all_online'], 'im_list_all_online', 'Online_Lists');
$im_s2s_user_list = generic_select($new['im_s2s_user_list'], 'im_s2s_user_list', 's2s_lists');

$template->set_filenames(array(
	'body' => 'admin/imclient_admin_config.tpl')
);

$template->assign_vars(array(
	'S_CONFIG_ACTION' => append_sid('admin_im_config.'.$phpEx),

	'L_YES' => $lang['Yes'],
	'L_NO' => $lang['No'],
	'L_SUBMIT' => $lang['Submit'],
	'L_RESET' => $lang['Reset'],
	'L_CONFIGURATION_TITLE' => $lang['Prillian_Config'],
	'L_CONFIGURATION_EXPLAIN' => $lang['Prillian_Config_explain'],

	'L_PRILLIAN' => $lang['Prillian'],
	'PRILLIAN_VERSION' => $board_config['im_version'],
	'L_PREFS' => $lang['Preferences'],

	'L_FLOOD_INTERVAL' => $lang['Flood_Interval'],
	'L_FLOOD_INTERVAL_EXPLAIN' => $lang['Flood_Interval_explain'],
	'L_IM_REFRESH_RATE' => $lang['Refresh_rate'],
	'L_IM_REFRESH_RATE_EXPLAIN' => $lang['Refresh_rate_explain'],
	'L_IM_SUCCESS_CLOSE' => $lang['Success_close'],
	'L_IM_REFRESH_METHOD' => $lang['Refresh_method'],
	'L_IM_REFRESH_METHOD_EXPLAIN' => $lang['Refresh_method_explain'],
	'L_JAVASCRIPT' => $lang['JavaScript'],
	'L_META' => $lang['META_tag'],
	'L_BOTH' => $lang['Use_both_methods'],
	'L_IM_AUTO_LAUNCH' => $lang['IM_auto_launch'],
	'L_IM_POPUP_IMS' => $lang['IM_auto_popup'],
	'L_IM_LIST_IMS' => $lang['IM_list_new'],
	'L_WIDTH' => $lang['Width'],
	'L_HEIGHT' => $lang['Height'],
	'L_IM_SET_WINDOW_SIZES' => $lang['Admin_Set_window_sizes'],
	'L_SET_WINDOW_SIZES_EXPLAIN' => $lang['Set_window_sizes_explain'],
	'L_MAIN_WINDOW' => $lang['Main_Window'],
	'L_SEND_WINDOW' => $lang['Send_Message'],
	'L_READ_WINDOW' => $lang['Read_Message'],
	'L_ONLINE_WINDOW' => $lang['Whos_Online_Window'],
	'L_IM_BOX_LIMIT' => $lang['IM_box_limit'],
	'L_IM_ENABLE_FLOOD' => $lang['IM_enable_flood'],
	'L_IM_OVERRIDE_USERS' => $lang['IM_override_settings'],
	'L_IM_OVERRIDE_USERS_EXPLAIN' => $lang['IM_override_settings_explain'],
	'L_IM_ALLOW_IMS' => $lang['IM_enable_ims'],
	'L_IM_ALLOW_SHOUT' => $lang['IM_enable_shoutbox'],
	'L_IM_ALLOW_CHAT' => $lang['IM_enable_chatbox'],
	'L_IM_WHO_TO_LIST' => $lang['Who_to_list'],
	'L_IM_ALL_ONLINE' => $lang['All_online'],
	'L_IM_BUDDIES_BOARD' => $lang['Buddies_on_board'],
	'L_IM_BUDDIES_IM' => $lang['Buddies_on_im'],
	'L_IM_SHOW_CONTROLS' => $lang['Show_controls'],
	'L_IM_REFRESH_DROP' => $lang['IM_refresh_drop'],
	'L_IM_ALLOW_SOUND' => $lang['IM_allow_sound'],
	'L_IM_SOUND_NAME' => $lang['IM_sound_name'],
	'L_IM_DEFAULT_SOUND' => $lang['IM_default_sound'],
	'L_IM_STYLE' => $lang['IM_style'],
	'L_IM_STYLE_ALLOW' => $lang['IM_allow_different_style'],
	'L_IM_ALLOW_S2S' => $lang['IM_allow_s2s'],
	'L_IM_SESS_LEN' => $lang['IM_session_length'],
	'L_IM_SESS_LEN_EXPLAIN' => $lang['IM_session_length_explain'],
	'L_IM_OPEN_PMS' => $lang['Open_pms'],
	'L_IM_AUTO_DEL' => $lang['Auto_delete_ims'],
	'L_IM_ENABLE_LIMIT' => $lang['IM_enable_imbox_limit'],
	'L_IM_S2S_USER_SELECT' => $lang['s2s_user_list'],

	'IM_S2S_USER_SELECT' => $im_s2s_user_list,
	'IM_STYLE_SELECT' => style_select($new['im_themes_id'], 'im_themes_id'),
	'IM_ENABLE_LIMIT_YES' => $im_enable_im_limit_yes,
	'IM_ENABLE_LIMIT_NO' => $im_enable_im_limit_no,
	'IM_AUTO_DELETE_YES' => $im_auto_delete_yes,
	'IM_AUTO_DELETE_NO' => $im_auto_delete_no,
	'IM_OPEN_PMS_YES' => $im_open_pms_yes,
	'IM_OPEN_PMS_NO' => $im_open_pms_no,
	'IM_ALLOW_S2S_YES' => $im_allow_s2s_yes,
	'IM_ALLOW_S2S_NO' => $im_allow_s2s_no,
	'IM_STYLE_ALLOW_YES' => $im_style_allow_yes,
	'IM_STYLE_ALLOW_NO' => $im_style_allow_no,
	'IM_REFRESH_DROP_YES' => $im_refresh_drop_yes,
	'IM_REFRESH_DROP_NO' => $im_refresh_drop_no,
	'IM_POPUP_IMS_YES' => $im_popup_ims_yes,
	'IM_POPUP_IMS_NO' => $im_popup_ims_no,
	'IM_LIST_IMS_YES' => $im_list_ims_yes,
	'IM_LIST_IMS_NO' => $im_list_ims_no,
	'IM_ALLOW_SOUND_YES' => $im_allow_sound_yes,
	'IM_ALLOW_SOUND_NO' => $im_allow_sound_no,
	'IM_DEFAULT_SOUND_YES' => $im_default_sound_yes,
	'IM_DEFAULT_SOUND_NO' => $im_default_sound_no,
	'IM_SOUND_NAME' => $new['im_sound_name'],
	'IM_AUTO_LAUNCH_YES' => $im_auto_launch_yes,
	'IM_AUTO_LAUNCH_NO' => $im_auto_launch_no,
	'IM_SUCCESS_CLOSE_YES' => $im_success_close_yes,
	'IM_SUCCESS_CLOSE_NO' => $im_success_close_no,
	'IM_REFRESH_METHOD_YES' => $im_refresh_method_yes,
	'IM_REFRESH_METHOD_NO' => $im_refresh_method_no,
	'IM_REFRESH_METHOD_BOTH' => $im_refresh_method_both,
	'IM_LIST_ALL_ONLINE' => $im_list_all_online,
	'IM_SHOW_CONTROLS' => $im_show_controls,
	'IM_ALLOW_IMS_YES' => $im_allow_ims_yes,
	'IM_ALLOW_IMS_NO' => $im_allow_ims_no,
	'IM_ALLOW_SHOUT_YES' => $im_allow_shout_yes,
	'IM_ALLOW_SHOUT_NO' => $im_allow_shout_no,
	'IM_ALLOW_CHAT_YES' => $im_allow_chat_yes,
	'IM_ALLOW_CHAT_NO' => $im_allow_chat_no,
	'IM_OVERRIDE_USERS_YES' => $im_override_users_yes,
	'IM_OVERRIDE_USERS_NO' => $im_override_users_no,
	'IM_ENABLE_FLOOD_YES' => $im_enable_flood_yes,
	'IM_ENABLE_FLOOD_NO' => $im_enable_flood_no,
	'IM_REFRESH_RATE' => $new['im_refresh_rate'],
	'IM_SESS_LEN' => $new['im_session_length'],
	'IM_FLOOD_INTERVAL' => $new['im_flood_interval'],
	'IM_BOX_LIMIT' => $new['im_box_limit'],
	'IM_MAIN_HEIGHT' => $new['im_main_height'],
	'IM_MAIN_WIDTH' => $new['im_main_width'],
	'IM_ONLINE_HEIGHT' => $new['im_online_height'],
	'IM_ONLINE_WIDTH' => $new['im_online_width'],
	'IM_READ_HEIGHT' => $new['im_read_height'],
	'IM_READ_WIDTH' => $new['im_read_width'],
	'IM_SEND_HEIGHT' => $new['im_send_height'],
	'IM_SEND_WIDTH' => $new['im_send_width']
));

$template->pparse('body');

/************************************************************************
** START Auto-Hacks List Insertion
   This automatically adds Prillian to Nivisec's Admin Hacks List addon
/***********************************************************************/
if (defined('HACKS_LIST_TABLE'))
{
	// You Are Required To Edit These //
	$auto_hack_list['name'] = 'Prillian';
	$auto_hack_list['desc'] = 'phpBB-based Instant Messenger';
	$auto_hack_list['author'] = 'Thoul';
	// You May Optionally Edit Any or All of These //
	$auto_hack_list['version'] = $board_config['im_version'];
	$auto_hack_list['download_url'] = 'http://darkmods.sourceforge.net';
	$auto_hack_list['author_email'] = 'thoul@users.sourcefore.net';
	$auto_hack_list['author_website'] = 'http://darkmods.sourceforge.net';
	// Do Not Change Anything Else //
	$need_inserted_list = TRUE;
	$neat_bc_name = addslashes(str_replace(' ', '_', $auto_hack_list['name'])) . '_list_info';
	if (isset($board_config[$neat_bc_name]))
	{
		list($list_version) = explode('!', $board_config[$neat_bc_name]);
		if ($list_version != $auto_hack_list['version'])
		{
			$sql = 'SELECT hack_hide FROM ' . HACKS_LIST_TABLE . '
			   WHERE hack_name = \'' . addslashes($auto_hack_list['name']) . "'";
			if (!$result = $db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, 'Error Getting Hack From List', '', __LINE__, __FILE__, $sql);
			}
			$row = $db->sql_fetchrow($result);
			$sql = 'DELETE FROM ' . HACKS_LIST_TABLE . '
			   WHERE hack_name = \'' . addslashes($auto_hack_list['name']) . "'";
			if (!$db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, 'Error Deleting Hack From List', '', __LINE__, __FILE__, $sql);
			}
			$sql = 'DELETE FROM ' . CONFIG_TABLE . "
			   WHERE config_name = '$neat_bc_name'";
			if (!$db->sql_query($sql))
			{
				message_die(GENERAL_ERROR, 'Error Deleting Hack From List', '', __LINE__, __FILE__, $sql);
			}
		}
		else
		{
			$need_inserted_list = FALSE;
		} 
	}
	if ($need_inserted_list)
	{
		$old_hide_info = (isset($row['hack_hide'])) ? $row['hack_hide'] : 'Yes';
		$sql = 'INSERT INTO ' . HACKS_LIST_TABLE . "
				   (hack_name, hack_desc, hack_author, hack_version,
		   		   hack_download_url, hack_author_email, 
				   hack_author_website, hack_add_date, hack_hide)
				   VALUES 
				   ('" . addslashes($auto_hack_list['name']) . "', '" . addslashes($auto_hack_list['desc']) . "', '" . addslashes($auto_hack_list['author']) . "', '". addslashes($auto_hack_list['version']) .
		"', '" . addslashes($auto_hack_list['download_url']) . "', '" . addslashes($auto_hack_list['author_email']) .
		"', '" . addslashes($auto_hack_list['author_website']) . "', " . time() . ", '$old_hide_info')";
		if (!$result = $db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, 'Error Inserting Hack Into List', '', __LINE__, __FILE__, $sql);
		}
		$sql = 'INSERT INTO ' . CONFIG_TABLE . "
				   (config_name, config_value)
			   VALUES
			   ('$neat_bc_name', '" . $auto_hack_list['version'] . "')";
		if (!$result = $db->sql_query($sql))
		{
			message_die(GENERAL_ERROR, 'Error Inserting Hack Into Config Table', '', __LINE__, __FILE__, $sql);
		}
	}
}
/************************************************************************
** END Auto-Hacks List Insertion
/***********************************************************************/

include('./page_footer_admin.'.$phpEx);

?>