<?php
/***************************************************************************
 *
 *                               activity.php
 *                            -------------------
 *   begin                : Thursday, August 1, 2002
 *   copyright            : (c) 2002 Giga Knight
 *   email                : community@gigaknight.com
 *
 *   $Id                  : activity.php v0.2.0
 *
 *   $FMId: 2003/04/29 19:07:45 mj 
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

// Start session management
$userdata = session_pagestart($user_ip, PAGE_ACTIVITY);
init_userprefs($userdata);
// End session management

// include language file
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_games.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_games.' . $phpEx);

// Make sure the player is registered
$user_id = $userdata['user_id'];
$username = $userdata['username'];

if ( !$userdata['session_logged_in'] && $user_id == ANONYMOUS) 
{ 
	redirect("login.".$phpEx."?redirect=activity.".$phpEx); 
	exit; 
} 

// Grab some Gk Game Data ===================================================

$sql = "SELECT * 
	FROM " . GK_TABLE . "";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain quiz information', '', __LINE__, __FILE__, $sql);
}
if ( $row = $db->sql_fetchrow($result) )
{
	// Grab Quiz data
	$quiz_hs = $row['quiz_best_score'];
	$quiz_bp = $row['quiz_best_player'];
	$quiz_bs = $row['quiz_hs_bonus'];

	// Grab Quiz TopTen list
	$quiz_ts1 = $row['quiz_ts1'];   
	$quiz_tn1 = $row['quiz_tn1'];
	$quiz_ts2 = $row['quiz_ts2'];   
	$quiz_tn2 = $row['quiz_tn2'];
	$quiz_ts3 = $row['quiz_ts3'];  
	$quiz_tn3 = $row['quiz_tn3'];
	$quiz_ts4 = $row['quiz_ts4']; 
	$quiz_tn4 = $row['quiz_tn4'];
	$quiz_ts5 = $row['quiz_ts5'];
	$quiz_tn5 = $row['quiz_tn5'];
	$quiz_ts6 = $row['quiz_ts6']; 
	$quiz_tn6 = $row['quiz_tn6'];
	$quiz_ts7 = $row['quiz_ts7'];  
	$quiz_tn7 = $row['quiz_tn7'];
	$quiz_ts8 = $row['quiz_ts8']; 
	$quiz_tn8 = $row['quiz_tn8'];
	$quiz_ts9 = $row['quiz_ts9']; 
	$quiz_tn9 = $row['quiz_tn9'];
	$quiz_ts10 = $row['quiz_ts10'];
	$quiz_tn10 = $row['quiz_tn10'];
}

if ($quiz_bp != 'No Highscore')
{
  $sql = "SELECT user_id, username
          FROM " . USERS_TABLE;
  if ( !($result = $db->sql_query($sql)) )
  {
    message_die(GENERAL_ERROR, 'Could not obtain user information', '', __LINE__, __FILE__, $sql);
  }
  if ( $row = $db->sql_fetchrow($result) )
  {
    $i = 0;
    do
    {
      if ($row['username'] == $quiz_bp)
      {
        $quiz_user_id = $row['user_id'];
      }
      $i++;
    }
    while ( $row = $db->sql_fetchrow($result) );
  }

  if ($quiz_user_id <> '')
  {
    $temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$quiz_user_id");
    $profile = '<a href="' . $temp_url . '"><span class="gentbl">' . $quiz_bp . '</span></a>';
    $quiz_bp = $profile;
  }
}

//===========================================================================

// Start of program proper
if (isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']))
{
  $mode = (isset($HTTP_GET_VARS['mode'])) ? $HTTP_GET_VARS['mode'] : $HTTP_POST_VARS['mode'];

//===========================================================================
  if ($mode == 'quiz')
  {
    include($phpbb_root_path . 'games/quiz/quiz.'.$phpEx);
    exit;
  }

//===========================================================================
  if ($mode == 'take_quiz')
  {
    $quiz_id = ( isset($HTTP_POST_VARS['quiz_id']) ) ? intval($HTTP_POST_VARS['quiz_id']) : 0;

    if ($quiz_id > 0)
    {
      // Check to see if the user has taken this Quiz already
      $sql = "SELECT * FROM " . GK_QUIZERS_TABLE . "
              WHERE quiz_id = $quiz_id";
      if(!$result = $db->sql_query($sql))
      {
		message_die(GENERAL_ERROR, "Could not obtain quiz information", "", __LINE__, __FILE__, $sql);
      }
      $quizers_count = $db->sql_numrows($result);
      $quizers_rows = $db->sql_fetchrowset($result);

      for($i = 0; $i < $quizers_count; $i++)
      {
  	  $user_id = $userdata['user_id']; 
        $quizer_id = $quizers_rows[$i]['user_id'];
        $quizer_quiz = $quizers_rows[$i]['quiz_id'];

        if (($user_id == $quizer_id) && ($quiz_id == $quizer_quiz))
        {
		$message = $lang['Taken_this_quiz'] . "<br /><br />" . sprintf($lang['Click_return_quiz'], "<a href=\"" . append_sid("activity.$phpEx?mode=quiz") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
        }
      }
    }

    if ($quiz_id)
    {
      // Update Quizers table
      $sql = "INSERT INTO " . GK_QUIZERS_TABLE . " (quiz_id,user_id)
              VALUES ('$quiz_id','$user_id')";
      if( !$result = $db->sql_query($sql) )
      {
        message_die(GENERAL_ERROR, "Could not update quiz information", "", __LINE__, __FILE__, $sql);
      }

      // Total number of questions
      $sql = "SELECT * FROM " . GK_QUIZ_TABLE . "
              WHERE quiz_topic_id = $quiz_id";
      if(!$result = $db->sql_query($sql))
      {
        message_die(GENERAL_ERROR, "Could not obtain quiz information", "", __LINE__, __FILE__, $sql);
      }
      if ( $row = $db->sql_fetchrow($result) )
      {
        $total_qs = $row['quiz_topic_total_qs'];
        $quiz_bs = $row['quiz_topic_bonus'];
        $quiz_co = $row['quiz_topic_cost'];
      }

      $total_qs_correct = 0;
      $total_qs_wrong = 0;
      $total_charges = $quiz_co;
      $total_rewards = 0;

      $sql = "SELECT * FROM " . GK_QUIZ_QS_TABLE . "
              WHERE quiz_topic_id = $quiz_id";
      if(!$result = $db->sql_query($sql))
      {
        message_die(GENERAL_ERROR, "Could not obtain question information", "", __LINE__, __FILE__, $sql);
      }
      $quiz_qs_count = $db->sql_numrows($result);
      $quiz_qs_rows = $db->sql_fetchrowset($result);

      // Do Question Math
      $total_charges = ($total_charges + $quiz_qs_rows['quiz_qs_charge']);
      $total_rewards = ($total_rewards + $quiz_qs_rows['quiz_qs_reward']);

      // Run through the Answers
      for($i = 0; $i < $quiz_qs_count; $i++)
      {
        $qs_id = $quiz_qs_rows[$i]['quiz_qs_id'];
        $as_id = ( isset($HTTP_POST_VARS[$qs_id]) ) ? intval($HTTP_POST_VARS[$qs_id]) : 0;

        if ($as_id)
        {
          $_sql = "SELECT * FROM " . GK_QUIZ_AS_TABLE . "
                   WHERE quiz_as_id = $as_id";
          if(!$result = $db->sql_query($_sql))
          {
            message_die(GENERAL_ERROR, "Could not obtain answer information", "", __LINE__, __FILE__, $_sql);
          }
          if ( $row = $db->sql_fetchrow($result) )
          {
            // Do Answer Math
            if ($row['quiz_as_correct'])
            {
              $total_qs_correct++;
            }
            else
            {
              $total_qs_wrong++;
            }
            $total_charges = ($total_charges + $row['quiz_as_charge']);
            $total_rewards = ($total_rewards + $row['quiz_as_reward']);
          }
        }
        else
        { 
		$message = $lang['Answer_all_qs'] . "<br /><br />" . sprintf($lang['Click_return_quiz'], "<a href=\"" . append_sid("activity.$phpEx?mode=play_quiz&quiz_id=$quiz_id") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
        }
      }
      // Finished the Quiz so check for Bonuses
      if ($total_qs_correct == $total_qs)
      {
        $total_rewards = ($total_rewards + $quiz_bs);
      }
      $quiz_percent = ( $total_qs_correct > 0 ) ? $total_qs_correct / $total_qs : 0;

      // Charge/Reward User
      if( $board_config['use_allowance_system'] )
      {
        $quiz_money = (($userdata['user_money'] + $total_rewards) - $total_charges);

        $sql = "UPDATE " . USERS_TABLE . "
                SET user_money = '$quiz_money'
                WHERE user_id = " . $user_id;
        if (!$db->sql_query($sql))
        {
           message_die(GENERAL_ERROR, 'Could not update user information', '', __LINE__, __FILE__, $sql);
        }

        $money = $board_config['money_name'];
      }
      else if ( $board_config['use_point_system'] )
      {
        $quiz_money = (($userdata['user_points'] + $total_rewards) - $total_charges);

        $sql = "UPDATE " . USERS_TABLE . "
                SET user_points = '$quiz_money'
                WHERE user_id = " . $user_id;
        if (!$db->sql_query($sql))
        {
           message_die(GENERAL_ERROR, 'Could not update user points information', '', __LINE__, __FILE__, $sql);
        }

        $money = $board_config['points_name'];
      }

      // Highscore Math
      if ($quiz_bs)
      {
        $score = ($total_qs_correct * $quiz_bs);
      }
      else
      {
        $score = ($total_qs_correct * $total_rewards);
      }

      // Check and/or change Highscore
      if ($score > $quiz_hs)
      {
        // Shuffle around the new top ten list
        $quiz_ts10 = $quiz_ts9; 
	  $quiz_tn10 = $quiz_tn9;
        $quiz_ts9 = $quiz_ts8;  
	  $quiz_tn9 = $quiz_tn8;
        $quiz_ts8 = $quiz_ts7;
        $quiz_tn8 = $quiz_tn7;
        $quiz_ts7 = $quiz_ts6;
        $quiz_tn7 = $quiz_tn6;
        $quiz_ts6 = $quiz_ts5;
	  $quiz_tn6 = $quiz_tn5;
        $quiz_ts5 = $quiz_ts4;
	  $quiz_tn5 = $quiz_tn4;
        $quiz_ts4 = $quiz_ts3;
	  $quiz_tn4 = $quiz_tn3;
	  $quiz_ts3 = $quiz_ts2;
	  $quiz_tn3 = $quiz_tn2;
	  $quiz_ts2 = $quiz_ts1;
	  $quiz_tn2 = $quiz_tn1;
	  $quiz_ts1 = $score;     
	  $quiz_tn1 = $username;

        $sql = "UPDATE " . GK_TABLE . "
                SET quiz_best_score = '$score', quiz_best_player = '$username', quiz_ts1 = '$quiz_ts1', quiz_tn1 = '$quiz_tn1', quiz_ts2 = '$quiz_ts2', quiz_tn2 = '$quiz_tn2', quiz_ts3 = '$quiz_ts3', quiz_tn3 = '$quiz_tn3', quiz_ts4 = '$quiz_ts4', quiz_tn4 = '$quiz_tn4', quiz_ts5 = '$quiz_ts5', quiz_tn5 = '$quiz_tn5', quiz_ts6 = '$quiz_ts6', quiz_tn6 = '$quiz_tn6', quiz_ts7 = '$quiz_ts7', quiz_tn7 = '$quiz_tn7', quiz_ts8 = '$quiz_ts8', quiz_tn8 = '$quiz_tn8', quiz_ts9 = '$quiz_ts9', quiz_tn9 = '$quiz_tn9', quiz_ts10 = '$quiz_ts10', quiz_tn10 = '$quiz_tn10' ";
        if (!$db->sql_query($sql))
        {
          message_die(GENERAL_ERROR, 'Could not update quiz highscore information', '', __LINE__, __FILE__, $sql);
        }
      }

      else if ($score > 0) // Insert user if the score is empty.
      {
        if (($quiz_tn2 == '-:-') || ($score > $quiz_ts2))
        {
          if ($score > $quiz_ts2)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9;
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
            $quiz_ts8 = $quiz_ts7; 
		$quiz_tn8 = $quiz_tn7;
            $quiz_ts7 = $quiz_ts6; 
		$quiz_tn7 = $quiz_tn6;
            $quiz_ts6 = $quiz_ts5; 
		$quiz_tn6 = $quiz_tn5;
            $quiz_ts5 = $quiz_ts4; 
		$quiz_tn5 = $quiz_tn4;
            $quiz_ts4 = $quiz_ts3; 
		$quiz_tn4 = $quiz_tn3;
            $quiz_ts3 = $quiz_ts2; 
		$quiz_tn3 = $quiz_tn2;
          }
          $quiz_ts2 = $score;
          $quiz_tn2 = $username;
        }
        else if (($quiz_tn3 == '-:-') || ($score > $quiz_ts3))
        {
          if ($score > $quiz_ts3)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
            $quiz_ts8 = $quiz_ts7; 
		$quiz_tn8 = $quiz_tn7;
            $quiz_ts7 = $quiz_ts6; 
		$quiz_tn7 = $quiz_tn6;
            $quiz_ts6 = $quiz_ts5; 
		$quiz_tn6 = $quiz_tn5;
            $quiz_ts5 = $quiz_ts4; 
		$quiz_tn5 = $quiz_tn4;
            $quiz_ts4 = $quiz_ts3; 
		$quiz_tn4 = $quiz_tn3;
          }
          $quiz_ts3 = $score;
          $quiz_tn3 = $username;
        }
        else if (($quiz_tn4 == '-:-') || ($score > $quiz_ts4))
        {
          if ($score > $quiz_ts4)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
            $quiz_ts8 = $quiz_ts7; 
		$quiz_tn8 = $quiz_tn7;
            $quiz_ts7 = $quiz_ts6; 
		$quiz_tn7 = $quiz_tn6;
            $quiz_ts6 = $quiz_ts5; 
		$quiz_tn6 = $quiz_tn5;
            $quiz_ts5 = $quiz_ts4; 
		$quiz_tn5 = $quiz_tn4;
          }
          $quiz_ts4 = $score;
          $quiz_tn4 = $username;
        }
        else if (($quiz_tn5 == '-:-') || ($score > $quiz_ts5))
        {
          if ($score > $quiz_ts5)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
            $quiz_ts8 = $quiz_ts7; 
		$quiz_tn8 = $quiz_tn7;
            $quiz_ts7 = $quiz_ts6; 
		$quiz_tn7 = $quiz_tn6;
            $quiz_ts6 = $quiz_ts5; 
		$quiz_tn6 = $quiz_tn5;
          }
          $quiz_ts5 = $score;
          $quiz_tn5 = $username;
        }
        else if (($quiz_tn6 == '-:-') || ($score > $quiz_ts6))
        {
          if ($score > $quiz_ts6)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
            $quiz_ts8 = $quiz_ts7; 
		$quiz_tn8 = $quiz_tn7;
            $quiz_ts7 = $quiz_ts6; 
		$quiz_tn7 = $quiz_tn6;
          }
          $quiz_ts6 = $score;
          $quiz_tn6 = $username;
        }
        else if (($quiz_tn7 == '-:-') || ($score > $quiz_ts7))
        {
          if ($score > $quiz_ts7)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
            $quiz_ts8 = $quiz_ts7; 
		$quiz_tn8 = $quiz_tn7;
          }
          $quiz_ts7 = $score;
          $quiz_tn7 = $username;
        }
        else if (($quiz_tn8 == '-:-') || ($score > $quiz_ts8))
        {
          if ($score > $quiz_ts8)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 	
		$quiz_tn10 = $quiz_tn9;
            $quiz_ts9 = $quiz_ts8; 
		$quiz_tn9 = $quiz_tn8;
          }
          $quiz_ts8 = $score;
          $quiz_tn8 = $username;
        }
        else if (($quiz_tn9 == '-:-') || ($score > $quiz_ts9))
        {
          if ($score > $quiz_ts9)
          {
            // Bump the scores
            $quiz_ts10 = $quiz_ts9; 
		$quiz_tn10 = $quiz_tn9;
          }
          $quiz_ts9 = $score;
          $quiz_tn9 = $username;
        }
        else if (($quiz_tn10 == '-:-') || ($score > $quiz_ts10))
        {
          $quiz_ts10 = $score;
          $quiz_tn10 = $username;
        }

        $sql = "UPDATE " . GK_TABLE . "
                SET quiz_ts1 = '$quiz_ts1', quiz_tn1 = '$quiz_tn1', quiz_ts2 = '$quiz_ts2', quiz_tn2 = '$quiz_tn2', quiz_ts3 = '$quiz_ts3', quiz_tn3 = '$quiz_tn3', quiz_ts4 = '$quiz_ts4', quiz_tn4 = '$quiz_tn4', quiz_ts5 = '$quiz_ts5', quiz_tn5 = '$quiz_tn5', quiz_ts6 = '$quiz_ts6', quiz_tn6 = '$quiz_tn6', quiz_ts7 = '$quiz_ts7', quiz_tn7 = '$quiz_tn7', quiz_ts8 = '$quiz_ts8', quiz_tn8 = '$quiz_tn8', quiz_ts9 = '$quiz_ts9', quiz_tn9 = '$quiz_tn9', quiz_ts10 = '$quiz_ts10', quiz_tn10 = '$quiz_tn10' ";
        if (!$db->sql_query($sql))
        {
          message_die(GENERAL_ERROR, 'Could not update quiz information', '', __LINE__, __FILE__, $sql);
        }
      }

      // Display Quiz Finished/Stats
      $template->set_filenames(array(
		"body" => "quiz_done.tpl")
	);
	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

      $template->assign_vars(array(
		"L_QUIZ_STATS" => $lang['Quiz_stats'],
		"L_TOTAL_QUESTIONS" => $lang['Total_questions'],
		"L_CORRECT_ANSWERS" => $lang['Correct_answers'],
		"L_INCORRECT_ANSWERS" => $lang['Incorrect_answers'],
		"L_YOUR_SCORE" => $lang['Your_score'],
		"L_WON" => $lang['Won'],
		"L_MONEY" => $money,
		"L_PERCENT_CORRECT" => $lang['Percent_correct'],

		"TOTAL_QS" => $total_qs,
		"TOTAL_CORRECT" => $total_qs_correct,
		"TOTAL_WRONG" => $total_qs_wrong,
		"SCORE" => $score,
		"TOTAL_WON" => $total_rewards,

		"QUIZ_PERCENT" => sprintf("%.1d%%", ($quiz_percent * 100)))
	);
	}
	else
	{
		message_die(GENERAL_MESSAGE, "You must select a Quiz First.", "", __LINE__, __FILE__, $sql);
	}
}

//===========================================================================
if ($mode == 'play_quiz')
{
	$quiz_id = ( isset($HTTP_GET_VARS['quiz_id']) ) ? intval($HTTP_GET_VARS['quiz_id']) : 0;

	if ($quiz_id > 0)
	{
	// Check to see if the user has taken this Quiz already
	$sql = "SELECT * FROM " . GK_QUIZERS_TABLE . "
		WHERE quiz_id = $quiz_id";
	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not obtain quiz information","", __LINE__, __FILE__, $sql);
	}
	$quizers_count = $db->sql_numrows($result);
      $quizers_rows = $db->sql_fetchrowset($result);

      for($i = 0; $i < $quizers_count; $i++)
      {
		$user_id = $userdata['user_id']; 
		$quizer_id = $quizers_rows[$i]['user_id'];
		$quizer_quiz = $quizers_rows[$i]['quiz_id'];

		if (($quizer_id == $user_id) && ($quizer_quiz == $quiz_id))
		{
		$message = $lang['Taken_this_quiz'] . "<br /><br />" . sprintf($lang['Click_return_quiz'], "<a href=\"" . append_sid("activity.$phpEx?mode=quiz") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
		}
	}
}

if ($quiz_id)
{
	// Grab Quiz Info
	$sql = "SELECT * FROM " . GK_QUIZ_TABLE . "
              WHERE quiz_topic_id = $quiz_id";
      if(!$result = $db->sql_query($sql))
      {
		message_die(GENERAL_ERROR, "Could not obtain quiz information", "", __LINE__, __FILE__, $sql);
      }
      $quiz_info = $db->sql_fetchrow($result);

      $s_hidden_fields = '<input type="hidden" name="quiz_id" value="' . $quiz_id . '" />';

      $template->set_filenames(array(
		"body" => "quiz_body.tpl")
	);
	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

      $template->assign_vars(array(
		"QUIZ" => $quiz_info['quiz_topic_name'],
					
		"L_EDIT" => $lang['Edit'],
		"L_SUBMIT" => $lang['Submit'],
		"L_RESET" => $lang['Reset'],

		"S_QUIZ_HIDDEN" => $s_hidden_fields,
		"S_QUIZ_ACTION" => append_sid('activity.'.$phpEx.'?mode=take_quiz'))
      );

      $sql = "SELECT * FROM " . GK_QUIZ_QS_TABLE . "
              WHERE quiz_topic_id = $quiz_id";
      if(!$result = $db->sql_query($sql))
      {
		message_die(GENERAL_ERROR, "Could not obtain question information", "", __LINE__, __FILE__, $sql);
      }
      $quiz_qs_count = $db->sql_numrows($result);
      $quiz_qs_rows = $db->sql_fetchrowset($result);

      for($i = 0; $i < $quiz_qs_count; $i++)
      {
		$qs_id = $quiz_qs_rows[$i]['quiz_qs_id'];

		$_sql = "SELECT * FROM " . GK_QUIZ_AS_TABLE . "
                WHERE quiz_qs_id = $qs_id";
		if(!$result = $db->sql_query($_sql))
		{
			message_die(GENERAL_ERROR, "Could not obtain answer information", "", __LINE__, __FILE__, $_sql);
		}
		$quiz_as_count = $db->sql_numrows($result);
		$quiz_as_rows = $db->sql_fetchrowset($result);

		$answers = '';

		for($j = 0; $j < $quiz_as_count; $j++)
		{
			$quiz_as_display_img = ( $quiz_as_rows[$j]['quiz_as_img'] != "" ) ? '<img align="middle" src="./games/quiz/images/' . $quiz_as_rows[$j]['quiz_as_img'] . '">' : "";
			$as_id = $quiz_as_rows[$j]['quiz_as_id'];

			$answers .= '<tr>';
			$answers .= '<td class="row2">';
			$answers .= $quiz_as_display_img . '&nbsp;';
			$answers .= $quiz_as_rows[$j]['quiz_as_name'];
			$answers .= '</td>';
			$answers .= '<td class="row2" width="5%"><input type="radio" name="' . $qs_id . '" value="' . $as_id . '">';
			$answers .= '</tr>';
		}

			$quiz_qs_name = $quiz_qs_rows[$i]['quiz_qs_name'];
			$quiz_qs_img = $quiz_qs_rows[$i]['quiz_qs_img'];
			
			$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
			$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

			$template->assign_block_vars("quiz_qs", array(
				"ROW_COLOR" => "#" . $row_color,
				"ROW_CLASS" => $row_class,
	
				"QUIZ_AS" => $answers,
	
				"QUIZ_QS_NAME" => $quiz_qs_name,
				"QUIZ_QS_DISPLAY_IMG" => ( $quiz_qs_img != "" ) ? '<img align="middle" src="./games/quiz/images/' . $quiz_qs_img . '">' : "")
		        );
	      }
	}
	else
	{
	      message_die(GENERAL_MESSAGE, "You must select a Quiz First", "", __LINE__, __FILE__, $sql);
	}
}

//===========================================================================
if ($mode == 'quiz_topten')
{
	$template->set_filenames(array(
		"body" => "activity_topten.tpl") 
	);
	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

	$template->assign_vars(array(
		"L_TOPTEN_BEST" => $lang['Topten_players'],
		
		"TITLE" => $lang['Quiz'],
		"SCORE_1" => $quiz_ts1, 
		"NAME_1" => $quiz_tn1,
		"SCORE_2" => $quiz_ts2, 
		"NAME_2" => $quiz_tn2,
		"SCORE_3" => $quiz_ts3, 
		"NAME_3" => $quiz_tn3,
		"SCORE_4" => $quiz_ts4, 
		"NAME_4" => $quiz_tn4,
		"SCORE_5" => $quiz_ts5, 
		"NAME_5" => $quiz_tn5,
		"SCORE_6" => $quiz_ts6, 
		"NAME_6" => $quiz_tn6,
		"SCORE_7" => $quiz_ts7, 
		"NAME_7" => $quiz_tn7,
		"SCORE_8" => $quiz_ts8, 
		"NAME_8" => $quiz_tn8,
		"SCORE_9" => $quiz_ts9, 
		"NAME_9" => $quiz_tn9,
		"SCORE_10" => $quiz_ts10, 
		"NAME_10" => $quiz_tn10,

		"L_GAMES" => $lang['Online_games'],
		"L_TOPTEN" => $lang['Top_ten'],
		"L_HIGHSCORE" => $lang['Highscore'],
		"L_VARIES" => $lang['Varies'])
	);
	}
}

else // Display Default Page
{
	$template->set_filenames(array(
		'body' => 'activity_body.tpl') 
	);
	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

	$template->assign_vars(array(
		'QUIZ_BP' => $quiz_bp,
		'QUIZ_HS' => $quiz_hs,

		'L_QUIZ' => $lang['Quiz'],
		'L_QUIZ_EXPLAIN' => $lang['Quiz_explain'],
		'L_MONEY' => $board_config['money_name'],
		'L_VARIES' => $lang['Varies'],
		'L_HIGHSCORE' => $lang['Highscore'],
		'L_TOPTEN' => $lang['Topten'],
		'L_MONEY' => $board_config['points_name'],

		'U_QUIZ' => append_sid('activity.'.$phpEx.'?mode=quiz'),
		'U_QUIZ_TOPTEN' => append_sid('activity.'.$phpEx.'?mode=quiz_topten'))
	);
}

//===========================================================================
// Generate page

$page_title = $lang['Online_games'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>