///////////////////////////////////////
// CodeBox.cpp
// Helper unit for various projects
// Copyright (c) 1997 by Charlie Calvert
//
#include <vcl/vcl.h>
#include <windows.h>
#include <wtypes.h>
#include <stdio.h>
#include <ddraw.h>
#include <vcl\oleauto.hpp>
#include <vcl\ole2.hpp>
#include <vcl\oleconst.hpp>
#include <vcl\registry.hpp>
#pragma hdrstop

#include "CodeBox.h"


void FontFromRegistry(TFont *Font, TRegIniFile *RegFile)
{
  Font->Color = TColor(RegFile->ReadInteger("Font", "Color", clBtnFace));
  Font->Size = RegFile->ReadInteger("Font", "Size", 12);
  int Value = RegFile->ReadInteger("Font", "Style", fsNormal);
  for (int i = 0; i < 4; i++)
    if (BitOn(i, Value))
      Font->Style = Font->Style << TFontStyle(i);
  Font->Name = RegFile->ReadString("Font", "Name", "New Times Roman");
  Font->Pitch = TFontPitch(RegFile->ReadInteger("Font", "Pitch", fpDefault));
}

void FontToRegistry(TFont *Font, TRegIniFile *RegFile)
{
  RegFile->WriteInteger("Font", "Size", Font->Size);
  int Value = 0;
  for (int i = 0; i < 4; i++)
  {
    if(Font->Style.Contains(TFontStyle(i)))
      SetBit(i, 1, Value);
  }
  RegFile->WriteInteger("Font", "Style", Value);
  RegFile->WriteString("Font", "Name", Font->Name);
  RegFile->WriteInteger("Font", "Pitch", Font->Pitch);
  RegFile->WriteInteger("Font", "Color", Font->Color);
}

void ShowMessage(HRESULT hr)
{
  char S[100];
  sprintf(S, "Error: %x", hr);
  // FormatMessage
  MessageBox(0, S, "Info", MB_OK);
}

BOOL CreateLocalObject(GUID ClassID, IUnknown *Unknown)
{
  IClassFactory *ClassFactory;
  ClassFactory = NULL;
  HRESULT hr;

  hr = CoGetClassObject(ClassID, CLSCTX_LOCAL_SERVER, NULL,
                   IID_IClassFactory, (void **)&ClassFactory);

  if (hr != S_OK)
     ShowMessage(hr);
  else if (ClassFactory != NULL)
  {
    ClassFactory->CreateInstance(NULL, IID_IUnknown, (void **)&Unknown);
    ClassFactory->Release();
    return TRUE;
  }

  return FALSE;
}

BOOL CreateRemoteObject(GUID ClassID, char *Server, Variant &V)
{
  IClassFactory *ClassFactory;
  IUnknown *Unknown1;
  COSERVERINFO Info;
  OLECHAR Dest[MAX_PATH];

  int i = MultiByteToWideChar(CP_ACP, 0, Server, -1, Dest, MAX_PATH);
  if (i <= 0)
    return FALSE;

  ClassFactory = NULL;
  Info.dwReserved1 = 0;
  Info.pAuthInfo = NULL;
  Info.dwReserved2 = 0;
  Info.pwszName = Dest;

  HRESULT hr = CoGetClassObject(ClassID, CLSCTX_REMOTE_SERVER, &Info,
                 IID_IClassFactory, (void **)&ClassFactory);
  OleCheck(hr);
  
  if (ClassFactory != NULL)
  {
    hr = ClassFactory->CreateInstance(NULL, IID_IUnknown, (void **)&Unknown1);
    OleCheck(hr);
    V = VarFromInterface(Unknown1);
    ClassFactory->Release();
    if (VarType(V) != varNull)
      return True;
    else
      return False;
  }

  return FALSE;
}

AnsiString GetVariantType(Variant &V)
{
  TVarData VarData;
  AnsiString S;

  VarData = TVarData(V);
  switch (VarData.VType)
  {
    case varEmpty: S = "varEmpty"; break;
    case varNull:  S = "varNull";  break;
    case varSmallint: S = "varSmallInt";  break;
    case varInteger: S = "varInteger";  break;
    case varSingle: S = "varSingle"; break;
    case varDouble: S= "varDouble"; break;
    case varCurrency: S = "varCurrency"; break;
    case varDate: S = "varDate"; break;
    case varOleStr: S = "varOleStr"; break;
    case varDispatch: S = "varDispatch"; break;
    case varError: S = "varError"; break;
    case varBoolean: S = "varBoolean"; break;
    case varVariant: S = "varVariant"; break;
    case varUnknown: S = "varUnknown"; break;
    case varString: S = "varString"; break;
    case varTypeMask: S = "varTypeMask"; break;
    case varByRef: S = "varByRef"; break;
    case varByte: S = "varByte"; break;
    case varArray: S = "varArray"; break;
    default:
      S = "Error";
  }
  return S;
}

AnsiString GetDirectDrawError(System::HResult ErrorCode)
{
  AnsiString S;
  switch (ErrorCode)
  {
    case DDERR_ALREADYINITIALIZED: S = "Already Initialized"; break;
    case DDERR_CANNOTATTACHSURFACE: S = "Can''t Attach Surface"; break;
    case DDERR_CANNOTDETACHSURFACE: S = "CANNOT DETACH SURFACE"; break;
    case DDERR_CURRENTLYNOTAVAIL: S = "Currently Not Available"; break;
    case DDERR_EXCEPTION: S = "Exception"; break;
    case DDERR_GENERIC: S = "E_FAIL"; break;
    case DDERR_HEIGHTALIGN: S = "Height Align"; break;
    case DDERR_INCOMPATIBLEPRIMARY: S = "Incompatible Primary"; break;
    case DDERR_INVALIDCAPS: S = "Invalid Caps"; break;
    case DDERR_INVALIDCLIPLIST: S = "Invalid Clip List"; break;
    case DDERR_INVALIDMODE: S = "Invalid Mode"; break;
    case DDERR_INVALIDOBJECT: S = "Invalid Object"; break;
    case DDERR_INVALIDPARAMS: S = "E_INVALIDARG"; break;
    case DDERR_INVALIDPIXELFORMAT: S = "Invalid Pixel Format"; break;
    case DDERR_INVALIDRECT: S = "Invalid Rectangle"; break;
    case DDERR_LOCKEDSURFACES: S = "Locked Surfaces"; break;
    case DDERR_NO3D: S = "No 3D"; break;
    case DDERR_NOALPHAHW: S = "No Alpha HW"; break;
    case DDERR_NOCLIPLIST: S = "No Clip List"; break;
    case DDERR_NOCOLORCONVHW: S = "No Color Conv HW"; break;
    case DDERR_NOCOOPERATIVELEVELSET: S = "No Cooperative Level Set"; break;
    case DDERR_NOCOLORKEY: S = "No Color Key"; break;
    case DDERR_NOCOLORKEYHW: S = "No Color Key HW"; break;
    case DDERR_NODIRECTDRAWSUPPORT: S = "No Direct Draw Support"; break;
    case DDERR_NOEXCLUSIVEMODE: S = "No Exclusive Mode"; break;
    case DDERR_NOFLIPHW: S = "No Flip HW"; break;
    case DDERR_NOGDI: S = "No GDI"; break;
    case DDERR_NOMIRRORHW: S = "250"; break;
    case DDERR_NOTFOUND: S = "255"; break;
    case DDERR_NOOVERLAYHW: S = "260"; break;
    case DDERR_NORASTEROPHW: S = "280"; break;
    case DDERR_NOROTATIONHW: S = "290"; break;
    case DDERR_NOSTRETCHHW: S = "310"; break;
    case DDERR_NOT4BITCOLOR: S = "316"; break;
    case DDERR_NOT4BITCOLORINDEX: S = "317"; break;
    case DDERR_NOT8BITCOLOR: S = "320"; break;
    case DDERR_NOTEXTUREHW: S = "330"; break;
    case DDERR_NOVSYNCHW: S = "335"; break;
    case DDERR_NOZBUFFERHW: S = "340"; break;
    case DDERR_NOZOVERLAYHW: S = "350"; break;
    case DDERR_OUTOFCAPS: S = "360"; break;
    case DDERR_OUTOFMEMORY: S = "E_OUTOFMEMORY"; break;
    case DDERR_OUTOFVIDEOMEMORY: S = "Out Of Video Memory"; break;
    case DDERR_OVERLAYCANTCLIP: S = "382"; break;
    case DDERR_OVERLAYCOLORKEYONLYONEACTIVE: S = "Overlay Color Key Only One Active"; break;
    case DDERR_PALETTEBUSY: S = "Palette Busy"; break;
    case DDERR_COLORKEYNOTSET: S = "ColorKey Not Set"; break;
    case DDERR_SURFACEALREADYATTACHED: S = "Surface Already Attached"; break;
    case DDERR_SURFACEALREADYDEPENDENT: S = "Surface Already Dependent"; break;
    case DDERR_SURFACEBUSY: S = "Surface Busy"; break;
    case DDERR_SURFACEISOBSCURED: S = "Surface Is Obscured"; break;
    case DDERR_SURFACELOST: S = "Surface Lost"; break;
    case DDERR_SURFACENOTATTACHED: S = "Surface Not Attached"; break;
    case DDERR_TOOBIGHEIGHT: S = "Too Big Height"; break;
    case DDERR_TOOBIGSIZE: S = "Too Big Size"; break;
    case DDERR_TOOBIGWIDTH: S = "Too Big Width"; break;
    case DDERR_UNSUPPORTED: S = "E_NOTIMPL"; break;
    case DDERR_UNSUPPORTEDFORMAT: S = "Unsupported Format"; break;
    case DDERR_UNSUPPORTEDMASK: S = "520"; break;
    case DDERR_VERTICALBLANKINPROGRESS: S = "537"; break;
    case DDERR_WASSTILLDRAWING: S = "540"; break;
    case DDERR_XALIGN: S = "560"; break;
    case DDERR_INVALIDDIRECTDRAWGUID: S = "Invalid Direct Draw GUID"; break;
    case DDERR_DIRECTDRAWALREADYCREATED: S = "562"; break;
    case DDERR_NODIRECTDRAWHW: S = "563"; break;
    case DDERR_PRIMARYSURFACEALREADYEXISTS: S = "564"; break;
    case DDERR_NOEMULATION: S = "565"; break;
    case DDERR_REGIONTOOSMALL: S = "566"; break;
    case DDERR_CLIPPERISUSINGHWND: S = "567"; break;
    case DDERR_NOCLIPPERATTACHED: S = "568"; break;
    case DDERR_NOHWND: S = "569"; break;
    case DDERR_HWNDSUBCLASSED: S = "570"; break;
    case DDERR_HWNDALREADYSET: S = "571"; break;
    case DDERR_NOPALETTEATTACHED: S = "572"; break;
    case DDERR_NOPALETTEHW: S = "573"; break;
    case DDERR_BLTFASTCANTCLIP: S = "574"; break;
    case DDERR_NOBLTHW: S = "575"; break;
    case DDERR_NODDROPSHW: S = "576"; break;
    case DDERR_OVERLAYNOTVISIBLE: S = "577"; break;
    case DDERR_NOOVERLAYDEST: S = "578"; break;
    case DDERR_INVALIDPOSITION: S = "579"; break;
    case DDERR_NOTAOVERLAYSURFACE: S = "580"; break;
    case DDERR_EXCLUSIVEMODEALREADYSET: S = "581"; break;
    case DDERR_NOTFLIPPABLE: S = "582"; break;
    case DDERR_CANTDUPLICATE: S = "583"; break;
    case DDERR_NOTLOCKED: S = "584"; break;
    case DDERR_CANTCREATEDC: S = "585"; break;
    case DDERR_NODC: S = "586"; break;
    case DDERR_WRONGMODE: S = "587"; break;
    case DDERR_IMPLICITLYCREATED: S = "588"; break;
    case DDERR_NOTPALETTIZED: S = "589"; break;
    case DDERR_UNSUPPORTEDMODE: S = "590"; break;
    default:
    {
      S = SysErrorMessage(ErrorCode);
      if (S == "") ;
    //    FmtStr(S, LoadStr(Oleconst::_SOleError), OPENARRAY(TVarRec, (int(ErrorCode))));
    }
  }
  return "GetOleError: " + S;
}

///////////////////////////////////////////////////////////////////////////////
// String functions ///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

AnsiString Address2Str(void *Addr)
{
  return Format("%p", OPENARRAY(TVarRec, (Addr)));
}


AnsiString GetFirstToken(AnsiString S, char Token)
{
  AnsiString Temp;
  int Index;

  Index = S.Pos(Token);

  if (Index < 1)
  {
    return Temp;
  }

  Index--;
  Temp.SetLength(Index);

  memcpy(Temp.c_str(), S.c_str(), Index);
  return Temp;
}

///////////////////////////////////////
// Strip all instances of a character from a string
// S: string to pillage
// Ch: character to delete
AnsiString StripChars(AnsiString S, char Ch)
{
  int Index;
  BOOL NotDone = TRUE;
  while (NotDone)
  {
    Index = S.Pos(Ch); 
    if (Index == 0)
      NotDone = FALSE; 
    else
      S.Delete(Index, 1); 
  }
  return S; 
}

AnsiString StripFirstToken(AnsiString &S, char Token)
{
  AnsiString TokenStr(Token);
  AnsiString Temp1;
  AnsiString Temp2 = S + " ";

  Temp1 = strtok(S.c_str(), TokenStr.c_str());
  Temp2 = strrev(Temp2.c_str());
  Temp2.SetLength(Temp2.Length() - (Temp1.Length() + 1));
  S = strrev(Temp2.c_str());
  return S;
}

AnsiString Shorten(AnsiString S, int Cut)
{
  S.SetLength(S.Length() - Cut);
  return S;
}

AnsiString StripFromFront(AnsiString S, int Len)
{
  S = strrev(S.c_str());
  S = Shorten(S, Len);
  S = strrev(S.c_str());
  return S;
}

AnsiString StripLastToken(AnsiString S, char Token)
{
  AnsiString TokenStr(Token);
  AnsiString Temp1;
  AnsiString Temp2(S);
  AnsiString NewVal;

  S = strrev(S.c_str());
  Temp1 = strtok(S.c_str(), TokenStr.c_str());
  NewVal = strrev(Temp2.c_str());
  NewVal.SetLength(NewVal.Length() - (Temp1.Length() + 1));
  return NewVal;
}

/* This function accepts a integer and returns
  a string of ones and zeros indicating the
  binary form of an int */
AnsiString ShowBits(int n)
{
  AnsiString S;
  int i;
  static int size= 8 * sizeof(int);
  S.SetLength(32);

  for (i = size - 1; i >= 0; i--, n>>=1)
  {
    S[i] = char((01 & n) + '0');
  }
  S[size] = '\0';
  return S;
}


/* This procedure sets a particular bit in the byte changebyte
   to either 1 or 0. The bit is specified by Position, which can range
   from 0 to 7. In Value, put 1 if you want the bit Position set to 1
   and put 0 if you want bit Position set to 0. The right byte is Position
   0, the far left is Position 7. Based on a routine found in
   Turbo Pascal by Stephen K O'Brian. */
void SetBit(int Position, int Value, int &ChangeByte)
{
  int bt;
  bt = 0x01;
  bt = bt << Position;
  if (Value == 1)
    ChangeByte = ChangeByte | bt;
  else
  {
    bt = bt ^ 0xFFFFFFFF;
    ChangeByte = ChangeByte & bt;
  }
}

/* This function tests if a bit in TestByte is turned on (equal to 1).
  If the bit indicated by Position is turned on, then BitOn returns True. */
bool BitOn(int Position, int TestByte)
{
  int bt;

  bt = 0x01;
  bt = bt << Position;
  return (bt & TestByte) > 0;
}



