#ifndef Ftp2H
#define Ftp2H

class PACKAGE TMyFtp : public Classes::TComponent
{
  typedef Classes::TComponent* inherited;
private:
  int FContext;
  bool FConnected;
  void *FINet;
  void *FFtpHandle;
  Classes::TStringList* FCurFiles;
  System::AnsiString FServer;
  Classes::TNotifyEvent FOnNewDir;
  System::AnsiString FCurDir;
  System::AnsiString FUserID;
  System::AnsiString FPassword;
  System::AnsiString __fastcall GetCurrentDirectory(void);
  void __fastcall SetUpNewDir(void);
protected:
  __fastcall virtual ~TMyFtp(void);
public:
  __fastcall TMyFtp(Classes::TComponent* AOwner);
  void __fastcall Connect(void);
  Classes::TStringList* __fastcall FindFiles(void);
  bool __fastcall BackOneDir(void);
  bool __fastcall ChangeDir(System::AnsiString *S);
  bool __fastcall ChangeDirCustom(System::AnsiString *S);
  bool __fastcall CreateDirectory(AnsiString S);
  bool __fastcall RemoveDir(System::AnsiString S);
  bool __fastcall RemoveDirCustom(System::AnsiString S);
  bool __fastcall DeleteFile(System::AnsiString S);
  bool __fastcall DeleteFileCustom(System::AnsiString S);
  bool __fastcall GetFile(System::AnsiString FTPFile,  System::AnsiString NewFile);
  bool __fastcall SendFile1(System::AnsiString FTPFile,  System::AnsiString NewFile);
  bool __fastcall SendFile2(System::AnsiString FTPFile,  System::AnsiString NewFile);
  System::AnsiString *__fastcall CustomToFileName(System::AnsiString *S);
__published:
  __property Classes::TStringList* CurFiles = {read=FCurFiles, nodefault};
  __property System::AnsiString CurDir = {read=GetCurrentDirectory, nodefault};
  __property System::AnsiString UserID = {read=FUserID, write=FUserID, nodefault};
  __property System::AnsiString Password = {read=FPassword, write=FPassword, nodefault};
  __property System::AnsiString Server = {read=FServer, write=FServer, nodefault};
  __property Classes::TNotifyEvent OnNewDir = {read=FOnNewDir, write=FOnNewDir};
};

#endif
