///////////////////////////////////////
// Add a "#pragma comment(lib, "Inet.lib")" statement to the
// module that requires the lib.
// Add a "#pragma link "codebox.obj"" into the module that needs
// an obj.
///////////////////////////////////////
#include <vcl\vcl.h>
#include <wininet.h>
#pragma hdrstop
#pragma comment(lib, "Inet.lib")
#pragma link "codebox.obj"
#include "codebox.h"
#include "Ftp2.h"
#pragma package(smart_init)

__fastcall TMyFtp::~TMyFtp(void)
{
  if (FINet != NULL)
    InternetCloseHandle(FINet);
  if (FFtpHandle != NULL)
    InternetCloseHandle(FFtpHandle);
}

__fastcall TMyFtp::TMyFtp(Classes::TComponent* AOwner)
: TComponent(AOwner)
{
  FCurFiles = new TStringList();
  FINet = InternetOpen("WinINet1", 0, NULL, 0, 0);
  FFtpHandle = NULL;
  FConnected = False;
}

void __fastcall TMyFtp::Connect(void)
{
  AnsiString S;
  AnsiString CR1("\x00D\x00A");

  FContext = 255;
  FFtpHandle = InternetConnect(FINet, FServer.c_str(), 0,
   FUserID.c_str(), FPassword.c_str(),
   INTERNET_SERVICE_FTP, 0, FContext);
  if (FFtpHandle == NULL)
  {
    S = "Connection failed" + CR1 +
         "Server: " + FServer + CR1 +
         "UserID: " + FUserID + CR1 +
         "Password: " + FPassword;
    Screen->Cursor = Controls::TCursor(crDefault);
    throw Exception(S);
  }
  else
  {
    FConnected = True;
    SetUpNewDir();
  }
}

System::AnsiString __fastcall TMyFtp::GetCurrentDirectory(void)
{
  DWORD Len = 0;

  FtpGetCurrentDirectory(FFtpHandle, FCurDir.c_str(), &Len);
  FCurDir.SetLength(Len);
  FtpGetCurrentDirectory(FFtpHandle, FCurDir.c_str(), &Len);
  return FCurDir;
}

void __fastcall TMyFtp::SetUpNewDir(void)
{
  FCurDir = GetCurrentDirectory();
  if (FOnNewDir != NULL)
    FOnNewDir(this);
}

AnsiString GetDots(int NumDots)
{
  AnsiString S;
  int i;
  for (i = 1; i <= NumDots; i++)
    S = S + " ";
  return S;
}

AnsiString *GetFindDataStr(WIN32_FIND_DATA FindData, AnsiString *S)
{
  AnsiString Temp;
  switch (FindData.dwFileAttributes)
  {
    case FILE_ATTRIBUTE_ARCHIVE:
    {
      *S = 'A';
      break;
    }

    case FILE_ATTRIBUTE_COMPRESSED:
      *S = 'C';
      break;

    case FILE_ATTRIBUTE_DIRECTORY:
      *S = 'D';
      break;

    case FILE_ATTRIBUTE_HIDDEN:
      *S = 'H';
      break;

    case FILE_ATTRIBUTE_NORMAL:
      *S = 'N';
      break;

    case FILE_ATTRIBUTE_READONLY:
      *S = 'R';
      break;

    case FILE_ATTRIBUTE_SYSTEM:
      *S = 'S';
      break;

    case FILE_ATTRIBUTE_TEMPORARY:
      *S = 'T';
      break;

    default:
      *S = IntToStr(FindData.dwFileAttributes);
  }

  *S = *S + GetDots(75);
  S->Insert(FindData.cFileName, 6);
  Temp = IntToStr(FindData.nFileSizeLow);
  S->Insert(Temp, 25);
  return S;
}

Classes::TStringList* __fastcall TMyFtp::FindFiles(void)
{
  WIN32_FIND_DATA FindData;
  HINTERNET FindHandle;
  AnsiString Temp;

   FCurFiles->Clear();
   FindHandle = FtpFindFirstFile(FFtpHandle, "*.*", &FindData, 0, 0);
   if (FindHandle == NULL)
   {
     return FCurFiles;
   }

   GetFindDataStr(FindData, &Temp);
   FCurFiles->Add(Temp);

   while (InternetFindNextFile(FindHandle, &FindData))
   {
     GetFindDataStr(FindData, &Temp);
     FCurFiles->Add(Temp);
   }
   InternetCloseHandle(FindHandle);

   return FCurFiles;
}

bool __fastcall TMyFtp::ChangeDir(System::AnsiString *S)
{
  if(!FConnected)
    throw Exception("You must connect first!");
  if (S->Length() != 0)
    if (!FtpSetCurrentDirectory(FFtpHandle, S->c_str()))
    {
      ShowMessage("Could not change to: " + *S);
      return FALSE;
    }
  FindFiles();
  SetUpNewDir();
  return TRUE;
}

System::AnsiString *__fastcall TMyFtp::CustomToFileName(System::AnsiString *S)
{
  const int PreSize = 5;
  AnsiString Temp;
  int TempSize;

  TempSize = S->Length() - PreSize;
  Temp.SetLength(TempSize);
  *S = StripFromFront(*S, PreSize);
  memcpy(Temp.c_str(), S->c_str(), TempSize);
  *S = GetFirstToken(Temp, ' ');
  return S;
}

bool __fastcall TMyFtp::ChangeDirCustom(System::AnsiString *S)
{
  AnsiString Temp = *CustomToFileName(S);
  return ChangeDir(&Temp);
}

bool __fastcall TMyFtp::CreateDirectory(AnsiString S)
{
  return FtpCreateDirectory(FFtpHandle, S.c_str());
}

bool __fastcall TMyFtp::RemoveDir(System::AnsiString S)
{
  return FtpRemoveDirectory(FFtpHandle, S.c_str());
}

bool __fastcall TMyFtp::RemoveDirCustom(System::AnsiString S)
{
  AnsiString Temp = *CustomToFileName(&S);
  return RemoveDir(Temp);
}

bool __fastcall TMyFtp::BackOneDir(void)
{
  AnsiString S;
  S = FCurDir;
  S = StripLastToken(S, '/');
  if (S == '/')
  {
    return FALSE;
  }

  if (S.Length() != 0)
  {
    ChangeDir(&S);
  }
  else
  {
    S = '/';
    ChangeDir(&S);
  }
  return TRUE;
}

bool __fastcall TMyFtp::DeleteFile(System::AnsiString S)
{
  return FtpDeleteFile(FFtpHandle, S.c_str());
}

bool __fastcall TMyFtp::DeleteFileCustom(System::AnsiString S)
{
  S = *CustomToFileName(&S);
  return DeleteFile(S);
}

bool __fastcall TMyFtp::GetFile(System::AnsiString FTPFile,
  System::AnsiString NewFile)
{
  return FtpGetFile(FFtpHandle, FTPFile.c_str(), NewFile.c_str(),
    False, FILE_ATTRIBUTE_NORMAL, FTP_TRANSFER_TYPE_BINARY, 0);
}

bool __fastcall TMyFtp::SendFile1(System::AnsiString FTPFile,
  System::AnsiString NewFile)
{
  DWORD Size = 3000;
  AnsiString S;

  BOOL Transfer = FtpPutFile(FFtpHandle,
                       FTPFile.c_str(),
                       NewFile.c_str(),
                       FTP_TRANSFER_TYPE_BINARY, 0);
  if (!Transfer)
  {
    int Error = GetLastError();
    S = Format("Error Number: %d. Hex: %x",
      OPENARRAY(TVarRec, (Error, Error)));
    ShowMessage(S);
    S.SetLength(Size);
    if (!InternetGetLastResponseInfo(&(DWORD)Error, S.c_str(), &Size))
    {
      Error = GetLastError();
      ShowMessage(Format("Error Number: %d. Hex: %x",
        OPENARRAY(TVarRec, (Error, Error))));
    }
    ShowMessage(Format("Error Number: %d. Hex: %x Info: %s",
                OPENARRAY(TVarRec, (Error, Error, S))));
  }
  //else
    //ShowMessage("Success");

  return Transfer;
}

bool __fastcall TMyFtp::SendFile2(System::AnsiString FTPFile,
  System::AnsiString NewFile)
{
  HINTERNET FHandle;

  FHandle = FtpOpenFile(FFtpHandle, "sam.txt", GENERIC_READ,
                           FTP_TRANSFER_TYPE_BINARY, 0);
  if (FHandle != NULL)
    InternetCloseHandle(FHandle);
  else
    ShowMessage("Failed");
  return TRUE;
}

namespace Ftp2
{
  void __fastcall PACKAGE Register()
  {
    TComponentClass classes[1] = {__classid(TMyFtp)};
    RegisterComponents("Unleash", classes, 0);
  }

}

