#!/usr/bin/perl -w

##############################################################################
# Simple Search                 Version 1.0                                  #
# Copyright 1996 Matt Wright    mattw@worldwidemart.com                      #
# Created 12/16/95              Last Modified 12/16/95                       #
# Scripts Archive at:           http://www.worldwidemart.com/scripts/        #
##############################################################################
# COPYRIGHT NOTICE                                                           #
# Copyright 1996 Matthew M. Wright  All Rights Reserved.                     #
#                                                                            #
# Simple Search may be used and modified free of charge by anyone so long as #
# this copyright notice and the comments above remain intact.  By using this #
# code you agree to indemnify Matthew M. Wright from any liability that      #  
# might arise from it's use.                                                 #  
#                                                                            #
# Selling the code for this program without prior written consent is         #
# expressly forbidden.  In other words, please ask first before you try and  #
# make money off of my program.                                              #
#                                                                            #
# Obtain permission before redistributing this software over the Internet or #
# in any other medium.  In all cases copyright and header must remain intact.#
##############################################################################
# Define Variables							     #

$basedir = '/usr44/home/kasra/public_html/chattest2/';
$baseurl = 'http://www.telangelix.com/chattest2/';
@files = ('fpatches.html');
$title = "kaztrix";
$title_url = 'http://www.telangelix.com/chattest2/';
$search_url = 'http://www.telangelix.com/chattest2/index.html';
$master_admin_email_address = 'support@KazTrix.com';

# Done									     #
##############################################################################

# Parse Form Search Information
&parse_form;

# Get Files To Search Through
&get_files;

# Search the files
&search;

# Print Results of Search
&return_html;


sub parse_form {

   # Get the input
   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});

   # Split the name-value pairs
   @pairs = split(/&/, $buffer);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $FORM{$name} = $value;
   }
}

sub get_files {

   chdir($basedir);
   foreach $file (@files) {
      $ls = `ls $file`;
      @ls = split(/\s+/,$ls);
      foreach $temp_file (@ls) {
         if (-d $file) {
            $filename = "$file$temp_file";
            if (-T $filename) {
               push(@FILES,$filename);
            }
         }
         elsif (-T $temp_file) {
            push(@FILES,$temp_file);
         }
      }
   }
}

sub search {

	if ($FORM{'terms'} eq "")
	{
		&display_error("Please go back and enter the text to search","Keyword is missing!");
	}
   @terms = split(/\s+/, $FORM{'terms'});

   foreach $FILE (@FILES) {

      open(FILE,"$FILE");
      @LINES = <FILE>;
      close(FILE);
	  
	  @data = ();
	  @link = ();
	  @kyes = ();
	  $num = 0;

      #$string = join(' ',@LINES);
      #$string =~ s/\n//g;
	  
	  foreach $line (@LINES)
	  {
		  @main = split(/\|/, $line);
		  #$string =~ s/\<[a-zA-Z0-9\=\"\'\;\-\_\#\(\)]+\>//g;
		  #$string =~ s/\<\/[a-zA-Z0-9\"\']+\>//g;
	      if ($FORM{'boolean'} eq 'AND') {
	         foreach $term (@terms) {
	            if ($FORM{'case'} eq 'Insensitive') {
	               if ($main[1] =~ /$term/i) {
	                  $include{$FILE} = 'yes';
					  @data[$num] = $main[1];
					  @link[$num] = $main[0];
					  @kyes[$num] = $term;
					  $num++;
					  
	               }
	               else {
	                  $include{$FILE} = 'no';
					  #print "$string!!!<BR>";
	               }
	            }
	            elsif ($FORM{'case'} eq 'Sensitive') {
	               if ($main[1] =~ /$term/) {
	                  $include{$FILE} = 'yes';
	                  @data[$num] = $main[1];
					  @link[$num] = $main[0];
					  @kyes[$num] = $term;
					  $num++;
					  #print "$string<BR>";
	               }
	               else {
	                  $include{$FILE} = 'no';
					  #print "$string!!!!<BR>";
	               }
	            }
	         }
	      }
	      elsif ($FORM{'boolean'} eq 'OR') {
	         foreach $term (@terms) {
	            if ($FORM{'case'} eq 'Insensitive') {
	               if ($main[1] =~ /$term/i) {
	                  $include{$FILE} = 'yes';
					  @data[$num] = $main[1];
					  @link[$num] = $main[0];
					  @kyes[$num] = $term;
					  $num++;
	       
	               }
	               else {
	                  $include{$FILE} = 'no';
					  #print "$string!!!!<BR>";
	               }
	            }
	            elsif ($FORM{'case'} eq 'Sensitive') {
	               if ($main[1] =~ /$term/) {
			  $include{$FILE} = 'yes';
			  @data[$num] = $main[1];
			  @link[$num] = $main[0];
			  @kyes[$num] = $term;
			  $num++;
	          #print "$string<BR>";        
	               }
	               else {
	                  $include{$FILE} = 'no';
					  #print "$string!!!!<BR>";
	               }
	            }
	         }
	      }
	      if ($string =~ /<title>(.*)<\/title>/i) {
	         $titles{$FILE} = "$1";
	      }
	      else {
	         $titles{$FILE} = "$FILE";
	      }
	    }
	  }
	}
	      
sub return_html {
   print "Content-type: text/html\n\n";
   print "<html>\n <head>\n  <title>Results of Search</title>\n </head>\n";
   print "<body bgcolor=#FFFFFF text=#000000>\n <center>\n  <font face=\"Arial, Helvetica, sans-serif\"><h1>Results of Search in $title</h1>\n </center>\n";
   print "<p align=center>Below are the results of your Search in no particular order:</p><hr size=3 width=75%><p>\n";
   print "<ul>\n";
   $num = 0;
   foreach $key (keys %include) {
      if ($include{$key} eq 'yes') {
         print "<li><a href=\"$baseurl$key\">$titles{$key}</a>\n";
		 
      }
   }
   if (@data[0] eq "")
   {
		print "<center><H2>Please go back and try another keyword!!!</h2></font></center>\n";
   }else{
   	$num = 0;
   	$num1 = 1;
   	foreach $line (@data)
   	{
		$line =~ s/</\&lt;/g;s/>/\&gt;/g;
		   $line =~ s/$kyes[$num]/<B>$kyes[$num]<\/B>/gi;
		   print "<dl><dt>\n";
		   if ($line =~ /\?/)
		   {
				print "<font face=\"Arial, Helvetica, sans-serif\"><B>$num1.</B> <a href=\"$link[$num]\" TARGET=\"main\">$kyes[$num]</a></font></dt>\n";
				print "<dd><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">$line</font>\n";   
		   }else{
				print "<font face=\"Arial, Helvetica, sans-serif\"><B>$num1.</B> <a href=\"$link[$num]\" TARGET=\"main\">$kyes[$num]</a></font></dt>\n";
				print "<dd><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">...$line...</font>\n";
		   }
		   print "</dd></dl>\n";
			$num++;
			$num1++;
   	}
   }
   print "</ul>\n";
#   print "<hr size=3 width=75%>\n";
#   print "Search Information:<p>\n";
#   print "<ul>\n";
#   print "<li><b>Terms:</b> ";
#   $i = 0;
#   foreach $term (@terms) {
#      print "$term";
#      $i++;
#      if (!($i == @terms)) {
#         print ", ";
#      }
#   }
#   print "\n";
#   print "<li><b>Boolean Used:</b> $FORM{'boolean'}\n";
#   print "<li><b>Case $FORM{'case'}</b>\n";
    print "<P><form>
	  <center><font size=\"2\" face=\"Arial, Helvetica, sans-serif\">
	      <input type=button value=\" << Go Back \" onClick=\"history.go(-1)\" TARGET=\"main\"></form></center></font>\n
	<P>&nbsp;<p>\n";
   &footer;
   
}
   
sub footer
{
	print qq~
   <P>
   <center>
   <p>
   <font size=1>
   <i>Copyright &copy; 2000 <a href=\"$baseurl\" TARGET=\"_blank\">$title</a>. All rights reserved.<br>
   Please send your questions, comments, or bug reports to the 
   <a href=\"mailto:$master_admin_email_address\">$master_admin_email_address</a>.</i></font></font></center>
   </body>
</html>\n~;
exit;
}

# display an error message

sub display_error
  {
	local ($message, $title) = (@_[0], @_[1]);

	print "Content-type: text/html\n\n";
    print qq~
	<HTML>
	<TITLE>$title</TITLE>
	</HEAD>
	<BODY  bgcolor=#FFFFFF text=#000000>
	<font face="Arial, Helvetica, sans-serif">\n
      <center><h1>$title</h1></center></font>
	<center>
	<TABLE width="80%" BORDER="0" CELLPADDING="1">
	<tr>
	<td bgcolor="#9999FF" align=center>
	<font face="Arial, Helvetica, sans-serif" size="2" color="#FFFFFF"><B>
	$message
	</B></font>
	</td>
	</tr>
	</table>
	</center>
	<P>&nbsp;<p>
	<form>
	  <center>
	      <input type=button value="<< Go Back " onClick="history.go(-1)"></form></center>\n
	<P>&nbsp;<p>\n
		~;
	&footer;
   
  } 
