package cgilib;

# ReadParse
# Reads in GET or POST data, converts it to unescaped text, and puts
# one key=value in each member of the list "@in"
# Also creates key/value pairs in %in, using '\0' to separate multiple
# selections

# Copyright for this  ReadParse Sub belongs to Steven E. Brenner:
# Copyright (c) 1995 Steven E. Brenner  
# Unpublished work.
# Permission granted to use and modify this library so long as the
# copyright above is maintained, modifications are documented, and
# credit is given for any use of the library.



sub ReadParse {

local (*in)=@_ if @_;
local ($i, $key, $val);


 # Read in text
  if ($ENV{'REQUEST_METHOD'} eq "GET") {
     $in= $ENV{'QUERY_STRING'};
  } elsif ($ENV{'REQUEST_METHOD'} eq "POST") {
    read(STDIN, $in, $ENV{'CONTENT_LENGTH'});
}

@in= split(/&/,$in);

foreach $i (0 .. $#in) {
  #Convert pluses to spaces
  $in[$i] =~ s/\+/ /g;

#Split into key and value.
 ($key, $val)= split(/=/,$in[$i],2); # splits on the first =.

#Converts %XX from hex numbers to alphanumeric
  $key =~ s/%(..)/pack("c",hex($1))/ge;
  $val =~ s/%(..)/pack("c",hex($1))/ge;

#Associate key and value
  $in{$key} .= "\0" if (defined($in{$key})); # \0 is the multiple oper
$in{$key} .= $val;

}

return 1;

}






1;
