#!/usr/bin/perl

# Perlfect Subscribe
# (C)1998-99 Perlfect Solutions
#            www.perlfect.com
#
# Author     Nick Moraitakis
#
# Release    v1.0  - Oct 10, 1998
# History    v2.0  - Jul  4, 1999
#            v2.01 - Jul  5, 1999
#
# Contact    subscribe@perlfect.com

my $VERSION = '2.0';

$ENV{PATH} = '';
use lib qw(.);
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use Perlfect::Template;
require 'subscribe_conf.pl';
my $cgi = new CGI;
my $template;
my %cast;

if($cgi->param('op') eq 'add')
  {
    my $buffer;
    my $id = 0;
    my @lists = ();
    my $email = $cgi->param('email');
    my $list = $cgi->param('list');
    $list = 'default' unless($list);
    unless($email=~m/[\w\d\.-]+\@[\w\d\.-]+/)
      {
	error_page("You supplied an invalid email address");
      }
    open(LIST, "$MAILING_LIST")
      or error_page("Cannot open $MAILING_LIST: $!\n");
    while(<LIST>)
      {
	chomp;
	if(m/^$email:(\d+):(.*)/i)
	  {
	    $id = $1;
	    $liststr = $2;
	    @lists = split(/,/, $liststr);
	  }
	else
	  {
	    $buffer .= "$_\n";
	  }
      }
    close LIST;
    $id = int(1000*rand())*int(1000*rand()) unless($id);
    push(@lists, $list) unless(member(\@lists, $list));
    open(LIST, ">$MAILING_LIST")
      or error_page("Cannot open $MAILING_LIST: $!\n");
    print LIST $buffer;
    print LIST "$email:$id:".join(",", @lists)."\n";
    close LIST;
    $template = new Perlfect::Template($TEMPLATE_ADD_PAGE);
    $cast{email} = $email;
    $cast{list} = $list;
    $cast{id} = $id;
    $cast{unsubscribe} = "$INSTURL/subscribe.cgi?op=remove&email=$email&id=$id&list=$list";
    my $mail = new Perlfect::Template($TEMPLATE_ADD_MAIL);
    open(MAIL, "|$SENDMAIL")
      or error_page("Cannot send mail with $SENDMAIL: $!\n");
    print MAIL "From: $FROM\n";
    print MAIL "Reply-to: $REPLY_TO\n";
    print MAIL "To: $email\n";
    print MAIL "Subject: $ADDMAIL_SUBJECT\n";
    print MAIL "X-Mailer: Perlfect Subscribe v$VERSION\n";
    print MAIL "Content-type: text/plain\n\n";
    print MAIL $mail->cast(\%cast);
    print MAIL "\n\nMailing list powered by Perlfect Subscribe v$VERSION\nhttp://www.perlfect.com/freescripts/subscribe/";
    close MAIL;
  }

elsif($cgi->param('op') eq 'remove')
  {
    my $buffer;
    my @lists;
    my $email = $cgi->param('email');
    my $list = $cgi->param('list');
    my $id = $cgi->param('id');
    my $found = 0;
    open(LIST, "$MAILING_LIST")
      or error_page("Cannot open $MAILING_LIST: $!\n");
    while(<LIST>)
      {
	chomp;
	if(m/^$email:$id:(.*)/i)
	  {
	    $found = 1;
	    $liststr = $1;
	    foreach (split(/,/, $liststr))
	      {
		push(@lists, $_) unless($_ eq $list);
	      }
	  }
	else
	  {
	    $buffer .= "$_\n";
	  }
      }
    close LIST;
    open(LIST, ">$MAILING_LIST")
      or error_page("Cannotopen $MAILING_LIST: $!\n");
    print LIST $buffer;
    print LIST "$email:$id:".join(",", @lists)."\n" if(@lists);
    close LIST; 
    if($found)
      {
	$template = new Perlfect::Template($TEMPLATE_REMOVE_PAGE);
	$cast{email} = $email;
	$cast{list} = $list;
	$cast{id} = $id;
      }
    else
      {
	error_page("Email not in list of invalid key supplied.");
      }
  }
else
  {
    $template = new Perlfect::Template($TEMPLATE_ERROR_PAGE);
    error_page("Invalid Invocation Parameters");
  }

print $cgi->header();
print $template->cast(\%cast);
exit;



sub error_page
  {
    $cast{error} = shift;
    $template = new Perlfect::Template($TEMPLATE_ERROR_PAGE);
    print $cgi->header();
    print $template->cast(\%cast);
    exit;
  }



sub member
  {
    my ($ar, $el) = @_;
    foreach (@$ar)
      {
	return 1 if(lc($_) eq lc($el));
      }
    return 0;
  }
