#!/usr/bin/perl

#
# Perlfect Subscribe Setup Utility
# (C)1999 Perlfect Solutions
#          www.perlfect.com
#

my $VERSION = '2.0';

print "
Perlfect Subscribe $VERSION Setup Utility

WARNING: There is no guarantee implicit or explicit that this program 
will work correctly. By using this program you automatically indemnify 
Perlfect Solutions of any damage or harm directly or indirectly caused 
by its operation. Use it at your own risk!

";
exit if(input("Are you sure you want to continue? [y/n]", "y", ["y","n"]) eq "n");

my ($perl, $sendmail);
$perl = `which perl`;
chomp $perl;
$perl='/usr/bin/perl' unless ($perl);
$perl = input("Where is perl? [$perl]", "$perl");
print "Ok, I will configure the scripts to run with $perl\n";
set_perl_path("subscribe.cgi", $perl);
set_perl_path("mailer.cgi", $perl);
my $whereis = `whereis sendmail`;
if($whereis=~m/^sendmail: (\S+)/)
  {
    $sendmail = "$1 -t";
  }
else
  {
    $sendmail = input("Please enter the full path and to your sendmail application (including command-line switches)");
  }
print "\n";

my $name = input("What is your name?");
my $from = input("What is your email address?");

my $pass = input("Choose a password for administering the mailing lists."); 

my $cgidir = input("Where is your cgi directory? (e.g. /home/httpd/cgi-bin/)");
my $cgiurl = input("What is the URL of your cgi directory? (e.g. http://www.perlfect.com/cgi-bin/");

print "
Perlfect Subscribe needs to be able to update your mailing 
list file in your account. One way of doing this is to set 
the permissions of the mailing list to writeable-by-all, 
which is a last resort solution because it will endanger 
the integrity of your list. Ideally this can be avoided 
by running the program in SUID mode (don't worry if you 
don't know what this is) but SUID mode is disabled on some 
hosts. If you are not sure what the situation is with your 
host, try answering 'y' to the next question and if it doesn't
work delete all files installed and do it again from scratch, 
answering 'n' the second time.
";

if(input("Can you run programs in SUID mode? [y/n]", "y", ["y", "n"]) eq 'y')
  {
    $mode = "4755";
  }
else
  {
    $mode = "0755";
  }


foreach ($cgidir, $cgiurl)
  {
    $_=~s/\/$//;
    $_.='/';
  }
my $instdir=$cgidir."perlfect/subscribe/";
my $insturl=$cgiurl."perlfect/subscribe/";

print "
I will now install Perlfect Subscribe $VERSION in
$instdir

";
install_dir($cgidir."perlfect", "0755");
install_dir($cgidir."perlfect/subscribe", "0755");
install_file("subscribe.cgi", $instdir."subscribe.cgi", "0755");
install_file("mailer.cgi", $instdir."mailer.cgi", "0755");
install_file("subscribe_conf.pl", $instdir."subscribe_conf.pl", "0755");
install_file("mailing_list.txt", $instdir."mailing_list.txt", $mode, keep);
install_dir($instdir."templates", "0755");
install_file("templates/add.html", $instdir."templates/add.html", "0755", keep);
install_file("templates/remove.html", $instdir."templates/add.html", "0755", keep);
install_file("templates/addmail.html", $instdir."templates/add.html", "0755", keep);
install_file("templates/error.html", $instdir."templates/add.html", "0755", keep);
install_dir($instdir."Perlfect", "0755");
install_file("Perlfect/Template.pm", $instdir."Perlfect/Template.pm", "0755");

print "Configuring Perlfect Subscribe...\n";
open(CONF, ">$instdir/search_conf.pl")
  or die "\n** Could not open $instdir/search_conf.pl: $!\n";
print CONF "
# Configuration for Perlfect Subscribe

# installation location
$INSTDIR = '$instdir';
$INSTURL = '$insturl';
$MAILING_LIST = $INSTDIR.'/mailing_list.txt';

# sendmail setup
$SENDMAIL = '$sendmail';
$FROM = '$name <$email>';
$REPLY_TO = '$name <$email>';

# access control
$ACCESS_CONTROL = 1; # set to 0 to turn off if you're using .htaccess
$ADMIN_PASSWORD = '$pass';

# templates
$TEMPLATE_ADD_PAGE = $INSTDIR.'/templates/add.html';
$TEMPLATE_REMOVE_PAGE = $INSTDIR.'/templates/remove.html';
$TEMPLATE_ERROR_PAGE = $INSTDIR.'/templates/error.html';
$TEMPLATE_ADD_MAIL = $INSTDIR.'/templates/addmail.txt';
$ADDMAIL_SUBJECT = 'Welcome!';

1;
";
close CONF;


print "
Perlfect Subscribe $VERSION has been installed on your system.
";
input("-- press enter to continue --");
system('clear');

print "
We would like to know the people that use Perlfect Subscribe so that 
we may notify them by email when upgrades become available. I can send
your registration email automatically if you are online right now.
It will only take a few seconds and it will ensure you are up to
date with the development of Perlfect Subscribe.
";
if(input("Do you want to register by email now? [y/n]", "y", ["y", "n"]) eq "y")
  {
    my $date = localtime(time());
    if(open (MAIL, "|$sendmail"))
      {
	print MAIL "From: $email\n";
	print MAIL "To: subscribe-registration\@perlfect.com\n";
	print MAIL "Subject: REGISTRATION - PERLFECT SUBSCRIBE\n";
	print MAIL "Content-type: text/plain\n\n";
	print MAIL "Name      $name\n";
	print MAIL "Email     $email\n";
	print MAIL "Version   $VERSION\n";
	print MAIL "Site      $baseurl\n";
	print MAIL "Date      $date\n";
	close MAIL;
	print "
Thank you. Your registration email has been sent!
";
	input("-- press enter to continue --");
	system('clear');
      }
    else
      {
	print "
There was an error using your sendmail program. If you want, 
you can register by going to Perlfect Subscribe's website 
     http://www.perlfect.com/freescripts/subscribe/
and following the instructions there to subscribe to our 
announcements mailing list.
";
      }
  }

print "
Please refer to the README file that came with this program 
to find out how to use it on your site. The program's homepage,
    http://www.perlfect.com/freescripts/subscribe/
also contains up-to-date information and documentation so, 
take a look.

If you think you have found a bug, or have a comment/suggestion 
to make that is not covered in the documentation, please contact 
us by email at subscribe\@perlfect.com We receive a lot of email 
every  day regarding Perlfect Subscribe so please bear with us.

Thanks for choosing Perlfect Subscribe for your site.
Perlfect Solutions - http://www.perlfect.com

";



sub install_dir
  {
    my ($dir, $permissions) = @_;
    print "Setting up $dir\n";
    if(-e $dir)
      {
	if(-d $dir)
	  {
	    print "**Directory already exists.\n";
	  }
	else
	  {
	    print "**$dir is not a directory.\n";
	    print "**I'd better not touch it then\n**Aborting!\n";
	    exit(1);
	  }
      }
    else
      {
	unless(mkdir($dir, oct($permissions)))
	  {
	    print "**Cannot create $dir\n";
	    print "**Aborting!\n";
	    exit(1);
	  }
      }
    unless(chmod(oct($permissions), $dir))
      {
	print "**Cannot set permissions!\n**Aborting.\n";
	exit(1);
      }
  }



sub install_file
  {
    my ($source, $destination, $permissions, $keepold) = @_;
    print "Installing $source to $destination\n";
    my $uninstall;
    if(-e $destination)
      {
	print "**$destination already exists.\n";
	if($keepold)
	  {
	    print "**Preserving existing $destination\n";
	    return;
	  }
	if(rename("$destination", "$destination.bak"))
	  {
	    print "**I kept a backup in $destination.bak\n";
	  }
	else
	  {
	    print "**Cannot backup the file\n**Aborting.\n";
	    exit(1);
	  }
      }
    if(system("cp $source $destination"))
      {
	print "**Cannot copy $source to $destination\n**Aborting.";
	exit(1);
      }
    unless(chmod(oct($permissions), $destination))
      {
	print "**Cannot set permissions!\n**Aborting.\n";
	exit(1);
      }
  }


sub set_perl_path
  {
    my ($file, $path) = @_;
    print "Setting perl path in $file.\n";
    my $source = "#!$path\n";
    open(SRC, "$file") or die "Cannot open $file: $!\n";
    my $dump = <SRC>;
    while(<SRC>)
      {
	$source .= $_;
      }
    close SRC;
    open(DST, ">$file") or die "Cannot open $file: $!\n";
    print DST $source;
    close DST;
  }


sub input
  {
    my ($question, $default, $options) = @_;
    print "$question\n: ";
    my $answer = <>;
    chomp $answer;
    print "\n";
    $answer = $default unless $answer;
    unless(scalar(@$options)==0 or member($options, $answer))
      {
	print "Invalid option. Please select one of: ";
	print join(",", @$options)."\n";
	return input($question, $default, $options);
      }
    return $answer;
  }


sub member
  {
    my ($ary, $el) = @_;
    foreach (@$ary)
      {
	return 1 if($_ eq $el);
      }
    return 0;
  }
