#!/usr/local/bin/perl
#<!--
# ------------------------------------------------------------------
#  DISCUS FTP SETUP ASSISTANT SCRIPT
#
#  Congratulations, if you are seeing this page, generation of this
#  script was successful!
#
#  Now, select "File | Save As..." from your browser's window.
#  This output should be saved as "ftpdiag.cgi" in any temporary
#  folder on your hard disk.  When you have saved the file, use your
#  browser's back button to return to the instructions.  This file
#  should be saved as plain text, NOT as HTML.
#
#  This script is Copyright (c) 2001 by DiscusWare, LLC, all rights
#  reserved.  It may be used under the same terms as Discus itself,
#  detailed in http://www.discusware.com/discus/license
#
# ------------------------------------------------------------------
#
# This code checks for the script being displayed as HTML

if (1 == 0) {
	print <<EOF;
-->
<HTML><HEAD><TITLE>FTP Assistant Error</TITLE></HEAD>
<BODY BGCOLOR=#ffffff TEXT=#000000>
<H1>FTP Assistant Error</H1>
If you are seeing this error message, the FTP setup assistant is not
being properly executed as a CGI script, but is rather being shown as
an ordinary HTML file.  You must consult your server administrator to
have them turn on CGI permissions in this directory.
</BODY></HTML>
<!--
EOF
}

#
# Check for compliance of Perl interpreter
#

if ($] < 5) {
	&header("FTP Setup Error");
	print "Your Perl interpreter is not Perl 5 or better.\n";
	&perl_sysreq();
}

eval 'use strict;';
if ($@) {
	&header("FTP Setup Error");
	print "Your Perl interpreter does not support 'use strict'.\n";
	&perl_sysreq();
}

my $rv = eval 'my $x = returns_one(); $x;';
if ($rv != 1 || $@) {
	&header("FTP Setup Error");
	print "Your Perl interpreter does not properly handle subroutine definitions.\n";
	&perl_sysreq();
}

my $kv = eval 'my $u = 0; foreach my $z ( 1, 2 ) { $u += $z; }; $u;';
if ($kv != 3 || $@) {
	&header("FTP Setup Error");
	print "Your Perl interpreter does not properly handle lexical loop variables.\n";
	&perl_sysreq();
}

my $c = eval 'crypt("test", "na");';
if ($c ne "nagdheJ4NyCzY") {
	&header("FTP Setup Error");
	print "Your Perl interpreter does not properly support the 'crypt' function.\n";
	if ($^O eq "MSWin32") {
		print "Note: On Windows, you need <a href='http://www.activestate.com'>ActivePerl</a>!\n";
	}
	&perl_sysreq();
}

#
# Figure out what this script is running as
#

header();

my $prog = $0;
my $cgi_extension = "";
my $b4 = "";

if ($prog =~ m|ftpdiag\.(\w+)|i) {
    $prog = $&;
    $cgi_extension = $1;
	$b4 = $`; $b4 =~ s/\/$//; $b4 =~ s/\\$//;
} else {
   print "<HTML><HEAD><TITLE>Sorry...</TITLE></HEAD>\n";
   print "<BODY><B>Setup Error</B>\n\n";
   if ($prog eq "") {
      print "<P>This version of Perl is malfunctioning, as it did not\n";
      print "set the <B>\$0</B> variable.  Please contact your server\n";
      print "administrator and inform them that this Perl installation\n";
      print "is not functioning properly.<P>\n";
   } else {
     print "<P>It appears that this script is not named &quot;ftpdiag.***&quot;\n";
     print "as required by the setup.  If necessary, rename this file.  Currently\n";
     print "this file is titled <B>$prog</B><P>\n";
   }
   print "</BODY></HTML>\n";
   exit(0);
}

#
# Find your home directory
#

my ($script_uid, $hdsees, $elim, $sees, $sees_warn);
if ($^O ne "MSWin32") {
	($script_uid, $hdsees, $elim, $sees) = eval {
		my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat $0;
		my $hd = (getpwuid($uid))[7];
		if ($hd =~ m|/\./|) {
			( $uid, $hd, $`, "$'" );
		} else {
			( $uid, $hd, "", "" );
		}
	};
	if ($elim || $sees) {
		$sees_warn = "
			<p>
			<ul>
			<table bgcolor=#ffcccc><tr><td>
			<font face='Verdana,Arial,Helvetica' size=2>
			<p>
			<b>Directory Information:</b>  It appears that when you log in by FTP, you are
			restricted by your web host to a certain portion of your server.  This is OK, but
			it will require you to mentally adjust directory paths when you complete the
			setup of this software.
			</p>
			<p>
			It appears that when you log in by FTP, the name of the directory you first see in
			your FTP program is <b>/$sees</b>.  The actual, full path to this directory is
			<b>$elim/$sees</b>.
			</p>
			<p>
			It is very important in this setup that you leave the <b>$elim</b> part at the
			beginning of the directory paths, even though you don't see this when you log in
			by FTP.  However, in the final setup instructions, you may be asked for example
			to create the directory $elim/$sees/discus.  In your FTP program, it would appear
			that you are creating the directory	/$sees/discus.
			</p>
			<p>
			For more information regarding this situation, please read our Knowledge Center
			document on <a href='http://support.discusware.com/center/resources/tips/adjust.html' target=_blank>Adjusting Directory Paths</a>.
			</p>
			</font></td></tr></table></ul>
			</p>
			<input type=hidden name='sees' value='/$sees'>
			<input type=hidden name='elim' value='$elim'>
			<input type=hidden name='own_uid' value='$script_uid'>
			<input type=hidden name='run_uid' value='$<'>
		";
	}
}

my $homedir = {};
if ($^O ne "MSWin32") {
	eval '$homedir->{home} = (getpwuid($<))[7];';
	$homedir->{pwd} = `pwd`; chomp $homedir->{pwd};
}
if (!eval 'use Cwd;') {
    eval '$homedir->{cwd} = cwd();';
}
$homedir->{docroot} = $ENV{'DOCUMENT_ROOT'};
$homedir->{filename} = $ENV{'SCRIPT_FILENAME'};
$homedir->{filename} =~ s/\/$prog//;
$homedir->{filename} =~ s/\\$prog//;
$homedir->{path} = $ENV{'PATH_TRANSLATED'};
$homedir->{b4} = $b4;
my $real = check($homedir, [ 'pwd', 'filename', 'path', 'cwd', 'b4', 'docroot' ], $prog);
$real =~ s%\\%/%g; $real =~ s%//%/%g;

if ($real eq "") {
   print "<HTML><HEAD><TITLE>Sorry...</TITLE></HEAD>\n";
   print "<BODY><PRE><B>Setup Complication</B>\n\n";
   print "The setup script could not determine the current working directory\n";
   print "of the server.  This is very rare (only 1-2% of servers).  The environment\n";
   print "variables and other potentially helpful values are being printed here for\n";
   print "your reference:\n\n";
   print "<B>PWD</B>         $homedir->{pwd}\n";
   print "<B>Doc. Root</B>   $homedir->{docroot}\n";
   print "<B>File name</B>   $homedir->{filename}\n";
   print "<B>Path</B>        $homedir->{path}\n";
   print "<B>CWD</B>         $homedir->{cwd}\n";
   print "<B>'b4'</B>        $homedir->{b4}\n";
   print "Here are the environment variables:\n\n";
   my $key;
   foreach $key (sort keys(%ENV)) {
       print "<B>$key</B> = [$ENV{$key}]\n";
   }
   print "\n\n";
   print "</PRE></BODY></HTML>\n";
   exit(0);
}

my @founddir = ();
opendir(CURDIR, "..");
while (my $q = readdir(CURDIR)) {
    push (@founddir, $q);
}
closedir(CURDIR);
@founddir = grep(!/\./, @founddir);

my $discusware_url = "http://www.discusware.com/cgi-bin/discus/ftp/ftp-inst.cgi";

my $version = "3_10";
my $get_discus_pro = 0;
my $pro_license = '';

my $language_list = '<OPTION VALUE=danish>Danish
<OPTION VALUE=french>French
<OPTION VALUE=dutch>Dutch
<OPTION VALUE=finnish>Finnish
<OPTION VALUE=german>German
<OPTION VALUE=italian>Italian
<OPTION VALUE=korean>Korean
<OPTION VALUE=malaysian>Malaysian
<OPTION VALUE=norwegian>Norwegian
<OPTION VALUE=portuguese>Portuguese
<OPTION VALUE=slovenian>Slovenian
<OPTION VALUE=spanish>Spanish
<OPTION VALUE=swedish>Swedish
<OPTION VALUE=turkish>Turkish
<OPTION VALUE=greek>Greek
';

### SUGGESTION PARAMETERS ###
my $discus_dir_name = 'discus';
my $board_title = '';
my $contact_name = '';
my $contact_email = '';

#
# On some unix platforms, figure out altered directory paths
#

my $adjustment = "";
if ($^O ne "MSWin32") {
	my $s = '
		my $u = (stat "$0")[4];
		my $hd = (getpwuid($u))[7];
		if ($hd =~ m|/\./|) {
			$`;
		}
	';
	$adjustment = eval $s;
}

#
# Guess your setup parameters
#

open (PROG, $prog);
my @prog = <PROG>;
close (PROG);

my $perl = $prog[0]; $perl =~ s/^#!//; $perl =~ s/\s+$//;
$perl = "/usr/bin/perl" if $perl eq "";
my $base = ""; my $cgi = "";
if ($real =~ m|(.*)/(.+)|) {
    $base = $1; $cgi = $2;
} else {
    $base = $real; $cgi = "cgi-bin";
}
my $admin_dir = "$base/$discus_dir_name" . "_admin_"; my $p = $$; $p =~ s/\D//g; $p .= substr(time, 0, -5); $admin_dir .= $p;
my $html_prefix = 'public_html htdocs www htdoc html docs doc';
my $html_dir = $base;
my $i;
foreach $i (split(/\s+/, $html_prefix)) {
	if (-e "$base/$i/index.html" || -e "$base/$i/default.htm" || -e "$base/$i/index.htm") {
		$html_dir .= "/$i";
		last;
	}
}
$html_dir .= "/$discus_dir_name";
my $script_dir = "$real/$discus_dir_name";

my $sn = "";
my $script_url = "";

if ($ENV{'SCRIPT_URI'} ne "") {
    $sn = $ENV{'SCRIPT_URI'};
} elsif ($ENV{'SCRIPT_URL'} ne "") {
    $sn = $ENV{'SCRIPT_URL'};
} elsif ($ENV{'REQUEST_URI'}) {
    $sn = $ENV{'REQUEST_URI'};
} elsif ($ENV{'SCRIPT_NAME'} ne "") {
    $sn = $ENV{'SCRIPT_NAME'};
}

if ($sn ne "") {
    if ($sn =~ m|^http://([^/]+)|) {
        $sn = $';
    }
    if ($sn =~ m|/$prog|i) {
        $sn = $`;
    }
    if ($sn ne "") {
        $script_url = "http://$ENV{'HTTP_HOST'}$sn/$discus_dir_name";
    }
} else {
    $script_url = "http://$ENV{'HTTP_HOST'}/$cgi/$discus_dir_name";
}

my $uinfo = "";
if ($script_url =~ m|^http://([^/]+)/~([^/]+)/|) {
    $uinfo = "~" . $2 . "/";
}
my $html_url = "http://$ENV{'HTTP_HOST'}/$uinfo$discus_dir_name";
my $bdcgi = "$base/$cgi";

#
# For NT users, convert / to \ to make it look more familiar
#

$admin_dir =~ s%/%\\%g if $admin_dir =~ m|^(\w+):|;
$html_dir =~ s%/%\\%g if $html_dir =~ m|^(\w+):|;
$script_dir =~ s%/%\\%g if $script_dir =~ m|^(\w+):|;
$admin_dir =~ s%\\\\%\\%g;
$html_dir =~ s%\\\\%\\%g;
$script_dir =~ s%\\\\%\\%g;
$bdcgi =~ s%/%\\%g if $admin_dir =~ m|^(\w+):|;
$bdcgi =~ s%\\\\%\\%g;

my $NTFLAG = '';
my $slash = "/";
if (-e 'c:/' || $^O eq "MSWin32") {
	$NTFLAG = '<input type=hidden name=OS value="NT">';
	$slash = "\\";
}

my $path_warning = "";
if ($cgi =~ m|/| || $sn =~ m|^.+/|) {
	$path_warning = "
		<p>
		<font color=#ff0000><b>Warning:</b></font>
		<b>
		It has been detected that you might have created a separate directory
		for this script (e.g., cgi-bin/discus).  If you did this, THIS IS BAD and the
		suggestions will not be accurate.  To ensure the most accurate suggestions,
		this script should be placed, if possible, into the server's main cgi directory.
		</b></p>
	";
	$path_warning = "" if $cgi !~ m|discus| && $sn !~ m|discus|;
}

#
# Discus Setup Form
#

print <<_END_;
<html>
<head>
<title>Welcome to Discus Setup</title>
<style>
<!--
body {font: 9pt Verdana,Arial,Helvetica; }
p {width: 600;}
.mainheader {width: 600; font: 14pt Verdana,Arial,Helvetica; border-bottom: thin #aa0000 solid; }
.miniheader {width: 600; font: 11pt Verdana,Arial,Helvetica; font-weight: bold; border-bottom: thin #ff0000 solid; }

-->
</style>
</head>
<body bgcolor=#ffffff text=#000000 link=#0000ff vlink=#800080 background="http://www.discusware.com/discus/ftp/background.jpg">

<p class="mainheader">Discus Setup - Interactive Form</p>
<form action="$discusware_url" method=GET>
<input type=hidden name=adjustment value="$adjustment">
<p>
Congratulations!  You have successfully uploaded the FTP setup assistant to your server, and it is now being properly executed by your web server.  In addition, it appears that your web server meets our system requirements for basic installation and operation of Discus.
</p>
$path_warning
<p>
On this page, you will be able to enter the parameters for your Discus board after reviewing the instructions and suggestions that have been provided for you.  <b><font color=#ff0000>Don't just accept our guesses without reviewing them (and changing them if necessary)!</font></b>
</p>
<p>
When specifying directories, it is necessary to use the full directory path that your server "sees".  This may or may not correspond to what you see when you log in with your FTP program (many web hosts seek to restrict you to only certain parts of the server to avoid interrupting their other customers).  The suggestions are generally accurate or very close to being accurate.  If you find yourself substantially changing the suggestions, you might be doing something wrong. </p>
<p>
Your server reports seeing this script as:
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<b>$bdcgi$slash$prog</b>
</p>
$sees_warn
<p class="miniheader">Path to Perl, CGI Extension, License Information</p>

<p>
Setup has automatically selected the following parameters:
</p>
<p>
&nbsp;&nbsp;&nbsp;&nbsp;Path to Perl: <b>$perl</b><br>
&nbsp;&nbsp;&nbsp;&nbsp;CGI Extension: <b>$cgi_extension</b><br>
&nbsp;&nbsp;&nbsp;&nbsp;Discus Version: <b>Discus
_END_

my $v = $version; $v =~ s/_/\./g;
if ($get_discus_pro) {
	print "Pro $v</b><br>&nbsp;&nbsp;&nbsp;&nbsp;License Number: <b>$pro_license";
} else {
	print "Freeware $v";
}

print <<_END_;
</b>
</p>
<p>
The path to Perl, Discus version, and Discus Pro license information (if any) were configured when you downloaded this file from DiscusWare's web server.  The CGI extension is chosen to match the extension on this file.  If any of these parameters is incorrect, you should download another copy of this script from DiscusWare.
</p>
<input type=hidden name=version_requested value="$version">
<input type=hidden name=get_pro value="$get_discus_pro">
<input type=hidden name=pro_license value="$pro_license">
<input type=hidden name=pathperl value="$perl">
<input type=hidden name=cgi_extension value="$cgi_extension">
$NTFLAG

<p class="miniheader">Administration Directory</p>

<p>
The administration directory stores configuration files and password files for your Discus board.  This directory is never accessed by a web browser.  For your security, this directory should be &quot;hidden&quot; from the web server (out of the server's web space) if possible.  In other words, the administration directory should <b>not</b> be accessible at <I>http://your.server.com/something</I>.
</p>
<p>
If you must put this directory in a place where it's accessible via the web, we suggest a long string of numbers (or something else random) after the directory name to make it more difficult for an attacker to guess the directory name.  Note that if you don't hide this directory from your web server and someone finds it and accesses it via the web, they can look at your password files and other privileged information!  Finally, this setting must be a <I>directory</I> and not a URL -- it should <B>not</B> start with <B>http://</B>.</p>
<p>
Our suggestions for this parameter are over 95% accurate!
</p>

<p>
Administration Directory:
<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=admin_dir VALUE="$admin_dir"></p>

<p class="miniheader">HTML Directory and URL</p>

<p>
The HTML files that come with Discus, such as the instructions and main menu, are placed in the HTML Directory.  In addition, your message files (topics and messages), clipart, and icons are all stored in subdirectories of the HTML Directory.  This should <b>not</b> go under your server's CGI directory (i.e., don't put it under your cgi-bin).  The directory must be a <I>directory</I> and not a URL -- it should <B>not</B> start with <B>http://</B>!
</p>
<p>
Our suggestions for this parameter are generally quite accurate (unless you choose to rename "discus" to something else).  The most common mistake in the suggestion is if the suggestion forgets to put in the directory immediately above "discus" -- sometimes named public_html, www, htdocs, docs, and so on.  Or, sometimes the suggestion contains one of these directory names when it shouldn't.
</p>

<p>
HTML Directory:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=html_dir VALUE="$html_dir"></p>

<p>
You also need to give the URL that corresponds to the HTML Directory that you specified above.  This <B>must</B> start with <B>http://</B>.  If you changed "discus" to something else when setting up the HTML Directory, be sure to change it here too.
</p>
<p>
HTML URL:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=html_url VALUE="$html_url"></p>

<p class="miniheader">Script Directory and URL</p>

<p>
The script (CGI) files that come with Discus, such as the board administration script and the new message search script, go into the Script Directory.  (These are the Perl scripts that actually power Discus by writing to the message files.)
</p>
<p>
The suggestion for this parameter is over 99% accurate.  You may change the "discus" part at the end if you want to, but don't change anything else unless you really know what you're doing.
</p>

<p>
Script Directory:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=script_dir VALUE="$script_dir"></p>

<p>
You also need to give the URL that corresponds to the Script Directory that you specified above.  This suggestion for this parameter has proven to be over 99% accurate.  If you changed the "discus" part in the Script Directory, be sure to change it here as well.  Don't change anything else unless you really know what you're doing.
</p>

<p>
Script URL:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=script_url VALUE="$script_url"></p>

<p class="miniheader">Title and Contact Information</p>

<p>
Here is where you specify the title of your discussion board.  Choose any title you wish.  Since it is fairly difficult to change this later, please be sure to double-check your spelling!
</p>
<p>
Board Title:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=title></p>

<p>
Enter the name and e-mail address of the person who is to be contacted if there is a problem with the board.  When users receive error messages, they are told to contact this person.  Generally you will enter your own name and e-mail address here.  This is very easy to change later.</p>

<p>
Board Contact Person:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=contact_name>
</p>

<p>
Board Contact E-mail Address:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<Input TYPE=text SIZE=50 NAME=contact_email>
</p>

<p class="miniheader">User Interface Options</p>

<p>
Available translations of the Discus User Interface are indicated on the list below.  Choose the desired language for your User Interface from this list.
</P>
<p>
User Interface Language:<br>
&nbsp;&nbsp;&nbsp;&nbsp;<SELECT NAME=language SIZE=1>
<OPTION VALUE=english SELECTED>English
$language_list
</SELECT>
</p>

<p class="miniheader">Submit the Form</p>

<p>
When you have filled in all of the blanks above, click the button to generate your individual customized Discus distribution.  Please note that <B>processing could take several seconds</B>, so please click the button only one time, and be patient.</p>
<p>
<input type=submit value="Submit Form">
</p>
</body></html>
_END_
exit(0);

sub check {
    my ($hr, $arr, $prog) = @_;
    my $l;
    foreach $l (@{ $arr }) {
    	my $dr = $hr->{$l};
    	next if $dr eq "";
    	$dr =~ s%\\%/%g;
    	$dr =~ s%/$%%g;
    	next if $dr eq "";
	    if (-e "$dr/$prog") {
			return $dr;
	    }
	}
	my $c = determine_cwd();
	return $c if $c ne "";

}

sub determine_cwd {
	my $filename = $0;
	if ($filename =~ m|(.*)/(.*)|) {
		$filename = $2;
	}
	undef my @parent;
	my $ctr = 100;
	my $dots = "";
	my $parent = "";
O:	while ($ctr > 0) {
		$ctr -= 1;
		$dots .= "/" if $dots ne "";
		$dots .= "..";
		if (opendir(DIR, $dots)) {
I:			while (my $dir = readdir(DIR)) {
				next if $dir =~ m|^\.+$|;
				next if !-d "$dots/$dir";
				if (scalar(@parent)) {
					$parent = "/" . join("/", reverse(@parent));
				} else {
					$parent = "";
				}
				if (-e "$dots/$dir$parent/$filename") {
					push (@parent, $dir);
					last I;
				}
			}
			closedir(DIR);
		} else {
			last O;
		}
		$parent = "/" . join("/", reverse(@parent));
		if (-e "$parent/$filename") {
			last O;
		}
	}
	$parent = "/" . join("/", reverse(@parent));
	if ($^O eq "MSWin32") {
		my $dr;
		foreach $dr ('c' .. 'z') {
			if (-e "$dr:$parent/$filename") {
				return "$dr:$parent";
			}
		}
	}
	return $parent;
}

sub returns_one {
	return 1;
}

sub header {
	my ($x) = @_;
	$| = 1;
	print "Content-type: text/html\n\n";
	return undef if $x eq "";
	print "<html><head><title>$x</title></head>\n";
	print "<body><h1>$x</h1><hr>\n";
	print "<pre>\n";
	return undef;
}

sub perl_sysreq {
	print "\n";
	print "Discus will not run on this system, as your Perl interpreter\n";
	print "does not meet the system requirements.  You should upgrade your\n";
	print "Perl interpreter at <a href='http://www.cpan.org'>CPAN</a> (for unix) or at ";
	print "<a href='http://www.activestate.com'>ActiveState</a> (for\nWindows) to be able ";
	print "to run Discus and other CGI scripts like it.\n\n";
	print "Your Perl version is: $]\n";
	print "Discus requires Perl 5.005 or higher\n";
	print "Your OS is reported as: $^O\n";
	print "The exact error was: $@\n" if ($@ ne "");
	print "\n";
	print "This is not a malfunction in Discus.  We regret that DiscusWare\n";
	print "Support cannot assist you with this problem.\n";
	print "\n";
	print "For more details:\n";
	print "  <a href=\"http://support.discusware.com/center/resources/faqs/perl.html\">http://support.discusware.com/center/resources/faqs/perl.html</a>\n";
	print "</pre></body></html>\n";
	exit(0);
}

# -->
