<?
  session_name("KDB_SESS_ID");
  session_start();

  require_once("config.inc.php");
  require_once("db_util.inc.php");
  require_once("db.inc.php");
  require_once("util.inc.php");

  function uid() {
    if (!isset($_SESSION["uid"])) {
      $_SESSION["uid"] = -1;
    }
    return $_SESSION["uid"];
  }

  function is_guest() {
    return (uid() == -1);
  }

  function logout() {
    unset($_SESSION["uid"]);
    session_destroy();
  }

  function login($name, $password) {
    $user = get_user_info_by_name($name);
    if (!($user && ($password == $user["password"]))) {
      add_error("Invalid user name or password");
      logout();
      return FALSE;
    }
    if (!$user["active"]) {
      add_error("Your account disabled by administrator");
//      logout();
      return FALSE;
    }
    if ($user["expiration_date"] < date("Y-m-d")) {
      add_error("Your account expired");
//      logout();
      return FALSE;
    }
    $_SESSION["uid"] = $user["id"];
    return TRUE;
  }

  function deny_guest() {
    if (is_guest()) need_login();
  }

  function need_login() {
    redirect("login.php?php_uri=".urlencode($_SERVER["REQUEST_URI"]));
  }

  function get_righ_description($right_id) {
    $sql = "select description from `rights` where id = '$right_id'";
    $row = db_fetch_row(db_query($sql));
    return $row[0];
  }

  $RIGHTS_CACHE = NULL;
  function __right_by_name($name) {
    global $RIGHTS_CACHE;
    if (!isset($RIGHTS_CACHE)) {
      $sql = "select sql_cache id, name from `rights`";
      $res = db_query($sql);
      while ($row = db_fetch_row($res)) {
        $RIGHTS_CACHE[strtoupper($row["name"])] = $row["id"];
      }
    }
    $name = strtoupper($name);
    if (!isset($RIGHTS_CACHE[$name])) die("Unknown right name '$name'");
    return $RIGHTS_CACHE[$name];
  }

  function r_NONE() {
    return __right_by_name("NONE");
  }

  function r_LIST() {
    return __right_by_name("LIST");
  }

  function r_READ() {
    return __right_by_name("READ");
  }

  function r_WRITE() {
    return __right_by_name("WRITE");
  }

  function r_MANAGE() {
    return __right_by_name("MANAGE");
  }

  function r_ADMIN() {
    return __right_by_name("ADMIN");
  }

  function get_right($db_id) {
    static $rights;
    if (!isset($rights[$db_id])) {
      $sql = "select d.default_right, u.global_right, r.right_id \r\n".
             "from   `databases` as d \r\n".
             "left   join `users` as u on u.id = '".uid()."' \r\n".
             "left   join `db_user_rights` r on r.user_id = u.id and r.db_id = d.id \r\n".
             "where  d.id = '$db_id'";
      $row = db_fetch_row(db_query($sql));
      if ($row) {
        $r1 = isset($row[0]) ? $row[0] : 0;
        $r2 = isset($row[1]) ? $row[1] : 0;
        $r3 = isset($row[2]) ? $row[2] : 0;
        $rights[$db_id] = max($r1, $r2, $r3);
      } else {
        $rights[$db_id] = 0;
      }
    }
    return $rights[$db_id];
  }

  function __check_right($db_id, $right_id) {
    return get_right($db_id) >= $right_id;
  }

  function check_LIST($db_id) {
    return __check_right($db_id, r_LIST());
  }

  function check_READ($db_id) {
    return __check_right($db_id, r_READ());
  }

  function check_WRITE($db_id) {
    return __check_right($db_id, r_WRITE());
  }

  function check_MANAGE($db_id) {
    return __check_right($db_id, r_MANAGE());
  }

  function check_ADMIN($db_id = -1) {
    if ($db_id == -1) {
      $user = get_user_info();
      if ($user)
        return $user["global_right"] >= r_ADMIN();
      else
        return FALSE;
    }
    return __check_right($db_id, r_ADMIN());
  }

?>