#!/usr/bin/perl
use strict; 

# make sure the MOJO lib is in the lib paths!
use lib qw(./ ./MOJO ../ ../MOJO); 
# use some of those Modules
use MOJO::Config;
use MOJO::HTML; 
use MOJO::Guts;
use strict; 





my %Logs = (
	'Mojo Usage Log' => $MOJO_LOG,
	'SMTP Log'       => $SMTP_ERROR_LOG,
	'Mojo Error Log' => $MOJO_ERROR_LOG
); 
my $Default_Log = 'Mojo Usage Log';







# we need this for cookies things
use CGI; 
my $q = new CGI; 

# this is how we find what list we're working on
my %login          = $q->cookie(-name => 'login'); 

my $admin_list     = $login{admin_list}               || undef; 
my $admin_password = $login{admin_password}           || undef; 


# This will take care of all out security woes
my $root_login = check_list_security(-Admin_List      => $admin_list, 
                                     -Admin_Password  => $admin_password, 
                                     -IP_Address      => $ENV{REMOTE_ADDR},
                                     -Function        => 'log_viewer');
my $list = $admin_list; 

# get the list information
my %list_info = open_database(-List => $list); 
                              
# header     
print(admin_html_header(-Title      => "Log Viewer",
		                -List       => $list_info{list},
		                -Form       => 0,
		                -Root_Login => $root_login));
	
my $logs        = find_logs(); 
my $lines       = $q->param('lines')    || 100; 
my $log_name    = $q->param('log_name') || $Default_Log;
my $process     = $q->param('process'); 
   $Default_Log = $log_name; 
   
my @log_names = keys %$logs; 

if($process eq 'remove'){ 
	if(exists($logs->{$log_name})){ 
		unlink($Logs{$log_name}); 	
	}
}		               

if(!$log_names[0]){ 
	print $q->p($q->i('There are no Mojo Mail logs set')); 
}else{ 
	print log_controls($logs);
	print show_log($log_name, $lines); 
	print log_delete($log_name);
}

#footer
print admin_html_footer(-Form => 0); 


#---------------------------------------------------------------------#

sub find_logs { 
	my %found_logs;	
	foreach(keys %Logs){ 
		if(file_check($Logs{$_}) == 1){ 
			$found_logs{$_} = $Logs{$_};
		}
	}	
	return \%found_logs; 
}

sub file_check { 
	my $filename = shift; 
	if(-f $filename && -e $filename){ 
		return 1;
	}
}

sub log_lines { 
	my ($filename, $lines) = @_;
	my $log = `tail -n $lines $filename`;
	my @lines = split("\n", $log); 
	return \@lines;
}

sub show_log { 
	my ($log_name, $lines) = @_;
	my $loglines = log_lines($Logs{$log_name}, $lines); 
	my $html; 
	   $html .= '<pre>';
	foreach(@$loglines){ 
		$_ =~ s/\t/    /g;
		$html .= $_ . "\n";
	}
	$html .= '</pre>';
	return $html;
}

sub log_controls { 
	my $logs = shift;
	my $html; 
	
	$html .= $q->start_form(-method => 'post');
	$html .= $q->start_table({-cellpadding => 5}); 
	$html .= $q->Tr(
	         $q->td({-valign => 'bottom'}, [
	         
	         ($q->p('Show this log: ', $q->br, 
	          $q->popup_menu(-name    => 'log_name', 
	                        '-values' => [keys %$logs],
	                        -default  =>  $log_name)
	         )), 
	         
	         ($q->p('Show the last:', $q->br,   
			  $q->popup_menu(-name => 'lines',
							'-values' => [1,10,20,25,50,100,200,500,1000, 10000], 
							 -default => $lines), 
	                ' lines')),
	          ($q->p($q->submit(-value => 'Refresh')))
	         ])); 
	         
	 $html .= $q->end_form();
	 $html .= $q->end_table();
	                         
	return $html;
}

sub log_delete { 
	my $log_name = shift; 
	my $html; 
	$html .= $q->p({-align=> 'center'},
	$html .= $q->start_form(-method => 'post'), 
	         $q->hidden('process',  'remove'), 
	         $q->hidden('log_name', $log_name), 
	         $q->submit(-value	=> "Purge $log_name"),
	         $q->end_form());
	return $html;
}

#---------------------------------------------------------------------#

=pod

=head1 Plugin: view_log.cgi - View Logs Created by Mojo Mail

This plugin allows you to view the Mojo, Error and SMTP logs 
that  Mojo Mail creates in its activities through your web browser. 

=head2 Installation

Upload log_viewer.cgi into your cgi-bin. We suggest you create 
a 'plugins' directory in the same directory that the mojo.cgi script 
is in. For example. If mojo.cgi is at: 

 /home/account/cgi-bin/mojo/mojo.cgi 

create a directory called plugins at: 

  /home/account/cgi-bin/mojo/plugins

and upload this script into that directory:

 /home/account/cgi-bin/mojo/plugins/log_viewer.cgi

Once uploaded in plain text or ASCII mode, chmod the script to 755.   

Add this entry to the $ADMIN_MENU array ref:

	 {-Title          => 'View Logs', 
	  -Title_URL      => $PLUGIN_URL."/log_viewer.cgi",
	  -Function       => 'log_viewer',
	  -Activated      => 1, 
	  },

It's possible that this has already been added to $ADMIN_MENU and all
you would need to do is uncomment this entry.



=head1 COPYRIGHT 

Copyright (c) 1999 - 2003 
Justin Simoni
me@justinsimoni.com http://justinsimoni.com

All rights reserved. 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

=cut




