// Conditional alert.
function cAlert (message)
{
	if (!this.silent)
	{
		alert(message);
	}
}

// Conditional confirm.
function cConfirm (message)
{
	if (this.silent)
	{
		return true;
	}
	else
	{
		return confirm (message);
	}
}

// Variable indicating whether or not installation should proceed.
var bInstall = true;

// Make sure Java is enabled before doing anything else.
if (!navigator.javaEnabled ())
{
	bInstall = false;
	cAlert ("Java must be enabled to install.");
}


// Make sure installation is attempted on correct machine architecture.
else if (navigator.platform != "Win32")
{
	bInstall = false;
	cAlert ("This plug-in only runs on Win32 platforms.");
}

// If all conditions look good, proceed with the installation.
if (bInstall)
{
	// Create a version object and a software update object
	vi = new netscape.softupdate.VersionInfo (4, 3, 0, 0);
	su = new netscape.softupdate.SoftwareUpdate (this, "Esker ActiveX Plug-in");

	// Start the install process
	var err = su.StartInstall ("plugins/com/esker/deployer/npeskp32", vi, netscape.softupdate.SoftwareUpdate.FULL_INSTALL);
	if (err != 0)
	{
		cAlert ("Installation error. Aborting.");
	}
	else
	{
		bAbort = false;
	}

	// Find the plug-ins directory on the user's machine
	var PIFolder = su.GetFolder ("Plugins");

	// Install the files. Unpack them and list where they go
	if (!bAbort)
	{
		err = su.AddSubcomponent ("Esker ActiveX Plug-in", vi, "npeskp32.dll", PIFolder, "", this.force);
		bAbort = bAbort || (err !=0);
	}

	// Unless there was a problem, move files to final location 
	// and update the Client Version Registry
	if (bAbort)
	{
		cAlert ("Installation error. Aborting.");
		su.AbortInstall();
	}
	else
	{
		err = su.FinalizeInstall();
	}

	// Refresh list of available plug-ins
	if (err == 0)
	{
		navigator.plugins.refresh(true);
	}
	else if (err == 999)
	{
		cAlert ("You must reboot to finish this installation.");
	}
	else
	{
		cAlert ("Install encountered errors.");
	}
}