<?php 

/***************************************************************************
 *                               whoposted.php
 *                            -------------------
 *   copyright            : Edgardo Rossetto 
 *   email                : linux@i18n.com.ar
 *
 *   Version		  : 0.1.2 - 01/05/2002
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start initial var setup
//
if ( isset($HTTP_GET_VARS[POST_TOPIC_URL]) )
{
	$topic_id = intval($HTTP_GET_VARS[POST_TOPIC_URL]);
}
else if ( isset($HTTP_GET_VARS['topic']) )
{
	$topic_id = intval($HTTP_GET_VARS['topic']);
}

if ( !isset($topic_id) )
{
	message_die(GENERAL_MESSAGE, 'No_post_id');
}

$sql = "SELECT forum_id FROM " . TOPICS_TABLE . "
	WHERE topic_id = $topic_id";
if( !($result = $db->sql_query($sql)) )
{ 
	message_die(GENERAL_ERROR, 'Could not query topics table', '', __LINE__, __FILE__, $sql);
}

$row = $db->sql_fetchrow($result);
$forum_id = $row['forum_id'];

//
// Start session management
//
$userdata = session_pagestart($user_ip, $forum_id);
init_userprefs($userdata);
//
// End session management
//

$sql = "SELECT COUNT(p.post_id) AS posts, p.topic_id, p.poster_id, u.user_id, u.username
	FROM " . POSTS_TABLE . " AS p
	LEFT JOIN " . USERS_TABLE . " AS u ON (p.poster_id = u.user_id)
	WHERE p.topic_id = $topic_id
	GROUP BY p.poster_id
	ORDER BY posts DESC";
if( !($result = $db->sql_query($sql)) )
{ 
	message_die(GENERAL_ERROR, 'Could not query db', '', __LINE__, __FILE__, $sql);
}

$total_posts = 0;
for ( $i = 1; $row = $db->sql_fetchrow($result); $i++ )
{
	$poster = ( $row['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $row['user_id']) . '" target="_blank">' : '';
	$poster .= ( $row['user_id'] != ANONYMOUS ) ? $row['username'] : $lang['Guest'];
	$poster .= ( $row['user_id'] != ANONYMOUS ) ? '</a>' : '';

	$posts = $row['posts'];
	$rowclass = "row1";
	if ( $i % 2 == 0 )
	{
		$rowclass = "row2";
		$i = 0;
	}

	$template->assign_block_vars("whoposted", array(
		'ROWCLASS' => $rowclass,
		'POSTER' => $poster,
		'POSTS' => $posts)
	);
	$total_posts = $total_posts + $posts;
}

$template->set_filenames(array(
	'body' => 'whoposted_body.tpl')
);

$template->assign_vars(array(
	'TOPIC_ID' => $topic_id,
	'TOTAL_POSTS' => $total_posts,
	'L_WHO_POSTED_MSG' => $lang['Who_posted_msg'],
	'L_TOTAL_POSTS' => $lang['Total_posts'],
	'L_AUTHOR' => $lang['Author'],
	'L_POSTS' => $lang['Posts'])
);

$gen_simple_header = 1;

$page_title = $lang['Who_posted'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->pparse("body");

?>