<?php
/***************************************************************************
 *                              viewonline.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: viewonline.php,v 1.54.2.2 2002/12/02 10:53:42 bartvb Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/07 04:27:12 mj 
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_VIEWONLINE);
init_userprefs($userdata);
//
// End session management
//

//
// Output page header and load viewonline template
//
$page_title = $lang['Who_is_Online'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'viewonline_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_WHOSONLINE' => $lang['Who_is_online'],
	'L_ONLINE_EXPLAIN' => $lang['Online_explain'],
	'L_USERNAME' => $lang['Username'],
	'L_FORUM_LOCATION' => $lang['Forum_Location'],
	'L_STARTED' => $lang['Logged_on'],
	'L_LAST_UPDATE' => $lang['Last_updated'])
);

//
// Forum info
//
$sql = "SELECT forum_name, forum_id
	FROM " . FORUMS_TABLE;
if ( $result = $db->sql_query($sql) )
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_data[$row['forum_id']] = $row['forum_name'];
	}
}
else
{
	message_die(GENERAL_ERROR, 'Could not obtain user/online forums information', '', __LINE__, __FILE__, $sql);
}

//
// Get auth data
//
$is_auth_ary = array();
$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata);

//
// Get user list
//
$sql = "SELECT u.user_id, u.username, u.user_allow_viewonline, u.user_level, s.session_logged_in, s.session_time, s.session_page, s.session_topic, s.session_ip, s.session_start
	FROM ".USERS_TABLE." u, ".SESSIONS_TABLE." s
	WHERE u.user_id = s.session_user_id
		AND s.session_time >= ".( time() - 300 ) . "
	ORDER BY u.username ASC, s.session_ip ASC";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain regd user/online information', '', __LINE__, __FILE__, $sql);
}

$guest_users = 0;
$registered_users = 0;
$hidden_users = 0;

$reg_counter = 0;
$guest_counter = 0;
$prev_user = 0;
$prev_ip = '';

while ( $row = $db->sql_fetchrow($result) )
{
	$view_online = false;

	if ( $row['session_logged_in'] ) 
	{
		$user_id = $row['user_id'];

		if ( $user_id != $prev_user )
		{
			$username = $row['username'];

			$style_color = '';
			if ( $row['user_level'] == ADMIN )
			{
				$username = '<b style="color:#' . $theme['adminfontcolor'] . '">' . $username . '</b>';
			}
			else if ( $row['user_level'] == LESS_ADMIN )
			{
				$username = '<b style="color:#' . $theme['supermodfontcolor'] . '">' . $username . '</b>';
			}
			else if ( $row['user_level'] == MOD )
			{
				$username = '<b style="color:#' . $theme['modfontcolor'] . '">' . $username . '</b>';
			}

			if ( !$row['user_allow_viewonline'] )
			{
				$view_online = ( $userdata['user_level'] == ADMIN ) ? true : false;
				$hidden_users++;

				$username = '<i>' . $username . '</i>';
			}
			else
			{
				$view_online = true;
				$registered_users++;
			}

			$which_counter = 'reg_counter';
			$which_row = 'reg_user_row';
			$prev_user = $user_id;
		}
	}
	else
	{
		if ( $row['session_ip'] != $prev_ip )
		{
			$username = $lang['Guest'];
			$view_online = true;
			$guest_users++;
	
			$which_counter = 'guest_counter';
			$which_row = 'guest_user_row';
		}
	}

	$prev_ip = $row['session_ip'];

	if ( $view_online )
	{
		if ( $row['session_page'] < 1 || !$is_auth_ary[$row['session_page']]['auth_view'] )
		{
			switch( $row['session_page'] )
			{
				case PAGE_INDEX:
					$location = $lang['Forum_index'];
					$location_url = "index.$phpEx";
					break;
				case PAGE_POSTING:
					$location = $lang['Posting_message'];
					$location_url = "index.$phpEx";
					break;
				case PAGE_LOGIN:
					$location = $lang['Logging_on'];
					$location_url = "index.$phpEx";
					break;
				case PAGE_SEARCH:
					$location = $lang['Searching_forums'];
					$location_url = "search.$phpEx";
					break;
				case PAGE_PROFILE:
					$location = $lang['Viewing_profile'];
					$location_url = "index.$phpEx";
					break;
				case PAGE_VIEWONLINE:
					$location = $lang['Viewing_online'];
					$location_url = "viewonline.$phpEx";
					break;
				case PAGE_VIEWMEMBERS:
					$location = $lang['Viewing_member_list'];
					$location_url = "memberlist.$phpEx";
					break;
				case PAGE_PRIVMSGS:
					$location = $lang['Viewing_priv_msgs'];
					$location_url = "privmsg.$phpEx";
					break;
				case PAGE_FAQ:
					$location = $lang['Viewing_FAQ'];
					$location_url = "faq.$phpEx";
					break;
				case PAGE_SMILES:
					$location = $lang['Viewing_Smilies'];
					$location_url = "smilies.$phpEx";
					break;
				case PAGE_TELLFRIEND:
					$location = $lang['Viewing_Tell_Friend'];
					$location_url = "tellafriend.$phpEx";
					break;
				case PAGE_LINKS:
					$location = $lang['Viewing_Links'];
					$location_url = "links.$phpEx";
					break;
				case PAGE_LINK:
					$location = $lang['Viewing_Links'];
					$location_url = "link.$phpEx";
					break;
				case PAGE_DOWNLOAD:
					$location = $lang['Viewing_Download'];
					$location_url = "dload.$phpEx";
					break;    
				case PAGE_TOPIC_VIEW:
					$location = $lang['Viewing_topic_views'];
					$location_url = "memberlist.$phpEx";
					break;
				case PAGE_TOPICS_STARTED:
					$location = $lang['Viewing_topics_started'];
					$location_url = "topics.$phpEx";
					break;
				case PAGE_STAFF:
					$location = $lang['Viewing_staff'];
					$location_url = "staff.$phpEx";
					break;
				case PAGE_ALBUM:
					$location = $lang['Viewing_album'];
					$location_url = "album.$phpEx";
					break;
				case PAGE_ATTACHMENTS:
					$location = $lang['Viewing_attachments'];
					$location_url = "attachments.$phpEx";
					break;
				case PAGE_STATISTICS:
					$location = $lang['Viewing_stats'];
					$location_url = "statistics.$phpEx";
					break;
				case PAGE_MY_TRANS:
					$location = $lang['My_Trans'];
					$location_url = "mytransfer.$phpEx";
					break;
				case PAGE_GLOBAL_TRANS:
					$location = $lang['Global_Trans'];
					$location_url = "transaction.$phpEx";
					break;	
				case PAGE_CALENDAR:
					$location = $lang['Viewing_calendar'];
					$location_url = "calendar.$phpEx";
					break;
				case PAGE_BANK:
					$location = $lang['Viewing_bank'];
					$location_url = "bank.$phpEx";
					break;
				case PAGE_SHOP:
					$location = $lang['Viewing_shop'];
					$location_url = "shop.$phpEx";
					break;
				case PAGE_RATINGS:
					$location = $lang['Viewing_ratings'];
					$location_url = "ratings.$phpEx";
					break;
				case PAGE_USERCP:
					$location = $lang['Viewing_user_CP'];
					$location_url = "usercp.$phpEx";
					break;
				case PAGE_CHATROOM:
					$location = $lang['Viewing_chatroom'];
					$location_url = "chatroom.$phpEx";
					break;
				case PAGE_IMLIST:
					$location = $lang['Viewing_IM_list'];
					$location_url = "imlist.$phpEx";
					break;
				case PAGE_TOPLIST:
					$location = $lang['Viewing_toplist'];
					$location_url = "toplist.$phpEx";
					break;
				case PAGE_LOTTERY:
					$location = $lang['Viewing_lottery'];
					$location_url = "lottery.$phpEx";
					break;
				case PAGE_LOTTERY_WINNERS:
					$location = $lang['Viewing_lottery_winners'];
					$location_url = "lotwin.$phpEx";
					break;
				case PAGE_ACTIVITY:
					$location = $lang['Viewing_online_games'];
					$location_url = "activity.$phpEx";
					break;
				case PAGE_PRILLIAN:
					$location = $lang['Prillian'];
					$location_url = "imclient.$phpEx?mode=main";
					break;
				case PAGE_BUDDY:
					if ( !defined('IN_BID_LANG') )
					{
						include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_bid.' . $phpEx);
					}
					$location = $lang['Buddy_Management'];
					$location_url = "bid.$phpEx";
					break;
				case PAGE_CHARTS:
					$location = $lang['Viewing_charts'];
					$location_url = "charts.php?action=list";
					break;
				case PAGE_BANLIST:
					$location = $lang['Viewing_banlist'];
					$location_url = "banlist.$phpEx";
					break;
				case PAGE_KB:
					$location = $lang['Viewing_KB'];
					$location_url = "kb.$phpEx";
					break;
				default:
					$location = $lang['Forum_index'];
					$location_url = "index.$phpEx";
			}
		}
		else
		{
		if ($row['session_topic'])
		{
			//
			// Topic info
			//
			$sql = "SELECT topic_title FROM " . TOPICS_TABLE . " WHERE topic_id=" . $row['session_topic'];
			if ( $result2 = $db->sql_query($sql) )
			{
				$topic_title = $db->sql_fetchrow($result2);
			}
			else
			{	
				message_die(GENERAL_ERROR, 'Could not obtain user/online forums information', '', __LINE__, __FILE__, $sql);
			}
			$location_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $row['session_topic']);
			$location = $forum_data[$row['session_page']] .' -> '.$topic_title['topic_title'];
		} else 
		{
			$location_url = append_sid("viewforum.$phpEx?" . POST_FORUM_URL . '=' . $row['session_page']);
			$location = $forum_data[$row['session_page']];
		}
		}

		$row_color = ( $$which_counter % 2 ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( $$which_counter % 2 ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars("$which_row", array(
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'USERNAME' => $username,
			'STARTED' => create_date($board_config['default_dateformat'], $row['session_start'], $board_config['board_timezone']),
			'LASTUPDATE' => create_date($board_config['default_dateformat'], $row['session_time'], $board_config['board_timezone']),
			'FORUM_LOCATION' => $location,

			'U_USER_PROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $user_id),
			'U_FORUM_LOCATION' => append_sid($location_url))
		);

		$$which_counter++;
	}
}

if( $registered_users == 0 )
{
	$l_r_user_s = $lang['Reg_users_zero_online'];
}
else if( $registered_users == 1 )
{
	$l_r_user_s = $lang['Reg_user_online'];
}
else
{
	$l_r_user_s = $lang['Reg_users_online'];
}

if( $hidden_users == 0 )
{
	$l_h_user_s = $lang['Hidden_users_zero_online'];
}
else if( $hidden_users == 1 )
{
	$l_h_user_s = $lang['Hidden_user_online'];
}
else
{
	$l_h_user_s = $lang['Hidden_users_online'];
}

if( $guest_users == 0 )
{
	$l_g_user_s = $lang['Guest_users_zero_online'];
}
else if( $guest_users == 1 )
{
	$l_g_user_s = $lang['Guest_user_online'];
}
else
{
	$l_g_user_s = $lang['Guest_users_online'];
}

$template->assign_vars(array(
	'TOTAL_REGISTERED_USERS_ONLINE' => sprintf($l_r_user_s, $registered_users) . sprintf($l_h_user_s, $hidden_users), 
	'TOTAL_GUEST_USERS_ONLINE' => sprintf($l_g_user_s, $guest_users))
);

if ( $registered_users + $hidden_users == 0 )
{
	$template->assign_vars(array(
		'L_NO_REGISTERED_USERS_BROWSING' => $lang['No_users_browsing'])
	);
}

if ( $guest_users == 0 )
{
	$template->assign_vars(array(
		'L_NO_GUESTS_BROWSING' => $lang['No_users_browsing'])
	);
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
