<?php
/***************************************************************************
 *                              online.php
 *                            -------------------
 *   begin                : 2003
 *   copyright            : (C) 2003 President
 *   email                : paul@mikado.eeng.may.ie
 *
 *   $Id: online.php,v 0.0.5 2003/03/13 21:45:00 pres Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);

$sql = "SELECT u.username, u.user_id, u.user_allow_viewonline, u.user_level, s.session_logged_in, s.session_ip
	FROM ".USERS_TABLE." u, ".SESSIONS_TABLE." s 
	WHERE u.user_id = s.session_user_id 
      AND s.session_time >= ".( time() - 300 ) . " 
$user_forum_sql 
	ORDER BY u.username ASC, s.session_ip ASC"; 

if(!$result = $db->sql_query($sql)) 
{ 
   message_die(GENERAL_ERROR, "Couldn't obtain user/online information.", "", __LINE__, __FILE__, $sql); 
}

$home_url = "http://".$board_config['server_name']."".$board_config['script_path'].""; 

$userlist_ary = array(); 
$userlist_visible = array(); 

$logged_visible_online = 0; 
$logged_hidden_online = 0; 
$guests_online = 0; 
$online_userlist = ""; 

$prev_user_id = 0; 

while( $row = $db->sql_fetchrow($result) ) 
{ 
   // User is logged in and therefor not a guest 
   if( $row['session_logged_in'] ) 
   { 
      // Skip multiple sessions for one user 
      if( $row['user_id'] != $prev_user_id ) 
      { 
         $style_color = ""; 
         if( $row['user_level'] == ADMIN ) 
         { 
            $row['username'] = '<b>' . $row['username'] . '</b>'; 
            $style_color = 'style="color:#' . $theme['adminfontcolor'] . '"'; 
         } 
         else if( $row['user_level'] == LESS_ADMIN ) 
         { 
            $row['username'] = '<b>' . $row['username'] . '</b>'; 
            $style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"'; 
         } 
         else if( $row['user_level'] == MOD ) 
         { 
            $row['username'] = '<b>' . $row['username'] . '</b>'; 
            $style_color = 'style="color:#' . $theme['modfontcolor'] . '"'; 
         } 
         $phpbb_web_path = "".$home_url."";
         if( $row['user_allow_viewonline'] ) 
         { 
            $user_online_link = '<a href="' . append_sid($phpbb_web_path."profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall">' . $row['username'] . '</a>'; 
            $logged_visible_online++; 
         } 
         else 
         { 
            $user_online_link = '<a href="' . append_sid($phpbb_web_path."profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall"><i>' . $row['username'] . '</i></a>';
            $logged_hidden_online++; 
         } 
          
         if( $row['user_allow_viewonline'] || $userdata['user_level'] == ADMIN ) 
         { 
            $online_userlist .= ( $online_userlist != "" ) ? ", " . $user_online_link : $user_online_link; 
         } 
      } 
   } 
   else 
   { 
      $guests_online++; 
   } 

   $prev_user_id = $row['user_id']; 
} 

if( empty($online_userlist) ) 
{ 
   $online_userlist = $lang['None']; 
} 
$online_userlist = ( ( isset($forum_id) ) ? $lang['Browsing_forum'] : $lang['Registered_users'] ) . " " . $online_userlist;

$total_online_users = $logged_visible_online + $logged_hidden_online + $guests_online; 

if($total_online_users > $board_config['record_online_users']) 
{ 
   $sql = "UPDATE " . CONFIG_TABLE . " 
      SET config_value = '$total_online_users' 
      WHERE config_name = 'record_online_users'"; 
   if( !$result = $db->sql_query($sql) ) 
   { 
      message_die(GENERAL_ERROR, "Couldn't update online user record (nr of users)", "", __LINE__, __FILE__, $sql); 
   } 

   $sql = "UPDATE " . CONFIG_TABLE . " 
      SET config_value = '" . time() . "' 
      WHERE config_name = 'record_online_date'"; 
   if( !$result = $db->sql_query($sql) ) 
   { 
      message_die(GENERAL_ERROR, "Couldn't update online user record (date)", "", __LINE__, __FILE__, $sql); 
   } 

   $board_config['record_online_users'] = $total_online_users; 
   $board_config['record_online_date'] = time(); 
} 

if( $total_online_users == 0 ) 
{ 
   $l_t_user_s = $lang['Online_users_zero_total']; 
} 
else if( $total_online_users == 1 ) 
{ 
   $l_t_user_s = $lang['Online_user_total']; 
} 
else 
{ 
   $l_t_user_s = $lang['Online_users_total']; 
} 

if( $logged_visible_online == 0 ) 
{ 
   $l_r_user_s = $lang['Reg_users_zero_total']; 
} 
else if( $logged_visible_online == 1 ) 
{ 
   $l_r_user_s = $lang['Reg_user_total']; 
} 
else 
{ 
   $l_r_user_s = $lang['Reg_users_total']; 
} 

if( $logged_hidden_online == 0 ) 
{ 
   $l_h_user_s = $lang['Hidden_users_zero_total']; 
} 
else if( $logged_hidden_online == 1 ) 
{ 
   $l_h_user_s = $lang['Hidden_user_total']; 
} 
else 
{ 
   $l_h_user_s = $lang['Hidden_users_total']; 
} 

if( $guests_online == 0 ) 
{ 
   $l_g_user_s = $lang['Guest_users_zero_total']; 
} 
else if( $guests_online == 1 ) 
{ 
   $l_g_user_s = $lang['Guest_user_total']; 
} 
else 
{ 
   $l_g_user_s = $lang['Guest_users_total']; 
} 

$l_online_users = sprintf($l_t_user_s, $total_online_users); 
$l_online_users .= sprintf($l_r_user_s, $logged_visible_online); 
$l_online_users .= sprintf($l_h_user_s, $logged_hidden_online); 
$l_online_users .= sprintf($l_g_user_s, $guests_online); 

$onlinet="$l_online_users<br /><br />$online_userlist";

$template->set_filenames(array(
	'usercp_online_info' => 'usercp_online_info_body.tpl')
);

$template->assign_vars(array(
    'ONLINE_INFO' => $onlinet,
    'L_ONLINE_INFO' => $lang['Who_is_Online'],
    )
);

$template->assign_var_from_handle('USERCP_ONLINE_INFO_OUTPUT', 'usercp_online_info');

?>