<?php
/***************************************************************************
 *                        admin_show_avatars.php
 *                        ----------------------
 *   begin                : Saturday, Feb 15, 2003
 *   copyright            : (C) 2003 Jay MacDonald
 *   email                : jay@cheakamus.com
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/07/09 07:28:45 mj 
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Users']['Avatar_viewer'] = $filename;

	return;
}

//
// Load default header
//
$phpbb_root_path = "../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

//
// Perform SQL query to get all the avatars
//
$sql = "SELECT user_id, username, user_avatar, user_avatar_type
	FROM " . USERS_TABLE . "
	WHERE user_avatar_type != " . USER_AVATAR_NONE . "
	ORDER BY username";

$result = $db->sql_query($sql);
if( !$result )
{
	message_die(GENERAL_ERROR, "Couldn't obtain avatars from database", '', __LINE__, __FILE__, $sql);
}

$avatars = $db->sql_fetchrowset($result);

$template->set_filenames(array(
	"body" => "admin/admin_show_avatars_body.tpl")
);

$template->assign_vars(array(
	"L_PAGE_TITLE" => $lang['Avatar_viewer'],
	"L_PAGE_DESCRIPTION" => $lang['Avatar_viewer_explain'])
);

$columns=4;
$onrow=0;

//
// Loop through the avatars setting block vars for the template.
//
for($i = 0; $i < count($avatars); $i = $i + $columns)
{
	$onrow++;
	$row_class = ( !($onrow % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

	$template->assign_block_vars("avatar_row", array(
		"ROW_CLASS" => $row_class)
	);

	for ( $j = 0; $j < $columns; $j++ )
	{

		$avatar_id = $i + $j;
		if ( $avatars[$avatar_id]['user_avatar'] )
		{
			switch ($avatars[$avatar_id]['user_avatar_type']) {
				case USER_AVATAR_UPLOAD:
					$img_src = $phpbb_root_path . $board_config['avatar_path'] . '/' . $avatars[$avatar_id]['user_avatar'];
					break;
				case USER_AVATAR_REMOTE:
					$img_src = $avatars[$avatar_id]['user_avatar'];
					break;
				case USER_AVATAR_GALLERY:
					$img_src = $phpbb_root_path . $board_config['avatar_gallery_path'] . '/' . $avatars[$avatar_id]['user_avatar'];
					break;
                        }

			$template->assign_block_vars("avatar_row.avatars", array(
				"AVATAR_IMG" => $img_src,
				"LINK" => append_sid("admin_users.php?mode=edit&amp;" . POST_USERS_URL . "=". $avatars[$avatar_id]['user_id']),
				"USERNAME" => $avatars[$avatar_id]['username'])
			);
		}
	}
}

//
// Spit out the page.
//
$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>