<?php
  // --------------------------------------------------------------------
  // phpSpell 1.06 (beta) PHPBB & Nuke Specific code
  //
  // This is (c)Copyright 2003, Team phpSpell.
  // --------------------------------------------------------------------

  if (!defined("PHPSPELL_CONFIG")) exit;
  define("IN_PHPBB", true);
  $Spell_Config["DB_MODULE"] = "PHPBB v2.0";

  $phpbb_root_path = $Spell_Config["PHPBB_ROOT_PATH"];
  include ($phpbb_root_path."extension.inc");

  $PathPrefix = "";

  // --------------------------------------------
  // Setup to use under NUKE
  // --------------------------------------------
  if ($Spell_Config["DB_Type"] == "PHPNuke") {
    $Spell_Config["PHPBB_NUKE"] = true;
    $PathPrefix = "../../";
    $Spell_Config["DB_MODULE"] .= " - w/ Nuke Support";
  } else {
    $Spell_Config["PHPBB_NUKE"] = false;
  }

  // -------------------

  // General Configuration Include File
  include ($phpbb_root_path.$PathPrefix."config.".$phpEx);
  // ---------------------------------

  if (defined("IN_SPELL_ADMIN")) {
    include($phpbb_root_path . 'common.'.$phpEx);
    if ($Spell_Config["PHPBB_NUKE"]) {
      $user = PHPNuke_User_Check();
      $userdata = session_pagestart($user_ip, PAGE_INDEX, $user);
    } else {
    $userdata = session_pagestart($user_ip, PAGE_INDEX);
    }
    init_userprefs($userdata);

    if( !$userdata['session_logged_in'] )
    {
      $header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
      header($header_location . '../' . append_sid("login.$phpEx?redirect=spelling/spell_admin.$phpEx"));
      exit;
    }
    else if( $userdata['user_level'] != ADMIN )
    {
        message_die(GENERAL_MESSAGE, $lang['Not_admin']);
    }
  } else {
    include ($phpbb_root_path."includes/db.".$phpEx);
    define("CRITICAL_ERROR", 1);
    define('BEGIN_TRANSACTION', 1);
    define('END_TRANSACTION', 2);
    function message_die($Error, $Message) {
     die($Message);
    }
  }

  // Activate Spelling Support for the Database
  $Spelling_DB = new SPELL_DB($db);

  // Required for Nuke
  if ($Spell_Config["PHPBB_NUKE"] == true) {
    $table_prefix = @$user_prefix . "_";
    $dbms = $dbtype;
  }

  if ($Spell_Config["PHPBB_Load_Smilies"]) Create_PHPBB_Smiles();


  function Create_PHPBB_Smiles()
  {
    global $Spell_Config;
    global $db, $table_prefix;

    // Php Nuke Specific code.
    $nuke_prefix = "";
    if ($Spell_Config["PHPBB_NUKE"] == true) $nuke_prefix = "bb";

    $Query = "select code from ".$table_prefix.$nuke_prefix."smilies order by length(code) desc";
    if( !($Query_Result = $db->sql_query($Query)) ) {

       if (defined("IN_SPELL_DIAGS") || defined("IN_SPELL_ADMIN")) {
         echo "<br><Br><center><b>Error opening smilies table.</b></center><br>";
       } else {
         message_die(CRITICAL_ERROR,"Unable to perform spell check at this time.<br>");
         exit;
       }
    }

    $Count = $db->sql_numrows($Query_Result);
    for ($i=0;$i<$Count;$i++) {
      $Fetched_Array = $db->sql_fetchrow($Query_Result);
      $Spell_Config["Symbol_Tags"][] = $Fetched_Array["code"];
    }
  }

  function PHPNuke_User_Check()
  {
    global $cookie, $nukeuser, $db;
    $user = base64_decode($user);
    $cookie = explode(":", $user);
    $sql = "SELECT uid, pass FROM " . USERS_TABLE . "WHERE uname='$cookie[1]'";
    $result = $db->sql_query($sql);
    if(!$result) {
      message_die(GENERAL_ERROR, 'Could not query user account', '', __LINE__, __FILE__, $sql);
    }
    $row = $db->sql_fetchrow($result);
    if ($cookie[2] == $row['pass'] && $row['pass'] != "") {
       return ($user);
    } else {
      unset($user);
      unset($cookie);
      message_die(GENERAL_MESSAGE, "You are not authorised to administer this board");
    }
    return ("");
  }

  // ------------------------------------------------------------
  // Database Library Abstraction Library.
  // ------------------------------------------------------------
  class SPELL_DB {
    // Holds the Database Link Information
    var $DataBaseLink;
    var $SQL_Connection=false;
    var $Database;
    var $Username;
    var $Server;

    function SPELL_DB($DBLink) {
      $this->DataBaseLink = $DBLink;
      $this->SQL_Connection = $DBLink->db_connect_id;
      $this->Database = $DBLink->dbname;
      $this->Username = $DBLink->user;
      $this->Server = $DBLink->server;
    }

    function Run_Query($Query) {
      return ($this->DataBaseLink->sql_query($Query));
    }

    function Number_Rows($Query_Result) {
      return ($this->DataBaseLink->sql_numrows($Query_Result));
    }

    function Fetch_Row($Query_Result) {
      return ($this->DataBaseLink->sql_fetchrow($Query_Result));
    }

    function SQL_Error()
    {
      return ($this->DataBaseLink->sql_error());
    }
  }

?>
