<?php
/***************************************************************************
 *                              ratings.php
 *                            -------------------
 *   begin                : Monday, Nov 3, 2002
 *   copyright            : (C) 2002 Web Centre Ltd
 *   email                : phpbb@mywebcommunities.com
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
define('RATING_PATH', $phpbb_root_path.'ratings/');
include (RATING_PATH.'functions_rating.'.$phpEx);

// Include language file
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_rating.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_rating.' . $phpEx);

// Start session management
$userdata = session_pagestart($user_ip, PAGE_RATINGS);
init_userprefs($userdata);
// End session management

$sql_limit = 10; // Number of posts/topics you want displayed 
$rating_config = get_rating_config('1,2,8,9');
if ( $rating_config[1] == 0 )
{
	message_die(GENERAL_ERROR, $lang['Rating_deactivated']); 
}

// SHOULD DATA IN 'REGISTERED USER ONLY' FORUMS BE DISPLAYED?
$r_auth_level = ( !$userdata['session_logged_in'] ) ? 0 : 1;

// Grab all the basic data 
$sql_select = 't.topic_title, t.rating_rank_id AS topic_rating, p.rating_rank_id AS post_rating, t.topic_id, u.username, u.user_id, r.rating_time, ro.label, ro.points AS label2, f.forum_id, p.post_id';
$sql_from = RATING_TABLE.' r, '. TOPICS_TABLE . ' t, ' . USERS_TABLE . ' u, ' . POSTS_TABLE . ' p, ' . FORUMS_TABLE . ' f, ' . USERS_TABLE . ' u2, ' . RATING_OPTION_TABLE . ' ro, ' . RATING_RANK_TABLE . ' rt';
$sql_where = 'r.post_id = p.post_id 
AND p.poster_id = u.user_id 
AND r.user_id = u2.user_id 
AND p.topic_id = t.topic_id 
AND t.topic_status = 0
AND t.forum_id = f.forum_id 
AND f.auth_view <= '.$r_auth_level.' 
AND f.auth_read <= '.$r_auth_level.' 
AND r.option_id = ro.option_id';
$sql_where .= ( $rating_config[2] == '1' ) ? ' AND r.post_id = t.topic_first_post_id' : '';
switch ($type)
{
	case 'p':
		if ( $rating_config[8] == 1 )
		{
			$rmethod = 'SUM(ro.points)';
			$l_column4 = $lang['Total_points'];
			$sql_order = 'rt.sum_threshold DESC, points DESC';
		}
		else
		{
			$rmethod = 'ROUND(AVG(ro.points),1)';
			$l_column4 = $lang['Average_points'];
			$sql_order = 'rt.average_threshold DESC, points DESC';
		}
		$page_title = $lang['Highest_rated_posts'];

		$sql_select .= ', f.forum_name, '.$rmethod.' AS points';
		$sql_where .= ' AND p.rating_rank_id = rt.rating_rank_id';
		$sql_group = 'p.post_id';
		// Get double req number of ratings, to allow for multiple ratings for same post. note this still doesn't guarantee enough records for desired no. of posts/topics but grabbing too many records would affect screen performance. Adjust to suit your own requirements
		$sql_limit *= 3;
		$l_column1 = $lang['Forum'];
		$l_column3 = $lang['Poster'];
		$l_column5 = $lang['Post_rank'];
		break;
	case 't':
		if ( $rating_config[9] == 1 )
		{
			$rmethod = 'SUM(ro.points)';
			$l_column4 = $lang['Total_points'];
		}
		else
		{
			$rmethod = 'ROUND(AVG(ro.points),1)';
			$l_column4 = $lang['Average_points'];
		}
		$page_title = $lang['Highest_rated_topics'];
		$sql_select .= ', f.forum_name, '.$rmethod.' AS points';
		$sql_where = str_replace('p.poster_id', 't.topic_poster', $sql_where);
		$sql_where .= ' AND t.rating_rank_id = rt.rating_rank_id';
		$sql_order = 'points DESC';
		$sql_group = 't.topic_id';
		$sql_limit *= 3;
		$l_column1 = $lang['Forum'];
		$l_column3 = $lang['Topic_starter'];
		$l_column5 = $lang['Topic_rank'];
		break;
	default:
		$page_title = $lang['Latest_ratings'];
		$sql_select .= ', u2.username as ratedby, u2.rating_status, u2.user_id as ratedby_id';
		$sql_where .= ' AND p.rating_rank_id = rt.rating_rank_id';
		$sql_order = 'r.rating_time DESC';
		$l_column1 = $lang['Poster'];
		$l_column3 = $lang['Rating'];
		$l_column4 = $lang['Rated_by'];
		$l_column5 = $lang['Post_rank'];
}

// POSTS BY A SPECIFIC POSTER?
$postedby = intval($postedby);
if ( $postedby > 0 )
{
	if ( $postedby == $userdata['user_id'] )
	{
		$by_poster = $lang['Ratings_posts_by_you'];
	}
	else
	{
		$sql = 'SELECT username, rating_status FROM '.USERS_TABLE.' WHERE user_id = '.$postedby;
		$result = $db->sql_query($sql);
		$r = $db->sql_fetchrow($result);
		$by_poster = $lang['Ratings_posts_by'].' '.$r['username'];
	}
	$sql_where .= ' AND p.poster_id = '.$postedby;
	$page_title .= ' ('.$by_poster.')';
	// IF SHOWING POSTS, DISPLAY POST RATING INSTEAD OF TOTAL/AVERAGE POINTS
}

// RATINGS BY A SPECIFIC USER?
$ratedby = intval($ratedby);
if ( $ratedby > 0 )
{
	if ( $ratedby == $userdata['user_id'] )
	{
		$by_user = $lang['As_rated_by_you'];
	}
	else
	{
		$sql = 'SELECT username, rating_status FROM '.USERS_TABLE.' WHERE user_id = '.$ratedby;
		$result = $db->sql_query($sql);
		$r = $db->sql_fetchrow($result);
		if ( $r['rating_status'] == 1 )
		{
			$is_anonymous = 'y';
		}
		$by_user = $lang['As_rated_by'].' '.$r['username'];
	}
	$sql_where .= ' AND r.user_id = '.$ratedby;
	$page_title .= ' '.$by_user;
	// IF SHOWING POSTS, DISPLAY POST RATING INSTEAD OF TOTAL/AVERAGE POINTS
	if ( $type == 'p' )
	{
		$l_column4 = $lang['Rating'];
	}
}


$sql = 'SELECT '.$sql_select.' FROM '.$sql_from.' WHERE '.$sql_where;
$sql .= ( !empty($sql_group) ) ? ' GROUP BY '.$sql_group : '';
$sql .= ( !empty($sql_order) ) ? ' ORDER BY '.$sql_order : '';
$sql .= ' LIMIT '.$sql_limit;

if( !($result = $db->sql_query($sql)) ) 
{ 
	message_die(GENERAL_ERROR, "Couldn't obtain post rating information", '', __LINE__, __FILE__, $sql); 
} 
$total_rows = $db->sql_numrows($result); 

// Define censored word matches 
$orig_word = array(); 
$replacement_word = array(); 
obtain_word_list($orig_word, $replacement_word); 

$template->set_filenames(array( 
	'body' => 'ratings_body.tpl'
	)
); 

make_jumpbox('viewforum.'.$phpEx);

$u_posts = append_sid($PHP_SELF.'?type=p');
$u_topics = append_sid($PHP_SELF.'?type=t');
$u_ratings = append_sid($PHP_SELF);

// Setup the stuff usually in the header 
$template->assign_vars(array( 
	"U_POSTS" => $u_posts, 
	"U_TOPICS" => $u_topics, 
	"U_RATINGS" => $u_ratings, 
	"L_POSTER" => $lang['Poster'], 
	"L_TOPIC" => $lang['Topic'], 
	"L_COLUMN1" => $l_column1, 
	"L_COLUMN3" => $l_column3, 
	"L_COLUMN4" => $l_column4, 
	"L_COLUMN5" => $l_column5 
	)
); 

// Okay, lets dump out the page ... 
if( !empty($total_rows) && $is_anonymous != 'y' ) 
{ 
	while( $row = $db->sql_fetchrow($result) ) 
	{ 
		// Start auth check 
		$is_auth = array(); 
		$is_auth = auth(AUTH_ALL, $row['forum_id'], $userdata); 

		if( $is_auth['auth_read'] )
		{
			$rowset[] = $row; 
		}
	}

	// Limit the number of topics 
	$total_rows = ( $total_rows > $sql_limit ) ? $sql_limit : $total_rows;

	get_rating_ranks();

	for($i = 0; $i < $total_rows; $i++) 
	{ 
		$topic_title = ( count($orig_word) > 0 ) ? preg_replace($orig_word, $replacement_word, $rowset[$i]['topic_title']) : 	$rowset[$i]['topic_title']; 

		$poster = ( $rowset[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid($phpbb_root_path . 'profile.' . $phpEx . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $rowset[$i]['user_id']) . '">' . $rowset[$i]['username'] . '</a>' : $lang['Guest']; 

		switch ($type)
		{
			case 'p':
				$column1 = '<a href="' . append_sid($phpbb_root_path . 'viewforum.' . $phpEx . '?' . POST_FORUM_URL . '=' . $rowset[$i]['forum_id']) . '">' . $rowset[$i]['forum_name'] . '</a>';
				$column2 = append_sid($phpbb_root_path . 'viewtopic.' . $phpEx . '?' . POST_POST_URL. '=' .$rowset[$i]['post_id'] . '#' . $rowset[$i]['post_id']);
				$column3 = $poster;
				if ( $ratedby > 0 )
				{
					$column4 = ( !empty($rowset[$i]['label']) ) ? $rowset[$i]['label'] : $rowset[$i]['label2'];
				}
				else
				{
					$column4 = $rowset[$i]['points'];
				}
				$column5 = ( empty($rowset[$i]['post_rating']) ) ? $lang['No_rank'] : $post_rank_set[$rowset[$i]['post_rating']];
				break;
			case 't':
				$column1 = '<a href="' . append_sid($phpbb_root_path . 'viewforum.' . $phpEx . '?' . POST_FORUM_URL . '=' . $rowset[$i]['forum_id']) . '">' . $rowset[$i]['forum_name'] . '</a>';
				$column2 = append_sid($phpbb_root_path . 'viewtopic.' . $phpEx . '?' . POST_TOPIC_URL. '=' .$rowset[$i]['topic_id']);
				$column3 = $poster;
				$column4 = $rowset[$i]['points'];
				$column5 = ( empty($rowset[$i]['topic_rating']) ) ? $lang['No_rank'] : $topic_rank_set[$rowset[$i]['topic_rating']];
				break;
			default:
				$column1 = $poster;
				$column2 = append_sid($phpbb_root_path . 'viewtopic.' . $phpEx . '?' . POST_POST_URL. '=' .$rowset[$i]['post_id'] . '#' . $rowset[$i]['post_id']);
				$column3 = ( !empty($rowset[$i]['label']) ) ? $rowset[$i]['label'] : $rowset[$i]['label2'];
				$column4 = ( $rowset[$i]['rating_status'] != 1 ) ? '<a href="' . append_sid($phpbb_root_path . 'profile.' . $phpEx . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $rowset[$i]['ratedby_id']) . '">' . $rowset[$i]['ratedby'] . '</a>' : $lang['Rating_anon_user']; 
				$column5 = ( empty($rowset[$i]['post_rating']) ) ? $lang['No_rank'] : $post_rank_set[$rowset[$i]['post_rating']];
		}



		$template->assign_block_vars('rating', array( 
			"COLUMN1" => $column1, 
			"COLUMN2" => $column2,
			"COLUMN3" => $column3, 
			"COLUMN4" => $column4, 
			"COLUMN5" => $column5, 
			"TOPIC_TITLE" => $topic_title, 
			"ROW_CLASS" => $row_class
			)
		); 
	}
} 
else 
{ 
	// No ratings 
	$template->assign_vars(array( 
		"L_NO_RATINGS" => $lang['No_ratings']) 
	); 
	$template->assign_block_vars('norating', array() ); 
} 
$db->sql_freeresult($result);

$template->assign_vars(array( 
	"L_HIGHEST_RATED_POSTS" => $lang['Highest_rated_posts'],
	"L_HIGHEST_RATED_TOPICS" => $lang['Highest_rated_topics'],
	"L_HIGHEST_RATED_USERS" => $lang['Highest_rated_users'],
	"L_LATEST_RATINGS" => $lang['Latest_ratings']
	)
);

// Parse the page and print 
include($phpbb_root_path . 'includes/page_header.php'); 
$template->pparse('body'); 
include($phpbb_root_path . 'includes/page_tail.php'); 
?>