<?php
/***************************************************************************
 *                                portal.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: portal.php,v 2.0.1 2002/11/05 21:48:00 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/16 07:32:45 mj
 *
 ***************************************************************************/

define('IN_PHPBB', true);
define('SHOW_ONLINE', true); 
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'lgf-reflog.'.$phpEx);
include($phpbb_root_path . 'portal_newsfeed.'.$phpEx);
include($phpbb_root_path . 'referers.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx); 

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_PORTAL);
init_userprefs($userdata);
//
// End session management
//

//
// Include language file
//
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_main_link.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_main_link.' . $phpEx);

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_portal.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_portal.' . $phpEx);

//
// Number of new posts
//
if( $userdata['session_logged_in'] ) 
{ 
	$sql = "SELECT COUNT(post_id) as total 
		FROM " . POSTS_TABLE . " 
		WHERE post_time >= " . $userdata['user_lastvisit'] . " 
		AND poster_id != " . $userdata['user_id']; 
	$result = $db->sql_query($sql); 
	if( $result ) 
	{ 
	$row = $db->sql_fetchrow($result); 
	$lang['Search_new'] = $lang['Search_new'] . " (" . $row['total'] . ")"; 
	} 
} 

//
// Random user
//
function random_user() 
{ 
global $db; 

$sql = "SELECT *
	FROM " . USERS_TABLE . " 
	WHERE user_active = '1' 
	AND user_id <> " . ANONYMOUS . " 
	ORDER BY RAND() LIMIT 1"; 
	if ( !($result = $db->sql_query($sql)) ) 
	{ 
		message_die(GENERAL_ERROR, 'Could not query database for random user data.', '', __LINE__, __FILE__, $sql); 
	} 
	return ( $row = $db->sql_fetchrow($result) ) ? $row : false; 
} 
$profiledata = random_user(); 
$random_name = '<b><a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=".$profiledata['user_id']."") . '">'. $profiledata['username']. '</a></b>'; 
$random_avatar = ''; 
if ( $profiledata['user_avatar_type'] && $user_id != ANONYMOUS && $profiledata['user_allowavatar'] ) 
{ 
	switch( $profiledata['user_avatar_type'] ) 
{ 
case USER_AVATAR_UPLOAD: 
	$random_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $profiledata['user_avatar'] . '" alt="" border="0" />' : ''; 
	break; 
case USER_AVATAR_REMOTE: 
	$random_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $profiledata['user_avatar'] . '" alt="" border="0" />' : ''; 
	break; 
case USER_AVATAR_GALLERY: 
	$random_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $profiledata['user_avatar'] . '" alt="" border="0" />' : ''; 
	break; 
	} 
} 
// Shows default avatar, if no avatar 
else if ( empty($user_avatar) ) 
{ 
	$random_avatar = '<img src="'. $images['default_avatar'] .'" alt="" border="0" />'; 
} 
$random_posts = $profiledata['user_posts']; 
$random_visits = $profiledata['user_totallogon']; 
$random_location = $profiledata['user_from']; 


//
// Get Random Pic
//
$sql = "SELECT p.pic_id, p.pic_title, p.pic_username, p.pic_user_id, p.pic_time, p.pic_desc, p.pic_approval, u.username
	FROM ". ALBUM_TABLE ." AS p
	LEFT JOIN ". USERS_TABLE ." AS u ON p.pic_user_id = u.user_id
	WHERE pic_approval = 1
	ORDER BY RAND() 
	LIMIT 1";
if (!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, 'Could not query album information', '', __LINE__, __FILE__, $sql);
}
$picrow = $db->sql_fetchrow($result);
$pic_poster = '<a href="'. append_sid("profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL .'='. $picrow['pic_user_id']) .'" class="gensmall">'. $picrow['pic_username'] .'</a>';

//
//
//
if ( isset($HTTP_GET_VARS['page']) )
{
	$page_id = intval($HTTP_GET_VARS['page']);
}
else
{
	$page_id = 1 ;
}

$viewcat = ( !empty($HTTP_GET_VARS[POST_CAT_URL]) ) ? $HTTP_GET_VARS[POST_CAT_URL] : -1;

if( isset($HTTP_GET_VARS['mark']) || isset($HTTP_POST_VARS['mark']) )
{
	$mark_read = ( isset($HTTP_POST_VARS['mark']) ) ? $HTTP_POST_VARS['mark'] : $HTTP_GET_VARS['mark'];
}
else
{
	$mark_read = '';
}

$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_t"]) : array();
$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_f"]) : array();

$total_posts = get_db_stat('postcount');
$total_users = get_db_stat('usercount');
$total_topics = get_db_stat('topiccount');
$newest_userdata = get_db_stat('newestuser');
$newest_user = $newest_userdata['username'];
$newest_uid = $newest_userdata['user_id'];

if( $total_posts == 0 )
{
	$l_total_post_s = $lang['Posted_articles_zero_total'];
}
else if( $total_posts == 1 )
{
	$l_total_post_s = $lang['Posted_article_total'];
}
else
{
	$l_total_post_s = $lang['Posted_articles_total'];
}

if( $total_users == 0 )
{
	$l_total_user_s = $lang['Registered_users_zero_total'];
}
else if( $total_users == 1 )
{
	$l_total_user_s = $lang['Registered_user_total'];
}
else
{
	$l_total_user_s = $lang['Registered_users_total'];
}

	//
	// Show daily users
	//
	$time_now=time();
	$time1Hour=$time_now-3600;
	$minutes = date('is', $time_now);
	$hour_now = $time_now - (60*($minutes[0].$minutes[1])) - ($minutes[2].$minutes[3]); 
	$dato=create_date('H', $time_now,$board_config['board_timezone']);
	$timetoday = $hour_now - (3600*$dato); 
	$sql = 'SELECT session_ip, MAX(session_time) as session_time FROM '.SESSIONS_TABLE.' WHERE session_user_id="'.ANONYMOUS.'" AND session_time >= '.$timetoday.' AND session_time< '.($timetoday+86399).' GROUP BY session_ip';
	if (!$result = $db->sql_query($sql)) message_die(GENERAL_ERROR, "Couldn't retrieve guest user today data", "", __LINE__, __FILE__, $sql); 
	while( $guest_list = $db->sql_fetchrow($result))
	{ 
		if ($guest_list['session_time'] >$time1Hour) $users_lasthour++;
	}
	$guests_today = $db->sql_numrows($result);
	$sql = 'SELECT user_id,username,user_allow_viewonline,user_level,user_lastlogon FROM ' . USERS_TABLE . ' WHERE user_id!="'.ANONYMOUS.'" AND user_session_time >= '.$timetoday.' AND user_session_time< '.($timetoday+86399).' ORDER BY username'; 
	if (!$result = $db->sql_query($sql)) message_die(GENERAL_ERROR, "Couldn't retrieve user today data", "", __LINE__, __FILE__, $sql); 
	while( $todayrow = $db->sql_fetchrow($result)) 
	{ 
		$style_color = ""; 
		if ($todayrow['user_lastlogon']>=$time1Hour)
		{
			$users_lasthour++;
		}
		switch ($todayrow['user_level'])
		{
			case ADMIN :
			      $todayrow['username'] = '<b>' . $todayrow['username'] . '</b>'; 
	      		$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
				break;
			case LESS_ADMIN :
      			$todayrow['username'] = '<b>' . $todayrow['username'] . '</b>'; 
				$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
				break;
			case MOD :
			      $todayrow['username'] = '<b>' . $todayrow['username'] . '</b>'; 
	      		$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
				break;
		}
	 	$users_today_list.=( $todayrow['user_allow_viewonline'])?' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $todayrow['user_id']) . '"' . $style_color .' class="gensmall">' . $todayrow['username'] . '</a>,' : (($userdata[user_level]==ADMIN) ? ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $todayrow['user_id']) . '"' . $style_color .' class="gensmall"><i>' . $todayrow['username'] . '</i></a>,' : '');
		if (!$todayrow['user_allow_viewonline']) $logged_hidden_today++;
		else $logged_visible_today++;
	}
	if ($users_today_list) 
	{
		$users_today_list[ strlen( $users_today_list)-1] = ' '; 
	} else
	{
		$users_today_list = $lang['None'];
	}
	$total_users_today = $db->sql_numrows($result)+$guests_today;
	
	$users_today_list = $lang['Registered_users'].' ' . $users_today_list;
	$l_today_user_s = ($total_users_today) ? ( ( $total_users_today == 1 )? $lang['User_today_total'] : $lang['Users_today_total'] ) : $lang['Users_today_zero_total'];
	$l_today_r_user_s = ($logged_visible_today) ? ( ( $logged_visible_today == 1 ) ? $lang['Reg_user_total'] : $lang['Reg_users_total'] ) : $lang['Reg_users_zero_total'];
	$l_today_h_user_s = ($logged_hidden_today) ? (($logged_hidden_today == 1) ? $lang['Hidden_user_total'] : $lang['Hidden_users_total'] ) : $lang['Hidden_users_zero_total'];
	$l_today_g_user_s = ($guests_today) ? (($guests_today == 1) ? $lang['Guest_user_total'] : $lang['Guest_users_total']) : $lang['Guest_users_zero_total'];
	$l_today_users = sprintf($l_today_user_s, $total_users_today);
	$l_today_users .= sprintf($l_today_r_user_s, $logged_visible_today); 
	$l_today_users .= sprintf($l_today_h_user_s, $logged_hidden_today); 
	$l_today_users .= sprintf($l_today_g_user_s, $guests_today);
	
	if ( $total_users_today > $board_config['record_day_users'])  
	{  
		$board_config['record_day_users'] = $total_users_today;  
		$board_config['record_day_date'] = time();   

		$sql = "UPDATE " . CONFIG_TABLE . "  
			SET config_value = '$total_users_today'  
			WHERE config_name = 'record_day_users'";  
		if ( !$db->sql_query($sql) )  
		{  
			message_die(GENERAL_ERROR, 'Could not update today user record (number of users)', '', __LINE__, __FILE__, $sql);  
		}   
	

		$sql = "UPDATE " . CONFIG_TABLE . "  
			SET config_value = '" . $board_config['record_day_date'] . "'  
			WHERE config_name = 'record_day_date'";  
		if ( !$db->sql_query($sql) )  
		{  
			message_die(GENERAL_ERROR, 'Could not update today user record (date)', '', __LINE__, __FILE__, $sql);  
		}  
	}  	

	// Birthday, Show users with birthday 
	$sql = ($board_config['birthday_check_day']) ? "SELECT user_id, username, user_birthday,user_level FROM " . USERS_TABLE. " WHERE user_birthday!=999999 ORDER BY username" :"";
	if($result = $db->sql_query($sql)) 
	{ 
		if (!empty($result)) 
		{ 
			$time_now = time();
			$this_year = create_date('Y', $time_now, $board_config['board_timezone']);
			$date_today = create_date('Ymd', $time_now, $board_config['board_timezone']);
			$date_forward = create_date('Ymd', $time_now+($board_config['birthday_check_day']*86400), $board_config['board_timezone']);
		      while ($birthdayrow = $db->sql_fetchrow($result))
			{ 
			      $user_birthday2 = $this_year.($user_birthday = realdate("md",$birthdayrow['user_birthday'] )); 
	      		if ( $user_birthday2 < $date_today ) $user_birthday2 += 1000;
				if ( $user_birthday2 > $date_today  && $user_birthday2 <= $date_forward ) 
				{ 
					// user are having birthday within the next days
					$user_age = ( $this_year.$user_birthday < $date_today ) ? $this_year - realdate ('Y',$birthdayrow['user_birthday'])+1 : $this_year- realdate ('Y',$birthdayrow['user_birthday']); 
					switch ($birthdayrow['user_level'])
					{
						case ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
							break;
						case LESS_ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
							break;
						case MOD :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
							break;
						default: $style_color = '';
					}
					$birthday_week_list .= ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow['user_id']) . '"' . $style_color .' class="gensmall">' . $birthdayrow['username'] . ' <i>('.$user_age.')</i></a>,'; 
				} else if ( $user_birthday2 == $date_today ) 
	      		{ 
					//user have birthday today 
					$user_age = $this_year - realdate ( 'Y',$birthdayrow['user_birthday'] ); 
					switch ($birthdayrow['user_level'])
					{
						case ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
							break;
						case LESS_ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
							break;
						case MOD :
				      		$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
							break;
						default: $style_color = '';
					}
					$birthday_today_list .= ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow['user_id']) . '"' . $style_color .' class="gensmall">' . $birthdayrow['username'] . ' <i>('.$user_age.')</i></a>,'; 
			      }
				 
			}
			if ($birthday_today_list) $birthday_today_list[ strlen( $birthday_today_list)-1] = ' ';
			if ($birthday_week_list) $birthday_week_list[ strlen( $birthday_week_list)-1] = ' ';
		} 
		$db->sql_freeresult($result);
	}

		//
		// Referring Sites
		//
		$template->set_filenames(array( 
			'body' => 'referrers_body.tpl') 
		); 
		$links_array = array(); 
		$log = 'reflog.txt'; 
		$rfile = file($log); // read the log into an array 
		foreach ($rfile as $r) { // loop through the array 
		if (!(in_array($r, $links_array))) 
		{ 
			$links_array[] = $r; 
			$r = chop($r); 
			$split_http = array(); 
			$split_http = explode("//", $r); 
			$split_url = array(); 
			$split_url = explode("/", $split_http[1]); 
			$r = "http://".$split_url[0].""; // remove trailing whitespace 
			if ($r <> "Direct request") 
			{ 
				$template->assign_block_vars('linkrow', array( 
					'U_LINK_TEXT' => $r, 
					'LINK_TEXT' => $r) 
				); 
			} 
		} 
		} 


	$is_auth_ary = array(); 
	$is_auth_ary = auth(AUTH_ALL, AUTH_LIST_ALL, $userdata, $forum_data); 

	//
	// Links
	//
	$sql = "SELECT *
		FROM ". LINK_CONFIG_TABLE;
	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query Link config information", "", __LINE__, __FILE__, $sql);
	}
	
	while( $row = $db->sql_fetchrow($result) )
	{
		$link_config_name = $row['config_name'];
		$link_config_value = $row['config_value'];
		$link_config[$link_config_name] = $link_config_value;
		$link_self_img = $link_config['site_logo'];
		$site_logo_height = $link_config['height'];
		$site_logo_width = $link_config['width'];
	}

	//
	// Start output of page
	//
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
//	include($phpbb_root_path . 'lastxpostsindex.'.$phpEx);

	// Link to iframe page if external link
	$sql = "SELECT portal_id, portal_use_url, portal_use_iframe, portal_url 
		FROM " . PORTAL_TABLE . " 
		WHERE portal_id = $page_id";
	if (!$result = $db->sql_query($sql)) 
	{ 
		message_die(GENERAL_ERROR, 'Could not obtain portal external url & frame information', '', __LINE__, __FILE__, $sql); 
	} 
	$portalurlrow = $db->sql_fetchrow($result); 
	
	if ($portalurlrow['portal_use_url'] == '1' && $portalurlrow['portal_use_iframe'] == '0') 
	{ 
		$portal_body_fn = 'portal_site_body.tpl'; 
	} 
	else 
	{ 
		$portal_body_fn = 'portal_body.tpl'; 
	} 
	
	$template->set_filenames(array( 
		'body' => $portal_body_fn) 
	); 

	//
	// Show Avatar 
	//
	$avatar_img = ''; 
	if ( $userdata['user_avatar_type'] && $userdata['user_allowavatar'] ) 
	{ 
		switch( $userdata['user_avatar_type'] ) 
		{ 
		case USER_AVATAR_UPLOAD: 
			$avatar_img = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : ''; 
			break; 
		case USER_AVATAR_REMOTE: 
			$avatar_img = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $userdata['user_avatar'] . '" alt="" border="0" />' : ''; 
			break; 
		case USER_AVATAR_GALLERY: 
			$avatar_img = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : ''; 
			break; 
		} 
	} 
	if ($avatar_img == '')
	{
		$avatar_img = '<img src="'. $images['default_avatar'] .'" />'; 
	}	
	// Check For Anonymous User 
	if ($userdata['user_id'] != '-1') 
	{ 
		$name_link = '<a href="' . append_sid("profile.$phpEx?mode=editprofile&amp;" . $userdata['user_id']) . '">' . $userdata['username'] . '</a>'; 
	} 
	else 
	{ 
		$name_link = '<a href="profile.php?mode=register">' . $lang['Guest'] . '</a>'; 
	} 

	$total_posts_format = sprintf($l_total_post_s, $total_posts); 
	$total_posts_format = str_replace($total_posts, number_format($total_posts), $total_posts_format); 

	$start_date = create_date($board_config['default_dateformat'], $board_config['board_startdate'], $board_config['board_timezone']);

	srand ((double) microtime() * 1000000); 
	$zitate = file("quotes.txt"); 
	$i = count($zitate)-1; 

   $template->assign_vars(array( 
	'START_DATE' => $start_date,
      'QUOTE' => $zitate[rand(0,$i)], 
      'TOTAL_POSTS' => $total_posts_format, 
	'TOTAL_USERS' => sprintf($l_total_user_s, $total_users),
	'TOTAL_TOPICS' => sprintf($lang['Posted_topics_total'], $total_topics),
	'NEWEST_USER' => sprintf($lang['Newest_user'], '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$newest_uid") . '">', $newest_user, '</a>'), 
	
	'FORUM_IMG' => $images['forum'],
	'FORUM_NEW_IMG' => $images['forum_new'],
	'FORUM_LOCKED_IMG' => $images['forum_locked'],
  	'AVATAR_IMG' => $avatar_img,
	'USERS_TODAY_LIST' => $users_today_list,
	'L_ONLINE_EXPLAIN' => $lang['Online_explain'], 
	'L_ONLINETODAY' => $lang['Onlinetoday'], 
	'L_USERS_LASTHOUR' => ($users_lasthour)?sprintf($lang['Users_lasthour_explain'],$users_lasthour):$lang['Users_lasthour_none_explain'],
	'L_USERS_TODAY' => $l_today_users,
	'L_WHOSBIRTHDAY_WEEK' => sprintf((($birthday_week_list)? $lang ['Birthday_week'].$birthday_week_list:$lang ['Nobirthday_week']),$board_config['birthday_check_day']), 
	'L_WHOSBIRTHDAY_TODAY' => ($birthday_today_list&&$board_config['birthday_check_day'])? $lang ['Birthday_today'].$birthday_today_list:$lang ['Nobirthday_today'], 

 	'LANGUAGE_SELECT' => language_select($board_config['default_lang'], 'language'), 
	'TEMPLATE_SELECT' => style_select($board_config['default_style'], 'template'),
	'FPAGE_STYLE' => style_select($fpage_style, 'fpage_theme'), 

	'PIC_IMAGE' => append_sid('album_thumbnail.'. $phpEx . '?pic_id=' . $picrow['pic_id']),
	'PIC_TITLE' => $picrow['pic_title'],
	'PIC_POSTER' => $pic_poster,
	'PIC_TIME' => create_date($board_config['default_dateformat'], $picrow['pic_time'], $board_config['board_timezone']),
	'PIC_DESCR' => $picrow['pic_desc'],
	'U_PIC_LINK' => append_sid('album_pic.' . $phpEx . '?pic_id=' . $picrow['pic_id']),
	'U_PIC_COMMENT' => append_sid('album_comment.' . $phpEx . '?pic_id=' . $picrow['pic_id']),

	'L_MOST' => $lang['Most'],
	'L_POINTS_NAME' => $board_config['points_name'],

	'MY_NEWS_CODE' => $newsfeedtext,

	'L_LINK_TO_US' => $lang['Link_us'],
	'L_LINK_TO_US_EXPLAIN' => sprintf($lang['Link_us_explain'], $board_config['sitename']),
	'PORTAL_OURLINK' => str_replace(" ", "&nbsp;", sprintf(htmlentities($lang['Link_us_syntax'], ENT_QUOTES), $link_config['site_url'], $link_config['site_logo'], $link_config['width'], $link_config['height'], $board_config['sitename'])),
	'U_SITE_LOGO' => $link_self_img,

	'L_RANDOM_LINKS' => $lang['Random_links'],
	'U_LINKS_JS' => "portal_links.$phpEx", 

	'RANDOM_NAME' => $random_name, 
	'RANDOM_AVATAR' => $random_avatar, 
	'RANDOM_POSTS' => $random_posts, 
	'RANDOM_LAST_VISIT' => ($profiledata['user_level'] == ADMIN || (!$board_config['hidde_last_logon'] && $profiledata['user_allow_viewonline'])) ? (($profiledata['user_lastlogon'])? create_date($board_config['default_dateformat'], $profiledata['user_lastlogon'], $board_config['board_timezone']):$lang['Never_last_logon']):$lang['Hidde_last_logon'], 
	'RANDOM_VISITS' => $random_visits, 
	'RANDOM_JOINED' => create_date($lang['DATE_FORMAT'], $profiledata['user_regdate'], $board_config['board_timezone']),
	'RANDOM_LOCATION' => $random_location, 
	'L_RANDOM_USER' => $lang['Random_user'], 
	'L_RANDOM_USER_EXPLAIN' => $lang['Random_user_explain'], 
	'L_LOCATION' => $lang['Location'], 
	'L_LAST_VISIT' => $lang['Last_logon'], 
	'L_VISITS' => $lang['Number_of_visit'], 
	'L_JOINED' => $lang['Joined'], 

	'L_SELECT_LANG' => $lang['Board_lang'], 
	'L_CHANGE_NOW' => $lang['Go'], 

	'L_DAILY_GAME' => $lang['Daily_game'], 
	'L_SEARCH_GAMES' => $lang['Search_games'], 

	'L_RECENT_REFERRALS' => $lang['Recent_referrals'], 

	'L_FORUM' => $lang['Forum'],
	'L_TOPICS' => $lang['Topics'],
	'L_REPLIES' => $lang['Replies'],
	'L_VIEWS' => $lang['Views'],
	'L_POSTS' => $lang['Posts'],
	'L_LASTPOST' => $lang['Last_Post'], 
	'L_LAST_POST_BY' => $lang['Last_Post_By'], 
	'L_INFORMATION' => $lang['Information'],
	'L_NO_NEW_POSTS' => $lang['No_new_posts'],
	'L_NEW_POSTS' => $lang['New_posts'],
	'L_NO_NEW_POSTS_LOCKED' => $lang['No_new_posts_locked'], 
	'L_NEW_POSTS_LOCKED' => $lang['New_posts_locked'], 
	'NEW_POST_IMG' => '<img src="'. $images['post_new'] . '" border="0" alt="' . $lang['Post_new_topic'] . '">',
	'L_INVITE_FRIEND' => $lang['Invite_Friend'],
	'INVITE_FRIEND_IMG' => $images['invite_friend'],

	'L_LATEST_POSTS' => $lang['Latest_Posts'], 
	'L_POLL' => $lang['Poll'], 
	'L_NAVIGATE' => $lang['Navigate'], 
	'L_COMMENT' => $lang['Comment'], 
	'L_READ_MORE' => $lang['Read_more'], 
	'L_VIEWS' => $lang['Views'], 
	'L_REPLIES' => $lang['Replies'], 
	'L_MODERATOR' => $lang['Moderators'], 
	'L_FORUM_LOCKED' => $lang['Forum_is_locked'],
      'L_NAME_WELCOME' => $lang['Welcome'],
	'L_SELECT_STYLE' => $lang['Board_style'],  
	'L_ARCHIVE' => $lang['Archive'],
	'L_SEARCH_ENGINE' => $lang['Search_engine'],
	'L_SITE_SEARCH' => $lang['Site_search'],
	'L_CURRENT_NEWS' => $lang['Current_news'],
	'L_POSTED' => $lang['Posted'],
	'L_QUOTE' => $lang['Quote'],
	'L_WORLD_NEWS' => $lang['World_news'],
	'L_LINKS' => $lang['Links'],
	'L_POSTED_BY' => $lang['Posted_By'],
	'L_ON' => $lang['On'],
	'L_TOP_POSTERS' => $lang['Top_posters'],
	'L_NEWEST_MEMBERS' => $lang['Newest_members'],
	'L_TOP_DOWNLOADS' => $lang['Top_downloads'],

	'U_INVITE_FRIEND' => append_sid("invite.$phpEx"),
	'U_NAME_LINK' => $name_link)
);

// Not sure why this is necessary, but it caused a problem for anonymous users on some boards
if ( $userdata['user_style'] == '' )
{
	$userdata['user_style'] = $board_config['default_style'] ;
}

$sql = "SELECT *
	FROM " . THEMES_TABLE . "
	WHERE themes_id = " . $userdata['user_style'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(CRITICAL_ERROR, 'Could not query database for theme info');
}

if ( !($row = $db->sql_fetchrow($result)) )
{
	message_die(CRITICAL_ERROR, "Could not get theme data for themes_id [$style]");
}

$template_path = 'templates/' ;
$template_name = $row['template_name'] ;

//
// Display the nav bar and the page description
//

$sql = "SELECT n.* 
	FROM " . PORTAL_TABLE . " n
	ORDER BY n.portal_order ASC " ;

if( !$result = $db->sql_query($sql) )
{
   message_die(GENERAL_ERROR, "Could not obtain portal navigation information", "", __LINE__, __FILE__, $sql);
}

$total_nav = 0;
while( $row = $db->sql_fetchrow($result) )
{
	$portal_rowset[] = $row;
	$total_nav++;
}

$db->sql_freeresult($result);


//
// Okay, lets dump out the page ...
//
if( $total_nav )
{
	$display_navbar = 0 ;
	$display_moreover = 0 ;
	$display_calendar = 0 ;
	$display_login = 0 ;
	$display_online = 0 ;
	$display_onlinetoday = 0 ;
	$display_latest = 0 ;
	$display_latestx = 0 ;
	$display_poll = 0 ;
	$display_shoutbox = 0 ;
	$display_photo = 0 ;
	$display_language = 0 ;
	$display_theme = 0 ;
	$display_search = 0 ;
	$display_quote = 0 ;
	$display_links = 0 ;
	$display_ourlink = 0 ;
	$display_downloads = 0 ;
	$display_randomuser = 0 ;
	$display_mostpoints = 0 ;
	$display_topposters = 0 ;
	$display_newusers = 0 ;
	$display_games = 0 ;
	$display_newsfader = 0 ;

	$no_date = 0 ;
	$sort_asc = 0 ;
	$list_limit = 0 ;


	// Get the nav bar info
	for($i = 0	; $i < $total_nav; $i++)
	{
		$portal_id = $portal_rowset[$i]['portal_id'] ;
		$portal_url = append_sid("portal.$phpEx?page=$portal_id");
		if ($portal_rowset[$i]['portal_use_url'] && $portal_rowset[$i]['portal_use_iframe'])
		{
			$portal_url = $portal_rowset[$i]['portal_url'] ;
		}
		$portal_navbar_name = $portal_rowset[$i]['portal_navbar_name'] ;
		if ( $portal_rowset[$i]['portal_id'] != $page_id)
		{
		}
		else
		{
			// Get the page desc info and other config info
			$page_forum = $portal_rowset[$i]['portal_forum'] ;
			$display_navbar = $portal_rowset[$i]['portal_navbar'] ;
			$display_moreover = $portal_rowset[$i]['portal_moreover'] ;
			$display_calendar = $portal_rowset[$i]['portal_calendar'] ;
			$display_login = $portal_rowset[$i]['portal_login'] ;
			$display_online = $portal_rowset[$i]['portal_online'] ;
			$display_onlinetoday = $portal_rowset[$i]['portal_onlinetoday'] ;
			$display_latest = $portal_rowset[$i]['portal_latest'] ;
			$display_latestx = $portal_rowset[$i]['portal_latestx'] ;
			$display_poll = $portal_rowset[$i]['portal_poll'] ;
			$display_polls = $portal_rowset[$i]['portal_polls'] ; 
			$display_shoutbox = $portal_rowset[$i]['portal_shoutbox'] ;
			$display_photo = $portal_rowset[$i]['portal_photo'] ;
			$display_search = $portal_rowset[$i]['portal_search'] ;
			$display_quote = $portal_rowset[$i]['portal_quote'] ;
			$display_links = $portal_rowset[$i]['portal_links'] ;
			$display_ourlink = $portal_rowset[$i]['portal_ourlink'] ;
			$display_downloads = $portal_rowset[$i]['portal_downloads'] ;
			$display_randomuser = $portal_rowset[$i]['portal_randomuser'] ;
			$display_mostpoints = $portal_rowset[$i]['portal_mostpoints'] ;
			$display_topposters = $portal_rowset[$i]['portal_topposters'] ;
			$display_newusers = $portal_rowset[$i]['portal_newusers'] ;
			$display_games = $portal_rowset[$i]['portal_games'] ;
			$display_newsfader = $portal_rowset[$i]['portal_newsfader'] ;
			$no_date = $portal_rowset[$i]['portal_nodate'] ;
			$sort_asc = $portal_rowset[$i]['portal_ascending'] ;
			$list_limit = $portal_rowset[$i]['portal_list_limit'] ;
			$portal_column_width = $portal_rowset[$i]['portal_column_width'] ;
			$portal_links_height = $portal_rowset[$i]['portal_links_height'] ;

			$bbcode_uid = $portal_rowset[$i]['portal_bbcode_id'] ;
			$message = preg_replace("#(<)([\/]?.*?)(>)#is", "&lt;\\2&gt;", $message);
			$message = bbencode_second_pass($message, $bbcode_uid) ;
			$message = make_clickable($message);
			if( count($orig_word) )
			{
				$message = preg_replace($orig_word, $replacement_word, $message);
			}
			$message = smilies_pass($message);
			$message = str_replace("\n", "\n<br />\n", $message);

			$template->assign_block_vars("pagedesc", array(
				"U_PORTAL_SITE_NAME" => $portal_rowset[$i]['portal_navbar_name'],
				"U_PORTAL_SITE_URL" => $portal_rowset[$i]['portal_url'],
				"PAGE_TITLE" => $portal_rowset[$i]['portal_title'],
				"PAGE_HEADER" => $message)
			);
		}

		$template->assign_block_vars("navrow", array(
			"NAV_ALT" => $portal_navbar_name,

			"U_NAVIGATE" => $portal_url)
		);
	}
}
else
{
	//
	// No topics
	//
	$no_topics_msg = ($forum_row['forum_status'] == FORUM_LOCKED) ? $lang['Forum_locked'] : $lang['No_topics_post_one'];
	$template->assign_vars(array(
		"L_NO_TOPICS" => $no_topics_msg)
	);

	$template->assign_block_vars("nonavrow", array() );
}

//
// Archive forum
//
$template->assign_vars(array(
	'LINKS_HEIGHT' => $portal_links_height,
	'COLUMN_WIDTH' => $portal_column_width,

	'U_ARCHIVE' => append_sid("viewforum.$phpEx?f=$page_forum"))
);


//
// Display module blocks
//
if ($display_navbar)
{
	$template->set_filenames(array(
		"index_links" => "portal_navbar.tpl")
	);
	$template->assign_var_from_handle("INDEX_LINKS", "index_links");

	$template->assign_block_vars("displaynavbar", array() );
}

if ($display_moreover)
{
	$template->assign_block_vars("displaymoreover", array() );
}

if ($display_calendar)
{
	$template->assign_block_vars("displaycalendar", array() );
}

if ($display_login)
{
	$template->assign_block_vars("displaylogin", array() );
}

if ($display_shoutbox)
{
	$template->assign_block_vars("displayshoutbox", array() );
}

if ($display_photo)
{
	$template->assign_block_vars("displayphoto", array() );
}

if ($display_search)
{
	$template->assign_block_vars("displaysearch", array() );
}

if ($display_online)
{
	$template->assign_block_vars("displayonline", array() );
}

if ($display_onlinetoday)
{
	$template->assign_block_vars("displayonlinetoday", array() );
}

if ($display_quote)
{
	$template->assign_block_vars("displayquote", array() );
}

if ($display_links)
{
	$template->assign_block_vars("displaylinks", array() );
}

if ($display_ourlink)
{
	$template->assign_block_vars("displayourlink", array() );
}

if ($display_latestx)
{
	$template->assign_block_vars("displaylatestx", array() );
}

if ($display_randomuser)
{
	$template->assign_block_vars("displayrandomuser", array() );
}

if ($display_games)
{
	$template->assign_block_vars("displaygames", array() );
}

if ($display_newsfader)
{
	$template->assign_block_vars("displaynewsfader", array() );
}

if ($list_limit > 0)
{
	$template->assign_block_vars("displayarchive", array() );
}

$sql = "SELECT t.*, u.username, u.user_id, p.*, x.*
	FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . POSTS_TEXT_TABLE . " x 
	WHERE t.forum_id = $page_forum 
		AND t.topic_poster = u.user_id
		AND p.post_id = t.topic_first_post_id
		AND x.post_id = t.topic_first_post_id" ;

$sql = ($sort_asc) ? $sql . " ORDER BY t.topic_time ASC" : $sql . " ORDER BY t.topic_time DESC" ;
$sql = ($list_limit) ? $sql . " LIMIT 0, $list_limit" : $sql ;

if( !$result = $db->sql_query($sql) )
{
   message_die(GENERAL_ERROR, $lang['No_page_exists']);
}


$total_topics = 0;
while( $row = $db->sql_fetchrow($result) )
{
	$topic_rowset[] = $row;
	$total_topics++;
}
$db->sql_freeresult($result);


//
// Okay, lets dump out the page ...
//
if( $total_topics )
{
	for($i = 0	; $i < $total_topics; $i++)
	{
		$topic_id = $topic_rowset[$i]['topic_id'];

		$post_subject = ( count($orig_word) ) ? preg_replace($orig_word, $replacement_word, $topic_rowset[$i]['topic_title']) : $topic_rowset[$i]['topic_title'];

		$replies = $topic_rowset[$i]['topic_replies'];

		$topic_poster = ( $topic_rowset[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $topic_rowset[$i]['user_id']) . '">' : '';
		$topic_poster .= ( $topic_rowset[$i]['user_id'] != ANONYMOUS ) ? $topic_rowset[$i]['username'] : ( ( $topic_rowset[$i]['post_username'] != "" ) ? $topic_rowset[$i]['post_username'] : $lang['Guest'] );
		$topic_poster .= ( $topic_rowset[$i]['user_id'] != ANONYMOUS ) ? '</a>' : '';

		$topic_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['topic_time'], $board_config['board_timezone']);

		$views = $topic_rowset[$i]['topic_views'];
		$bbcode_uid = $topic_rowset[$i]['bbcode_uid'];

		//
		// format the message
		//
		$message = $topic_rowset[$i]['post_text'];

		$message= $message . "<br />&nbsp;<br />"; 

		if( ( !$board_config['allow_html'] ) && ( $topic_rowset[$i]['enable_html'] ))
		{
			$message = preg_replace("#(<)([\/]?.*?)(>)#is", "&lt;\\2&gt;", $message);
		}

		if( ( $board_config['allow_bbcode']) && ( $bbcode_uid != "" ))
		{
			$message = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($message, $bbcode_uid) : preg_replace("/\:[0-9a-z\:]+\]/si", "]", $message);
//			$message = ( $board_config['allow_bbcode'] ) ? bbencode_third_pass($message, $bbcode_uid, $valid) : preg_replace("/\:[0-9a-z\:]+\]/si", "]", $message);
		}

		$message = make_clickable($message);

		//
		// Replace naughty words
		//
		if( count($orig_word) )
		{
			$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);
			$message = preg_replace($orig_word, $replacement_word, $message);
		}

		//
		// Parse smilies
		//
		if( $board_config['allow_smilies'] )
		{
			if( $topic_rowset[$i]['enable_smilies'] )
			{
				$message = smilies_pass($message);
			}
		}

		//
		// Replace newlines
		//
		$message = str_replace("\n", "\n<br />\n", $message);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$view_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id");

		$template->assign_block_vars("topicrow", array(
			"FORUM_ID" => $forum_id,
			"TOPIC_ID" => $topic_id,
			"TOPIC_POSTER" => $topic_poster,
			"TOPIC_TIME" => ($no_date) ? '' : $topic_time . '&nbsp;&nbsp;&nbsp;&nbsp; ',
			"TOPIC_ALIGN" => ($no_date) ? 'center' : 'left',
			"REPLIES" => $replies,
			"TOPIC_TITLE" => $post_subject,
			"VIEWS" => $views,
			"POST_TEXT" => $message,
			"ROW_COLOR" => $row_color,
			"ROW_CLASS" => $row_class,

			"U_POST_COMMENT" => append_sid("posting.$phpEx?mode=reply&amp;t=$topic_id"),
			"U_VIEW_TOPIC" => $view_topic_url)
		);
	}
}
else
{
	//
	// No topics
	//
	$no_topics_msg = ($forum_row['forum_status'] == FORUM_LOCKED) ? $lang['Forum_locked'] : $lang['No_topics_post_one'];
	$template->assign_vars(array(
		'NEW_POST' => append_sid("posting.$phpEx?mode=newtopic&amp;f=$page_forum"),
		'L_NO_TOPICS' => $no_topics_msg)
	);

	$template->assign_block_vars("notopicsrow", array() );

}

//
// Display the latest posts
//
if ($display_latest)
{
	$template->assign_block_vars('displaylatest', array());

	$sql = "SELECT t.*, u.username, u.user_id, p.* 
		FROM (( " . TOPICS_TABLE . " t 
		LEFT JOIN " . POSTS_TABLE . " p ON t.topic_last_post_id = p.post_id ) 
		LEFT JOIN " . USERS_TABLE . " u ON p.poster_id = u.user_id ) 
		ORDER BY p.post_time DESC 
		LIMIT 0, 50" ;

	if( !$result = $db->sql_query($sql) )
	{
	   message_die(GENERAL_ERROR, "Couldn't obtain latest post information", "", __LINE__, __FILE__, $sql);
	}

	$total_topics = 0;
	while( $total_topics < 5 && $row = $db->sql_fetchrow($result) ) 
	{ 
	$is_auth = auth(AUTH_READ, $row['forum_id'], $userdata); 
	if ( $is_auth['auth_read'] ) { 
		$last_rowset[] = $row; 
		$total_topics++; 
		}
	}
	$db->sql_freeresult($result);


	//
	// Okay, lets dump out the page ...
	//
	if( $total_topics )
	{
		for($i = 0	; $i < $total_topics; $i++)
		{
			$topic_id = $last_rowset[$i]['topic_id'];
			$post_id = $last_rowset[$i]['post_id'];

			$post_subject = ( count($orig_word) ) ? preg_replace($orig_word, $replacement_word, $last_rowset[$i]['topic_title']) : $last_rowset[$i]['topic_title'];

			$last_post_time = create_date($board_config['default_dateformat'], $last_rowset[$i]['post_time'], $board_config['board_timezone']);

			$last_post = $last_post_time ;

			$poster_username = ( $last_rowset[$i]['user_id'] == ANONYMOUS ) ? ( ($last_rowset[$i]['username'] != "" ) ? $last_rowset[$i]['username'] . ' ' : $lang['Guest'] . ' ' ) : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "="  . $last_rowset[$i]['user_id']) . '">' . $last_rowset[$i]['username'] . '</a> ';

			$view_topic_url = append_sid("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id");

			$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
			$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

			$template->assign_block_vars("lasttopicrow", array(
				"FORUM_ID" => $forum_id,
				"TOPIC_ID" => $topic_id,
				"POST_USERNAME" => $poster_username,
				"POST_TIME" => $last_post_time,
				"TOPIC_TITLE" => $post_subject,

				"ROW_COLOR" => $row_color,
				"ROW_CLASS" => $row_class,

				"U_VIEW_TOPIC" => $view_topic_url)
			);
		}
	}
	else
	{
		//
		// No topics
		//
		$no_topics_msg = ($forum_row['forum_status'] == FORUM_LOCKED) ? $lang['Forum_locked'] : $lang['No_topics_post_one'];
		$template->assign_vars(array(
			"L_NO_TOPICS" => $no_topics_msg)
		);

		$template->assign_block_vars("lastnotopicsrow", array() );
	}
}

if ($display_poll)
{
	$template->assign_block_vars('displaypoll', array());

	$sql = "SELECT t.* 
		FROM " . TOPICS_TABLE . " t 
		WHERE t.forum_id = $display_polls
		ORDER BY t.topic_id DESC 
		LIMIT 1 " ;

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Couldn't obtain poll information.", "", __LINE__, __FILE__, $sql);
	}

	if(!$total_posts = $db->sql_numrows($result))
	{
		message_die(GENERAL_MESSAGE, $lang['No_polls_exist']);
	}
	$pollrow = $db->sql_fetchrowset($result);
	$db->sql_freeresult($result);

	$topic_id = $pollrow[0]['topic_id'] ;

	//
	// Does this topic contain a poll? 
	//
	//if( !empty($forum_row['topic_vote']) )
	//{
		$sql = "SELECT vd.vote_id, vd.vote_text, vd.vote_start, vd.vote_length, vd.vote_max, vd.vote_voted, vr.vote_option_id, vr.vote_option_text, vr.vote_result
			FROM " . VOTE_DESC_TABLE . " vd, " . VOTE_RESULTS_TABLE . " vr
			WHERE vd.topic_id = $topic_id
				AND vr.vote_id = vd.vote_id
			ORDER BY vr.vote_option_id ASC";
		if( !$result = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, "Couldn't obtain vote data for this topic", "", __LINE__, __FILE__, $sql);
		}


		if( $vote_options = $db->sql_numrows($result) )
		{
			$vote_info = $db->sql_fetchrowset($result);

			$vote_id = $vote_info[0]['vote_id'];
			$vote_title = $vote_info[0]['vote_text'];
			$max_vote = $vote_info[0]['vote_max'];
			$voted_vote = $vote_info[0]['vote_voted'];

			$sql = "SELECT vote_id
				FROM " . VOTE_USERS_TABLE . "
				WHERE vote_id = $vote_id
					AND vote_user_id = " . $userdata['user_id'];
			if( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Couldn't obtain user vote data for this topic", "", __LINE__, __FILE__, $sql);
			}

			$user_voted = ( $db->sql_numrows($result) ) ? TRUE : 0;

			if( isset($HTTP_GET_VARS['vote']) || isset($HTTP_POST_VARS['vote']) )
			{
				$view_result = ( ( ( isset($HTTP_GET_VARS['vote']) ) ? $HTTP_GET_VARS['vote'] : $HTTP_POST_VARS['vote'] ) == "viewresult" ) ? TRUE : 0;
			}
			else
			{
				$view_result = 0;
			}

			$poll_expired = ( $vote_info[0]['vote_length'] ) ? ( ( $vote_info[0]['vote_start'] + $vote_info[0]['vote_length'] < time() ) ? TRUE : 0 ) : 0;

			if( $user_voted || $view_result || $poll_expired || $forum_row['topic_status'] == TOPIC_LOCKED )
			{

				$template->set_filenames(array(
					"pollbox" => "viewtopic_poll_result.tpl")
				);

				$vote_results_sum = 0;

				for($i = 0; $i < $vote_options; $i++)
				{
					$vote_results_sum += $vote_info[$i]['vote_result'];
				}

				$vote_graphic = 0;
				$vote_graphic_max = count($images['voting_graphic']);

				for($i = 0; $i < $vote_options; $i++)
				{
					$vote_percent = ( $vote_results_sum > 0 ) ? $vote_info[$i]['vote_result'] / $vote_results_sum : 0;
					$vote_graphic_length = round($vote_percent * $board_config['vote_graphic_length']);

					$vote_graphic_img = $images['voting_graphic'][$vote_graphic];
					$vote_graphic = ($vote_graphic < $vote_graphic_max - 1) ? $vote_graphic + 1 : 0;

					if( count($orig_word) )
					{
						$vote_info[$i]['vote_option_text'] = preg_replace($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
					}

					$template->assign_block_vars("poll_option", array(
						"POLL_OPTION_CAPTION" => $vote_info[$i]['vote_option_text'],
						"POLL_OPTION_RESULT" => $vote_info[$i]['vote_result'],
						"POLL_OPTION_PERCENT" => sprintf("%.1d%%", ($vote_percent * 100)),

						"POLL_OPTION_IMG" => $vote_graphic_img,
						"POLL_OPTION_IMG_WIDTH" => $vote_graphic_length/10)
					);
				}

				if ( $max_vote > 1 )
					$voted_vote_nb = $voted_vote;
				else
				{
					$lang['Voted_show'] = '';
					$voted_vote_nb = '';
				}

				$template->assign_vars(array(
					"L_TOTAL_VOTES" => $lang['Total_votes'],
					"VOTED_SHOW" => $lang['Voted_show'],
					"TOTAL_VOTES" => $vote_results_sum)
				);

			}
			else
			{
				$template->set_filenames(array(
					"pollbox" => "viewtopic_poll_ballot.tpl")
				);

				if ( $max_vote > 1 )
				$vote_box = 'checkbox';
				else 	$vote_box = 'radio';

				for($i = 0; $i < $vote_options; $i++)
				{
					if( count($orig_word) )
					{
						$vote_info[$i]['vote_option_text'] = preg_replace($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
					}

					$template->assign_block_vars("poll_option", array(
						"POLL_OPTION_ID" => $vote_info[$i]['vote_option_id'],
						"POLL_VOTE_BOX" => $vote_box,
						"POLL_OPTION_CAPTION" => $vote_info[$i]['vote_option_text'])
					);
				}

				$template->assign_vars(array(
					"L_SUBMIT_VOTE" => $lang['Submit_vote'],
					"L_VIEW_RESULTS" => $lang['View_results'],

					"U_VIEW_RESULTS" => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order&amp;vote=viewresult"))
				);

				$s_hidden_fields = '<input type="hidden" name="topic_id" value="' . $topic_id . '"><input type="hidden" name="mode" value="vote">';
			}

			if ( $max_vote > 1 )
			{
				$vote_br = '<br />';
				$max_vote_nb = $max_vote;
			}
			else
			{
				$vote_br = '';
				$lang['Max_voting_1_explain'] = '';
				$lang['Max_voting_2_explain'] = '';
				$lang['Max_voting_3_explain'] = '';
				$max_vote_nb = '';
			}

			if( count($orig_word) )
			{
				$vote_title = preg_replace($orig_word, $replacement_word, $vote_title);
			}

		      $sql_votes = mysql_query("SELECT * FROM ".VOTE_DESC_TABLE." ORDER BY vote_id"); 
		      for ($v = 0; $v < mysql_num_rows($sql_votes); $v++) 
		      if (mysql_result($sql_votes, $v, "vote_id") == $vote_id) $vote_nr = $v; 
		      $vote_end = mysql_result($sql_votes, $vote_nr, "vote_start") + mysql_result($sql_votes, $vote_nr, "vote_length"); 
		      if (time() < $vote_end) { $vote_end = sprintf($lang['Vote_until']) . ": " . date ("m.d.Y H:i:s",$vote_end); } 
		      else if (mysql_result($sql_votes, $vote_nr, "vote_length") == 0) { $vote_end = sprintf($lang['Vote_endless']) ; } 
		      else { $vote_end = sprintf($lang['Vote_closed']) ; } 

			$template->assign_vars(array(
				"POLL_QUESTION" => $vote_title,
				"POLL_VOTE_BR" => $vote_br,
				"MAX_VOTING_1_EXPLAIN" => $lang['Max_voting_1_explain'],
				"MAX_VOTING_2_EXPLAIN" => $lang['Max_voting_2_explain'],
				"MAX_VOTING_3_EXPLAIN" => $lang['Max_voting_3_explain'],
				"max_vote" => $max_vote_nb,
				"voted_vote" => $voted_vote_nb,

				"S_HIDDEN_FIELDS" => ( !empty($s_hidden_fields) ) ? $s_hidden_fields : "",
				"S_POLL_ACTION" => append_sid("posting.$phpEx?" . POST_TOPIC_URL . "=$topic_id"),
				"VOTE_END" => $vote_end) 
			);

			$template->assign_var_from_handle("POLL_DISPLAY", "pollbox");
		}
}

//
// Display the top downloads
//
if ($display_downloads)
{
	$template->assign_block_vars('displaydownloads', array());

	$sql = "SELECT * 
		FROM " . PA_FILES_TABLE . "
		ORDER BY file_dls DESC LIMIT 5";
		if ( !($result = $db->sql_query($sql)) )
	         {
	         	message_die(GENERAL_ERROR, 'Could not query database for most downloads');
	         } 
	while ($dlrow = $db->sql_fetchrow($result))
	{
		$template->assign_block_vars('dlrow', array(
			'FILELINK' => 'dload.php?action=download&file_id=' . $dlrow[file_id],
			'FILENAME' => $dlrow[file_name],			
			'INFO' => $dlrow[file_dls])
		);
	}
}

//
// Display most points
//
if ($display_mostpoints)
{
	$template->assign_block_vars('displaymostpoints', array());

	$sql = "SELECT user_id, username, user_points 
		FROM " . USERS_TABLE . "
		ORDER BY user_points DESC LIMIT 5";
		if ( !($result = $db->sql_query($sql)) )
	         {
	         	message_die(GENERAL_ERROR, 'Could not query database for most points');
	         } 
	while ($pointsrow = $db->sql_fetchrow($result))
	{
		$template->assign_block_vars('pointsrow', array(
			'NAME' => $pointsrow['username'],
			'NAME_LINK' => 'profile.php?mode=viewprofile&u=' . $pointsrow[user_id],
			'POINTS' => $pointsrow['user_points'])
		);
	}
}

//
// Display top posters
//
if ($display_topposters)
{
	$template->assign_block_vars('displaytopposters', array());

	$sql = "SELECT user_id, username, user_posts
		FROM " . USERS_TABLE . "
		ORDER BY user_posts DESC LIMIT 5";
		if ( !($result = $db->sql_query($sql)) )
	         {
	         	message_die(GENERAL_ERROR, 'Could not query database for top posters');
	         } 
	while ($toppostersrow = $db->sql_fetchrow($result))
	{
		$template->assign_block_vars('toppostersrow', array(
			'POSTNAME' => $toppostersrow['username'],
			'POSTNAME_LINK' => 'profile.php?mode=viewprofile&u=' . $toppostersrow[user_id],
			'POSTS' => $toppostersrow['user_posts'])
		);
	}
}

//
// Display newest members
//
if ($display_newusers)
{
	$template->assign_block_vars('displaynewusers', array());

	$sql = "SELECT user_id, username, user_regdate
		FROM " . USERS_TABLE . "
		ORDER BY user_id DESC LIMIT 5";
		if ( !($result = $db->sql_query($sql)) )
	         {
	         	message_die(GENERAL_ERROR, 'Could not query database for newest members');
	         } 
	while ($newusersrow = $db->sql_fetchrow($result))
	{
		$template->assign_block_vars('newusersrow', array(
			'NEWNAME' => $newusersrow['username'],
			'NEWNAME_JOINED' => create_date($lang['DATE_FORMAT'], $newusersrow['user_regdate'], $board_config['board_timezone']),
			'NEWNAME_LINK' => 'profile.php?mode=viewprofile&u=' . $newusersrow[user_id])
		);
	}
}


//
// Generate the page
//
include($phpbb_root_path . 'calendar/mini_cal/mini_cal.'.$phpEx); 

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>