<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// remote_getid3.php      -  part of foing                     //
//                                                             //
/////////////////////////////////////////////////////////////////



$re_path = '';


// do not modify anything below this point.

header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");    // Date in the past
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); // always modified
header("Cache-Control: no-store, no-cache, must-revalidate");  // HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");                          // HTTP/1.0

$re_url		= $re_path . 'song.php?foing_mode=remote';
$die_url	= $re_path . 'song.php?foing_mode=die';

include('getid3/getid3.php');
$song_url = stripslashes($song_url);
$mp3info = @GetAllMP3info($song_url);
if (!$mp3info['exist']) // first check if we have an existing file
{
	echo 'window.location="'.$die_url . '";';
	exit();
}

$song_data = Array (
				'url'		=> $song_url,
				'title'		=> $mp3info['title'],
				'artist'	=> $mp3info['artist'], // third parameter for matching
				'length'	=> round($mp3info['playtime_seconds']),
				'quality'	=> round($mp3info['bitrate'] / 1000), // in kbps
				'album'		=> $mp3info['album'], // third parameter for matching
				'year'		=> $mp3info['year'],
				'genre'		=> $mp3info['genre'],
				'website'	=> $mp3info['id3']['id3v2']['WXXX']['0']['url'],
				'size'		=> round(($mp3info['filesize'] / 1048576), 1) // in 1-decimal rounded mb
				); 

if (isset($mp3info['id3']['id3v2']['genreid']))
{
	$song_data['genre_id'] = $mp3info['id3']['id3v2']['genreid'];
}
if (isset($mp3info['id3']['id3v1']['genreid']))
{
	$song_data['genre_id'] = $mp3info['id3']['id3v1']['genreid'];
}
if (!isset($song_data['genre_id']))
{
	$song_data['genre_id'] = 255;
}

reset ($song_data);
while (list ($key, $value) = each ($song_data)) 
{
	if ($value != '')
	{
		$re_url .= '&song_'.$key.'='.rawurlencode($value);
	}
}
if (isset($sid))
{
	$re_url .= '&sid='.$sid;
}

echo 'window.location="'.$re_url . '";';

?>
