<?php
/////////////////////////////////////////////////////////////////
/// getID3() by James Heinrich <getid3@users.sourceforge.net>  //
//        available at http://getid3.sourceforge.net          ///
/////////////////////////////////////////////////////////////////
//                                                             //
// getid3.la.php - part of getID3()                            //
// See getid3.readme.txt for more details                      //
//                                                             //
/////////////////////////////////////////////////////////////////

function getLAHeaderFilepointer(&$fd, &$MP3fileInfo) {
	$offset = 0;
	rewind($fd);
	$rawdata = fread($fd, FREAD_BUFFER_SIZE);

	switch (substr($rawdata, $offset, 4)) {
		case 'LA02':
		case 'LA03':
			$MP3fileInfo['fileformat']              = 'la';
			$MP3fileInfo['la']['version_major']     = (int) substr($rawdata, $offset + 2, 1);
			$MP3fileInfo['la']['version_minor']     = (int) substr($rawdata, $offset + 3, 1);
			$MP3fileInfo['la']['version']           = (float) $MP3fileInfo['la']['version_major'] + ($MP3fileInfo['la']['version_minor'] / 10);
			$offset += 4;
			
			$MP3fileInfo['la']['uncompressed_size'] = LittleEndian2Int(substr($rawdata, $offset, 4));
			$offset += 4;

			$WAVEchunk = substr($rawdata, $offset, 4);
			if ($WAVEchunk !== 'WAVE') {
				$MP3fileInfo['error'] .= "\n".'Expected "WAVE" ('.PrintHexBytes('WAVE').') at offset '.$offset.', found "'.$WAVEchunk.'" ('.PrintHexBytes($WAVEchunk).') instead.';
				return FALSE;
			}
			$offset += 4;

			$MP3fileInfo['la']['format_size']       = 24;
			if ($MP3fileInfo['la']['version'] > 0.2) {

				$MP3fileInfo['la']['format_size']   = LittleEndian2Int(substr($rawdata, $offset, 4));
				$MP3fileInfo['la']['header_size']   = 49 + $MP3fileInfo['la']['format_size'] - 24;
				$offset += 4;

			} else {

				// version two didn't support additional data blocks
				$MP3fileInfo['la']['header_size']   = 41;

			}

			$fmt_chunk = substr($rawdata, $offset, 4);
			if ($fmt_chunk !== 'fmt ') {
				$MP3fileInfo['error'] .= "\n".'Expected "fmt " ('.PrintHexBytes('fmt ').') at offset '.$offset.', found "'.$fmt_chunk.'" ('.PrintHexBytes($fmt_chunk).') instead.';
				return FALSE;
			}
			$offset += 4;
			$fmt_size = LittleEndian2Int(substr($rawdata, $offset, 4));
			$offset += 4;
			
			$MP3fileInfo['la']['format_raw']        = LittleEndian2Int(substr($rawdata, $offset, 2));
			$offset += 2;

			$MP3fileInfo['la']['channels']          = LittleEndian2Int(substr($rawdata, $offset, 2));
			$offset += 2;
			$MP3fileInfo['la']['sample_rate']       = LittleEndian2Int(substr($rawdata, $offset, 4));
			$offset += 4;
			$MP3fileInfo['la']['bytes_per_second']  = LittleEndian2Int(substr($rawdata, $offset, 4));
			$offset += 4;
			$MP3fileInfo['la']['bytes_per_sample']  = LittleEndian2Int(substr($rawdata, $offset, 2));
			$offset += 2;
			$MP3fileInfo['la']['bits_per_sample']   = LittleEndian2Int(substr($rawdata, $offset, 2));
			$offset += 2;

			$MP3fileInfo['la']['samples']           = LittleEndian2Int(substr($rawdata, $offset, 4));
			$offset += 4;

			$MP3fileInfo['la']['seekable']          = (bool) LittleEndian2Int(substr($rawdata, $offset, 1));
			$offset += 1;

			$MP3fileInfo['la']['original_crc']      = LittleEndian2Int(substr($rawdata, $offset, 4));
			$offset += 4;

			include_once(GETID3_INCLUDEPATH.'getid3.riff.php');
			$MP3fileInfo['la']['format']            = RIFFwFormatTagLookup($MP3fileInfo['la']['format_raw']);
			$MP3fileInfo['la']['compression_ratio'] = (float) ($MP3fileInfo['filesize'] / $MP3fileInfo['la']['uncompressed_size']);
			$MP3fileInfo['playtime_seconds']        = (float) ($MP3fileInfo['la']['samples'] / $MP3fileInfo['la']['sample_rate']) / $MP3fileInfo['la']['channels'];
			$MP3fileInfo['bitrate_audio']           = ($MP3fileInfo['filesize'] * 8) / $MP3fileInfo['playtime_seconds'];
			break;

		default:
			if (substr($rawdata, $offset, 2) == 'LA') {
				$MP3fileInfo['error'] .= "\n".'This version of getID3() (v'.GETID3VERSION.') doesn\'t support LA version '.substr($rawdata, $offset + 2, 1).'.'.substr($rawdata, $offset + 3, 1).' which this appears to be - check http://getid3.sourceforge.net for updates.';
			} else {
				$MP3fileInfo['error'] .= "\n".'Not a LA (Lossless-Audio) file';
			}
			return FALSE;
			break;
	}

	return TRUE;
}

?>