<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// common.php     - part of foing                              //
//                                                             //
/////////////////////////////////////////////////////////////////


// Work around for "current" Apache 2 + PHP module which seems to not
// cope with private cache control setting
if (!empty($HTTP_SERVER_VARS['SERVER_SOFTWARE']) && strstr($HTTP_SERVER_VARS['SERVER_SOFTWARE'], 'Apache/2'))
{
	header ('Cache-Control: no-cache, pre-check=0, post-check=0, max-age=0');
}
else
{
	header ('Cache-Control: private, pre-check=0, post-check=0, max-age=0');
}
header ('Expires: ' . gmdate('D, d M Y H:i:s', time()) . ' GMT');
header ('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');


//
// foing installed ?
//
@include($foing_root_path . 'config.php'); 
if( !defined("FOING_INSTALLED") )
{
	header("Location: install/");
	exit;
}

//
// handle generic get & post values, any html chars get converted
// (i am a lazy bum, i know)
//

if (!empty($HTTP_GET_VARS))
{
	reset($HTTP_GET_VARS);
	while( list($key, $val) = @each($HTTP_GET_VARS) )
	{
		if (is_string($HTTP_GET_VARS[$key]))
		{
			$HTTP_GET_VARS[$key] = trim(htmlspecialchars($HTTP_GET_VARS[$key]));
			@eval("\$" . $key . " = trim(htmlspecialchars('" . $val . "'));");
		}
	}
}
if (!empty($HTTP_POST_VARS))
{
	reset($HTTP_POST_VARS);
	while( list($key, $val) = @each($HTTP_POST_VARS) )
	{
		if (is_string($HTTP_POST_VARS[$key]))
		{
			$HTTP_POST_VARS[$key] = trim(htmlspecialchars($HTTP_POST_VARS[$key]));
			@eval("\$" . $key . " = trim(htmlspecialchars('" . $val . "'));");
		}
	}
}

//
// include some phpbb files for user management, template system and sql abstraction layer
//

define('IN_PHPBB', true);
$phpbb_root_path = $foing_root_path . $phpbb_root_path;
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'player/config.'.$phpEx);

$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
session_start();

$old_template_dir = $template->root;
$template->set_rootdir($old_template_dir . '/foing');
$image_dir = $template->root . '/images/';

//
// include foing php files
//

include($foing_root_path . 'includes/constants.php');
include($foing_root_path . 'includes/functions.php');

//
// get foing configuration
//

$sql = "SELECT *
	FROM " . FOING_CONFIG_TABLE;
$result = $db->sql_query($sql);
while ( $row = $db->sql_fetchrow($result) )
{
	$foing_config[$row['config_name']] = $row['config_value'];
}
$userdata['foing_mod'] = check_perm_dd('mod'); // do we have a Foing moderator?

$sql = "SELECT *
	FROM " . STATUS_TABLE;
$result = $db->sql_query($sql);
while ( $row = $db->sql_fetchrow($result) )
{
	$foing_status_pub[$row['status_id']] = (bool) $row['status_pub'];
	if ($row['status_pub'] == 1 || $userdata['foing_mod'])
	{
		$foing_status[$row['status_id']] = $row['status_name'];
	}
}


//
// prepare the Foing Filters (ff)
//

if (!session_is_registered('ff'))
{
	session_register('ff');
	$ff['artist'] = -1;
	$ff['genre'] = -1;
	$ff['status'] = 0;
	$ff['flip_order'] = 1; // 1: ASC, -1: DESC
	$ff['order'] =  Array (
					'0' => 'artist_name',
					'1' => 'album_title',
					'2' => 'song_title',
					'3' => 'genre_name',
					'4' => 'status_id',
					'5' => 'song_quality',
					'6' => 'song_length',
					'7' => 'song_size',
					'8' => 'user_id');

}
if (!session_is_registered('fpl'))
{
  session_register('fpl');
  $fpl['id'] = 0;
  $fpl['owner'] = FALSE;
}


//
// handle the get variables for the foing-filters
//

if (is_numeric($ffartist))
{
	$ff['artist'] = ceil($ffartist);
}
if (is_numeric($ffgenre))
{
	$ff['genre'] = ceil($ffgenre);
}
if (isset($fforder))
{
	if ($fforder == $ff['order']['0'])
	{
		$ff['flip_order'] = $ff['flip_order']*-1;
	}
	else
	{
		if ($key = array_search($fforder, $ff['order']))
		{
			array_splice($ff['order'], $key, 1);
			$ff['order'] = array_reverse($ff['order']);
			$ff['order'][] = $fforder;
			$ff['order'] = array_reverse($ff['order']);
		}	
	}
}
if (isset($ffstatus))
{
	if (in_array($ffstatus, array_flip($foing_status)) || $ffstatus == '0')
	{
		$ff['status'] = $ffstatus;
	}
}

if (is_numeric($plactive))
{
	$fpl['id'] = $plactive;
	if ($fpl['id'] != 0)
	{
		// check if the user is owner
		$sql = 'SELECT user_id FROM ' . PLAYLIST_TABLE . ' WHERE ( list_id = "' . $fpl['id'] .'") LIMIT 1';
		$result = $db->sql_query($sql);
		if ($db->sql_fetchfield('user_id','0',$result) == $userdata['user_id'])
		{
			$fpl['owner'] = TRUE;
		} 
		else 
		{
			$fpl['owner'] = FALSE;
		}
	}
	else
	{
		$fpl['owner'] = FALSE;
	}
}

?>