<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// index_stats.php  -  part of foing                           //
//                                                             //
/////////////////////////////////////////////////////////////////

$template->set_filenames(array(
	'foing_stats' => 'foing_stats.tpl')
);

//
// get the foing stats
//

$sql = 'SELECT COUNT(DISTINCT song_id),  SUM(song_size), AVG(song_size), STD(song_size), MIN(song_size), MAX(song_size), 
						 				 SUM(song_length), AVG(song_length), STD(song_length), MIN(song_length), MAX(song_length),
						 				 AVG(song_quality), STD(song_quality), MIN(song_quality), MAX(song_quality)
		FROM ' . SONGS_TABLE;
$sql = append_status_sql($sql);
$result = $db->sql_query($sql);
$stats_data = $db->sql_fetchrow($result);

//
// get the most played songs
//

$sql = 'SELECT song_id, song_title, song_played, ' . ARTISTS_TABLE . '.artist_id, artist_name, artist_prefix ' .
		' FROM ' . SONGS_TABLE . ', ' . ARTISTS_TABLE .
		' WHERE ( ' .SONGS_TABLE . '.artist_id = ' . ARTISTS_TABLE . '.artist_id ) ';
$sql = append_status_sql($sql);
$sql .= ' ORDER BY song_played DESC LIMIT 10';
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	$template->assign_block_vars('hit_songs', Array (
		'U_VIEWARTIST'	=> append_sid('view_artist.php?id=' . $sql_data['artist_id']),
		'ARTIST_NAME' 	=> artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']),
		'SONG_TITLE' 	=> $sql_data['song_title'],
		'U_VIEWSONG' => append_sid('view_song.php?id=' . $sql_data['song_id']))
		);
}

//
// get the songs which in are the most playlists
//

$sql = 'SELECT COUNT(*) AS num, ' . SONGS_TABLE .'.song_id, song_title, ' . ARTISTS_TABLE . '.artist_id, artist_name, artist_prefix ' .
		' FROM ' . PLAYLIST_DATA_TABLE . ', ' . SONGS_TABLE . ', ' . ARTISTS_TABLE .
		' WHERE ( ' . PLAYLIST_DATA_TABLE . '.song_id = ' . SONGS_TABLE . '.song_id ) ' .
		' AND ( ' .SONGS_TABLE . '.artist_id = ' . ARTISTS_TABLE . '.artist_id ) ';
$sql = append_status_sql($sql);
$sql .= ' GROUP BY artist_name, song_title ' .
		' ORDER BY num DESC LIMIT 10';
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	$template->assign_block_vars('upl_songs', Array (
		'U_VIEWARTIST'	=> append_sid('view_artist.php?id=' . $sql_data['artist_id']),
		'ARTIST_NAME' 	=> artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']),
		'SONG_TITLE' 	=> $sql_data['song_title'],
		'U_VIEWSONG' => append_sid('view_song.php?id=' . $sql_data['song_id']))
		);
}


//
// get the newest songs
//

$sql = 'SELECT song_id, song_title, ' . ARTISTS_TABLE . '.artist_id, artist_name, artist_prefix ' .
		' FROM ' . SONGS_TABLE . ', ' . ARTISTS_TABLE .
		' WHERE ( ' .SONGS_TABLE . '.artist_id = ' . ARTISTS_TABLE . '.artist_id ) ';
$sql = append_status_sql($sql);
$sql .= ' ORDER BY song_id DESC LIMIT 10';
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	$template->assign_block_vars('new_songs', Array (
		'U_VIEWARTIST'	=> append_sid('view_artist.php?id=' . $sql_data['artist_id']),
		'ARTIST_NAME' 	=> artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']),
		'SONG_TITLE' 	=> $sql_data['song_title'],
		'U_VIEWSONG' => append_sid('view_song.php?id=' . $sql_data['song_id']))
		);
}

$template->assign_vars(array(
	'TOTAL_SONGS'	=> $stats_data['COUNT(DISTINCT song_id)'],
	'SUM_SIZE'		=> $stats_data['SUM(song_size)'],
	'SUM_LENGTH'	=> format_length(round($stats_data['SUM(song_length)'])),
	'AVG_SIZE'		=> round($stats_data['AVG(song_size)'],1),
	'AVG_LENGTH'	=> format_length(round($stats_data['AVG(song_length)'])),
	'AVG_QUALITY' 	=> round($stats_data['AVG(song_quality)']),
	'STD_SIZE'		=> round($stats_data['STD(song_size)'],1),
	'STD_LENGTH'	=> format_length(round($stats_data['STD(song_length)'])),
	'STD_QUALITY' 	=> round($stats_data['STD(song_quality)']),
	'MIN_SIZE'		=> $stats_data['MIN(song_size)'],
	'MIN_LENGTH'	=> format_length(round($stats_data['MIN(song_length)'])),
	'MIN_QUALITY' 	=> round($stats_data['MIN(song_quality)']),
	'MAX_SIZE'		=> $stats_data['MAX(song_size)'],
	'MAX_LENGTH'	=> format_length(round($stats_data['MAX(song_length)'])),
	'MAX_QUALITY' 	=> round($stats_data['MAX(song_quality)'])
	)
);
$template->assign_var_from_handle('FOING_STATS', 'foing_stats');

?>
