<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// list_artists.php -  part of foing                           //
//                                                             //
/////////////////////////////////////////////////////////////////
 
$foing_root_path = '../';
include($foing_root_path . 'includes/common.php');
define('IN_ADMIN', true);
check_perm('mod');
$page_title = 'artist edit (moderator only)';

$nonzero_bands = array();

// first, do the bands with songs in the database
$sql = 'SELECT COUNT('. ALBUMS_TABLE .'.album_id) AS num,' . SONGS_TABLE . '.artist_id, ' . SONGS_TABLE . '.album_id, album_title, album_year, artist_name, artist_prefix, artist_url FROM 
	' . SONGS_TABLE . ', ' . ARTISTS_TABLE . ', ' . ALBUMS_TABLE . ' WHERE 
	(' . SONGS_TABLE . '.artist_id = ' . ARTISTS_TABLE . '.artist_id ) AND
	(' . SONGS_TABLE . '.album_id = ' . ALBUMS_TABLE . '.album_id )
	GROUP BY artist_name, album_title
	ORDER BY artist_name, album_title ASC';

$result = $db->sql_query($sql);
while ($data = $db->sql_fetchrow($result))
{
	if ($data['artist_id'] != $prev_artist)
	{
		$u_edit_artist = append_sid('edit_artist.php?artist='.$data['artist_id'].'&action=edit');
		$l_edit_artist = 'edit';
		$artist_name = artist_add_prefix($data['artist_name'], $data['artist_prefix']);
		$artist_url = $data['artist_url'];
	}
	else
	{
		$u_edit_artist = '';
		$l_edit_artist = '';
		$artist_name = '';
		$artist_url = '';
	}
	if ($data['album_id'] != $prev_album || $data['artist_id'] != $prev_artist)
	{
		if ($data['album_id'] != '0')
		{
			$u_edit_album = append_sid('edit_album.php?album='.$data['album_id'].'&action=edit');
			$l_edit_album = 'edit';
		}
		else
		{
			$u_edit_album = '';
			$l_edit_album = '';
		}
		$album_title = $data['album_title'];
		if ($data['album_year'] > 0)
		{
			$album_year = $data['album_year'];
		}
		else
		{
			$album_year = '--';
		}
	}
	$prev_artist = $data['artist_id'];
	$prev_album = $data['album_id'];
	$nonzero_bands[++$i-1] = $data['artist_id'];
	$template->assign_block_vars('normal_bands', Array(
		'U_EDIT_ARTIST' => $u_edit_artist,
		'L_EDIT_ARTIST'	=> $l_edit_artist,
		'ARTIST_NAME'	=> $artist_name,
		'ARTIST_URL'	=> $artist_url,
		'U_EDIT_ALBUM'	=> $u_edit_album,
		'L_EDIT_ALBUM'	=> $l_edit_album,
		'ALBUM_TITLE'	=> $album_title,
		'ALBUM_YEAR'	=> $album_year,
		'NUM_SONGS'		=> $data['num']
		)
	);	
}


// now list the songless bands
$sql = 'SELECT artist_id, artist_name, artist_prefix, artist_url FROM '.ARTISTS_TABLE.' WHERE ';
$sql .= ' ( artist_id != '.reset($nonzero_bands);
while($bla = next($nonzero_bands))
{
	$sql .= ' AND artist_id != '.$bla;
}
$sql .= ') ORDER BY artist_name ASC';
$result = $db->sql_query($sql);
while ($data = @$db->sql_fetchrow($result))
{
	$u_edit_artist = append_sid('edit_artist.php?artist='.$data['artist_id'].'&action=edit');
	$l_edit_artist = 'edit';
	$artist_name = artist_add_prefix($data['artist_name'], $data['artist_prefix']);
	$artist_url = $data['artist_url'];
	$template->assign_block_vars('zero_bands', Array(
		'U_EDIT_ARTIST' => $u_edit_artist,
		'L_EDIT_ARTIST'	=> $l_edit_artist,
		'ARTIST_NAME'	=> $artist_name,
		'ARTIST_URL'	=> $artist_url
		)
	);
}

// and now also the albums with no songs
$sql = 'SELECT ' . ARTISTS_TABLE . '.artist_id, album_id, album_title, album_year, artist_name, artist_prefix, artist_url FROM 
	' . ARTISTS_TABLE . ', ' . ALBUMS_TABLE . ' WHERE 
	(' . ARTISTS_TABLE . '.artist_id = ' . ALBUMS_TABLE . '.artist_id ) AND ';
$sql .= ' ( ' . ARTISTS_TABLE. '.artist_id != '.reset($nonzero_bands) . ' ) ';;
while($bla = next($nonzero_bands))
{
	$sql .= ' AND ( ' . ARTISTS_TABLE .'.artist_id != '.$bla. ' )';
}
$sql .= ' ORDER BY artist_name, album_title ASC';
$result = $db->sql_query($sql);
while ($data = @$db->sql_fetchrow($result))
{
	$list_zero_album .= '<tr>';
	if ($data['artist_id'] != $prev_artist)
	{
		$u_edit_artist = append_sid('edit_artist.php?artist='.$data['artist_id'].'&action=edit');
		$l_edit_artist = 'edit';
		$artist_name = artist_add_prefix($data['artist_name'], $data['artist_prefix']);
		$artist_url = $data['artist_url'];
	}
	else
	{
		$u_edit_artist = '';
		$l_edit_artist = '';
		$artist_name = '';
		$artist_url = '';
	}
	$u_edit_album = append_sid('edit_album.php?album='.$data['album_id'].'&action=edit');
	$l_edit_album = 'edit';
	$album_title = $data['album_title'];
	if ($data['album_year'] > 0)
	{
		$album_year = $data['album_year'];
	}
	else
	{
		$album_year = '--';
	}

	$template->assign_block_vars('zero_albums', Array(
		'U_EDIT_ARTIST' => $u_edit_artist,
		'L_EDIT_ARTIST'	=> $l_edit_artist,
		'ARTIST_NAME'	=> $artist_name,
		'ARTIST_URL'	=> $artist_url,
		'U_EDIT_ALBUM'	=> $u_edit_album,
		'L_EDIT_ALBUM'	=> $l_edit_album,
		'ALBUM_TITLE'	=> $album_title,
		'ALBUM_YEAR'	=> $album_year
		)
	);
	$prev_artist = $data['artist_id'];
	$prev_album = $data['album_id'];
}

$template->set_filenames(array(
	'body' => 'admin/list_artists_body.tpl')
);

include('page_header_admin.php');
$template->pparse('body');
include('page_footer_admin.php');
?>