<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

class pafiledb_rate extends pafiledb
{
	function main($action)
	{
		global $pafiledb_template, $lang, $board_config, $phpEx, $pafiledb_config, $db, $images, $userdata;
		global $_REQUEST, $_POST, $cat_rowset, $file_rowset, $phpbb_root_path, $user_info;

		if ( isset($_REQUEST['file_id']) )
		{
			$file_id = intval($_REQUEST['file_id']);
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['File_not_exist']);
		}

		$rating = ( isset($_POST['rating']) ) ? intval($_POST['rating']) : '';


		$sql = "SELECT * 
			FROM " . PA_FILES_TABLE . " 
			WHERE file_id = '" . $file_id . "'";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query file info', '', __LINE__, __FILE__, $sql);
		}

		if(!$file = $db->sql_fetchrow($result))
		{
			message_die(GENERAL_MESSAGE, $lang['File_not_exist']);
		}
		
		$db->sql_freeresult($result);
		
		$pafiledb_auth = pafiledb_auth(PA_AUTH_RATE, $file['file_catid'], $userdata, $cat_rowset);
		
		if( (!$pafiledb_auth['auth_rate']) )
		{
			if ( !$userdata['session_logged_in'] )
			{
				redirect(append_sid("login.$phpEx?redirect=dload.$phpEx?action=rate&file_id=" . $file_id, true));
			}

			$message = sprintf($lang['Sorry_auth_rate'], $pafiledb_auth['auth_rate_type']);
			message_die(GENERAL_MESSAGE, $message);
		}

		generate_category_nav($file['file_catid']);
		$pafiledb_template->assign_vars(array(
			'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
			'L_RATE' => $lang['Rate'],

			'U_INDEX' => append_sid('index.'.$phpEx),
			'U_DOWNLOAD_HOME' => append_sid('dload.'.$phpEx),
			'U_FILE_NAME' => append_sid('dload.php?action=file&file_id=' . $file_id),

			'FILE_NAME' => $file['file_name'],
			'DOWNLOAD' => $pafiledb_config['settings_dbname'])
		); 

		if ( isset($_POST['submit']) )
		{
			$result_msg = str_replace("{filename}", $file['file_name'], $lang['Rconf']);

			$result_msg = str_replace("{rate}", $rating, $result_msg);
			
			if( ($rating <= 0) or ($rating > 10) )
			{
				message_die(GENERAL_ERROR, 'Bad submited value');
			}
			
			$user_info->update_voter_info($file_id, $rating);

			$rate_info = get_rating($file_id);

			$result_msg = str_replace("{newrating}", $rate_info, $result_msg);

			$pafiledb_template->assign_vars(array(
				"META" => '<meta http-equiv="refresh" content="3;url='  .append_sid('dload.php?action=file&file_id=' . $file_id) . '">')
			);
			
			$message = $result_msg . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid('dload.php?action=file&file_id=' . $file_id) . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid('index.' . $phpEx) . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);  

		}
		else
		{
			$rate_info = str_replace("{filename}", $file['file_name'], $lang['Rateinfo']);

			$pafiledb_template->assign_vars(array(
				'S_RATE_ACTION' => append_sid('dload.php?action=rate&file_id=' . $file_id),
				'L_RATE' => $lang['Rate'],
				'L_RERROR' => $lang['Rerror'],
				'L_R1' => $lang['R1'],
				'L_R2' => $lang['R2'],
				'L_R3' => $lang['R3'],
				'L_R4' => $lang['R4'],
				'L_R5' => $lang['R5'],
				'L_R6' => $lang['R6'],
				'L_R7' => $lang['R7'],
				'L_R8' => $lang['R8'],
				'L_R9' => $lang['R9'],
				'L_R10' => $lang['R10'],
				'RATEINFO' => $rate_info, 
				'ID' => $file_id) 
			);
		}
		$this->output($lang['Download'], 'pa_rate_body.tpl');
	}
}
?>
