<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

class pafiledb_download extends pafiledb
{
	function main($action)
	{
		global $_REQUEST, $lang, $db, $user_info, $pafiledb_config, $board_config, $phpEx, $cat_rowset, $userdata;

		if ( isset($_REQUEST['file_id']) )
		{
			$file_id = intval($_REQUEST['file_id']);
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['File_not_exist']);
		}

		$sql = "SELECT * 
			FROM " . PA_FILES_TABLE . " 
			WHERE file_id = '" . $file_id . "'";

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt select download', '', __LINE__, __FILE__, $sql);
		}

		//=========================================================================
		// Id doesn't match with any file in the database another nice error message
		//=========================================================================


		if(!$file = $db->sql_fetchrow($result))
		{
			message_die(GENERAL_MESSAGE, $lang['File_not_exist']);
		}
		
		$db->sql_freeresult($result);
		//=========================================================================
		// Check if the user is authorized to download the file
		//=========================================================================
		$pafiledb_auth = pafiledb_auth(PA_AUTH_DOWNLOAD, $file['file_catid'], $userdata, $cat_rowset);
		
		if( (!$pafiledb_auth['auth_download']) )
		{
			if ( !$userdata['session_logged_in'] )
			{
				redirect(append_sid("login.$phpEx?redirect=dload.$phpEx?action=download&file_id=" . $file_id, true));
			}

			$message = sprintf($lang['Sorry_auth_download'], $pafiledb_auth['auth_download_type']);
			message_die(GENERAL_MESSAGE, $message);
		}

		//=========================================================================
		// Check for hot links
		// Borrowed from Smartor Album mod, thanks Smartor
		//=========================================================================


		if( ($pafiledb_config['hotlink_prevent']) and (isset($HTTP_SERVER_VARS['HTTP_REFERER'])) )
		{
			$check_referer = explode('?', $HTTP_SERVER_VARS['HTTP_REFERER']);
			$check_referer = trim($check_referer[0]);

			$good_referers = array();

			if ($pafiledb_config['hotlink_allowed'] != '')
			{
				$good_referers = explode(',', $pafiledb_config['hotlink_allowed']);
			}

			$good_referers[] = $board_config['server_name'] . $board_config['script_path'];

			$errored = TRUE;

			for ($i = 0; $i < count($good_referers); $i++)
			{
				$good_referers[$i] = trim($good_referers[$i]);

				if( (strstr($check_referer, $good_referers[$i])) and ($good_referers[$i] != '') )
				{
					$errored = FALSE;
				}
			}

			if ($errored)
			{
				message_die(GENERAL_MESSAGE, $lang['Directly_linked']);
			}
		}
		
		
		//=========================================================================
		//Update download counter and the last downloaded date
		//=========================================================================

		$time = time();

		$sql = "UPDATE " . PA_FILES_TABLE . " 
			SET file_dls=file_dls+1, file_last=" . $time . " 
			WHERE file_id = '" . $file_id . "'";

		if ( !(pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Update Files table', '', __LINE__, __FILE__, $sql);
		}

		//=========================================================================
		// Update downloader Info for the given file
		//=========================================================================

		$user_info->update_downloader_info($file_id);

		$formated_url = get_formated_url();

		$html_path = $formated_url . '/' . UPLOAD_DIR;

		$file_url = $file['file_dlurl'];

		if (substr($file_url, 0, strlen($html_path)) !== $html_path)
		{
			Header("Location: $file_url");
			exit();
		}
		else
		{
			$directory = UPLOAD_DIR;

			$file_url = basename($file['file_dlurl']) ;

			$file_name = basename($file_url);

			//=========================================================================
			// now send the file to the user so he can enjoy it :D
			//=========================================================================

			send_file_to_browser($file_name, 'application/force-download', $file_name, $directory);
		}
	}
}

		//=========================================================================
		// this function Borrowed from Acyd Burn attachment mod, (thanks Acyd for this great mod)
		//=========================================================================

function send_file_to_browser($real_filename, $mimetype, $physical_filename, $upload_dir)
{
	global $_SERVER, $HTTP_USER_AGENT, $HTTP_SERVER_VARS, $lang, $db;

	if ($upload_dir == '')
	{
		$filename = $physical_filename;
	}
	else
	{
		$filename = $upload_dir . '/' . $physical_filename;
	}

	$gotit = FALSE;


	if (@!file_exists(@pafiledb_realpath($filename)))
	{
		message_die(GENERAL_ERROR, $lang['Error_no_download'] . "<br /><br /><b>404 File Not Found:</b> The File <i>" . $filename . "</i> does not exist.");
	}
	else
	{
		$gotit = TRUE;
	}


	//
	// Determine the Browser the User is using, because of some nasty incompatibilities.
	// Most of the methods used in this function are from phpMyAdmin. :)
	//
	if (!empty($_SERVER['HTTP_USER_AGENT'])) 
	{
		$HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
	}
	else if (!isset($HTTP_USER_AGENT))
	{
		$HTTP_USER_AGENT = '';
	}

	if (ereg('Opera(/| )([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[2];
		$browser_agent = 'opera';
	} 
	else if (ereg('MSIE ([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'ie';
	} 
	else if (ereg('OmniWeb/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'omniweb';
	} 
	else if (ereg('Netscape([0-9]{1})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'netscape';
	} 
	else if (ereg('Mozilla/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'mozilla';
	} 
	else if (ereg('Konqueror/([0-9].[0-9]{1,2})', $HTTP_USER_AGENT, $log_version)) 
	{
		$browser_version = $log_version[1];
		$browser_agent = 'konqueror';
	} 
	else 
	{
		$browser_version = 0;
		$browser_agent = 'other';
	}

	//
	// Correct the Mime Type, if it's an octetstream
	//
	if ( ($mimetype == 'application/octet-stream') || ($mimetype == 'application/octetstream') )
	{
		if ( ($browser_agent == 'ie') || ($browser_agent == 'opera') )
		{
			$mimetype = 'application/octetstream';
		}
		else
		{
			$mimetype = 'application/octet-stream';
		}
	}

	@ob_end_clean();
	@ini_set('zlib.output_compression', 'Off');
	header('Pragma: public');
	header('Content-Transfer-Encoding: none');

	//
	// Send out the Headers
	//
	if ($browser_agent == 'ie')
	{
		header('Content-Type: ' . $mimetype);
		header('Content-Disposition: inline; filename="' . $real_filename . '"');
	} 
	else
	{
		header('Content-Type: ' . $mimetype . '; name="' . $real_filename . '"');
		header('Content-Disposition: attachment; filename=' . $real_filename);
	}

	//
	// Now send the File Contents to the Browser
	//
	if ($gotit)
	{
		$size = @filesize($filename);
		if ($size)
		{
			header("Content-length: $size");
		}
		readfile($filename);
	}
	else
	{
		message_die(GENERAL_ERROR, $lang['Error_no_download'] . "<br /><br /><b>404 File Not Found:</b> The File <i>" . $filename . "</i> does not exist.");
	}

	exit();
}
?>
