<?php
/***************************************************************************
 *                              mytransfer.php
 *                            -------------------
 *   begin                : Saturday, November 16, 2002
 *   last modified        : Friday, April 25, 2003
 *   copyright            : (C) 2002 Conan Tran
 *   website			  : www.maihoatrang.com
 *   email                : conanqtran@maihoatrang.com
 *
 *   $Id: mytransfer.php,v 0.99 2002/11/16 09:20:00 conanqtran Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_MY_TRANS, $session_length);
init_userprefs($userdata);
//
// End session management
//
// Make sure the user is logged in
if( !$userdata['session_logged_in'] )
{
	header("Location: " . append_sid($phpbb_root_path . "login." . $phpEx . "?redirect=mytransfer.php"));
}

//
// Transactions sorting
//

$mode_types_text = array($lang['Sort_Trans_Date'], $lang['Sort_Trans_From'], $lang['Sort_Trans_To'], $lang['Sort_Trans_Amount'], $lang['Sort_Top_Ten_Trans']);
$mode_types = array('transdate', 'transfrom', 'transto', 'transamount', 'toptentrans');

//
// Generate page
//
$page_title = $lang['My_Trans'];

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'mytransfer_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(

	'L_TRANS_FROM' => $lang['Trans_From'],
	'L_TRANS_TO' => $lang['Trans_To'],
	'L_TRANS_AMOUNT' => $lang['Trans_Amount'],
	'L_TRANS_REASON' => $lang['Points_reason'],
	'L_TRANS_DATE' => $lang['Trans_Date'],
	'L_CUSTOM_POINT_NAME' => $lang['Custom_Point_Name'],
	'L_MY_TRANS' => $lang['My_Trans'],
	'L_GLOBAL_TRANS' => $lang['Global_Trans'],
	'L_VIEW_THE_REST' => $lang['View_The_Rest'],
	'L_TOTAL_TRANS' => $lang['Total_Trans'],
	'L_RECENT_TRANS_TO' => $lang['Recent_Trans_To'],
	'L_RECENT_TRANS_FROM' => $lang['Recent_Trans_From'])
);

//
//show all transactions made to your account
//
$sql = "SELECT trans_date, trans_from, trans_to, trans_amount, trans_reason
	FROM " . TRANSACTION_TABLE . "
	WHERE trans_to = '" . $userdata['username'] . "'
	ORDER BY trans_date DESC LIMIT 10";

if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query transaction', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$trans_from = $row['trans_from'];
		$trans_to = $row['trans_to'];
		$trans_amount = ( $row['trans_amount'] ) ? $row['trans_amount'] : 0;
		$trans_reason = $row['trans_reason'];
		$trans_date = create_date($board_config['default_dateformat'], $row['trans_date'], $board_config['board_timezone']);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars('transtorow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'TRANS_FROM' => $trans_from,
			'TRANS_TO' => $trans_to,
			'TRANS_AMOUNT' => $trans_amount,
			'TRANS_REASON' => $trans_reason,
			'TRANS_DATE' => $trans_date)
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

//
//Now show total amount of points sent to your account
//
$sql = "SELECT sum(trans_amount) AS total_sent_to
	FROM " . TRANSACTION_TABLE . "
	WHERE trans_to = '" . $userdata['username'] . "'";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting total transactions', '', __LINE__, __FILE__, $sql);
}

if ( $total_sent_to = $db->sql_fetchrow($result) )
{
	$total_money = $total_sent_to['total_sent_to'];
	$template->assign_block_vars('totalsendto', array(
		'TOTAL_SENT_TO' => $total_money)
	);
}

//
//show all transactions that you made through your account
//
$sql = "SELECT trans_date, trans_from, trans_to, trans_amount, trans_reason
	FROM " . TRANSACTION_TABLE . "
	WHERE trans_from = '" . $userdata['username'] . "'
	ORDER BY trans_date DESC LIMIT 10";


if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query transaction', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$trans_from = $row['trans_from'];
		$trans_to = $row['trans_to'];
		$trans_amount = ( $row['trans_amount'] ) ? $row['trans_amount'] : 0;
		$trans_reason = $row['trans_reason'];
		$trans_date = create_date($board_config['default_dateformat'], $row['trans_date'], $board_config['board_timezone']);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars('transfromrow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'TRANS_FROM' => $trans_from,
			'TRANS_TO' => $trans_to,
			'TRANS_AMOUNT' => $trans_amount,
			'TRANS_REASON' => $trans_reason,
			'TRANS_DATE' => $trans_date)
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

//
//Now show total amount of point you have sent through your account
//
$sql = "SELECT sum(trans_amount) AS total_sent_from
	FROM " . TRANSACTION_TABLE . "
	WHERE trans_from = '" . $userdata['username'] . "'";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting total transactions', '', __LINE__, __FILE__, $sql);
}

if ( $total_sent_from = $db->sql_fetchrow($result) )
{
	$total_money = $total_sent_from['total_sent_from'];
	$template->assign_block_vars('totalsendfrom', array(
		'TOTAL_SENT_FROM' => $total_money)
	);

}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
