<?php
/***************************************************************************
 *                               im_main.php
 *                            -------------------
 *   begin                : Wednesday, Nov 6, 2002
 *   version              : 0.6.0
 *   date                 : 2003/06/09 19:40
 ***************************************************************************/

// This file builds the Main IM Client and Who's Online Client window content.

if ( !defined('IN_PHPBB') || !defined('IN_PRILLIAN') )
{
	die('Hacking attempt');
}

// First, let's get a list of all messages we may be working with.
// This includes new, read, and unread instant messages as well as
// new private messages.

$all_msgs = array();
$s2s_msgs = array();
$pm_where = '';
$read_where = '';

if( $im_userdata['open_pms'] )
{
	$pm_where = ', ' . PRIVMSGS_UNREAD_MAIL;
	if( $delete && $mark_list )
	{
		$pm_where .= ', ' . PRIVMSGS_READ_MAIL;
	}
	if( $userdata['user_new_privmsg'] )
	{
		$pm_where .= ', ' . PRIVMSGS_NEW_MAIL;
	}
}

if( $im_userdata['auto_delete'] || ($delete && $mark_list) )
{
	$read_where = ', ' . IM_READ_MAIL;
}

$sql = 'SELECT pm.privmsgs_type, pm.privmsgs_id, pm.privmsgs_subject, pm.privmsgs_from_userid, u.username 
FROM ' . PRIVMSGS_TABLE . ' pm, ' . USERS_TABLE . ' u 
	WHERE pm.privmsgs_type IN (' . IM_NEW_MAIL . ', ' . IM_UNREAD_MAIL . $read_where . $pm_where . ')
		AND pm.privmsgs_to_userid = ' . $userdata['user_id'] . ' 
		AND u.user_id = pm.privmsgs_from_userid
		AND pm.site_id = 0';

if ( !$result=$db->sql_query($sql) )
{
	$msg = 'Could not get list of messages' . $lang['Close_window_link'];
	message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
}

$all_msgs = $db->sql_fetchrowset($result);
$db->sql_freeresult($result);

// Include Site-to-Site information
if( $im_userdata['user_allow_s2s'] && $im_userdata['admin_allow_s2s'] && $board_config['im_allow_s2s'] )
{
	$sql = 'SELECT pm.site_id, pm.privmsgs_type, pm.privmsgs_id, pm.privmsgs_subject, pm.privmsgs_from_username, ss.site_url, ss.site_phpex
	FROM ' . PRIVMSGS_TABLE . ' pm, ' . IM_SITES_TABLE . ' ss 
		WHERE pm.privmsgs_type IN (' . IM_NEW_MAIL . ', ' . IM_UNREAD_MAIL . $read_where . $pm_where . ')
			AND pm.privmsgs_to_userid = ' . $userdata['user_id'] . ' 
			AND pm.site_id = ss.site_id';

	if ( !$result=$db->sql_query($sql) )
	{
		$msg = 'Could not get list of messages' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$s2s_msgs = $db->sql_fetchrowset($result);
	$db->sql_freeresult($result);

	if( !empty($s2s_msgs) )
	{
		reset($s2s_msgs);
		while(list($k, $info) = each($s2s_msgs))
		{
			$all_msgs[] = $info;
		}
	}
}

$msgs_total = (!empty($all_msgs)) ? count($all_msgs): false;
if( $msgs_total )
{
	sort($all_msgs);
}
else
{
	$all_msgs = array();
}

// Now let's process any message deletion actions.

$im_read_mail = IM_READ_MAIL;
$im_unread_mail = IM_UNREAD_MAIL;
$privmsgs_read_mail = PRIVMSGS_READ_MAIL;
$privmsgs_unread_mail = PRIVMSGS_UNREAD_MAIL;

$delete_pos = array(); // Will hold position of deleted messages in $all_msgs
$delete_ids = array(); // Will hold privmsgs_id of deleted messages
$delete_sql_id = '';   // Will hold privmsgs_id of deleted messages for SQL
$delete_nums = array(
	"$privmsgs_read_mail" => 0,
	"$privmsgs_unread_mail" => 0,
	"$im_read_mail" => 0,
	"$im_unread_mail" => 0
); // Will hold numbers of deleted message by message type

// First, we'll get a list of messages the user wants to delete from the
// list in the IM Client.
if ( $msgs_total && $delete && $mark_list )
{
	// session id check
	if ($sid == '' || $sid != $userdata['session_id'])
	{
		$message = $lang['Invalid_session'] . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $message, '', __LINE__, __FILE__, '');
	}

	// Set to empty arrays instead of '0' if nothing is selected.
	if ( isset($mark_list) && !is_array($mark_list) )
	{
		$mark_list = array();
	}

	if( count($mark_list) )
	{
		for ($i = 0; $i < count($mark_list); $i++)
		{
			$pos_num = false;
			$pos_num = in_m_array($mark_list[$i], $all_msgs, true, 'privmsgs_id');
			if( $pos_num !== false )
			{
				$delete_pos[] = $pos_num[1];
				$delete_ids[] = intval($mark_list[$i]);
				$delete_sql_id .= (($delete_sql_id != '') ? ', ' : '') . intval($mark_list[$i]);
				$delete_nums[$all_msgs[$pos_num[1]]['privmsgs_type']]++;
			}
		}
	}
}

// Next, let's deal with instant messages that have already been read.
// We'll only bother with these if automatic deletion is on. Otherwise,
// they'll be tossed out of our data later.
if( $msgs_total && $im_userdata['read_ims'] &&  $im_userdata['auto_delete'] )
{
	// We need to do some automatic deletion
	for($ii=0; $ii<=$msgs_total; $ii++)
	{
		if( $all_msgs[$ii]['privmsgs_type'] == IM_READ_MAIL && !inarray($all_msgs[$ii]['privmsgs_id'], $delete_ids) )
		{
			$delete_pos[] = $ii;
			$delete_ids[] = $all_msgs[$ii]['privmsgs_id'];
			$delete_sql_id .= (($delete_sql_id != '') ? ', ' : '') . $all_msgs[$ii]['privmsgs_id'];
			$delete_nums[$all_msgs[$pos_num[1]]['privmsgs_type']]++;
		}
	}
}

// Now, if we have some messages to delete, let's do that.
if( count($delete_ids) )
{
	$delete_text_sql = 'DELETE FROM ' . PRIVMSGS_TEXT_TABLE . "
		WHERE privmsgs_text_id IN ($delete_sql_id)";
	$delete_sql = 'DELETE FROM ' . PRIVMSGS_TABLE . "
		WHERE privmsgs_id IN ($delete_sql_id)
			AND privmsgs_to_userid = " . $userdata['user_id'] . '
			AND privmsgs_type IN (' . IM_UNREAD_MAIL . ', ' . IM_READ_MAIL . ', ' . PRIVMSGS_READ_MAIL . ', ' . PRIVMSGS_UNREAD_MAIL . ')';
	if ( !$db->sql_query($delete_sql, BEGIN_TRANSACTION) )
	{
		$msg = 'Could not delete message info' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $delete_sql);
	}
	if ( !$db->sql_query($delete_text_sql, END_TRANSACTION) )
	{
		$msg = 'Could not delete message text' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $delete_text_sql);
	}

	// Now we need to update the various counters tracking the numbers of messages.
	// Got to update these in both the script and the database.
	$im_numbers_sql = '';
	$pm_numbers_sql = '';

	reset($delete_nums);
	while(list($k, $v) = each($delete_nums))
	{
		if( $v )
		{
			switch($k)
			{
				case $im_read_mail:
					$im_numbers_sql .= (($im_numbers_sql != '') ? ', ' : '') . ' read_ims = read_ims - ' . $v;
					$im_userdata['read_ims'] -= $v;
					break;
				case $im_unread_mail:
					$im_numbers_sql .= (($im_numbers_sql != '') ? ', ' : '') . ' unread_ims = unread_ims - ' . $v;
					$im_userdata['unread_ims'] -= $v;
					break;
				case $privmsgs_unread_mail:
					$pm_numbers_sql .= ' user_unread_privmsg = user_unread_privmsg - ' . $v;
					$userdata['user_unread_privmsg'] -= $v;
					break;
			}
		}
	}

	if( $im_numbers_sql != '' )
	{
		$sql = 'UPDATE ' . IM_PREFS_TABLE . " SET $im_numbers_sql WHERE user_id = " . $userdata['user_id'];
		if ( !$db->sql_query($sql) )
		{
			$msg = 'Could not update instant message numbers' . $lang['Close_window_link'];
			message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}
	}

	if( $pm_numbers_sql != '' )
	{
		$sql = 'UPDATE ' . USERS_TABLE . " SET $pm_numbers_sql WHERE user_id = " . $userdata['user_id'];
		if ( !$db->sql_query($sql) )
		{
			$msg = 'Could not update unread private message numbers' . $lang['Close_window_link'];
			message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}
	}

	// Finally, let's eliminate the deleted messages from our data.
	if( $msgs_total )
	{
		reset($delete_pos);
		while(list($k, $v) = each($delete_pos))
		{
			unset($all_msgs[$v]);
		}
		
		$msgs_total = (!empty($all_msgs)) ? count($all_msgs): false;
		if( $msgs_total )
		{
			sort($all_msgs);
		}
		else
		{
			$all_msgs = array();
		}
	}
}
// That's the end of all the message deletion stuff!

// We don't want to display read messages, so let's get those out of our data.
if( $msgs_total )
{
	$removed = false;
	for($ii=0; $ii<=$msgs_total; $ii++)
	{
		if( $all_msgs[$ii]['privmsgs_type'] == IM_READ_MAIL || $all_msgs[$ii]['privmsgs_type'] == PRIVMSGS_READ_MAIL )
		{
			unset($all_msgs[$ii]);
			$removed = true;
		}
	}

	$msgs_total = (!empty($all_msgs)) ? count($all_msgs): false;
	if( $msgs_total )
	{
		if( $removed )
		{
			sort($all_msgs);
		}
	}
	else
	{
		$all_msgs = array();
	}
}

// Begin building the IM Client!

define('SHOW_ONLINE', true);

// Begin building the window

if( $mode == 'who' )
{
	$body_template = 'imclient_whoonline_body.tpl';
	$mode_append = '?mode=who';
	$im_userdata['refresh_rate'] += 5;
}
else
{
	$body_template = 'imclient_main_body.tpl';
	$mode_append = '?mode=main';
}


$template->set_filenames(array(
	'body' => $body_template)
);
$refresh_url = append_sid($phpbb_root_path . "imclient.$phpEx$mode_append");


if( $im_userdata['refresh_method'] == 1 )
{
	$refresh_javascript = 'onLoad=window.setTimeout("location.href=\'' . $refresh_url . '\'",' . $im_userdata['refresh_rate'] . '000)';
}
elseif( $im_userdata['refresh_method'] == 2 )
{
	// Add 15 seconds to refresh rate - we'll stagger the refresh
	// triggers so that both of them don't go off at the same time.
	$im_refresh_rate2 = $im_userdata['refresh_rate'] + 15;
	$refresh_javascript = 'onLoad=window.setTimeout("location.href=\'' . $refresh_url . '\'",' . $im_refresh_rate2 . '000)';
	$meta_headers = '<meta http-equiv="refresh" content="' . $im_userdata['refresh_rate'] . ';url='  . $refresh_url . '">';
}
else
{
	$meta_headers = '<meta http-equiv="refresh" content="' . $im_userdata['refresh_rate'] . ';url='  . $refresh_url . '">';
}

if( !$im_userdata['popup_ims'] && $im_userdata['list_ims'] )
{
	$read_mark = '&mark_read=1';
}

$buddy_list = get_single_list('buddy');

include($phpbb_root_path . 'includes/page_header.'.$phpEx);


// Define basic or common template variables
$template->assign_vars(array(
	'IMG_LOGO' => $images['prill_logo'],
	'L_PRILLIAN' => $lang['Prillian'],
	'IMG_MESSAGE' => $images['prill_message'],

	'L_INFORMATION' => $lang['Information'],
	'L_PRIVATE_MESSAGES' => $lang['Private_Messages'],
	'L_USERS_ONLINE' => $lang['Users_Online'],
	'L_HIDDEN_USERS_ONLINE' => $lang['Hidden_Users_Online'],
	'L_GUESTS_ONLINE' => $lang['Guests_Online'],
	'L_PM' => $lang['PM'],
	'L_IM' => $lang['IM'],
	'L_MESSAGE' => $lang['Message'],

	'U_IM_PATH' => $phpbb_im_path,
	'U_PM_LINK' => append_sid($phpbb_root_path . 'privmsg.'.$phpEx.'?folder=inbox'),

	'SEND_WIDTH' => $im_userdata['win_send_width'],
	'SEND_HEIGHT' => $im_userdata['win_send_height'],
	'READ_WIDTH' => $im_userdata['win_read_width'],
	'READ_HEIGHT' => $im_userdata['win_read_height'],
	'NEW_PMS' => $userdata['user_new_privmsg'],
	'USERS_ONLINE' => $logged_visible_online,
	'HIDDEN_USERS_ONLINE' => $logged_hidden_online,
	'GUESTS_ONLINE' => $guests_online)
);

// If we're opening new private messages in the IM Client, it's pointless
// to display the number of new pms, since that number will be 0!
if( !$im_userdata['open_pms'] )
{
		$template->assign_block_vars('switch_pms', array());
}


// Create new message list and spawn pop-ups
if( $msgs_total )
{
	if( $im_userdata['list_ims'] )
	{
		$s_hidden_fields = '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><inout type="hidden" name="mode" value="' . $mode . '" />';

		$template->assign_block_vars('switch_newmsg_list', array(
			'S_FORM_ACTION' => append_sid($phpbb_root_path . 'imclient.' . $phpEx),
			'S_HIDDEN_FIELDS' => $s_hidden_fields,

			'L_NEW_MESSAGES' => $lang['New_messages'],
			'L_SUBJECT' => $lang['Subject'],
			'L_FROM' => $lang['From'],
			'L_MARK_ALL' => $lang['Mark_all'],
			'L_UNMARK_ALL' => $lang['Unmark_all'],
			'L_DELETE' => $lang['Delete'])
		);
	}

	$im_id_sql = '';
	$pm_id_sql = '';
	$total_unread = 0;
	$total_new = 0;
	$total_new_pms = 0;
	$total_unread_pms = 0;
	$left_pixels = 0;
	$right_pixels = 0;

	reset($all_msgs);
	while( list($key, $im) = each($all_msgs) )
	{
		if( $im['privmsgs_type'] == IM_UNREAD_MAIL )
		{
			if( $im_userdata['popup_ims'] && ! $im_userdata['list_ims'] )
			{
				$im_id_sql .=  ( ( $im_id_sql == '' ) ? '' : ', ' ) . $im['privmsgs_id'];
				$total_unread++;
			}
		}
		elseif( $im['privmsgs_type'] == IM_NEW_MAIL )
		{
			$im_id_sql .=  ( ( $im_id_sql == '' ) ? '' : ', ' ) . $im['privmsgs_id'];
			$total_new++;
		}
		elseif( $im['privmsgs_type'] == PRIVMSGS_NEW_MAIL )
		{
			$pm_id_sql .=  ( ( $pm_id_sql == '' ) ? '' : ', ' ) . $im['privmsgs_id'];
			$total_new_pms++;
		}
		elseif( $im['privmsgs_type'] == PRIVMSGS_UNREAD_MAIL )
		{
			$pm_id_sql .=  ( ( $pm_id_sql == '' ) ? '' : ', ' ) . $im['privmsgs_id'];
			$total_unread_pms++;
		}
		else
		{
			continue;
		}

		if( $left_pixels == 200 )
		{
			$left_pixels = 0;
			$right_pixels = 0;
		}
		else
		{
			$left_pixels += 20;
			$right_pixels += 40;
		}

		$s2s_mark = ( $im['site_id'] ) ? '&amp;sitesite=1': '';

		if( $im_userdata['popup_ims'] )
		{
			$template->assign_block_vars('switch_im_popups', array(
				'U_IMMSGS_POPUP' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=read&" . POST_POST_URL . '=' . $im['privmsgs_id'] . $s2s_mark),
				'IMNUM' => $key,
				'LEFT_PX' => $left_pixels,
				'TOP_PX' => $right_pixels)
			);
		}

		if( $im_userdata['list_ims'] )
		{
			$post_subject = $im['privmsgs_subject'];
			$orig_word = array();
			$replacement_word = array();
			obtain_word_list($orig_word, $replacement_word);
			if ( count($orig_word) )
			{
				$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);
			}
			if( strlen($post_subject) > 8 )
			{
				$short_subject = substr($post_subject, 0, 8) . '...';
			}
			else
			{
				$short_subject = $post_subject;
			}

			if( $im['site_id'] )
			{
				$im['username'] = $im['privmsgs_from_username'];
				$u_profile = append_sid($im['site_url'] . 'profile.' . $im['site_phpex'] . '?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $im['privmsgs_from_userid']);
			}
			else
			{
				$u_profile = append_sid($phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $im['privmsgs_from_userid']);
			}

			if( strlen($im['username']) > 5 )
			{
				$short_sender = substr($im['username'], 0, 5) . '...';
			}
			else
			{
				$short_sender = $im['username'];
			}

			$template->assign_block_vars('switch_newmsg_list.switch_newmsg_row', array(
				'U_IMMSGS' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=read&" . POST_POST_URL . '=' . $im['privmsgs_id'] . $read_mark . $s2s_mark),
				'U_PROFILE' => $u_profile,

				'S_MARK_ID' => $im['privmsgs_id'],

				'SUBJECT_SHORT' => $short_subject,
				'SUBJECT_FULL' => $post_subject,
				'SENDER_SHORT' => $short_sender,
				'SENDER_FULL' => $im['username'],
				'IMNUM' => $key,
				'LEFT_PX' => $left_pixels,
				'TOP_PX' => $right_pixels)
			);
		}
	}

	// Update mail status for all of these new messages

	$im_update_sql = '';
	$im_num_update_sql = '';
	$pm_update_sql = '';
	$pm_num_update_sql = '';

	if( $im_userdata['popup_ims'] )
	{
		if( $im_id_sql != '' )
		{
			$im_update_sql = 'UPDATE ' . PRIVMSGS_TABLE . '
				SET privmsgs_type = ' . IM_READ_MAIL . "
				WHERE privmsgs_id IN ($im_id_sql)";
			$im_update_err = 'Could not update instant message read status';
			$im_update_line = __LINE__;

			$im_num_update_sql = 'UPDATE ' . IM_PREFS_TABLE . " 
				SET new_ims = new_ims - $total_new, unread_ims = unread_ims - $total_unread, read_ims = read_ims + $total_unread + $total_new 
				WHERE user_id = " . $userdata['user_id'];
			$im_num_update_err = 'Could not update instant message read status for user';
			$im_num_update_line = __LINE__;
		}

		if( $total_new_pms || $total_unread_pms )
		{
			$pm_update_sql = 'UPDATE ' . PRIVMSGS_TABLE . '
				SET privmsgs_type = ' . PRIVMSGS_READ_MAIL . "
				WHERE privmsgs_id IN ($pm_id_sql)";
			$pm_update_err = 'Could not update private message read status';
			$pm_update_line = __LINE__;

			$pm_num_update_sql = 'UPDATE ' . USERS_TABLE . " 
				SET user_new_privmsg = user_new_privmsg - $total_new_pms, user_unread_privmsg = user_unread_privmsg - $total_unread_pms
				WHERE user_id = " . $userdata['user_id'];
			$pm_num_update_err = 'Could not update private message read status for user';
			$pm_num_update_line = __LINE__;
		}
	}
	elseif( $im_userdata['list_ims'] )
	{
		if( $im_id_sql != '' )
		{
			$im_update_sql = 'UPDATE ' . PRIVMSGS_TABLE . '
				SET privmsgs_type = ' . IM_UNREAD_MAIL . "
				WHERE privmsgs_id IN ($im_id_sql)";
			$im_update_err = 'Could not update instant message unread status';
			$im_update_line = __LINE__;
			$im_num_update_sql = 'UPDATE ' . IM_PREFS_TABLE . " 
				SET new_ims = new_ims - $total_new, unread_ims = unread_ims + $total_new 
				WHERE user_id = " . $userdata['user_id'];
			$im_num_update_err = 'Could not update instant message unread status for user';
			$im_num_update_line = __LINE__;
		}

		if( $total_new_pms )
		{
			$pm_update_sql = 'UPDATE ' . PRIVMSGS_TABLE . '
				SET privmsgs_type = ' . PRIVMSGS_UNREAD_MAIL . "
				WHERE privmsgs_id IN ($pm_id_sql)";
			$pm_update_err = 'Could not update private message unread status';
			$pm_update_line = __LINE__;

			$pm_num_update_sql = 'UPDATE ' . USERS_TABLE . " 
				SET user_new_privmsg = user_new_privmsg - $total_new_pms, user_unread_privmsg = user_unread_privmsg + $total_new_pms 
				WHERE user_id = " . $userdata['user_id'];
			$pm_num_update_err = 'Could not update private message unread status for user';
			$pm_num_update_line = __LINE__;
		}
	}

	if( $im_update_sql != '' )
	{
		if ( !$db->sql_query($im_update_sql) )
		{
			$msg = $im_update_err . $lang['Close_window_link'];
			message_die(GENERAL_ERROR, $msg, '', $im_update_line, __FILE__, $sql);
		}
		if ( !$db->sql_query($im_num_update_sql) )
		{
			$msg = $im_num_update_err . $lang['Close_window_link'];
			message_die(GENERAL_ERROR, $msg, '', $im_num_update_line, __FILE__, $sql);
		}
	}

	if( $pm_update_sql != '' )
	{
		if ( !$db->sql_query($pm_update_sql) )
		{
			$msg = $pm_update_err . $lang['Close_window_link'];
			message_die(GENERAL_ERROR, $msg, '', $pm_update_line, __FILE__, $sql);
		}
		if ( !$db->sql_query($pm_num_update_sql) )
		{
			$msg = $pm_num_update_err . $lang['Close_window_link'];
			message_die(GENERAL_ERROR, $msg, '', $pm_num_update_line, __FILE__, $sql);
		}
	}

	if( ( $total_new || $total_new_pms ) && $board_config['im_allow_sound'] && $im_userdata['play_sound'] )
	{
		$sound_name = ( !$board_config['im_default_sound'] ) ? $board_config['im_sound_name'] : $im_userdata['sound_name'];

		$template->assign_block_vars('switch_sound', array(
			'SOUND_NAME' => $sound_name)
		);
	}
}
// That's the end of the message list and pop-up spawning!

// Include Site-to-Site information
if( $im_userdata['user_allow_s2s'] && $im_userdata['admin_allow_s2s'] && $im_userdata['s2s_user_list'] && $board_config['im_allow_s2s'] )
{
	include($phpbb_im_path . 's2s_parseusers.'.$phpEx);
}

// Now, it's time to build the online user list!
// First, get a list of all users on the IM Client right now.
$on_im = array();

$sql = 'SELECT session_user_id FROM ' . IM_SESSIONS_TABLE;
if ( !$result = $db->sql_query($sql) )
{
	$msg = 'Could not query IM sessions list' . $lang['Close_window_link'];
	message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
}
while( $row = $db->sql_fetchrow($result) )
{
	$on_im[] = $row['session_user_id'];
}

if( $im_userdata['list_all_online'] == 1 || $im_userdata['list_all_online'] == 4 )
{
	// Let's show all online users
	$template->assign_block_vars('switch_users_online',	array(
		'L_USERS_ONLINE' => $lang['Users_Online']
	));

	if ( empty($prillian_online) )
	{
		// No users online at all!!
		$template->assign_block_vars('switch_users_online.switch_user_list',	array(
			'ONLINE_USER' => $lang['None'],
			'ONLINE_USER_STYLE' => '',
			'ONLINE_USER_URL' => '',
			'U_MESSAGE_USER' => '',
			'L_MESSAGE' => '')
		);
	}
	else
	{
		// Get ignore and disallowed lists to avoid showing users 
		// the person can't contact or doesn't want to see
		$ignore_list = get_single_list('ignore');
		$disallowed_list = get_single_list('disallowed');

		reset($prillian_online);
		while ( list($key, $value) = each($prillian_online) )
		{
			$is_on_im = 0;
			if( $value['user_level'] != OFF_SITE )
			{
				if( !in_m_array($value['user_id'], $ignore_list) && !in_m_array($value['user_id'], $disallowed_list) )
				{
					if( inarray($value['user_id'], $on_im) )
					{
						// A user is on the IM Client now
						$is_on_im = 1;
					}
					
					if( $im_userdata['list_all_online'] == 4 )
					{
						// All users on IM only
						if( $is_on_im )
						{
							process_user_online($value, $is_on_im);
						}
					}
					else
					{
						// All users on the forum
						process_user_online($value, $is_on_im);
					}
				}
			}
			else
			{
				process_user_online($value, 1);
			}
		}
	}
}
elseif( $im_userdata['list_all_online'] == 2 || $im_userdata['list_all_online'] == 3 )
{
	// We're going to show buddies only
	$buddy_count = 0;

	$template->assign_block_vars('switch_users_online',	array(
		'L_USERS_ONLINE' => $lang['Buddies_Online']
	));

	if ( empty($prillian_online) || !count($buddy_list) )
	{
		// Either the user has no buddies, or no users are online at all!
		$template->assign_block_vars('switch_users_online.switch_user_list',	array(
			'ONLINE_USER' => $lang['None'],
			'ONLINE_USER_STYLE' => '',
			'ONLINE_USER_URL' => '',
			'U_MESSAGE_USER' => '',
			'L_MESSAGE' => '')
		);
	}
	else
	{
		$buddies_online = array();
		reset($prillian_online);
		while (list($key, $value) = each ($prillian_online))
		{
			$is_on_im = 0;
			if( $value['user_level'] != OFF_SITE )
			{
				if( in_m_array($value['user_id'], $buddy_list) )
				{
					if( inarray($value['user_id'], $on_im) )
					{
						// A user is on the IM Client now
						$is_on_im = 1;
					}
					
					if( $im_userdata['list_all_online'] == 3 )
					{
						// Buddies on IM only
						if( $is_on_im )
						{
							$buddies_online[$buddy_count]['user'] = $value;
							$buddies_online[$buddy_count]['is_on'] = $is_on_im;
							$buddy_count++;
						}
					}
					else
					{
						// Buddies on all of forums
						$buddies_online[$buddy_count]['user'] = $value;
						$buddies_online[$buddy_count]['is_on'] = $is_on_im;
						$buddy_count++;
					}
				}
			}
			else
			{
				$buddies_online[$buddy_count]['user'] = $value;
				$buddies_online[$buddy_count]['is_on'] = 1;
				$buddy_count++;
			}
		}

		if( !$buddy_count )
		{
			// None of the online users are buddies.
			$template->assign_block_vars('switch_users_online.switch_user_list',	array(
				'ONLINE_USER' => $lang['None'],
				'ONLINE_USER_STYLE' => '',
				'ONLINE_USER_URL' => '',
				'U_MESSAGE_USER' => '',
				'L_MESSAGE' => '')
			);
		}
		else
		{
			// There are some buddies... print them out!
			for($ii=0; $ii<$buddy_count; $ii++)
			{
				process_user_online($buddies_online[$ii]['user'], $buddies_online[$ii]['is_on']);
			}
		}
	}
}

// End of File - imclient.php finishes things off
?>