<?php
/***************************************************************************
 *                                im_log.php
 *                            -------------------
 *   begin                : Wednesday, May 21, 2003
 *   version              : 0.1.0
 *   date                 : 2003/06/08 16:40
 ***************************************************************************/

// This file builds the Message Log window content.

if ( !defined('IN_PHPBB') || !defined('IN_PRILLIAN') )
{
	die('Hacking attempt');
}

// Check possible variables

// $type - Possible values include "received", "sent", "offreceived", "offsent"
if ( !empty($HTTP_POST_VARS['type']) || !empty($HTTP_GET_VARS['type']) )
{
	$type = ( !empty($HTTP_POST_VARS['type']) ) ? $HTTP_POST_VARS['type'] : $HTTP_GET_VARS['type'];
}
else
{
	$type = 'received';
}

// $sort_order & $start - used for pagination
if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;


$u_profile_base = $phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=';

$offsite = false;
$name_sql = '';
$s2s_mark = '';

// First, set up some options based on $type
switch($type)
{
	case 'offsent':
		$sender = $userdata['username'];
		$u_sender = $u_profile_base . $userdata['user_id'];
		$msg_sql = ' AND pm.privmsgs_from_userid = ' . $userdata['user_id'];
		$type_title = $lang['Offsite_Messages_Sent_by'] . $userdata['username'];
		$no_msg = $lang['No_sent'];
		$name_sql = 'pm.privmsgs_to_username, ';
		$offsite = true;
		$s2s_mark = '&amp;sitesite=1';
		break;
	case 'offreceived':
		$receiver = $userdata['username'];
		$u_receiver = $u_profile_base . $userdata['user_id'];
		$sent_mark = '';
		$msg_sql = ' AND pm.privmsgs_to_userid = ' . $userdata['user_id'];
		$type_title = $lang['Offsite_Messages_Received_by'] . $userdata['username'];
		$no_msg = $lang['No_received'];
		$name_sql = 'pm.privmsgs_from_username, ';
		$offsite = true;
		$s2s_mark = '&amp;sitesite=1';
		break;
	case 'sent':
		$sender = $userdata['username'];
		$u_sender = $u_profile_base . $userdata['user_id'];
		$msg_sql = ' AND pm.privmsgs_from_userid = ' . $userdata['user_id'] . ' AND u.user_id = pm.privmsgs_to_userid';
		$type_title = $lang['Messages_Sent_by'] . $userdata['username'];
		$no_msg = $lang['No_sent'];
		break;
	case 'received':
	default:
		$receiver = $userdata['username'];
		$u_receiver = $u_profile_base . $userdata['user_id'];
		$sent_mark = '';
		$msg_sql = ' AND pm.privmsgs_to_userid = ' . $userdata['user_id'] . ' AND u.user_id = pm.privmsgs_from_userid';
		$type_title = $lang['Messages_Received_by'] . $userdata['username'];
		$no_msg = $lang['No_received'];
		break;
}

if( $offsite )
{
	$msg_sql .= ' AND pm.site_id <> 0';
	$u_select_sql = '';
	$u_table_sql = '';
}
else
{
	$msg_sql .= ' AND pm.site_id=0';
	$u_select_sql = ', u.username';
	$u_table_sql = ', ' . USERS_TABLE . ' u ';
}

// Let's get a list of all messages we may be working with. This includes new,
// read, and unread instant messages. These may be messages sent or received by the
// user depending on $type.

$all_msgs = array();

$sql = 'SELECT pm.privmsgs_type, pm.privmsgs_id, pm.privmsgs_subject, pm.privmsgs_from_userid, ' . $name_sql . 'pm.privmsgs_to_userid, pm.privmsgs_date' . $u_select_sql . ' FROM ' . PRIVMSGS_TABLE . ' pm' . $u_table_sql . '
	WHERE pm.privmsgs_type IN (' . IM_NEW_MAIL . ', ' . IM_UNREAD_MAIL . ', ' . IM_READ_MAIL . ')' . $msg_sql;
$sql .= ' ORDER BY pm.privmsgs_date ' . $sort_order;
$sql .= ' LIMIT ' . (($start) ? $start . ', ' : '') . $board_config['topics_per_page'];

$msg_count_sql = 'SELECT COUNT(*) AS total
FROM ' . PRIVMSGS_TABLE . ' pm' . $u_table_sql . '
	WHERE pm.privmsgs_type IN (' . IM_NEW_MAIL . ', ' . IM_UNREAD_MAIL . ', ' . IM_READ_MAIL . ')' . $msg_sql;

if ( !$result=$db->sql_query($sql) )
{
	$msg = 'Could not get list of messages' . $lang['Close_window_link'];
	message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
}

$all_msgs = $db->sql_fetchrowset($result);
$db->sql_freeresult($result);

$msgs_total = (!empty($all_msgs)) ? count($all_msgs): false;
if( $msgs_total )
{
	sort($all_msgs);
}
else
{
	$all_msgs = array();
}



// Begin building the window

$template->set_filenames(array(
	'body' => 'imclient_log_body.tpl')
);

$page_title .=  ' - ' . $type_title;

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

// Define basic or common template variables
$template->assign_vars(array(
	'IMG_LOGO' => $images['prill_logo'],
	'L_PRILLIAN' => $lang['Prillian'],

	'L_SENT' => $lang['Sent'],
	'L_RECEIVED' => $lang['Received'],
	'L_OFF_SENT' => $lang['Offsite_Sent'],
	'L_OFF_RECEIVED' => $lang['Offsite_Received'],

	'U_RECEIVED' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=log&type=received"),
	'U_SENT' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=log&type=sent"),
	'U_OFF_RECEIVED' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=log&type=offreceived"),
	'U_OFF_SENT' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=log&type=offsent"),
	'U_IM_PATH' => $phpbb_im_path,

	'S_FORM_ACTION' => append_sid($phpbb_root_path . 'imclient.' . $phpEx),
	'MESSAGES' => $type_title,
	'READ_WIDTH' => $im_userdata['win_read_width'],
	'READ_HEIGHT' => $im_userdata['win_read_height']
));


// Create message list and spawn pop-ups
if( $msgs_total )
{
	$s_hidden_fields = '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" /><inout type="hidden" name="mode" value="' . $mode . '" />';

	$template->assign_block_vars('switch_msg_list', array(
		'S_HIDDEN_FIELDS' => $s_hidden_fields,

		'L_SUBJECT' => $lang['Subject'],
		'L_FROM' => $lang['From'],
		'L_TO' => $lang['To'],
		'L_DATE' => $lang['Date'],
		'L_MARK_ALL' => $lang['Mark_all'],
		'L_UNMARK_ALL' => $lang['Unmark_all'],
		'L_DELETE' => $lang['Delete']
	));

	$left_pixels = 0;
	$right_pixels = 0;
	$row_class = 'row1';

	reset($all_msgs);
	while( list($key, $im) = each($all_msgs) )
	{
		if( $left_pixels == 200 )
		{
			$left_pixels = 0;
			$right_pixels = 0;
		}
		else
		{
			$left_pixels += 20;
			$right_pixels += 40;
		}

		$post_subject = $im['privmsgs_subject'];
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);
		if ( count($orig_word) )
		{
			$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);
		}

		if( $im['privmsg_type'] != IM_READ_MAIL )
		{
			$read_mark = '&mark_read=1';
		}
		else
		{
			$read_mark = '';
		}

		switch($type)
		{
			case 'offsent':
				$receiver = $im['privmsgs_to_username'];
				$u_receiver = $u_profile_base . $im['privmsgs_to_userid'];
				$sent_mark = '&sent_mark=1';
				$read_mark = '';
				break;
			case 'offreceived':
				$sender = $im['privmsgs_from_username'];
				$u_sender = $u_profile_base . $im['privmsgs_from_userid'];
				break;
			case 'sent':
				$receiver = $im['username'];
				$u_receiver = $u_profile_base . $im['privmsgs_to_userid'];
				$sent_mark = '&sent_mark=1';
				$read_mark = '';
				break;
			case 'received':
			default:
				$sender = $im['username'];
				$u_sender = $u_profile_base . $im['privmsgs_from_userid'];
				break;
		}

		$template->assign_block_vars('switch_msg_list.switch_msg_row', array(
			'U_IMMSGS' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=read&" . POST_POST_URL . '=' . $im['privmsgs_id'] . $read_mark . $sent_mark . $s2s_mark),
			'U_SENDER' => append_sid($u_sender),
			'U_RECEIVER' => append_sid($u_receiver),

			'S_MARK_ID' => $im['privmsgs_id'],

			'ROW_CLASS' => $row_class,
			'SUBJECT' => $post_subject,
			'SENDER' => $sender,
			'RECEIVER' => $receiver,
			'DATE' => create_date($board_config['default_dateformat'], $im['privmsgs_date'], $board_config['board_timezone']),
			'IMNUM' => $key,
			'LEFT_PX' => $left_pixels,
			'TOP_PX' => $right_pixels
		));

		$row_class = ($row_class == 'row1') ? 'row2' : 'row1';
	}

	if ( !$result=$db->sql_query($msg_count_sql) )
	{
		$msg = 'Could not get total number of messages' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	if ( !$row=$db->sql_fetchrow($result) )
	{
		$msg = 'Could not find total number of messages' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$pagination = generate_pagination("imclient.$phpEx?mode=$mode&amp;type=$type&amp;order=$sort_order", $row['total'], $board_config['topics_per_page'], $start). '&nbsp;';

	$template->assign_vars(array(
		'TOTAL_POPUPS' => "total_popups = $msgs_total;",
		'PAGINATION' => $pagination,
		'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $row['total'] / $board_config['topics_per_page'] ))
	));
}
else
{
	// No messages.
	$template->assign_block_vars('switch_no_msg', array(
		'NO_MSG' => $no_msg
	));
	$template->assign_vars(array(
		'PAGINATION' => '',
		'PAGE_NUMBER' => ''
		)
	);
}
// That's the end of the message list!


// Output the controls panel(s)
print_controls();

// End of File - imclient.php finishes things off
?>