<?php
/***************************************************************************
 *                            functions_common.php
 *                            -------------------
 *   begin                : Saturday, Jan 25, 2003
 *   version              : 1.2.0
 *   date                 : 2003/06/08 16:48
 ***************************************************************************/

/***************************************************************************
 *								THOUL SAYS
 *   This file contains functions that both Prillian and BID List require.
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die('Hacking attempt');
}

// Used to avoid including the file twice and prevent errors.
define('CF_INCLUDED', true);

// inarray()
// This function is copied from phpBB 2.0.3's upgrade.php. It's a replacement
// for PHP 4's in_array() function and used for PHP 3 compatiblity.
// It's copyright (C) the phpBB Group.
function inarray($needle, $haystack)
{ 
	for( $i = 0 ; $i < sizeof($haystack) ; $i++ )
	{ 
		if ( $haystack[$i] == $needle )
		{ 
			return true; 
		} 
	} 

	return false; 
}

// in_m_array()
// This function is used to provide powerful search methods dealing with 
// two dimensional arrays. Many SQL queries used in phpBB/Prillian/BID List
// are stored in such arrays, so it's helpful to have a way of finding specific
// things in these arrays.
// Optional variables:
// $get_num - If TRUE, the function returns an array containing two elements:
//					[0] => TRUE
//					[1] => the position, in the first dimension, the data was in.
//			- If FALSE, the function returns true if the the data is found, or FALSE
//				if the data was not found.
// $k - Used to search only specific keys in the second dimension. $k may be a
//      string (the name of a single key) or an array of strings (the names of more
//      than one key).
function in_m_array($needle, $haystack, $get_num = FALSE, $k = false)
{ 
	$multikey = false;
	if( is_array($k) )
	{
		$multikey = true;
	}

	for( $i = 0 ; $i < sizeof($haystack) ; $i++ )
	{ 
		if( $k )
		{
			// Search second dimension by key
			if( $multikey )
			{
				// Search by array of keys
				for( $j = 0 ; $j < sizeof($k) ; $j++ )
				{
					if ( $haystack[$i][$k[$j]] == $needle )
					{ 
						if( $get_num )
						{
							return array(true, $i);
						}
						else
						{
							return true;
						}
					} 
				}
			}
			else
			{
				// Search by single key
				if ( $haystack[$i][$k] == $needle )
				{ 
					if( $get_num )
					{
						return array(true, $i);
					}
					else
					{
						return true;
					}
				} 
			}
		}
		else
		{
			// Search all of second dimension
			for( $j = 0 ; $j < sizeof($haystack[$i]) ; $j++ )
			{ 
				if ( $haystack[$i][$j] == $needle )
				{ 
					if( $get_num )
					{
						return array(true, $i);
					}
					else
					{
						return true;
					}
				} 
			}
		}
	} 

	return false; 
}

// thoul_redirect()
// This is an almost straight copy of phpBB 2.0.4's redirect() function (which is
// copyright (C) the phpBB Group. Since that function is not present in older
// versions of phpBB, this function is used instead of redirect() for compatiblity
// with those phpBB versions. The only difference from redirect() is that append_sid
// is used in this function, so it's not needed to call append_sid when calling this
// function.
function thoul_redirect($url)
{
	global $db, $board_config;

	if (!empty($db))
	{
		$db->sql_close();
	}

	$url = append_sid($url, true);

	$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
	$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
	$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$script_name = ($script_name == '') ? $script_name : '/' . $script_name;
	$url = preg_replace('#^\/?(.*?)\/?$#', '/\1', trim($url));

	// Redirect via an HTML form for PITA webservers
	if (@preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')))
	{
		header('Refresh: 0; URL=' . $server_protocol . $server_name . $server_port . $script_name . $url);
		echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html><head><meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"><meta http-equiv="refresh" content="0; url=' . $server_protocol . $server_name . $server_port . $script_name . $url . '"><title>Redirect</title></head><body><div align="center">If your browser does not support meta redirection please click <a href="' . $server_protocol . $server_name . $server_port . $script_name . $url . '">HERE</a> to be redirected</div></body></html>';
		exit;
	}

	// Behave as per HTTP/1.1 spec for others
	header('Location: ' . $server_protocol . $server_name . $server_port . $script_name . $url);
	exit;
}
?>