<?php
/***************************************************************************
 *                              lotwin.php
 *                            -------------------
 *   begin                : Wednesday, July 30, 2003
 *   copyright            : (C)2003 LaZeR 
 *   website	          : http://www.oasisforum.valcato.net/phpbb/portal.php
 *   email                : lazer@oasisforum.valcato.net
 *
 *   $Id: lotwin.php,v 1.0 2003/30/07 19:00:00 lazer Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/07 20:35:12 mj
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_lottery.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_LOTTERY_WINNERS, $session_length);
init_userprefs($userdata);
//
// End session management
//

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

//
// Winners sorting
//

$mode_types_text = array($lang['Date'], $lang['Username'], $lang['prize_amount'], $lang['Sort_Top_Ten_Trans']);
$mode_types = array('windate', 'winnername', 'prizeamount', 'toptenwins');

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

//
// Generate page
//
$page_title = $lang['LotteryWinners'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'lotwin_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_SUBMIT' => $lang['Sort'],
	'L_ORDER' => $lang['Order'],

	'L_WINNER' => $lang['Username'],
	'L_WINAMOUNT' => $lang['prize_amount'],
	'L_WINDATE' => $lang['win_date'],
	'L_MONEY_SYMBOL' => $lang['Money_Symbol'],

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_MODE_ACTION' => append_sid("lotwin.$phpEx"))
);

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];

	switch( $mode )
	{
		case 'windate':
			$order_by = "win_date $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'winnername':
			$order_by = "winner_name $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'prizeamount':
			$order_by = "prize_amount $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'toptenwins':
			$order_by = "prize_amount DESC LIMIT 10";
			break;
		default:
			$order_by = "win_date DESC LIMIT $start, " . $board_config['topics_per_page'];
			break;
	}
}
else
{
	$order_by = "win_date DESC LIMIT $start, " . $board_config['topics_per_page'];
}

$sql = "SELECT win_date, winner_name, prize_amount
	FROM " . LOTTERY_WINNER_TABLE . "
	ORDER BY $order_by";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query winners', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$winner_name = $row['winner_name'];
		$prize_amount = ( $row['prize_amount'] ) ? $row['prize_amount'] : 0;
		$win_date = create_date($board_config['default_dateformat'], $row['win_date'], $board_config['board_timezone']);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars('lotwinrow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'WINNER_NAME' => $winner_name,
			'PRIZE_AMOUNT' => $prize_amount,
			'WIN_DATE' => $win_date)
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . LOTTERY_WINNER_TABLE . "";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total transactions', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_transactions = $total['total'];

		$pagination = generate_pagination("lotwin.$phpEx?mode=$mode&amp;order=$sort_order", $total_transactions, $board_config['topics_per_page'], $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_transactions = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_transactions / $board_config['topics_per_page'] )),
	'L_GOTO_PAGE' => $lang['Goto_page'])
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
