<?php
/***************************************************************************
 *                         lang_bbcode.php [english]
 *                            -------------------
 *   begin                : Wednesday Oct 3, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: lang_bbcode.php,v 1.3.2.2 2002/12/18 15:40:20 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/12 23:17:10 mj
 *
 ***************************************************************************/

/* CONTRIBUTORS
	2002-12-15	Philip M. White (pwhite@mailhaven.com)
		Fixed many minor grammatical problems.
*/
 
// 
// To add an entry to your BBCode guide simply add a line to this file in this format:
// $faq[] = array("question", "answer");
// If you want to separate a section enter $faq[] = array("--","Block heading goes here if wanted");
// Links will be created automatically
//
// DO NOT forget the ; at the end of the line.
// Do NOT put double quotes (") in your BBCode guide entries, if you absolutely must then escape them ie. \"something\"
//
// The BBCode guide items will appear on the BBCode guide page in the same order they are listed in this file
//
// If just translating this file please do not alter the actual HTML unless absolutely necessary, thanks :)
//
// In addition please do not translate the colours referenced in relation to BBCode any section, if you do
// users browsing in your language may be confused to find they're BBCode doesn't work :D You can change
// references which are 'in-line' within the text though.
//
  
$faq[] = array("--","Introduction");
$faq[] = array("What is BBCode?", "BBCode is a special implementation of HTML. Whether you can actually use BBCode in your posts on the forum is determined by the administrator. In addition, you can disable BBCode on a per post basis via the posting form. BBCode itself is similar in style to HTML: tags are enclosed in square braces [ and ] rather than &lt; and &gt; and it offers greater control over what and how something is displayed. Depending on the template you are using you may find adding BBCode to your posts is made much easier through a clickable interface above the message area on the posting form. Even with this you may find the following guide useful.");

$faq[] = array("--","Text Formatting");
$faq[] = array("How to create bold, italic and underlined text", "BBCode includes tags to allow you to quickly change the basic style of your text. This is achieved in the following ways: <ul><li>To make a piece of text bold enclose it in <b>[b][/b]</b>, eg. <br /><br /><b>[b]</b>Hello<b>[/b]</b><br /><br />will become <b>Hello</b></li><li>For underlining use <b>[u][/u]</b>, for example:<br /><br /><b>[u]</b>Good Morning<b>[/u]</b><br /><br />becomes <u>Good Morning</u></li><li>To italicise text use <b>[i][/i]</b>, eg.<br /><br />This is <b>[i]</b>Great!<b>[/i]</b><br /><br />would give This is <i>Great!</i></li></ul>");
$faq[] = array("How to change the text colour, size or type", "To alter the color or size of your text the following tags can be used. Keep in mind that how the output appears will depend on the viewers browser and system: <ul><li>Changing the colour of text is achieved by wrapping it in <b>[color=][/color]</b>. You can specify either a recognised colour name (eg. red, blue, yellow, etc.) or the hexadecimal triplet alternative, eg. #FFFFFF, #000000. For example, to create red text you could use:<br /><br /><b>[color=red]</b>Hello!<b>[/color]</b><br /><br />or<br /><br /><b>[color=#FF0000]</b>Hello!<b>[/color]</b><br /><br />will both output <span style=\"color:red\">Hello!</span></li><li>Changing the text size is achieved in a similar way using <b>[size=][/size]</b>. This tag is dependent on the template you are using but the recommended format is a numerical value representing the text size in pixels, starting at 1 (so tiny you will not see it) through to 29 (very large). For example:<br /><br /><b>[size=9]</b>SMALL<b>[/size]</b><br /><br />will generally be <span style=\"font-size:9px\">SMALL</span><br /><br />whereas:<br /><br /><b>[size=24]</b>HUGE!<b>[/size]</b><br /><br />will be <span style=\"font-size:24px\">HUGE!</span></li><br /><br /><li>Changing the text type (font face) is just as simple. <b>[face=][/face]</b>. Keep in mind however, if other users don't have whichever font you are using, installed on their computer, they will simply see the defualt text.<br /><br />Another thing to be aware of is spaces. For example:<br /><br /><b>[face=trebuchet ms]</b>Blah<b>[/face]</b><br /><br />Will give you <b>[face=trebuchet ms]</b>Blah<b>[/face]</b><br /><br />Whereas:<br /><br /><b>[face=trebuchetms]</b>Blah<b>[/face]</b><br /><br />Will give you <span style=\"font-family: trebuchet ms\">Blah (The desired result - In Trebuchet MS font face)</span></li></ul>");
$faq[] = array("What does Blur do?", "This forum has Blur BBCode installed.  Using blur on selected text will display the text with a blur effect.  For example using:<ul><li>Wow! Look I'm <b>[blur]</b>blurred<b>[/blur]</b>!<br \><br \>will display as:<br \><br \>Wow! Look I'm <span style=\"height: 20; filter:blur(add=1,direction=270,strength=10)\">blurred</span>!</li></ul>") ;
$faq[] = array("What does Fade do?", "This forum has Fade BBCode installed.  Using fade on selected text will display the begining of the string as normal text and then continue lightening the text from left to right until the text just fades away.  For example using:<ul><li>Wow! Look I'm <b>[fade]</b>fading away<b>[/fade]</b>!<br \><br \>will display as:<br \><br \>Wow! Look I'm <span style=\"height: 1; Filter: Alpha(Opacity=100, FinishOpacity=0, Style=1, StartX=0, FinishX=100%)\">fading away</span>!</li></ul>") ;
$faq[] = array("What does Flip do?", "This forum has Flip BBCode installed.  Using flipv on selected text will display the text upside down (like a mirror reflection).  Using fliph on selected text will display the text upside down (like a mirror reflection).  Using both flipv and fliph will display the text upside down and backwards.  For example using:<ul><li>Wow! Look I'm <b>[flipv]</b>vertically flipped<b>[/flipv]</b>!<br \><br \>will display as:<br \><br \>Wow! Look I'm <span style=\"filter: flipv; height:1\">vertically flipped</span>!</li><br /><li>Wow! Look I'm <b>[fliph]</b>horizontally flipped<b>[/fliph]</b>!<br \><br \>will display as:<br \><br \>Wow! Look I'm <span style=\"filter: fliph; height:1\">horizontally flipped</span>!</li><br /><li>Wow! Look I'm <b>[flipv][fliph]</b>vertically and horizontally flipped<b>[/fliph][/flipv]</b>!<br \><br \>will display as:<br \><br \>Wow! Look I'm <span style=\"filter: flipv; height:1\"><span style=\"filter: fliph; height:1\">vertically and horizontally flipped</span></span>!</li></ul>") ;
$faq[] = array("What does Scroll do?", "This forum has Scroll BBCode installed.  Using scroll on selected text will make the text scroll from right to left across the post body.  The scroll text will appear on a seperate line.  For example using:<ul><li>Wow! Look I'm <b>[scroll]</b>scrolling across the screen<b>[/scroll]</b>!<br \><br \>will display as:<br \><br \>Wow! Look I'm <span><marquee>scrolling across the screen!</marquee></span></li></ul>") ;
$faq[] = array("Can I combine formatting tags?", "Yes, of course you can; for example to get someones attention you may write:<br /><br /><b>[size=18][color=red][b]</b>LOOK AT ME!<b>[/b][/color][/size]</b><br /><br />this would output <span style=\"color:red;font-size:18px\"><b>LOOK AT ME!</b></span><br /><br />We don't recommend you output lots of text that looks like this, though! Remember that it is up to you, the poster, to ensure that tags are closed correctly. For example, the following is incorrect:<br /><br /><b>[b][u]</b>This is wrong<b>[/b][/u]</b>");

$faq[] = array("--","Quoting and outputting fixed-width text");
$faq[] = array("Quoting text in replies", "There are two ways you can quote text: with a reference or without.<ul><li>When you utilise the Quote function to reply to a post on the board you should notice that the post text is added to the message window enclosed in a <b>[quote=\"\"][/quote]</b> block. This method allows you to quote with a reference to a person or whatever else you choose to put. For example, to quote a piece of text Mr. Blobby wrote, you would enter:<br /><br /><b>[quote=\"Mr. Blobby\"]</b>The text Mr. Blobby wrote would go here<b>[/quote]</b><br /><br />The resulting output will automatically add: Mr. Blobby wrote: before the actual text. Remember that you <b>must</b> include the quotation marks \"\" around the name you are quoting -- they are not optional.</li><li>The second method allows you to blindly quote something. To utilise this enclose the text in <b>[quote][/quote]</b> tags. When you view the message it will simply show: Quote: before the text itself.</li></ul>");
$faq[] = array("Outputting code or fixed width data", "If you want to output a piece of code or in fact anything that requires a fixed width with a Courier-type font, you should enclose the text in <b>[code][/code]</b> tags, eg.<br /><br /><b>[code]</b>echo \"This is some code\";<b>[/code]</b><br /><br />All formatting used within <b>[code][/code]</b> tags is retained when you later view it.");

$faq[] = array("--","Generating lists");
$faq[] = array("Creating an Un-ordered list", "BBCode supports two types of lists, unordered and ordered. They are essentially the same as their HTML equivalents. An unordered list ouputs each item in your list sequentially one after the other indenting each with a bullet character. To create an unordered list you use <b>[list][/list]</b> and define each item within the list using <b>[*]</b>. For example, to list your favorite colours you could use:<br /><br /><b>[list]</b><br /><b>[*]</b>Red<br /><b>[*]</b>Blue<br /><b>[*]</b>Yellow<br /><b>[/list]</b><br /><br />This would generate the following list:<ul><li>Red</li><li>Blue</li><li>Yellow</li></ul>");
$faq[] = array("Creating an Ordered list", "The second type of list, an ordered list gives you control over what is output before each item. To create an ordered list you use <b>[list=1][/list]</b> to create a numbered list or alternatively <b>[list=a][/list]</b> for an alphabetical list. As with the unordered list items are specified using <b>[*]</b>. For example:<br /><br /><b>[list=1]</b><br /><b>[*]</b>Go to the shops<br /><b>[*]</b>Buy a new computer<br /><b>[*]</b>Swear at computer when it crashes<br /><b>[/list]</b><br /><br />will generate the following:<ol type=\"1\"><li>Go to the shops</li><li>Buy a new computer</li><li>Swear at computer when it crashes</li></ol>Whereas for an alphabetical list you would use:<br /><br /><b>[list=a]</b><br /><b>[*]</b>The first possible answer<br /><b>[*]</b>The second possible answer<br /><b>[*]</b>The third possible answer<br /><b>[/list]</b><br /><br />giving<ol type=\"a\"><li>The first possible answer</li><li>The second possible answer</li><li>The third possible answer</li></ol>");

$faq[] = array("--", "Creating Links");
$faq[] = array("Linking to another site", "BBCode supports a number of ways of creating URIs, Uniform Resource Indicators better known as URLs.<ul><li>The first of these uses the <b>[url=][/url]</b> tag; whatever you type after the = sign will cause the contents of that tag to act as a URL. For example, to link to Fully Modded phpBB.com you could use:<br /><br /><b>[url=http://www.phpbbfm.net/]</b>Visit Fully Modded phpBB!<b>[/url]</b><br /><br />This would generate the following link, <a href=\"http://www.phpbbfm.net/\" target=\"_blank\">Visit Fully Modded phpBB!</a> You will notice the link opens in a new window so the user can continue browsing the forums if they wish.</li><li>If you want the URL itself displayed as the link you can do this by simply using:<br /><br /><b>[url]</b>http://www.phpbbfm.net/<b>[/url]</b><br /><br />This would generate the following link: <a href=\"http://www.phpbbfm.net/\" target=\"_blank\">http://www.phpbbfm.net/</a></li><li>An additional feature is something called <i>Magic Links</i>which will turn any syntatically correct URL into a link without you needing to specify any tags or even the leading http://. For example typing www.phpbbfm.net into your message will automatically lead to <a href=\"http://www.phpbbfm.net/\" target=\"_blank\">www.phpbbfm.net</a> being output when you view the message.</li><li>The same thing applies equally to email addresses; you can either specify an address explicitly, like:<br /><br /><b>[email]</b>no.one@domain.adr<b>[/email]</b><br /><br />which will output <a href=\"emailto:no.one@domain.adr\">no.one@domain.adr</a> or you can just type no.one@domain.adr into your message and it will be automatically converted when you view.</li></ul>As with all the BBCode tags you can wrap URLs around any of the other tags such as <b>[img][/img]</b> (see next entry), <b>[b][/b]</b>, etc. As with the formatting tags it is up to you to ensure the correct open and close order is following. For example:<br /><br /><b>[url=http://www.phpbbfm.net/][img]</b>http://www.phpbbfm.net/images/phplogo.gif<b>[/url][/img]</b><br /><br />is <u>not</u> correct which may lead to your post being deleted so take care.");

$faq[] = array("--", "Showing images in posts");
$faq[] = array("Adding an image to a post", "BBCode incorporates a tag for including images in your posts. Two very important things to remember when using this tag are: many users do not appreciate lots of images being shown in posts and second, the image you display must already be available on the Internet (it cannot exist only on your computer, for example, unless you run a webserver!). There is currently no way of storing images locally. To display an image, you must surround the URL pointing to the image with <b>[img][/img]</b> tags. For example:<br /><br /><b>[img]</b>http://www.phpbb.com/images/phplogo.gif<b>[/img]</b><br /><br />As noted in the URL section above you can wrap an image in a <b>[url][/url]</b> tag if you wish, eg.<br /><br /><b>[url=http://www.phpbbfm.net/][img]</b>http://www.phpbbfm.net/images/phplogo.gif<b>[/img][/url]</b><br /><br />would generate:<br /><br /><a href=\"http://www.phpbbfm.net/\" target=\"_blank\"><img src=\"templates/subSilver/images/logo_phpBB_med.gif\" border=\"0\" alt=\"\" /></a><br />");
$faq[] = array("Aligning images and wrapping text", "This forum has the Left-Right IMG tag installed.  Through the use of these tags, you can better format your posts by aligning text to the left or right side of the post body.  Additionally, through the use of these tags, text will now neatly wrap around the images as opposed to being in-line as with a normal [img] tag.  For example:<br /><br /><b>With img tags:</b><br />A really really <b>[img]</b>phplogo.gif<b>[/img]</b> <b>[img]</b>phplogo.gif<b>[/img]</b> really really really really really really long sentence. <table width=\"420\" cellpadding=\"5\"><tr><td class=\"quote\"><br />A really really <img src=\"templates/subSilver/images/logo_phpBB_med.gif\" border=\"0\" alt=\"\" /> <img src=\"templates/subSilver/images/logo_phpBB_med.gif\" border=\"0\" alt=\"\" /> really really really really really really long sentence.<br /><br /></td></tr></table><br /> <b>With left and right tags:</b><br />A really really <b>[left]</b>phplogo.gif<b>[/left]</b> <b>[right]</b>phplogo.gif<b>[/right]</b> really really really really really really long sentence. <table width=\"420\" cellpadding=\"5\"><tr><td class=\"quote\"><br /><img src=\"templates/subSilver/images/logo_phpBB_med.gif\" border=\"0\" alt=\"\" align=\"left\" /> <img src=\"templates/subSilver/images/logo_phpBB_med.gif\" border=\"0\" alt=\"\" align=\"right\" /> A really really really really really really really really long sentence.<br /><br /><br /></td></tr></table>") ;

$faq[] = array("--", "Using Flash"); 
$faq[] = array("Using Macromedia Flash", "BBCode Flash tag supports a number of ways of using flash URIs, Uniform Resource Indicators better known as URLs, to display stunning flash animations, games etc...<p>You may use the flash tag in your posts, and signature, and any other BBcode enabled fields on your site. Flash isn't for the faint hearted, and it is recommended that you know what you are doing before using these tags.</p><ul><li>The first of these uses the <b>[flash][/flash]</b> tag, everything in between the tags, it the URI for the swf file. For example to make a flash tag with this file you could use:<br /><br /><b>[flash]</b>http://www.macromedia.com/software/flash/header_fl_main.swf<b>[/flash]</b><br /><br />This would generate the following,</li></ul><p> 
<object codeBase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=5,0,0,0\" height=\"240\" width=\"420\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"> 
<param NAME=\"_cx\" VALUE=\"11113\"> 
<param NAME=\"_cy\" VALUE=\"6350\"> 
<param NAME=\"Movie\" VALUE=\"http://www.macromedia.com/software/flash/header_fl_main.swf\"> 
<param NAME=\"Src\" VALUE=\"http://www.macromedia.com/software/flash/header_fl_main.swf\"> 
<param NAME=\"WMode\" VALUE=\"Transparent\"> 
<param NAME=\"Play\" VALUE=\"1\"> 
<param NAME=\"Loop\" VALUE=\"-1\"> 
<param NAME=\"Quality\" VALUE=\"High\"> 
<param NAME=\"SAlign\" VALUE> 
<param NAME=\"Menu\" VALUE=\"-1\"> 
<param NAME=\"Base\" VALUE> 
<param NAME=\"Scale\" VALUE=\"NoBorder\"> 
<param NAME=\"DeviceFont\" VALUE=\"0\"> 
<param NAME=\"EmbedMovie\" VALUE=\"0\"> 
<param NAME=\"BGColor\" VALUE=\"000000\"> 
<param NAME=\"SWRemote\" VALUE> 
<param NAME=\"Stacking\" VALUE=\"below\"><embed src=\"http://www.macromedia.com/software/flash/header_fl_main.swf\" quality=\"high\" scale=\"noborder\" wmode=\"transparent\" bgcolor=\"#000000\" TYPE=\"application/x-shockwave-flash\" PLUGINSPAGE=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\"> 
</object> 
</p><ul><li>If you want the so set the width, height and loop params yourself:<br /><br /><b>[flash width=500 height=45 loop=true]</b>http://www.macromedia.com/software/flash/header_fl_main.swf<b>[/flash]</b><br /><br />This would generate the following,&nbsp;</li></ul><p> 
<object codeBase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=5,0,0,0\" height=\"45\" width=\"500\" classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\"> 
<param NAME=\"_cx\" VALUE=\"13229\"> 
<param NAME=\"_cy\" VALUE=\"1191\"> 
<param NAME=\"Movie\" VALUE=\"http://www.macromedia.com/software/flash/header_fl_main.swf\"> 
<param NAME=\"Src\" VALUE=\"http://www.macromedia.com/software/flash/header_fl_main.swf\"> 
<param NAME=\"WMode\" VALUE=\"Transparent\"> 
<param NAME=\"Play\" VALUE=\"-1\"> 
<param NAME=\"Loop\" VALUE=\"-1\"> 
<param NAME=\"Quality\" VALUE=\"High\"> 
<param NAME=\"SAlign\" VALUE> 
<param NAME=\"Menu\" VALUE=\"-1\"> 
<param NAME=\"Base\" VALUE> 
<param NAME=\"Scale\" VALUE=\"NoBorder\"> 
<param NAME=\"DeviceFont\" VALUE=\"0\"> 
<param NAME=\"EmbedMovie\" VALUE=\"0\"> 
<param NAME=\"BGColor\" VALUE=\"000000\"> 
<param NAME=\"SWRemote\" VALUE> 
<param NAME=\"Stacking\" VALUE=\"below\"><embed src=\"http://www.macromedia.com/software/flash/header_fl_main.swf\" loop=\"true\" quality=\"high\" scale=\"noborder\" wmode=\"transparent\" bgcolor=\"#000000\" WIDTH=\"500\" HEIGHT=\"45\" TYPE=\"application/x-shockwave-flash\" PLUGINSPAGE=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\"> 
</object> 
<br /></p><ul><li>You may also not use the loop param, and just post using the width and height params. for example <b>[flash width=500 height=45]</b>http://www.macromedia.com/software/flash/header_fl_main.swf<b>[/flash]</b> produces the same as not using the loop, except loop is set to a default value of, off.</li></ul><p>Make sure you use flash correctly otherwise you may end up with a mess (like the first flash posted), it is better to set the height and width params yourself. By param, we mean parameter which is just a value which makes it behave the way it does."); 

$faq[] = array("--", "Other matters");
$faq[] = array("Can I add my own tags?", "No, I am afraid not directly in this version. We are looking at offering customisable BBCode tags for the next major version.");

//
// This ends the BBCode guide entries
//

?>