#
# phpBB2 - MySQL schema
#
# $Id: mysql_schema.sql,v 1.35.2.7 2003/06/10 12:42:31 psotfx Exp $
#
# $FMId: 2003/08/13 20:52:00 mj
#

# --------------------------------------------------------
#
# Table structure for table 'phpbb_album'
#
CREATE TABLE phpbb_album (
   pic_id int(11) UNSIGNED NOT NULL auto_increment, 
   pic_filename varchar(255) NOT NULL, 
   pic_thumbnail varchar(255), 
   pic_title varchar(255) NOT NULL, 
   pic_user_id mediumint(8) NOT NULL, 
   pic_user_ip char(8) DEFAULT '0' NOT NULL, 
   pic_time int(11) UNSIGNED NOT NULL, 
   pic_cat_id mediumint(8) UNSIGNED DEFAULT '1' NOT NULL, 
   pic_view_count int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   pic_lock tinyint(3) DEFAULT '0' NOT NULL, 
   pic_username varchar(32), 
   pic_approval tinyint(3) DEFAULT '1' NOT NULL,
   pic_desc text, 
   PRIMARY KEY (pic_id), 
   KEY pic_cat_id(pic_cat_id), 
   KEY pic_user_id(pic_user_id), 
   KEY pic_time(pic_time)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_album_cat'
#
CREATE TABLE phpbb_album_cat (
   cat_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
   cat_title varchar(255) NOT NULL, 
   cat_desc TEXT, 
   cat_order mediumint(8) NOT NULL, 
   cat_view_level tinyint(3) DEFAULT '-1' NOT NULL, 
   cat_upload_level tinyint(3) DEFAULT '0' NOT NULL, 
   cat_rate_level tinyint(3) DEFAULT '0' NOT NULL, 
   cat_comment_level tinyint(3) DEFAULT '0' NOT NULL, 
   cat_edit_level tinyint(3) DEFAULT '0' NOT NULL, 
   cat_delete_level tinyint(3) DEFAULT '2' NOT NULL, 
   cat_moderator_groups varchar(255), 
   cat_approval tinyint(3) DEFAULT '0' NOT NULL,
   cat_view_groups varchar(255),
   cat_upload_groups varchar(255),
   cat_rate_groups varchar(255),
   cat_comment_groups varchar(255),
   cat_edit_groups varchar(255),
   cat_delete_groups varchar(255),
   PRIMARY KEY (cat_id), 
   KEY cat_order(cat_order)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_album_comment'
#
CREATE TABLE phpbb_album_comment (
   comment_id int(11) UNSIGNED NOT NULL auto_increment, 
   comment_pic_id int(11) UNSIGNED NOT NULL, 
   comment_user_id mediumint(8) NOT NULL, 
   comment_user_ip char(8) NOT NULL, 
   comment_time int(11) UNSIGNED NOT NULL, 
   comment_text TEXT, 
   comment_edit_time int(11) UNSIGNED, 
   comment_edit_count smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   comment_edit_user_id mediumint(8), 
   comment_username varchar(32),
   PRIMARY KEY (comment_id), 
   KEY comment_pic_id(comment_pic_id), 
   KEY comment_user_id(comment_user_id), 
   KEY comment_user_ip(comment_user_ip), 
   KEY comment_time(comment_time)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_album_config'
#
CREATE TABLE phpbb_album_config (
   config_name varchar(255) NOT NULL, 
   config_value varchar(255) NOT NULL, 
   PRIMARY KEY (config_name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_album_rate'
#
CREATE TABLE phpbb_album_rate (
   rate_pic_id int(11) UNSIGNED NOT NULL, 
   rate_user_id mediumint(8) NOT NULL, 
   rate_user_ip char(8) NOT NULL, 
   rate_point tinyint(3) UNSIGNED NOT NULL, 
   KEY rate_pic_id (rate_pic_id), 
   KEY rate_user_ip(rate_user_ip), 
   KEY rate_point(rate_point)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_attach_quota'
#
CREATE TABLE phpbb_attach_quota (
   user_id mediumint(8) UNSIGNED NOT NULL default '0',
   group_id mediumint(8) UNSIGNED NOT NULL default '0',
   quota_type smallint(2) NOT NULL default '0',
   quota_limit_id mediumint(8) UNSIGNED NOT NULL default '0',
   KEY quota_type (quota_type)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_attachments'
#
CREATE TABLE phpbb_attachments (
   attach_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   privmsgs_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   user_id_1 mediumint(8) NOT NULL,
   user_id_2 mediumint(8) NOT NULL,
   KEY attach_id_post_id (attach_id, post_id),
   KEY attach_id_privmsgs_id (attach_id, privmsgs_id)
); 


# --------------------------------------------------------
#
# Table structure for table 'phpbb_attachments_config'
#
CREATE TABLE phpbb_attachments_config (
   config_name varchar(255) NOT NULL,
   config_value varchar(255) NOT NULL,
   PRIMARY KEY (config_name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_attachments_desc'
#
CREATE TABLE phpbb_attachments_desc (
   attach_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   physical_filename varchar(255) NOT NULL,
   real_filename varchar(255) NOT NULL,
   download_count mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   comment varchar(255),
   extension varchar(100),
   mimetype varchar(100),
   filesize int(20) NOT NULL,
   filetime int(11) DEFAULT '0' NOT NULL,
   thumbnail tinyint(1) DEFAULT '0' NOT NULL,
   width smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   height smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   border tinyint(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (attach_id),
   KEY filetime (filetime),
   KEY physical_filename (physical_filename(10)),
   KEY filesize (filesize),
   INDEX (filetime),
   INDEX (physical_filename(10)),
   INDEX (filesize)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_auth_access'
#
CREATE TABLE phpbb_auth_access (
   group_id mediumint(8) DEFAULT '0' NOT NULL,
   forum_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   auth_view tinyint(1) DEFAULT '0' NOT NULL,
   auth_read tinyint(1) DEFAULT '0' NOT NULL,
   auth_post tinyint(1) DEFAULT '0' NOT NULL,
   auth_reply tinyint(1) DEFAULT '0' NOT NULL,
   auth_edit tinyint(1) DEFAULT '0' NOT NULL,
   auth_delete tinyint(1) DEFAULT '0' NOT NULL,
   auth_sticky tinyint(1) DEFAULT '0' NOT NULL,
   auth_announce tinyint(1) DEFAULT '0' NOT NULL,
   auth_vote tinyint(1) DEFAULT '0' NOT NULL,
   auth_pollcreate tinyint(1) DEFAULT '0' NOT NULL,
   auth_attachments tinyint(1) DEFAULT '0' NOT NULL,
   auth_mod tinyint(1) DEFAULT '0' NOT NULL,
   auth_download tinyint(1) DEFAULT '0' NOT NULL,
   auth_auth_suggest_events tinyint(2) DEFAULT '0' NOT NULL,
   auth_suggest_event tinyint(2) DEFAULT '0' NOT NULL,
   auth_ban tinyint(1) DEFAULT '0',
   auth_voteban tinyint(1) DEFAULT '0' NOT NULL,
   auth_greencard tinyint(1) DEFAULT '0',
   auth_bluecard tinyint(1) DEFAULT '0',
   KEY group_id (group_id),
   KEY forum_id (forum_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_bank'
#
CREATE TABLE phpbb_bank (
   id int UNSIGNED NOT NULL auto_increment, 
   name char(50) NOT NULL, 
   holding int(20) UNSIGNED DEFAULT '0', 
   totalwithdrew int(20) UNSIGNED DEFAULT '0', 
   totaldeposit int(20) UNSIGNED DEFAULT '0', 
   opentime int(20) UNSIGNED NOT NULL, 
   fees char(32) DEFAULT 'on' NOT NULL, 
   PRIMARY KEY (id), 
   INDEX(name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_banlist'
#
CREATE TABLE phpbb_banlist (
   ban_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   ban_userid mediumint(8) NOT NULL,
   user_name varchar(50) NOT NULL, 
   reason varchar(75) NOT NULL, 
   baned_by varchar(50) NOT NULL,
   date varchar(8) NOT NULL,
   time varchar(5) NOT NULL,
   ban_ip char(8) NOT NULL,
   ban_email varchar(255),
   ban_time int(11) default NULL,
   ban_expire_time int(11) default NULL,
   ban_by_userid mediumint(8) default NULL,
   ban_priv_reason text,
   ban_pub_reason_mode tinyint(1) default NULL,
   ban_pub_reason text,
   PRIMARY KEY (ban_id),
   KEY ban_ip_user_id (ban_ip, ban_userid)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_banner'
#
CREATE TABLE phpbb_banner (
    banner_id mediumint(8) UNSIGNED NOT NULL, 
    banner_name varchar(255) NOT NULL, 
    banner_spot smallint(1) UNSIGNED NOT NULL, 
    banner_forum mediumint(8) UNSIGNED NOT NULL, 
    banner_description varchar(255) NOT NULL, 
    banner_url varchar(255) NOT NULL, 
    banner_owner mediumint(8) NOT NULL, 
    banner_click mediumint(8) UNSIGNED NOT NULL, 
    banner_view mediumint(8) UNSIGNED NOT NULL, 
    banner_weigth tinyint(1) UNSIGNED DEFAULT '50' NOT NULL, 
    banner_active tinyint(1) NOT NULL, 
    banner_timetype tinyint(1) NOT NULL, 
    time_begin int(11) NOT NULL, 
    time_end int(11) NOT NULL, 
    date_begin int(11) NOT NULL, 
    date_end int(11) NOT NULL, 
    banner_level tinyint(1) NOT NULL,
    banner_level_type tinyint(1) NOT NULL,
    banner_comment varchar(100) NOT NULL, 
    INDEX (banner_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_cat_rel_cat_parents'
#
CREATE TABLE phpbb_cat_rel_cat_parents (
   cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0', 
   parent_cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0', 
   PRIMARY KEY (cat_id,parent_cat_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_cat_rel_forum_parents'
#
CREATE TABLE phpbb_cat_rel_forum_parents (
   cat_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0', 
   parent_forum_id smallint(5) UNSIGNED NOT NULL DEFAULT '0', 
   PRIMARY KEY (cat_id,parent_forum_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_categories'
#
CREATE TABLE phpbb_categories (
   cat_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   cat_title varchar(100),
   cat_order mediumint(8) UNSIGNED NOT NULL,
   cat_sponsor_img varchar(255) NOT NULL,
   cat_sponsor_alt varchar(255) NOT NULL,
   cat_sponsor_url varchar(255) NOT NULL,
   parent_forum_id smallint(5) UNSIGNED NOT NULL DEFAULT '0',
   cat_hier_level tinyint UNSIGNED NOT NULL DEFAULT '0',
   cat_icon varchar(255),
   PRIMARY KEY (cat_id),
   KEY cat_order (cat_order)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_config'
#
CREATE TABLE phpbb_config (
    config_name varchar(255) NOT NULL,
    config_value varchar(255) NOT NULL,
    PRIMARY KEY (config_name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_confirm'
#
CREATE TABLE phpbb_confirm (
  confirm_id char(32) DEFAULT '' NOT NULL,
  session_id char(32) DEFAULT '' NOT NULL,
  code char(6) DEFAULT '' NOT NULL, 
  PRIMARY KEY  (session_id,confirm_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_disallow'
#
CREATE TABLE phpbb_disallow (
   disallow_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   disallow_username varchar(25) DEFAULT '' NOT NULL,
   PRIMARY KEY (disallow_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_extension_groups'
#
CREATE TABLE phpbb_extension_groups (
   group_id mediumint(8) NOT NULL auto_increment,
   group_name char(20) NOT NULL,
   cat_id tinyint(2) DEFAULT '0' NOT NULL, 
   allow_group tinyint(1) DEFAULT '0' NOT NULL,
   download_mode tinyint(1) UNSIGNED DEFAULT '1' NOT NULL,
   upload_icon varchar(100) DEFAULT '',
   max_filesize int(20) DEFAULT '0' NOT NULL,
   forum_permissions varchar(255) DEFAULT '' NOT NULL,
   PRIMARY KEY group_id (group_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_extensions'
#
CREATE TABLE phpbb_extensions (
   ext_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   group_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   extension varchar(100) NOT NULL,
   comment varchar(100),
   PRIMARY KEY ext_id (ext_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_flags'
#
CREATE TABLE phpbb_flags (
   flag_id int(10) NOT NULL auto_increment,
   flag_name varchar(25),
   flag_image varchar(25),
   PRIMARY KEY (flag_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_albums'
#
CREATE TABLE phpbb_foing_albums (
   album_id mediumint(9) NOT NULL auto_increment,
   artist_id smallint(6) DEFAULT '0' NOT NULL,
   album_title varchar(96) DEFAULT '' NOT NULL,
   album_year int(4) default NULL,
   PRIMARY KEY (album_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_artist_desc'
#
CREATE TABLE phpbb_foing_artist_desc (
   artist_id mediumint(9) NOT NULL DEFAULT '0',
   artist_desc mediumint NOT NULL,
   PRIMARY KEY (artist_id),
   UNIQUE KEY artist_id (artist_id),
   KEY artist_id_2 (artist_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_artists'
#
CREATE TABLE phpbb_foing_artists (
   artist_id smallint(11) NOT NULL auto_increment,
   artist_name varchar(64) DEFAULT '' NOT NULL,
   artist_prefix varchar(16) DEFAULT '' NOT NULL,
   artist_url varchar(255) DEFAULT '' NOT NULL,
   PRIMARY KEY (artist_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_config'
#
CREATE TABLE phpbb_foing_config (
   config_name varchar(255) DEFAULT '' NOT NULL,
   config_value varchar(255) DEFAULT '' NOT NULL,
   PRIMARY KEY (config_name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_genres'
#
CREATE TABLE phpbb_foing_genres (
   genre_id int(3) DEFAULT '0' NOT NULL,
   genre_name varchar(32) DEFAULT '' NOT NULL,
   PRIMARY KEY (genre_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_playlist'
#
CREATE TABLE phpbb_foing_playlist (
   list_id mediumint(9) NOT NULL auto_increment,
   user_id mediumint(9) DEFAULT '0' NOT NULL,
   list_title varchar(64) DEFAULT '' NOT NULL,
   list_desc tinytext NOT NULL,
   list_pub int(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (list_id),
   KEY list_id (list_id)
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_playlist_data'
#
CREATE TABLE phpbb_foing_playlist_data (
   list_id mediumint(9) DEFAULT '0' NOT NULL,
   song_id mediumint(9) DEFAULT '0' NOT NULL
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_song_desc'
#
CREATE TABLE phpbb_foing_song_desc (
   song_id mediumint(9) NOT NULL default '0',
   song_desc mediumtext NOT NULL,
   PRIMARY KEY  (song_id),
   UNIQUE KEY song_id (song_id),
   KEY song_id_2 (song_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_songs'
#
CREATE TABLE phpbb_foing_songs (
   song_id mediumint(9) NOT NULL auto_increment,
   artist_id smallint(6) DEFAULT '0' NOT NULL,
   genre_id int(3) DEFAULT '0' NOT NULL,
   user_id mediumint(9) DEFAULT '0' NOT NULL,
   album_id mediumint(9) DEFAULT '0' NOT NULL,
   status_id int(1) DEFAULT '0' NOT NULL,
   song_title varchar(96) DEFAULT '' NOT NULL,
   song_url varchar(255) DEFAULT '' NOT NULL,
   song_quality int(3) DEFAULT '' NOT NULL,
   song_size varchar(16) DEFAULT '' NOT NULL,
   song_length mediumint(9) DEFAULT '0' NOT NULL,
   song_played bigint DEFAULT '0' NOT NULL,
   PRIMARY KEY (song_id)
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_foing_status'
#
CREATE TABLE phpbb_foing_status (
   status_id int(11) NOT NULL default '1',
   status_name varchar(32) NOT NULL default '',
   status_pub int(1) NOT NULL default '1',
   PRIMARY KEY  (status_id),
   UNIQUE KEY status_id (status_id),
   KEY status_id_2 (status_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_forbidden_extensions'
#
CREATE TABLE phpbb_forbidden_extensions (
   ext_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
   extension varchar(100) NOT NULL, 
   PRIMARY KEY (ext_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_forum_prune'
#
CREATE TABLE phpbb_forum_prune (
   prune_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   forum_id smallint(5) UNSIGNED NOT NULL,
   prune_days smallint(5) UNSIGNED NOT NULL,
   prune_freq smallint(5) UNSIGNED NOT NULL,
   PRIMARY KEY(prune_id),
   KEY forum_id (forum_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_forums'
#
CREATE TABLE phpbb_forums (
   forum_id smallint(5) UNSIGNED NOT NULL,
   cat_id mediumint(8) UNSIGNED NOT NULL,
   forum_name varchar(150),
   forum_desc text,
   forum_status tinyint(4) DEFAULT '0' NOT NULL,
   forum_order mediumint(8) UNSIGNED DEFAULT '1' NOT NULL,
   forum_posts mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_topics mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_views mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   forum_last_post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_hier_level tinyint UNSIGNED DEFAULT '0' NOT NULL, 
   forum_issub tinyint(1) DEFAULT '0' NOT NULL, 
   prune_next int(11),
   prune_enable tinyint(1) DEFAULT '0' NOT NULL,
   points_disabled tinyint(1) NOT NULL,
   auth_view tinyint(2) DEFAULT '0' NOT NULL,
   auth_read tinyint(2) DEFAULT '0' NOT NULL,
   auth_post tinyint(2) DEFAULT '0' NOT NULL,
   auth_reply tinyint(2) DEFAULT '0' NOT NULL,
   auth_edit tinyint(2) DEFAULT '0' NOT NULL,
   auth_delete tinyint(2) DEFAULT '0' NOT NULL,
   auth_sticky tinyint(2) DEFAULT '0' NOT NULL,
   auth_announce tinyint(2) DEFAULT '0' NOT NULL,
   auth_vote tinyint(2) DEFAULT '0' NOT NULL,
   auth_pollcreate tinyint(2) DEFAULT '0' NOT NULL,
   auth_attachments tinyint(2) DEFAULT '0' NOT NULL,
   auth_download tinyint(2) DEFAULT '0' NOT NULL,
   auth_suggest_event tinyint(2) DEFAULT '0' NOT NULL,
   is_default tinyint(2) DEFAULT '0' NOT NULL,
   events_forum tinyint(1) DEFAULT '0',
   auth_ban tinyint(2) DEFAULT '3',
   auth_voteban tinyint(2) DEFAULT '1' NOT NULL,
   auth_greencard tinyint(2) DEFAULT '5',
   auth_bluecard tinyint(2) DEFAULT '1',
   forum_icon varchar(255),
   PRIMARY KEY (forum_id),
   KEY forums_order (forum_order),
   KEY cat_id (cat_id),
   KEY forum_last_post_id (forum_last_post_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_forums_config'
#
CREATE TABLE phpbb_forums_config (
    config_name varchar(255) NOT NULL,
    config_value varchar(255) NOT NULL,
    PRIMARY KEY (config_name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_groups'
#
CREATE TABLE phpbb_groups (
   group_id mediumint(8) NOT NULL auto_increment,
   group_type tinyint(4) DEFAULT '1' NOT NULL,
   group_name varchar(40) NOT NULL,
   group_description varchar(255) NOT NULL,
   group_moderator mediumint(8) DEFAULT '0' NOT NULL,
   group_single_user tinyint(1) DEFAULT '1' NOT NULL,
   PRIMARY KEY (group_id),
   KEY group_single_user (group_single_user)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_ip'
#
CREATE TABLE phpbb_ip (
   id tinyint(4) NOT NULL auto_increment, 
   ip varchar(200) DEFAULT '0' NOT NULL, 
   host varchar(200) DEFAULT '0' NOT NULL, 
   date varchar(200) DEFAULT '0' NOT NULL, 
   username varchar(200) DEFAULT '0' NOT NULL, 
   referrer varchar(200) DEFAULT '0' NOT NULL, 
   forum varchar(200) DEFAULT '0' NOT NULL, 
   browser varchar(200) DEFAULT '0' NOT NULL, 
   KEY id(id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_links'
#
CREATE TABLE phpbb_links (
   link_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
   link_title varchar(255) DEFAULT '' NOT NULL, 
   link_desc varchar(255) DEFAULT NULL, 
   link_category mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   link_url varchar(100) DEFAULT '' NOT NULL, 
   link_logo_src varchar(100) DEFAULT NULL, 
   link_joined int(11) DEFAULT '0' NOT NULL, 
   link_active tinyint(1) DEFAULT '0' NOT NULL, 
   link_hits int(10) UNSIGNED DEFAULT '0' NOT NULL, 
   user_id mediumint(8) DEFAULT '0' NOT NULL, 
   user_ip varchar(8) DEFAULT '' NOT NULL, 
   last_user_ip varchar(8) DEFAULT '' NOT NULL, 
   PRIMARY KEY (link_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_links_cat'
#
CREATE TABLE phpbb_links_cat (
   id bigint(20) NOT NULL not null auto_increment, 
   name text NOT NULL, 
   hidden tinyint(2) NOT NULL DEFAULT '1', 
   owner mediumint(10) NOT NULL DEFAULT '0', 
   UNIQUE KEY id(id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_links_categories'
#
CREATE TABLE phpbb_links_categories (
   cat_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
   cat_title varchar(100) DEFAULT '' NOT NULL, 
   cat_order mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   PRIMARY KEY (cat_id), 
   KEY cat_order (cat_order)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_links_url'
#
CREATE TABLE phpbb_links_url (
   id bigint(20) NOT NULL auto_increment, 
   url text NOT NULL, 
   name text NOT NULL, 
   description text NOT NULL, 
   added int(11) default NULL, 
   owner mediumint(8) NOT NULL DEFAULT '0', 
   clickcounter int(12) NOT NULL DEFAULT '0', 
   lastclickid mediumint(8) NOT NULL DEFAULT '0', 
   lastclicktime int(11) NOT NULL DEFAULT '0', 
   bbcode_uid varchar(10) NOT NULL DEFAULT '', 
   enable_bbcode tinyint(1) NOT NULL DEFAULT '1', 
   UNIQUE KEY id(id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_links_urlincat'
#
CREATE TABLE phpbb_links_urlincat (
   id bigint(20) NOT NULL auto_increment, 
   url_id bigint(20) NOT NULL DEFAULT '0', 
   cat_id bigint(20) NOT NULL DEFAULT '0', 
   pos mediumint(10) NOT NULL DEFAULT '9999', 
   UNIQUE KEY id(id)
); 


# --------------------------------------------------------
#
# Table structure for table 'phpbb_logs'
#
CREATE TABLE phpbb_logs (
   id_log mediumint(10) DEFAULT '0' NOT NULL auto_increment, 
   mode varchar(50) DEFAULT '' NULL, 
   topic_id mediumint(10) DEFAULT '0' NULL, 
   user_id mediumint(8) DEFAULT '0' NULL, 
   username varchar(255) DEFAULT '' NULL, 
   user_ip char(8) DEFAULT '0' NOT NULL, 
   time INT(11) DEFAULT '0' NULL, 
   PRIMARY KEY(id_log)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_lottery'
#
CREATE TABLE phpbb_lottery (
   id int UNSIGNED NOT NULL auto_increment, 
   user_id int(20) NOT NULL, 
   PRIMARY KEY (id), 
   INDEX(user_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_module_admin_panel'
#
CREATE TABLE phpbb_module_admin_panel (
   module_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   config_name varchar(255) DEFAULT '' NOT NULL, 
   config_value varchar(255) DEFAULT '' NOT NULL, 
   config_type varchar(20) DEFAULT '' NOT NULL, 
   config_title varchar(100) DEFAULT '' NOT NULL, 
   config_explain varchar(100) default NULL, 
   config_trigger varchar(20) DEFAULT '' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_module_cache'
#
CREATE TABLE phpbb_module_cache (
   module_id mediumint(8) DEFAULT '0' NOT NULL, 
   module_cache_time int(12) DEFAULT '0' NOT NULL, 
   db_cache TEXT NOT NULL, 
   priority mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   PRIMARY KEY (module_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_module_group_auth'
#
CREATE TABLE phpbb_module_group_auth (
   module_id mediumint(8) UNSIGNED NOT NULL, 
   group_id mediumint(8) UNSIGNED NOT NULL 
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_module_info'
#
CREATE TABLE phpbb_module_info (
   module_id mediumint(8) DEFAULT '0' NOT NULL, 
   long_name varchar(100) DEFAULT '' NOT NULL, 
   author varchar(50) default NULL, 
   email varchar(50) default NULL, 
   url varchar(100) default NULL, 
   version varchar(10) DEFAULT '' NOT NULL, 
   update_site varchar(100) default NULL, 
   extra_info varchar(255) DEFAULT '' NOT NULL, 
   PRIMARY KEY (module_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_modules'
#
CREATE TABLE phpbb_modules (
   module_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
   short_name varchar(30) default NULL, 
   update_time mediumint(8) DEFAULT '0' NOT NULL, 
   module_order mediumint(8) DEFAULT '0' NOT NULL, 
   active tinyint(2) DEFAULT '0' NOT NULL,
   perm_all tinyint(2) UNSIGNED DEFAULT '1' NOT NULL, 
   perm_reg tinyint(2) UNSIGNED DEFAULT '1' NOT NULL, 
   perm_mod tinyint(2) UNSIGNED DEFAULT '1' NOT NULL, 
   perm_admin tinyint(2) UNSIGNED DEFAULT '1' NOT NULL, 
   PRIMARY KEY (module_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_mycalendar'
#
CREATE TABLE phpbb_mycalendar (
   cal_id int(12) NOT NULL auto_increment, 
   topic_id int(20) DEFAULT '0' NOT NULL,
   cal_date DATETIME DEFAULT '00-00-00 00:00:00' NULL,
   cal_interval tinyint(3) DEFAULT '1' NOT NULL,
   cal_interval_units enum('DAY', 'WEEK', 'MONTH', 'YEAR') DEFAULT 'DAY' NOT NULL,
   cal_repeat tinyint(3) DEFAULT '1' NOT NULL,
   forum_id int(5) DEFAULT '0' NOT NULL,
   confirmed enum( 'Y', 'N' ) DEFAULT 'Y' NOT NULL,
   event_type_id tinyint(4) DEFAULT '0' NOT NULL,
   PRIMARY KEY (cal_id),
   UNIQUE (topic_id)
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_mycalendar_event_types'
#
CREATE TABLE phpbb_mycalendar_event_types (
   forum_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   event_type_id tinyint(4) NOT NULL,
   event_type_text varchar(255) NOT NULL, 
   highlight_color VARCHAR(7) NOT NULL 
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_pa_cat'
#
CREATE TABLE phpbb_pa_cat (
  cat_id int(10) NOT NULL auto_increment,
  cat_name text,
  cat_desc text,
  cat_parent int(50) default NULL,
  parents_data text NOT NULL,
  cat_order int(50) default NULL,
  cat_allow_file tinyint(2) NOT NULL default '0',
  auth_view tinyint(2) NOT NULL default '0',
  auth_read tinyint(2) NOT NULL default '0',
  auth_view_file tinyint(2) NOT NULL default '0',
  auth_upload tinyint(2) NOT NULL default '0',
  auth_download tinyint(2) NOT NULL default '0',
  auth_rate tinyint(2) NOT NULL default '0',
  auth_email tinyint(2) NOT NULL default '0',
  auth_view_comment tinyint(2) NOT NULL default '0',
  auth_post_comment tinyint(2) NOT NULL default '0',
  auth_edit_comment tinyint(2) NOT NULL default '0',
  auth_delete_comment tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (cat_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_pa_comments'
#
CREATE TABLE phpbb_pa_comments (
   comments_id int(10) NOT NULL auto_increment, 
   file_id int(10) NOT NULL DEFAULT '0', 
   comments_text text NOT NULL, 
   comments_title text NOT NULL, 
   comments_time int(50) NOT NULL DEFAULT '0', 
   comment_bbcode_uid varchar(10) default NULL, 
   poster_id mediumint(8) NOT NULL DEFAULT '0', 
   PRIMARY KEY (comments_id), 
   FULLTEXT KEY comment_bbcode_uid (comment_bbcode_uid)
);


# --------------------------------------------------------
#
# Table structure for table `phpbb_pa_config`
#
CREATE TABLE phpbb_pa_config (
  config_name varchar(255) NOT NULL default '',
  config_value varchar(255) NOT NULL default '',
  PRIMARY KEY  (config_name)
);


# --------------------------------------------------------#
# Table structure for table 'phpbb_pa_custom'
#
CREATE TABLE phpbb_pa_custom (
   custom_id int(50) NOT NULL auto_increment, 
   custom_name text NOT NULL, 
   custom_description text NOT NULL, 
   data text NOT NULL,
   field_order int(20) NOT NULL default '0',
   field_type tinyint(2) NOT NULL default '0',
   regex varchar(255) NOT NULL default '',
   PRIMARY KEY (custom_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_pa_customdata'
#
CREATE TABLE phpbb_pa_customdata (
   customdata_file int(50) NOT NULL DEFAULT '0', 
   customdata_custom int(50) NOT NULL DEFAULT '0', 
   data text NOT NULL
);



# --------------------------------------------------------
#
# Table structure for table `phpbb_pa_download_info`
#
CREATE TABLE phpbb_pa_download_info (
  file_id mediumint(8) NOT NULL default '0',
  user_id mediumint(8) NOT NULL default '0',
  downloader_ip varchar(8) NOT NULL default '',
  downloader_os varchar(255) NOT NULL default '',
  downloader_browser varchar(255) NOT NULL default '',
  browser_version varchar(255) NOT NULL default ''
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_pa_files'
#
CREATE TABLE phpbb_pa_files (
  file_id int(10) NOT NULL auto_increment,
  user_id mediumint(8) NOT NULL default '0',
  poster_ip varchar(8) NOT NULL default '',
  file_name text,
  file_desc text,
  file_creator text,
  file_version text,
  file_longdesc text,
  file_ssurl text,
  file_sshot_link tinyint(2) NOT NULL default '0',
  file_dlurl text,
  file_time int(50) default NULL,
  file_update_time int(50) NOT NULL default '0',
  file_catid int(10) default NULL,
  file_posticon text,
  file_license int(10) default NULL,
  file_dls int(10) default NULL,
  file_last int(50) default NULL,
  file_pin int(2) default NULL,
  file_docsurl text,
  file_approved int(11) default NULL,
  PRIMARY KEY  (file_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_pa_license'
#
CREATE TABLE phpbb_pa_license (
   license_id int(10) NOT NULL auto_increment, 
   license_name text, 
   license_text text, 
   PRIMARY KEY (license_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_pa_votes'
#
CREATE TABLE phpbb_pa_votes (
  user_id mediumint(8) NOT NULL default '0',
  votes_ip varchar(50) NOT NULL default '0',
  votes_file int(50) NOT NULL default '0',
  rate_point tinyint(3) unsigned NOT NULL default '0',
  voter_os varchar(255) NOT NULL default '',
  voter_borwser varchar(255) NOT NULL default '',
  browser_version varchar(8) NOT NULL default '',
  KEY user_id (user_id),
  KEY votes_file (votes_file),
  KEY votes_ip (votes_ip),
  KEY voter_os (voter_os),
  KEY voter_borwser (voter_borwser),
  KEY browser_version (browser_version),
  KEY browser_version_2 (browser_version),
  KEY rate_point (rate_point)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_portal'
#
CREATE TABLE phpbb_portal (
   portal_id mediumint(8) NOT NULL auto_increment, 
   portal_order mediumint(8) NOT NULL, 
   portal_title varchar(60) NOT NULL, 
   portal_bbcode_id varchar(10) NOT NULL, 
   portal_use_url tinyint(1), 
   portal_use_iframe tinyint(1), 
   portal_forum mediumint(8) NOT NULL, 
   portal_url varchar(255) NOT NULL, 
   portal_list_limit mediumint(8) NOT NULL, 
   portal_ascending tinyint(1), 
   portal_nodate tinyint(1), 
   portal_navbar_name varchar(100) NOT NULL, 
   portal_newsfader tinyint(1),
   portal_column_width varchar(3) DEFAULT '200' NOT NULL,
   portal_navbar tinyint(1), 
   portal_moreover tinyint(1), 
   portal_calendar tinyint(1), 
   portal_online tinyint(1), 
   portal_onlinetoday tinyint(1), 
   portal_latest tinyint(1), 
   portal_latestx tinyint(1), 
   portal_latestxresponses tinyint(1), 
   portal_poll tinyint(1), 
   portal_polls tinyint(5) DEFAULT '1' NOT NULL, 
   portal_shoutbox tinyint(1), 
   portal_photo tinyint(1), 
   portal_birthday tinyint(6) DEFAULT '999999', 
   portal_search tinyint(1), 
   portal_quote tinyint(1), 
   portal_links tinyint(1), 
   portal_links_height varchar(4) DEFAULT '100' NOT NULL, 
   portal_ourlink tinyint(1), 
   portal_downloads tinyint(1), 
   portal_randomuser tinyint(1), 
   portal_mostpoints tinyint(1),
   portal_topposters tinyint(1),  
   portal_newusers tinyint(1), 
   portal_games tinyint(1),
   PRIMARY KEY(portal_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_posts'
#
CREATE TABLE phpbb_posts (
   post_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   topic_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   forum_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   poster_id mediumint(8) DEFAULT '0' NOT NULL,
   post_time int(11) DEFAULT '0' NOT NULL,
   poster_ip char(8) NOT NULL,
   post_username varchar(25),
   enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   enable_html tinyint(1) DEFAULT '0' NOT NULL,
   enable_smilies tinyint(1) DEFAULT '1' NOT NULL,
   enable_sig tinyint(1) DEFAULT '1' NOT NULL,
   post_edit_time int(11),
   post_edit_count smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   post_attachment TINYINT(1) DEFAULT '0' NOT NULL,
   post_edit_user mediumint(8) default NULL,
   post_icon tinyint(2) UNSIGNED DEFAULT '0' NOT NULL,
   post_bluecard tinyint(1),
   rating_rank_id smallint UNSIGNED NOT NULL,
   user_avatar varchar(100),
   user_avatar_type tinyint NOT NULL,
   PRIMARY KEY (post_id),
   KEY forum_id (forum_id),
   KEY topic_id (topic_id),
   KEY poster_id (poster_id),
   KEY post_time (post_time),
   KEY posts_ratingrankid (rating_rank_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_posts_text'
#
CREATE TABLE phpbb_posts_text (
   post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   bbcode_uid char(10) NOT NULL,
   post_subject varchar(120),
   post_text text,
   PRIMARY KEY (post_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_privmsgs'
#
CREATE TABLE phpbb_privmsgs (
   privmsgs_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   privmsgs_type tinyint(4) DEFAULT '0' NOT NULL,
   privmsgs_subject varchar(255) DEFAULT '0' NOT NULL,
   privmsgs_from_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_to_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_date int(11) DEFAULT '0' NOT NULL,
   privmsgs_ip char(8) NOT NULL,
   privmsgs_enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_enable_html tinyint(1) DEFAULT '0' NOT NULL,
   privmsgs_enable_smilies tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_attach_sig tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_attachment TINYINT(1) DEFAULT '0' NOT NULL,
   privmsgs_from_username varchar(25) DEFAULT '' NOT NULL,
   privmsgs_to_username varchar(25) DEFAULT '' NOT NULL,
   site_id mediumint(8) DEFAULT '0' NOT NULL,
   room_id mediumint(8) DEFAULT '0' NOT NULL,
   PRIMARY KEY (privmsgs_id),
   KEY privmsgs_from_userid (privmsgs_from_userid),
   KEY privmsgs_to_userid (privmsgs_to_userid),
   KEY room_id (room_id),
   KEY site_id (site_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_privmsgs_archive'
#
CREATE TABLE phpbb_privmsgs_archive (
   privmsgs_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   privmsgs_type tinyint(4) DEFAULT '0' NOT NULL,
   privmsgs_subject varchar(255) DEFAULT '0' NOT NULL,
   privmsgs_from_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_to_userid mediumint(8) DEFAULT '0' NOT NULL,
   privmsgs_date int(11) DEFAULT '0' NOT NULL,
   privmsgs_ip char(8) NOT NULL,
   privmsgs_enable_bbcode tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_enable_html tinyint(1) DEFAULT '0' NOT NULL,
   privmsgs_enable_smilies tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_attach_sig tinyint(1) DEFAULT '1' NOT NULL,
   privmsgs_attachment TINYINT(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (privmsgs_id),
   KEY privmsgs_from_userid (privmsgs_from_userid),
   KEY privmsgs_to_userid (privmsgs_to_userid)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_privmsgs_text'
#
CREATE TABLE phpbb_privmsgs_text (
   privmsgs_text_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   privmsgs_bbcode_uid char(10) DEFAULT '0' NOT NULL,
   privmsgs_text text,
   PRIMARY KEY (privmsgs_text_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_quota_limits'
#
CREATE TABLE phpbb_quota_limits (
   quota_limit_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   quota_desc varchar(20) NOT NULL default '',
   quota_limit bigint(20) UNSIGNED NOT NULL default '0',
   PRIMARY KEY  (quota_limit_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_ranks'
#
CREATE TABLE phpbb_ranks (
   rank_id smallint(5) UNSIGNED NOT NULL auto_increment,
   rank_title varchar(50) NOT NULL,
   rank_min mediumint(8) DEFAULT '0' NOT NULL,
   rank_special tinyint(1) DEFAULT '0',
   rank_image varchar(255),
   rank_reward int(11) UNSIGNED DEFAULT '0' NOT NULL,
   PRIMARY KEY (rank_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_rating_config'
#
CREATE TABLE phpbb_rating_config (
   label varchar(100) default NULL,
   num_value int UNSIGNED DEFAULT '0' NOT NULL,
   text_value varchar(255) default NULL,
   config_id int UNSIGNED DEFAULT '0' NOT NULL,
   input_type tinyint UNSIGNED DEFAULT '0' NOT NULL,
   list_order smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   PRIMARY KEY (config_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_rating_option'
#
CREATE TABLE phpbb_rating_option (
   option_id smallint UNSIGNED NOT NULL auto_increment,
   points tinyint NOT NULL DEFAULT '0',
   label varchar(100) default NULL,
   weighting smallint UNSIGNED NOT NULL DEFAULT '0',
   user_type tinyint UNSIGNED NOT NULL DEFAULT '0',
   PRIMARY KEY (option_id),
   KEY ratingoption_rating (points),
   KEY ratingoption_weighting (weighting)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_rating_rank'
#
CREATE TABLE phpbb_rating_rank (
   rating_rank_id smallint UNSIGNED NOT NULL auto_increment,
   type tinyint UNSIGNED NOT NULL DEFAULT '0',
   average_threshold tinyint NOT NULL DEFAULT '0',
   sum_threshold int NOT NULL DEFAULT '0',
   label varchar(100) default NULL,
   icon varchar(255) default NULL,
   user_rank int UNSIGNED NOT NULL,
   PRIMARY KEY (rating_rank_id),
   KEY ratingrank_type (type)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_rating'
#
CREATE TABLE phpbb_rating (
   post_id int UNSIGNED NOT NULL DEFAULT '0',
   user_id int UNSIGNED NOT NULL DEFAULT '0',
   rating_time int UNSIGNED NOT NULL DEFAULT '0',
   option_id smallint UNSIGNED NOT NULL DEFAULT '0',
   KEY rating_postid (post_id),
   KEY rating_userid (user_id),
   KEY rating_ratingoptionid (option_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_referral'
#
CREATE TABLE phpbb_referral (
   referral_id mediumint(8) UNSIGNED NOT NULL auto_increment, 
   ruid mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   nuid mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   referral_time varchar(10) DEFAULT '' NOT NULL, 
   KEY referraler_id(referral_id)
);


# --------------------------------------------------------
#
# Table structure for table `phpbb_search_results`
#
CREATE TABLE phpbb_search_results (
  search_id int(11) UNSIGNED NOT NULL default '0',
  session_id char(32) NOT NULL default '',
  search_array text NOT NULL,
  PRIMARY KEY  (search_id),
  KEY session_id (session_id)
);


# --------------------------------------------------------
#
# Table structure for table `phpbb_search_wordlist`
#
CREATE TABLE phpbb_search_wordlist (
  word_text varchar(50) binary NOT NULL default '',
  word_id mediumint(8) UNSIGNED NOT NULL auto_increment,
  word_common tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY (word_text),
  KEY word_id (word_id)
);


# --------------------------------------------------------
#
# Table structure for table `phpbb_search_wordmatch`
#
CREATE TABLE phpbb_search_wordmatch (
  post_id mediumint(8) UNSIGNED NOT NULL default '0',
  word_id mediumint(8) UNSIGNED NOT NULL default '0',
  title_match tinyint(1) NOT NULL default '0',
  KEY post_id (post_id),
  KEY word_id (word_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_serverload'
#
CREATE TABLE phpbb_serverload (
   time int(14) DEFAULT '0' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_sessions'
#
# Note that if you're running 3.23.x you may want to make
# this table a type HEAP. This type of table is stored
# within system memory and therefore for big busy boards
# is likely to be noticeably faster than continually
# writing to disk ...
#
CREATE TABLE phpbb_sessions (
   session_id char(32) DEFAULT '' NOT NULL,
   session_user_id mediumint(8) DEFAULT '0' NOT NULL,
   session_start int(11) DEFAULT '0' NOT NULL,
   session_time int(11) DEFAULT '0' NOT NULL,
   session_ip char(8) DEFAULT '0' NOT NULL,
   session_page int(11) DEFAULT '0' NOT NULL,
   session_topic int(11) NOT NULL,
   session_logged_in tinyint(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (session_id),
   KEY session_user_id (session_user_id),
   KEY session_id_ip_user_id (session_id, session_ip, session_user_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_shops'
#
CREATE TABLE phpbb_shops (
   id int UNSIGNED NOT NULL auto_increment, 
   shopname char(32) NOT NULL, 
   shoptype char(32) NOT NULL, 
   type char(32) NOT NULL, 
   restocktime int(20) UNSIGNED DEFAULT '86400', 
   restockedtime int(20) UNSIGNED DEFAULT '0', 
   restockamount int(4) UNSIGNED DEFAULT '5', 
   amountearnt int(20) UNSIGNED DEFAULT '0', 
   PRIMARY KEY (id), 
   INDEX(shopname)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_shop_items'
#
CREATE TABLE phpbb_shop_items (
   id int UNSIGNED NOT NULL auto_increment, 
   name char(32) NOT NULL, 
   shop char(32) NOT NULL, 
   sdesc char(80) NOT NULL, 
   ldesc text NOT NULL, 
   cost int(20) UNSIGNED DEFAULT '100', 
   startprice int(20) UNSIGNED DEFAULT '100', 
   raise int(20) UNSIGNED DEFAULT '100', 
   stock tinyint(3) UNSIGNED DEFAULT '10', 
   startstock tinyint(3) UNSIGNED DEFAULT '100',
   maxstock tinyint(3) UNSIGNED DEFAULT '100', 
   sold int(5) UNSIGNED DEFAULT '0' NOT NULL, 
   PRIMARY KEY (id), 
   INDEX(name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_shop_transactions'
#
CREATE TABLE phpbb_shop_transactions (
   shoptrans_date int(11) DEFAULT '0' NOT NULL, 
   trans_user varchar(25) DEFAULT '' NOT NULL, 
   trans_item varchar(25) DEFAULT '' NOT NULL, 
   trans_type varchar(25) DEFAULT '' NOT NULL, 
   trans_total mediumint(8) DEFAULT '0' NOT NULL, 
   PRIMARY KEY(shoptrans_date)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_smilies'
#
CREATE TABLE phpbb_smilies (
   smilies_id smallint(5) UNSIGNED NOT NULL auto_increment,
   code varchar(50),
   smile_url varchar(100),
   emoticon varchar(75),
   PRIMARY KEY (smilies_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_stats_config'
#
CREATE TABLE phpbb_stats_config (
   config_name varchar(100) DEFAULT '' NOT NULL, 
   config_value varchar(100) DEFAULT '' NOT NULL, 
   PRIMARY KEY (config_name)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_stats_smilies_index'
#
CREATE TABLE phpbb_stats_smilies_index (
   code varchar(50) default NULL, 
   smile_url varchar(100) default NULL, 
   smile_count mediumint(8) DEFAULT '0'
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_stats_smilies_info'
#
CREATE TABLE phpbb_stats_smilies_info (
   last_post_id mediumint(8) DEFAULT '0' NOT NULL, 
   last_update_time int(12) DEFAULT '0' NOT NULL, 
   update_time mediumint(8) DEFAULT '10080' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_subscriptions_list'
#
CREATE TABLE phpbb_subscriptions_list (
   user_id bigint, 
   forum bigint, 
   thread bigint
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_themes'
#
CREATE TABLE phpbb_themes (
   themes_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   template_name varchar(30) NOT NULL default '',
   style_name varchar(30) NOT NULL default '',
   head_stylesheet varchar(100) default NULL,
   body_background varchar(100) default NULL,
   body_bgcolor varchar(6) default NULL,
   body_text varchar(6) default NULL,
   body_link varchar(6) default NULL,
   body_vlink varchar(6) default NULL,
   body_alink varchar(6) default NULL,
   body_hlink varchar(6) default NULL,
   tr_color1 varchar(6) default NULL,
   tr_color2 varchar(6) default NULL,
   tr_color3 varchar(6) default NULL,
   tr_class1 varchar(25) default NULL,
   tr_class2 varchar(25) default NULL,
   tr_class3 varchar(25) default NULL,
   th_color1 varchar(6) default NULL,
   th_color2 varchar(6) default NULL,
   th_color3 varchar(6) default NULL,
   th_class1 varchar(25) default NULL,
   th_class2 varchar(25) default NULL,
   th_class3 varchar(25) default NULL,
   td_color1 varchar(6) default NULL,
   td_color2 varchar(6) default NULL,
   td_color3 varchar(6) default NULL,
   td_class1 varchar(25) default NULL,
   td_class2 varchar(25) default NULL,
   td_class3 varchar(25) default NULL,
   fontface1 varchar(50) default NULL,
   fontface2 varchar(50) default NULL,
   fontface3 varchar(50) default NULL,
   fontsize1 tinyint(4) default NULL,
   fontsize2 tinyint(4) default NULL,
   fontsize3 tinyint(4) default NULL,
   fontcolor1 varchar(6) default NULL,
   fontcolor2 varchar(6) default NULL,
   fontcolor3 varchar(6) default NULL,
   span_class1 varchar(25) default NULL,
   span_class2 varchar(25) default NULL,
   span_class3 varchar(25) default NULL,
   img_size_poll smallint(5) UNSIGNED,
   img_size_privmsg smallint(5) UNSIGNED,
   adminfontcolor varchar(6),
   supermodfontcolor varchar(6),
   modfontcolor varchar(6),
   PRIMARY KEY  (themes_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_themes_name'
#
CREATE TABLE phpbb_themes_name (
   themes_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   tr_color1_name char(50),
   tr_color2_name char(50),
   tr_color3_name char(50),
   tr_class1_name char(50),
   tr_class2_name char(50),
   tr_class3_name char(50),
   th_color1_name char(50),
   th_color2_name char(50),
   th_color3_name char(50),
   th_class1_name char(50),
   th_class2_name char(50),
   th_class3_name char(50),
   td_color1_name char(50),
   td_color2_name char(50),
   td_color3_name char(50),
   td_class1_name char(50),
   td_class2_name char(50),
   td_class3_name char(50),
   fontface1_name char(50),
   fontface2_name char(50),
   fontface3_name char(50),
   fontsize1_name char(50),
   fontsize2_name char(50),
   fontsize3_name char(50),
   fontcolor1_name char(50),
   fontcolor2_name char(50),
   fontcolor3_name char(50),
   span_class1_name char(50),
   span_class2_name char(50),
   span_class3_name char(50),
   adminfontcolor_name char(50),
   supermodfontcolor_name char(50),
   modfontcolor_name char(50),
   PRIMARY KEY (themes_id)
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_topic_view'
#
CREATE TABLE phpbb_topic_view (
   topic_id mediumint(8) NOT NULL, 
   user_id mediumint(8) NOT NULL, 
   view_time int(11) NOT NULL, 
   view_count int(11) NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_topics'
#
CREATE TABLE phpbb_topics (
   topic_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   forum_id smallint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_title char(120) NOT NULL,
   topic_poster mediumint(8) DEFAULT '0' NOT NULL,
   topic_time int(11) DEFAULT '0' NOT NULL,
   topic_views mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_replies mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_status tinyint(3) DEFAULT '0' NOT NULL,
   topic_vote tinyint(1) DEFAULT '0' NOT NULL,
   topic_type tinyint(3) DEFAULT '0' NOT NULL,
   topic_first_post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_last_post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   answer_status tinyint(1) UNSIGNED DEFAULT '0'  NOT NULL,
   topic_moved_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   topic_attachment tinyint(1) DEFAULT '0' NOT NULL,
   topic_icon tinyint(2) UNSIGNED DEFAULT '0' NOT NULL,
   rating_rank_id smallint UNSIGNED NOT NULL,
   PRIMARY KEY (topic_id),
   KEY forum_id (forum_id),
   KEY topic_moved_id (topic_moved_id),
   KEY topic_status (topic_status),
   KEY topic_type (topic_type),
   KEY topics_ratingrankid (rating_rank_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_topics_watch'
#
CREATE TABLE phpbb_topics_watch (
  topic_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  user_id mediumint(8) NOT NULL DEFAULT '0',
  notify_status tinyint(1) NOT NULL default '0',
  KEY topic_id (topic_id),
  KEY user_id (user_id),
  KEY notify_status (notify_status)
);


# --------------------------------------------------------
#
# Table structure for table 'toplist'
#
CREATE TABLE phpbb_toplist (
   id int(255) NOT NULL auto_increment, 
   nam varchar(255) NOT NULL DEFAULT '', 
   inf varchar(255) NOT NULL DEFAULT '', 
   hin int(255) NOT NULL DEFAULT '0', 
   lin varchar(255) NOT NULL DEFAULT '', 
   out int(255) NOT NULL DEFAULT '0', 
   img int(255) NOT NULL DEFAULT '0', 
   ban varchar(255) NOT NULL default 'http://', 
   owner int(255) NOT NULL DEFAULT '0', 
   tot int(255) NOT NULL DEFAULT '0', 
   imgfile varchar(50) NOT NULL default 'button1', 
   PRIMARY KEY (id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_transactions'
#
CREATE TABLE phpbb_transactions (
   trans_date int(11) DEFAULT '0' NOT NULL, 
   trans_from varchar(30) DEFAULT '' NOT NULL, 
   trans_to varchar(30) DEFAULT '' NOT NULL, 
   trans_amount mediumint(8) DEFAULT '0' NOT NULL, 
   trans_reason varchar(255) DEFAULT '' NOT NULL,
   PRIMARY KEY (trans_date)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_unique_hits'
#
CREATE TABLE phpbb_unique_hits (
   user_ip char(8) DEFAULT '0' not null, 
   time int(11) DEFAULT '0' not null, 
   INDEX (user_ip)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_user_group'
#
CREATE TABLE phpbb_user_group (
   group_id mediumint(8) DEFAULT '0' NOT NULL,
   user_id mediumint(8) DEFAULT '0' NOT NULL,
   user_pending tinyint(1),
   KEY group_id (group_id),
   KEY user_id (user_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_users'
#
CREATE TABLE phpbb_users (
   user_id mediumint(8) NOT NULL,
   user_active tinyint(1) DEFAULT '1',
   username varchar(25) NOT NULL,
   user_password varchar(32) NOT NULL,
   user_session_time int(11) DEFAULT '0' NOT NULL,
   user_session_page smallint(5) DEFAULT '0' NOT NULL,
   user_session_topic int(11) NOT NULL,
   user_lastvisit int(11) DEFAULT '0' NOT NULL,
   user_regdate int(11) DEFAULT '0' NOT NULL,
   user_level tinyint(4) DEFAULT '0',
   user_posts mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
   user_timezone decimal(5,2) DEFAULT '0' NOT NULL,
   user_style tinyint(4),
   user_lang varchar(255),
   user_dateformat varchar(14) DEFAULT 'd M Y H:i' NOT NULL,
   user_new_privmsg smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   user_unread_privmsg smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   user_last_privmsg int(11) DEFAULT '0' NOT NULL,
   user_emailtime int(11),
   user_viewemail tinyint(1),
   user_attachsig tinyint(1),
   user_allowhtml tinyint(1) DEFAULT '1',
   user_allowbbcode tinyint(1) DEFAULT '1',
   user_allowsmile tinyint(1) DEFAULT '1',
   user_allowavatar tinyint(1) DEFAULT '1' NOT NULL,
   user_allow_pm tinyint(1) DEFAULT '1' NOT NULL,
   user_allow_viewonline tinyint(1) DEFAULT '1' NOT NULL,
   user_notify tinyint(1) DEFAULT '1' NOT NULL,
   user_notify_pm tinyint(1) DEFAULT '0' NOT NULL,
   user_notify_donation tinyint(1) NOT NULL,
   user_popup_pm tinyint(1) DEFAULT '0' NOT NULL,
   user_sound_pm tinyint(1) DEFAULT '1' NOT NULL,
   user_rank int(11) DEFAULT '0',
   user_avatar varchar(100),
   user_avatar_type tinyint(4) DEFAULT '0' NOT NULL,
   user_email varchar(255),
   user_icq varchar(15),
   user_website varchar(100),
   user_from varchar(100),
   user_from_flag varchar(25) default NULL,
   user_sig text,
   user_sig_bbcode_uid char(10),
   user_aim varchar(255),
   user_yim varchar(255),
   user_msnm varchar(255),
   user_occ varchar(100),
   user_interests varchar(255),
   user_actkey varchar(32),
   user_newpasswd varchar(32),
   user_lastlogon int(11) DEFAULT '0',
   user_totaltime int(11) DEFAULT '0',
   user_totallogon smallint(5) DEFAULT '0',
   user_totalpages int(11) NOT NULL,
   user_birthday int DEFAULT '999999' NOT  NULL,
   user_next_birthday_greeting int DEFAULT '0' NOT NULL,
   user_gender tinyint DEFAULT '0' NOT NULL,
   user_photo varchar(100),
   user_photo_type tinyint(4) DEFAULT '0' NOT NULL,
   user_zipcode varchar(10),
   user_points int NOT NULL,
   user_items text,
   user_effects char(255),
   user_privs char(255),
   user_custitle text,
   user_specmsg text,
   user_warnings smallint(5) DEFAULT '0',
   rating_status tinyint UNSIGNED,
   avatar_sticky tinyint NOT NULL,
   user_money int(11) UNSIGNED DEFAULT '0' NOT NULL,
   user_profile_view smallint(5) UNSIGNED DEFAULT '0' NOT NULL,
   user_last_profile_view int(11) DEFAULT '0' NOT NULL,
   user_view_log tinyint DEFAULT '0' NOT NULL,
   user_votewarnings smallint(5) DEFAULT '0' NULL,
   PRIMARY KEY (user_id),
   KEY user_session_time (user_session_time)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_vote_desc'
#
CREATE TABLE phpbb_vote_desc (
  vote_id mediumint(8) UNSIGNED NOT NULL auto_increment,
  topic_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  vote_text text NOT NULL,
  vote_start int(11) NOT NULL DEFAULT '0',
  vote_length int(11) NOT NULL DEFAULT '0',
  vote_max int(2) NOT NULL DEFAULT '1',
  vote_voted int(7) DEFAULT '0' NOT NULL,
  PRIMARY KEY  (vote_id),
  KEY topic_id (topic_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_vote_results'
#
CREATE TABLE phpbb_vote_results (
  vote_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  vote_option_id tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  vote_option_text varchar(255) NOT NULL,
  vote_result int(11) NOT NULL DEFAULT '0',
  KEY vote_option_id (vote_option_id),
  KEY vote_id (vote_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_vote_voters'
#
CREATE TABLE phpbb_vote_voters (
  vote_id mediumint(8) UNSIGNED NOT NULL DEFAULT '0',
  vote_user_id mediumint(8) NOT NULL DEFAULT '0',
  vote_user_ip char(8) NOT NULL,
  vote_cast tinyint(4) UNSIGNED NOT NULL DEFAULT '0',
  KEY vote_id (vote_id),
  KEY vote_user_id (vote_user_id),
  KEY vote_user_ip (vote_user_ip)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_words'
#
CREATE TABLE phpbb_words (
   word_id mediumint(8) UNSIGNED NOT NULL auto_increment,
   word char(100) NOT NULL,
   replacement char(100) NOT NULL,
   PRIMARY KEY (word_id)
);

# --------------------------------------------------------
#
# Table structure for table 'shoutbox'
#
DROP TABLE IF EXISTS shoutbox;
CREATE TABLE shoutbox (
   id int(11) NOT NULL auto_increment, 
   name varchar(30) NOT NULL, 
   shout varchar(255) NOT NULL, 
   url varchar(100) NOT NULL, 
   timestamp int(10) UNSIGNED DEFAULT '0' NOT NULL, 
   ipaddress text NOT NULL, 
   PRIMARY KEY(id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_gk_data'
#
CREATE TABLE phpbb_gk_data (
   quiz_best_score int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_best_player varchar(25) default 'No Highscore' NOT NULL, 
   quiz_ts1 int(11) UNSIGNED DEFAULT '0' NOT NULL,
   quiz_ts2 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts3 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts4 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts5 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts6 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts7 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts8 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts9 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_ts10 int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_tn1 varchar(25) default '-:-' NOT NULL, 
   quiz_tn2 varchar(25) default '-:-' NOT NULL,
   quiz_tn3 varchar(25) default '-:-' NOT NULL,
   quiz_tn4 varchar(25) default '-:-' NOT NULL,
   quiz_tn5 varchar(25) default '-:-' NOT NULL,
   quiz_tn6 varchar(25) default '-:-' NOT NULL,
   quiz_tn7 varchar(25) default '-:-' NOT NULL,
   quiz_tn8 varchar(25) default '-:-' NOT NULL,
   quiz_tn9 varchar(25) default '-:-' NOT NULL,
   quiz_tn10 varchar(25) default '-:-' NOT NULL,
   last_payday smallint(11) UNSIGNED DEFAULT '0' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_gk_quiz'
#
CREATE TABLE phpbb_gk_quiz (
   quiz_topic_id smallint(5) UNSIGNED NOT NULL auto_increment, 
   quiz_topic_name varchar(255) default NULL, 
   quiz_topic_cost int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_topic_bonus mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_topic_img varchar(255) default NULL, 
   quiz_topic_total_qs smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_topic_desc varchar(255) default NULL, 
   PRIMARY KEY (quiz_topic_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_gk_quiz_as'
#
CREATE TABLE phpbb_gk_quiz_as (
   quiz_as_id smallint(5) UNSIGNED NOT NULL auto_increment, 
   quiz_as_name varchar(255) default NULL, 
   quiz_qs_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_id mediumint(9) DEFAULT '0' NOT NULL, 
   quiz_as_charge smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_as_reward smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_as_img varchar(255) default NULL, 
   quiz_as_correct tinyint(1) UNSIGNED DEFAULT '0' NOT NULL, 
   PRIMARY KEY(quiz_as_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_gk_quiz_qs'
#
CREATE TABLE phpbb_gk_quiz_qs (
   quiz_qs_id smallint(5) UNSIGNED NOT NULL auto_increment, 
   quiz_qs_name varchar(255) default NULL, 
   quiz_topic_id smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   quiz_qs_charge smallint(5) DEFAULT '0' NOT NULL, 
   quiz_qs_reward smallint(5) DEFAULT '0' NOT NULL, 
   quiz_qs_img varchar(255) default NULL, 
   PRIMARY KEY(quiz_qs_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_gk_quiz_quizers'
#
CREATE TABLE phpbb_gk_quiz_quizers (
   quiz_id int(11) UNSIGNED DEFAULT '0' NOT NULL, 
   user_id int(11) UNSIGNED DEFAULT '0' NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_im_prefs'
#
CREATE TABLE phpbb_im_prefs (
  user_id mediumint(8) NOT NULL default '0',
  user_allow_ims tinyint(1) NOT NULL default '0',
  user_allow_shout tinyint(1) NOT NULL default '1',
  user_allow_chat tinyint(1) NOT NULL default '1',
  attach_sig tinyint(1) NOT NULL default '0',
  admin_allow_ims tinyint(1) NOT NULL default '1',
  admin_allow_shout tinyint(1) NOT NULL default '1',
  admin_allow_chat tinyint(1) NOT NULL default '1',
  new_ims smallint(5) unsigned NOT NULL default '0',
  unread_ims smallint(5) unsigned NOT NULL default '0',
  read_ims smallint(5) unsigned NOT NULL default '0',
  total_sent mediumint(8) unsigned NOT NULL default '0',
  refresh_rate smallint(5) unsigned NOT NULL default '120',
  success_close tinyint(1) NOT NULL default '1',
  refresh_method tinyint(1) NOT NULL default '1',
  auto_launch tinyint(1) NOT NULL default '1',
  popup_ims tinyint(1) NOT NULL default '1',
  list_ims tinyint(1) NOT NULL default '0',
  show_controls tinyint(1) NOT NULL default '1',
  list_all_online tinyint(1) NOT NULL default '1',
  win_main_height varchar(4) NOT NULL default '400',
  win_main_width varchar(4) NOT NULL default '225',
  win_online_height varchar(4) NOT NULL default '225',
  win_online_width varchar(4) NOT NULL default '400',
  win_read_height varchar(4) NOT NULL default '225',
  win_read_width varchar(4) NOT NULL default '400',
  win_send_height varchar(4) NOT NULL default '365',
  win_send_width varchar(4) NOT NULL default '460',
  play_sound tinyint(1) NOT NULL default '1',
  default_sound tinyint(1) NOT NULL default '1',
  sound_name varchar(255) default NULL,
  themes_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL,
  user_allow_s2s tinyint(1) NOT NULL default '1',
  admin_allow_s2s tinyint(1) NOT NULL default '1',
  s2s_user_list tinyint(1) NOT NULL default '1',
  open_pms tinyint(1) NOT NULL default '0',
  auto_delete tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (user_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_im_buddy_list'
#
CREATE TABLE phpbb_im_buddy_list (
  user_id mediumint(8) NOT NULL default '0',
  buddy_id mediumint(8) NOT NULL default '0',
  user_ignore tinyint(1) NOT NULL default '0',
  alert tinyint(1) NOT NULL default '0',
  alert_status tinyint(1) NOT NULL default '0',
  disallow tinyint(1) NOT NULL default '0',
  KEY buddy_id (buddy_id),
  KEY user_id (user_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_im_sitetosite'
#
CREATE TABLE phpbb_im_sitetosite (
   site_id mediumint(8) NOT NULL auto_increment,
   site_name varchar(50) NOT NULL,
   site_url varchar(100) NOT NULL,
   site_phpex varchar(4) DEFAULT 'php' NOT NULL,
   site_ppu varchar(15) DEFAULT 'p' NOT NULL,
   site_puu varchar(15) DEFAULT 'u' NOT NULL,
   site_profile varchar(50) DEFAULT 'profile' NOT NULL,
   PRIMARY KEY (site_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_im_sessions'
#
CREATE TABLE phpbb_im_sessions (
   session_user_id mediumint(8) DEFAULT '0' NOT NULL,
   session_id char(32) DEFAULT '' NOT NULL,
   session_time int(11) DEFAULT '0' NOT NULL,
   session_popup tinyint(1) DEFAULT '0' NOT NULL,
   PRIMARY KEY (session_id),
   KEY session_user_id (session_user_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_charts'
#
CREATE TABLE phpbb_charts (
   chart_id mediumint(8) NOT NULL auto_increment, 
   chart_song_name varchar(100) NOT NULL, 
   chart_artist varchar(100) NOT NULL, 
   chart_album varchar(100) DEFAULT '',
   chart_label VARCHAR(100) NOT NULL,
   chart_catno VARCHAR(50) NOT NULL,
   chart_website VARCHAR(100) NOT NULL,
   chart_poster_id varchar(100) NOT NULL,
   chart_hot mediumint(8) DEFAULT '0', 
   chart_not mediumint(8) DEFAULT '0', 
   chart_curr_pos mediumint(8) DEFAULT '0', 
   chart_last_pos mediumint(8) DEFAULT '0', 
   chart_best_pos mediumint(8) DEFAULT '0', 
   PRIMARY KEY (chart_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_charts_voters'
#
CREATE TABLE phpbb_charts_voters (
   vote_id mediumint(8) NOT NULL auto_increment, 
   vote_user_id mediumint(8) NOT NULL, 
   vote_chart_id mediumint(8) NOT NULL, 
   vote_rate smallint(2) NOT NULL, 
   PRIMARY KEY (vote_id), 
   FOREIGN KEY (vote_chart_id) REFERENCES phpbb_charts(chart_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_config_nav'
#
CREATE TABLE phpbb_config_nav (
   config_name varchar(255), 
   config_value varchar(255)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_kb_articles'
#
CREATE TABLE phpbb_kb_articles (
   article_id tinyint(4) NOT NULL auto_increment, 
   article_category_id tinyint(4) NOT NULL, 
   article_title varchar(255) NOT NULL, 
   article_description varchar(255) NOT NULL, 
   article_date varchar(255) NOT NULL, 
   article_author_id mediumint(8) NOT NULL, 
   bbcode_uid varchar(10) NOT NULL, 
   article_body text NOT NULL, 
   article_type tinyint(4) NOT NULL, 
   article_keywords varchar(255) NOT NULL, 
   approved tinyint(1) DEFAULT "0" NOT NULL, 
   topic_link varchar(255) DEFAULT "" NOT NULL,
   UNIQUE article_id (article_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_kb_categories'
#
CREATE TABLE phpbb_kb_categories (
   category_id tinyint(3) NOT NULL auto_increment, 
   category_name varchar(255) NOT NULL, 
   category_details varchar(255) NOT NULL, 
   number_articles tinyint(3) NOT NULL, 
   UNIQUE category_id (category_id)
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_kb_config'
#
CREATE TABLE phpbb_kb_config (
   config_name varchar(255), 
   config_value varchar(255)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_kb_types'
#
CREATE TABLE phpbb_kb_types (
   id int(4) NOT NULL auto_increment, 
   type varchar(255) DEFAULT "0" NOT NULL, 
   UNIQUE KEY id (id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_users_comments'
#
CREATE TABLE phpbb_users_comments (
   comment_id mediumint(8) auto_increment NOT NULL, 
   user_id mediumint(8) NOT NULL, 
   poster_id mediumint(8) NOT NULL, 
   comments text NOT NULL, 
   time int (11) default NULL,
   PRIMARY KEY (comment_id) 
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_posts_edit'
#
CREATE TABLE phpbb_posts_edit (
   post_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   user_id mediumint(8) UNSIGNED DEFAULT '0' NOT NULL, 
   post_edit_count smallint(5) UNSIGNED DEFAULT '0' NOT NULL, 
   post_edit_time INT(11) default NULL, 
   KEY (post_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_profile_view'
#
CREATE TABLE phpbb_profile_view(
   user_id mediumint(8) NOT NULL,
   viewername varchar(255) NOT NULL,
   viewer_id mediumint(8) NOT NULL,
   view_stamp int(11) NOT NULL, 
   counter mediumint(8) NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_chatbox'
#
CREATE TABLE phpbb_chatbox(
   id int(11) NOT NULL auto_increment,
   name varchar(99) NOT NULL,
   msg varchar(255) NOT NULL,
   timestamp int(10) unsigned NOT NULL,
   PRIMARY KEY (id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_chatbox_session'
#
CREATE TABLE phpbb_chatbox_session (
   username varchar(99) NOT NULL,
   lastactive int(10) DEFAULT '0' NOT NULL,
   laststatus varchar(8) NOT NULL,
   UNIQUE username (username)
); 



# --------------------------------------------------------
#
# Table structure for table 'phpbb_referers'
#
CREATE TABLE phpbb_referers ( 
    referer_id mediumint(8) UNSIGNED NOT NULL auto_increment,
    referer_http varchar(255) NOT NULL default '', 
    referer_hits int(10) NOT NULL default '1',
    referer_firstvisit int(11) DEFAULT '0' NOT NULL,
    referer_lastvisit int(11) DEFAULT '0' NOT NULL,
    PRIMARY KEY (referer_id)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_link_config'
#
CREATE TABLE phpbb_link_config (
   config_name varchar(255) NOT NULL, 
   config_value varchar(255) NOT NULL
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_logs_config'
#
CREATE TABLE phpbb_logs_config (
   config_name varchar(255) NOT NULL, 
   config_value varchar(255) NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_news'
#
CREATE TABLE phpbb_news (
   config_name varchar(255) NOT NULL, 
   config_value varchar(255) NOT NULL
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_banvote_voters'
#
CREATE TABLE phpbb_banvote_voters (
   banvote_user_id mediumint(8) DEFAULT '0' NOT NULL, 
   banvote_banner_id mediumint(8) DEFAULT '0' NOT NULL
);

# --------------------------------------------------------
#
# Table structure for table 'phpbb_lottery_winner'
#
CREATE TABLE phpbb_lottery_winner (
  win_date int(11) NOT NULL default '0',
  winner_name varchar(25) NOT NULL default '',
  prize_amount varchar(25) NOT NULL default '',
  PRIMARY KEY (win_date)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_topics_viewdata'
#
CREATE TABLE phpbb_topics_viewdata (
  viewed_id int(10) unsigned NOT NULL auto_increment,
  user_id mediumint(9) NOT NULL default '0',
  topic_id mediumint(8) unsigned NOT NULL default '0',
  num_views tinyint(3) unsigned NOT NULL default '1',
  last_viewed int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (viewed_id),
  KEY user_id (user_id,topic_id),
  KEY last_viewed (last_viewed)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_forums_watch'
#
CREATE TABLE phpbb_forums_watch (
   forum_id mediumint(8) unsigned NOT NULL default '0', 
   user_id mediumint(8) NOT NULL default '0', 
   notify_status tinyint(1) NOT NULL default '0', 
   KEY forum_id (forum_id), 
   KEY user_id (user_id), 
   KEY notify_status (notify_status)
);


# --------------------------------------------------------
#
# Table structure for table 'phpbb_advance_html'
#
CREATE TABLE phpbb_advance_html (
   config_name varchar(255) NOT NULL default '', 
   config_value longtext NOT NULL
);
