<?php
/***************************************************************************
 *                                index.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: index.php,v 1.99.2.1 2002/12/19 17:17:40 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/13 17:36:45 mj 
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
require_once($phpbb_root_path . 'chatbox_front.php');
include($phpbb_root_path . 'lgf-reflog.'.$phpEx);
include($phpbb_root_path . 'referers.'.$phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx); 

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

//
// Include language file
//
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_main_link.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_main_link.' . $phpEx);

if( $userdata['session_logged_in'] ) 
{ 
	$sql = "SELECT COUNT(post_id) as total 
		FROM " . POSTS_TABLE . " 
		WHERE post_time >= " . $userdata['user_lastvisit'] . " 
		AND poster_id != " . $userdata['user_id']; 

	$result = $db->sql_query($sql); 
	if( $result ) 
	{ 
		$row = $db->sql_fetchrow($result); 
		$lang['Search_new'] = $lang['Search_new'] . " (" . $row['total'] . ")"; 
	} 
} 

$viewcat = ( !empty($HTTP_GET_VARS[POST_CAT_URL]) ) ? $HTTP_GET_VARS[POST_CAT_URL] : -1;
$hierarchie_level = ( !empty($HTTP_GET_VARS[POST_HIERARCHIE_URL]) ) ? $HTTP_GET_VARS[POST_HIERARCHIE_URL] : 0;
$parent_forum = ( !empty($HTTP_GET_VARS[POST_PARENTFORUM_URL]) ) ? $HTTP_GET_VARS[POST_PARENTFORUM_URL] : 0;

if( isset($HTTP_GET_VARS['mark']) || isset($HTTP_POST_VARS['mark']) )
{
	$mark_read = ( isset($HTTP_POST_VARS['mark']) ) ? $HTTP_POST_VARS['mark'] : $HTTP_GET_VARS['mark'];
}
else
{
	$mark_read = '';
}

//
// Handle marking posts
//
if( $mark_read == 'forums' )
{
	if( $userdata['session_logged_in'] )
	{
		setcookie($board_config['cookie_name'] . '_f_all', time(), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
	}

	$template->assign_vars(array(
		"META" => '<meta http-equiv="refresh" content="300;url='  .append_sid("index.$phpEx") . '">')
	);

	$message = $lang['Forums_marked_read'] . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a> ');

	message_die(GENERAL_MESSAGE, $message);
}
//
// End handle marking posts
//

$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_t"]) : array();
$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . "_f"]) : array();

//
// If you don't use these stats on your index you may want to consider
// removing them
//
$total_posts = get_db_stat('postcount');
$total_topics = get_db_stat('topiccount');
$total_users = get_db_stat('usercount');
$newest_userdata = get_db_stat('newestuser');
$newest_user = $newest_userdata['username'];
$newest_uid = $newest_userdata['user_id'];

if( $total_posts == 0 )
{
	$l_total_post_s = $lang['Posted_articles_zero_total'];
}
else if( $total_posts == 1 )
{
	$l_total_post_s = $lang['Posted_article_total'];
}
else
{
	$l_total_post_s = $lang['Posted_articles_total'];
}

if( $total_users == 0 )
{
	$l_total_user_s = $lang['Registered_users_zero_total'];
}
else if( $total_users == 1 )
{
	$l_total_user_s = $lang['Registered_user_total'];
}
else
{
	$l_total_user_s = $lang['Registered_users_total'];
}


//
// Start page proper
//
$sql = "SELECT c.*
	FROM " . CATEGORIES_TABLE . " c 
      WHERE c.cat_hier_level = " . $hierarchie_level . "
      AND c.parent_forum_id = " . $parent_forum . "
	ORDER BY c.cat_order";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query categories list', '', __LINE__, __FILE__, $sql);
}

while( $category_rows[] = $db->sql_fetchrow($result) );

if( ( $total_categories = count($category_rows) ) )
{
	//
	// Define appropriate SQL
	//
	switch(SQL_LAYER)
	{
		case 'postgresql':
			$sql = "SELECT f.*, p.post_time, p.post_username, u.username, u.user_id 
				FROM " . FORUMS_TABLE . " f, " . POSTS_TABLE . " p, " . USERS_TABLE . " u
				WHERE p.post_id = f.forum_last_post_id 
					AND u.user_id = p.poster_id  
					UNION (
						SELECT f.*, NULL, NULL, NULL, NULL
						FROM " . FORUMS_TABLE . " f
						WHERE NOT EXISTS (
							SELECT p.post_time
							FROM " . POSTS_TABLE . " p
							WHERE p.post_id = f.forum_last_post_id  
						)
					)
					ORDER BY cat_id, forum_order";
			break;

		case 'oracle':
			$sql = "SELECT f.*, p.post_time, p.post_username, u.username, u.user_id 
				FROM " . FORUMS_TABLE . " f, " . POSTS_TABLE . " p, " . USERS_TABLE . " u
				WHERE p.post_id = f.forum_last_post_id(+)
					AND u.user_id = p.poster_id(+)
				ORDER BY f.cat_id, f.forum_order";
			break;

		default:
			$sql = "SELECT f.*, p.post_time, p.post_username, u.username, u.user_id, t.topic_title, t.topic_last_post_id " .
				" FROM ((( " . FORUMS_TABLE . " f " .
				" LEFT JOIN " . POSTS_TABLE . " p ON p.post_id = f.forum_last_post_id )" .
				" LEFT JOIN " . USERS_TABLE . " u ON u.user_id = p.poster_id ) " .
				" LEFT JOIN " . TOPICS_TABLE . " t ON t.topic_last_post_id = p.post_id ) " .
				" ORDER BY f.cat_id, f.forum_order";
			break;
	}
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forums information', '', __LINE__, __FILE__, $sql);
	}

	$forum_data = array();
	$topic_last_ary = array();
	$i=0;
	while( $row = $db->sql_fetchrow($result) )
	{
		if (!in_array($row['topic_last_post_id'], $topic_last_ary) || $row['topic_last_post_id']==0) {
			$topic_last_ary[i]=$row['topic_last_post_id'];
			$i++;
			$forum_data[] = $row;
		}
	}
	unset($topic_last_ary);
	if ( !($total_forums = count($forum_data)) )
	{
		message_die(GENERAL_MESSAGE, $lang['No_forums']);
	}
	
	//
	// Filter topic_title not allowed to read
	// 
	if ( !($userdata['user_level'] == ADMIN && $userdata['session_logged_in']) ) {
		$auth_read_all = array();
		$auth_read_all=auth(AUTH_READ, AUTH_LIST_ALL, $userdata, $forum_data);
		$auth_data = '';
		for($i=0; $i<count($forum_data); $i++)
		{
			if (!$auth_read_all[$forum_data[$i]['forum_id']]['auth_read']) {
				$forum_data[$i]['topic_title']='';
			}
		}
	}

	//
	// Define censored word matches
	//
	$orig_word = array();
	$replacement_word = array();
	obtain_word_list($orig_word, $replacement_word);

	//
	// Obtain a list of topic ids which contain
	// posts made since user last visited
	//
	if ( $userdata['session_logged_in'] )
	{
		$sql = "SELECT t.forum_id, t.topic_id, p.post_time 
			FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p 
			WHERE p.post_id = t.topic_last_post_id 
				AND p.post_time > " . $userdata['user_lastvisit'] . " 
				AND t.topic_moved_id = 0"; 
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query new topic information', '', __LINE__, __FILE__, $sql);
		}

		$new_topic_forum_ids = '';
		$new_topic_data = array();
		while( $topic_data = $db->sql_fetchrow($result) )
		{
			$new_topic_forum_ids .= ", " . $topic_data['forum_id'] . " ";
			$new_topic_data[$topic_data['forum_id']][$topic_data['topic_id']] = $topic_data['post_time'];
		}

		//
		// Now we go and get all forums superior to the result above, but do it only if its necassary
		// 
		if(strlen($new_topic_forum_ids) > 0)
		{
			$new_topic_forum_ids = substr($new_topic_forum_ids, 1);
		
			$sql = "SELECT f.forum_id, cfp.parent_forum_id
				FROM " . FORUMS_TABLE . " f, " . CAT_REL_FORUM_PARENTS_TABLE . " cfp
				WHERE f.forum_id IN (" . $new_topic_forum_ids . ")
					AND f.cat_id = cfp.cat_id"; 

			if ( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query superior forums of new topic information', '', __LINE__, __FILE__, $sql);
			}

			while( $topic_data = $db->sql_fetchrow($result) )
			{
				$pfid = $topic_data['parent_forum_id'];
				$fid = $topic_data['forum_id'];
				foreach ($new_topic_data[$fid] as $key => $value) {
				$new_topic_data[$pfid][$key] = $value;
				}
				reset($new_topic_data[$fid]);
			}
		}
	}

	//
	// Obtain list of moderators of each forum
	// First users, then groups ... broken into two queries
	//
	$sql = "SELECT aa.forum_id, u.user_id, u.username 
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g, " . USERS_TABLE . " u
		WHERE aa.auth_mod = " . TRUE . " 
			AND g.group_single_user = 1 
			AND ug.group_id = aa.group_id 
			AND g.group_id = aa.group_id 
			AND u.user_id = ug.user_id 
		GROUP BY u.user_id, u.username, aa.forum_id 
		ORDER BY aa.forum_id, u.user_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
	}

	$forum_moderators = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_moderators[$row['forum_id']][] = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '">' . $row['username'] . '</a>';
	}

	$sql = "SELECT aa.forum_id, g.group_id, g.group_name 
		FROM " . AUTH_ACCESS_TABLE . " aa, " . USER_GROUP_TABLE . " ug, " . GROUPS_TABLE . " g 
		WHERE aa.auth_mod = " . TRUE . " 
			AND g.group_single_user = 0 
			AND g.group_type <> " . GROUP_HIDDEN . "
			AND ug.group_id = aa.group_id 
			AND g.group_id = aa.group_id 
		GROUP BY g.group_id, g.group_name, aa.forum_id 
		ORDER BY aa.forum_id, g.group_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query forum moderator information', '', __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		$forum_moderators[$row['forum_id']][] = '<a href="' . append_sid("groupcp.$phpEx?" . POST_GROUPS_URL . "=" . $row['group_id']) . '">' . $row['group_name'] . '</a>';
	}

	//
	// Find which forums are visible for this user
	//
	$is_auth_ary = array();
	$is_auth_ary = auth(AUTH_VIEW, AUTH_LIST_ALL, $userdata, $forum_data);

	//
	// Links
	//
	$sql = "SELECT *
		FROM ". LINK_CONFIG_TABLE;
	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query Link config information", "", __LINE__, __FILE__, $sql);
	}
	
	while( $row = $db->sql_fetchrow($result) )
	{
		$link_config_name = $row['config_name'];
		$link_config_value = $row['config_value'];
		$link_config[$link_config_name] = $link_config_value;
		$link_self_img = $link_config['site_logo'];
		$site_logo_height = $link_config['height'];
		$site_logo_width = $link_config['width'];
	}

	//
	// Use different body-templates for the main and the subpages
	//
	if( $hierarchie_level == 0 )
		$index_body_fn = 'index_body.tpl';
	else
		$index_body_fn = 'index_body_sub.tpl';

	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

	//
	// Show daily users
	//
	$time_now=time();
	$time1Hour=$time_now-3600;
	$minutes = date('is', $time_now);
	$hour_now = $time_now - (60*($minutes[0].$minutes[1])) - ($minutes[2].$minutes[3]); 
	$dato=create_date('H', $time_now,$board_config['board_timezone']);
	$timetoday = $hour_now - (3600*$dato); 
	$sql = 'SELECT session_ip, MAX(session_time) as session_time FROM '.SESSIONS_TABLE.' WHERE session_user_id="'.ANONYMOUS.'" AND session_time >= '.$timetoday.' AND session_time< '.($timetoday+86399).' GROUP BY session_ip';
	if (!$result = $db->sql_query($sql)) message_die(GENERAL_ERROR, "Couldn't retrieve guest user today data", "", __LINE__, __FILE__, $sql); 
	while( $guest_list = $db->sql_fetchrow($result))
	{ 
		if ($guest_list['session_time'] >$time1Hour) $users_lasthour++;
	}
	$guests_today = $db->sql_numrows($result);
	$sql = 'SELECT user_id, username, user_allow_viewonline, user_level, user_lastlogon FROM ' . USERS_TABLE . ' WHERE user_id!="'.ANONYMOUS.'" AND user_session_time >= '.$timetoday.' AND user_session_time< '.($timetoday+86399).' ORDER BY username'; 
	if (!$result = $db->sql_query($sql)) message_die(GENERAL_ERROR, "Couldn't retrieve user today data", "", __LINE__, __FILE__, $sql); 
	while( $todayrow = $db->sql_fetchrow($result)) 
	{ 
		$style_color = ""; 
		if ($todayrow['user_lastlogon']>=$time1Hour)
		{
			$users_lasthour++;
		}
		switch ($todayrow['user_level'])
		{
			case ADMIN :
			      $todayrow['username'] = '<b>' . $todayrow['username'] . '</b>'; 
	      		$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
				break;
			case LESS_ADMIN :
			      $todayrow['username'] = '<b>' . $todayrow['username'] . '</b>'; 
	      		$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
				break;
			case MOD :
			      $todayrow['username'] = '<b>' . $todayrow['username'] . '</b>'; 
	      		$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
				break;
		}
	 	$users_today_list.=( $todayrow['user_allow_viewonline'])?' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $todayrow['user_id']) . '"' . $style_color .' class="gensmall">' . $todayrow['username'] . '</a>,' : (($userdata[user_level]==ADMIN) ? ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $todayrow['user_id']) . '"' . $style_color .' class="gensmall"><i>' . $todayrow['username'] . '</i></a>,' : '');
		if (!$todayrow['user_allow_viewonline']) $logged_hidden_today++;
		else $logged_visible_today++;
	}
	if ($users_today_list) 
	{
		$users_today_list[ strlen( $users_today_list)-1] = ' '; 
	} else
	{
		$users_today_list = $lang['None'];
	}
	$total_users_today = $db->sql_numrows($result)+$guests_today;
	
	$users_today_list = $lang['Registered_users'].' ' . $users_today_list;
	$l_today_user_s = ($total_users_today) ? ( ( $total_users_today == 1 )? $lang['User_today_total'] : $lang['Users_today_total'] ) : $lang['Users_today_zero_total'];
	$l_today_r_user_s = ($logged_visible_today) ? ( ( $logged_visible_today == 1 ) ? $lang['Reg_user_total'] : $lang['Reg_users_total'] ) : $lang['Reg_users_zero_total'];
	$l_today_h_user_s = ($logged_hidden_today) ? (($logged_hidden_today == 1) ? $lang['Hidden_user_total'] : $lang['Hidden_users_total'] ) : $lang['Hidden_users_zero_total'];
	$l_today_g_user_s = ($guests_today) ? (($guests_today == 1) ? $lang['Guest_user_total'] : $lang['Guest_users_total']) : $lang['Guest_users_zero_total'];
	$l_today_users = sprintf($l_today_user_s, $total_users_today);
	$l_today_users .= sprintf($l_today_r_user_s, $logged_visible_today); 
	$l_today_users .= sprintf($l_today_h_user_s, $logged_hidden_today); 
	$l_today_users .= sprintf($l_today_g_user_s, $guests_today);
	
	if ( $total_users_today > $board_config['record_day_users'])  
	{  
		$board_config['record_day_users'] = $total_users_today;  
		$board_config['record_day_date'] = time();   

		$sql = "UPDATE " . CONFIG_TABLE . "  
			SET config_value = '$total_users_today'  
			WHERE config_name = 'record_day_users'";  
		if ( !$db->sql_query($sql) )  
		{  
			message_die(GENERAL_ERROR, 'Could not update today user record (number of users)', '', __LINE__, __FILE__, $sql);  
		}   
	
		$sql = "UPDATE " . CONFIG_TABLE . "  
			SET config_value = '" . $board_config['record_day_date'] . "'  
			WHERE config_name = 'record_day_date'";  
		if ( !$db->sql_query($sql) )  
		{  
			message_die(GENERAL_ERROR, 'Could not update today user record (date)', '', __LINE__, __FILE__, $sql);  
		}  
	}  	

	// Birthday, Show users with birthday 
	$sql = ($board_config['birthday_check_day']) ? "SELECT user_id, username, user_birthday,user_level FROM " . USERS_TABLE. " WHERE user_birthday!=999999 ORDER BY username" :"";
	if($result = $db->sql_query($sql)) 
	{ 
		if (!empty($result)) 
		{ 
			$time_now = time();
			$this_year = create_date('Y', $time_now, $board_config['board_timezone']);
			$date_today = create_date('Ymd', $time_now, $board_config['board_timezone']);
			$date_forward = create_date('Ymd', $time_now+($board_config['birthday_check_day']*86400), $board_config['board_timezone']);
		      while ($birthdayrow = $db->sql_fetchrow($result))
			{ 
			      $user_birthday2 = $this_year.($user_birthday = realdate("md",$birthdayrow['user_birthday'] )); 
	      		if ( $user_birthday2 < $date_today ) $user_birthday2 += 1000;
				if ( $user_birthday2 > $date_today  && $user_birthday2 <= $date_forward ) 
				{ 
					// user are having birthday within the next days
					$user_age = ( $this_year.$user_birthday < $date_today ) ? $this_year - realdate ('Y',$birthdayrow['user_birthday'])+1 : $this_year- realdate ('Y',$birthdayrow['user_birthday']); 
					switch ($birthdayrow['user_level'])
					{
						case ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
							break;
						case LESS_ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
							break;
						case MOD :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
							break;
						default: $style_color = '';
					}
					$birthday_week_list .= ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow['user_id']) . '"' . $style_color .' class="gensmall">' . $birthdayrow['username'] . ' <i>('.$user_age.')</i></a>,'; 
				} else if ( $user_birthday2 == $date_today ) 
	      		{ 
					//user have birthday today 
					$user_age = $this_year - realdate ( 'Y',$birthdayrow['user_birthday'] ); 
					switch ($birthdayrow['user_level'])
					{
						case ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
							break;
						case LESS_ADMIN :
			      			$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
							break;
						case MOD :
				      		$birthdayrow['username'] = '<b>' . $birthdayrow['username'] . '</b>'; 
	      					$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
							break;
						default: $style_color = '';
					}
					$birthday_today_list .= ' <a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $birthdayrow['user_id']) . '"' . $style_color .' class="gensmall">' . $birthdayrow['username'] . ' <i>('.$user_age.')</i></a>,'; 
			      }
				 
			}
			if ($birthday_today_list) $birthday_today_list[ strlen( $birthday_today_list)-1] = ' ';
			if ($birthday_week_list) $birthday_week_list[ strlen( $birthday_week_list)-1] = ' ';
		} 
		$db->sql_freeresult($result);
	}

	//
	// Get Random Pic
	//
	$sql = "SELECT p.pic_id, p.pic_title, p.pic_username, p.pic_user_id, p.pic_time, p.pic_desc, p.pic_approval, u.username
		FROM ". ALBUM_TABLE ." AS p
		LEFT JOIN ". USERS_TABLE ." AS u ON p.pic_user_id = u.user_id
		WHERE pic_approval = 1
		ORDER BY RAND() 
		LIMIT 1";
	if (!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Could not query album information', '', __LINE__, __FILE__, $sql);
	}
	$picrow = $db->sql_fetchrow($result);
	$pic_poster = '<a href="'. append_sid("profile.$phpEx?mode=viewprofile&amp;". POST_USERS_URL .'='. $picrow['pic_user_id']) .'" class="gensmall">'. $picrow['pic_username'] .'</a>';

	//
	// Start output of page
	//
	define('SHOW_ONLINE', true);
	$page_title = $lang['Forum_Index'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);

	$template->set_filenames(array(
		'body' => $index_body_fn)
	);

	//
	// Welcome & Avatar On Index
	//
	$avatar_img = '';
	if ( $userdata['user_avatar_type'] && $userdata['user_allowavatar'] )
	{
		switch( $userdata['user_avatar_type'] )
		{
			case USER_AVATAR_UPLOAD:
				$avatar_img = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_REMOTE:
				$avatar_img = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_GALLERY:
				$avatar_img = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : '';
				break;
		}
	}
	if ($avatar_img == '')
	{
        //
        // Set up style
        //
        if ( !$board_config['override_user_style'] )
        {
            if ( $userdata['user_id'] != ANONYMOUS && $userdata['user_style'] > 0 )
            {
                $template_name = get_template_name($board_config['default_style']);
                $avatar_img = '<img src="'. $phpbb_root_path . 'templates/' . $template_name . '/images/whosonline.gif" alt="" />';
            }
        }
        else
        {
            $avatar_img = '<img src="templates/subSilver/images/whosonline.gif" alt="" />';
	  }
	}
	// Check For Anonymous User
	if ($userdata['user_id'] != '-1')
	{
	    $name_link = '<a href="' . append_sid("profile.$phpEx?mode=editprofile&amp;" . $userdata['user_id']) . '" title="'.$lang['Profile'].'">' . $userdata['username'] . '</a>';
	}
	else
	{
	    $name_link = $lang['Guest'];
	}
	
	$start_date = create_date($board_config['default_dateformat'], $board_config['board_startdate'], $board_config['board_timezone']);

	$total_posts_format = sprintf($l_total_post_s, $total_posts); 
	$total_posts_format = str_replace($total_posts, number_format($total_posts), $total_posts_format); 
	$module_width = $forums_config['forum_module_width'];

	$template->assign_vars(array(
		'TOTAL_POSTS' => $total_posts_format,
		'TOTAL_TOPICS' => sprintf($lang['Posted_topics_total'], $total_topics),
		'WITHIN' => $lang['Within'],
		'TOTAL_USERS' => sprintf($l_total_user_s, $total_users),
		'NEWEST_USER' => sprintf($lang['Newest_user'], '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$newest_uid") . '">', $newest_user, '</a>'), 
		'FORUM_IMG' => $images['forum'],
		'FORUM_NEW_IMG' => $images['forum_new'],
		'FORUM_LOCKED_IMG' => $images['forum_locked'],
		'LANGUAGE_SELECT' => language_select($board_config['default_lang'], 'language'), 
		'START_DATE' => $start_date,
		'TOTAL_CHATTERS_ONLINE' => sprintf($lang['How_Many_Chatters'], $howmanychat),
		'CHATTERS_LIST' => sprintf($lang['Who_Are_Chatting' ],$chatters),
		'CHATBOX_NAME' => $userdata['user_id'] . '_ChatBox', 
		'AVATAR_IMG' => $avatar_img,
		'USERS_TODAY_LIST' => $users_today_list,
		'MODULE_WIDTH' => $module_width,
		'PIC_IMAGE' => append_sid('album_thumbnail.'. $phpEx . '?pic_id=' . $picrow['pic_id']),
		'PIC_TITLE' => $picrow['pic_title'],
		'PIC_POSTER' => $pic_poster,
		'PIC_TIME' => create_date($board_config['default_dateformat'], $picrow['pic_time'], $board_config['board_timezone']),
		'PIC_DESCR' => $picrow['pic_desc'],

		'L_BOARD_HAS' => $lang['Board_has'],
		'L_SELECT_LANG' => $lang['Board_lang'], 
		'L_LOCAL_FORECAST' => $lang['Local_forecast'], 
		'L_NAME_WELCOME' => $lang['Welcome'],
		'L_USERS_LASTHOUR' => ($users_lasthour)?sprintf($lang['Users_lasthour_explain'],$users_lasthour):$lang['Users_lasthour_none_explain'],
		'L_USERS_TODAY' => $l_today_users,
		'L_WHOSBIRTHDAY_WEEK' => ($board_config['birthday_check_day']>1) ? sprintf((($birthday_week_list)? $lang ['Birthday_week'].$birthday_week_list:$lang ['Nobirthday_week']),$board_config['birthday_check_day']) : '', 
		'L_WHOSBIRTHDAY_TODAY' => ($board_config['birthday_check_day']) ?($birthday_today_list)? $lang ['Birthday_today'].$birthday_today_list:$lang ['Nobirthday_today'] : '', 
		'L_CLICK_TO_JOIN_CHAT' => $lang['Click_to_join_chat'],
		'L_LOGIN_TO_JOIN_CHAT' => $lang['Login_to_join_chat'],
		'L_FORUM' => $lang['Forum'],
		'L_TOPICS' => $lang['Topics'],
		'L_REPLIES' => $lang['Replies'],
		'L_VIEWS' => $lang['Views'],
		'L_POSTS' => $lang['Posts'],
		'L_LASTPOST' => $lang['Last_Post'], 
		'L_NO_NEW_POSTS' => $lang['No_new_posts'],
		'L_NEW_POSTS' => $lang['New_posts'],
		'L_NO_NEW_POSTS_LOCKED' => $lang['No_new_posts_locked'], 
		'L_NEW_POSTS_LOCKED' => $lang['New_posts_locked'], 
		'L_ONLINE_EXPLAIN' => $lang['Online_explain'], 
		'L_RECENT_POSTS' => $lang['Recent_posts'], 
	      'L_TOPIC_JUMP' => $lang['Topic_Jump'],
		'L_MODERATOR' => $lang['Moderators'], 
		'L_FORUM_LOCKED' => $lang['Forum_is_locked'],
		'L_MARK_FORUMS_READ' => $lang['Mark_all_forums'],
 
		'S_JOIN_CHAT' => append_sid("chatbox/chatbox.$phpEx"),
		'U_NAME_LINK' => $name_link,

		'SITE_LOGO_WIDTH' => $site_logo_width,
		'SITE_LOGO_HEIGHT' => $site_logo_height,
		'U_LINKS_JS' => append_sid("links.js.$phpEx"),
		'U_SITE_LOGO' => $link_self_img,

		'U_PIC_LINK' => append_sid('album_pic.' . $phpEx . '?pic_id=' . $picrow['pic_id']),
		'U_PIC_COMMENT' => append_sid('album_comment.' . $phpEx . '?pic_id=' . $picrow['pic_id']),
		'U_INDEX_WEATHER' => append_sid("index_weather.$phpEx"),
	      'U_MARK_READ' => append_sid("index.$phpEx?mark=forums"), 
      	'U_VIEWTOPIC' => append_sid("viewtopic.$phpEx"))
	);

	//
	// Get the hierarchie if necessary
	//
	if($hierarchie_level > 0 && $total_categories > 0)
	{
	
		$cat_id = $category_rows[0]['cat_id'];

		$sql = "SELECT concat(c.cat_title, ', ', f.forum_name) AS hierarchie_title, f.forum_id, f.forum_hier_level + 1 AS hierarchie_level
			FROM " . CATEGORIES_TABLE . " c, " . CAT_REL_CAT_PARENTS_TABLE . " ccp, " . FORUMS_TABLE . " f, " . CAT_REL_FORUM_PARENTS_TABLE . " cfp
			WHERE ccp.parent_cat_id = c.cat_id
			AND ccp.cat_id = $cat_id
			AND cfp.parent_forum_id = f.forum_id
			AND cfp.cat_id = $cat_id
			AND f.cat_id = c.cat_id
			ORDER BY c.cat_hier_level, f.forum_hier_level";
		
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query hierarchie title', '', __LINE__, __FILE__, $sql);
		}
		while( $row = $db->sql_fetchrow($result) )
		{
			$template->assign_block_vars("navrow", array(
				'U_SUBINDEX' => append_sid("index.$phpEx?" . POST_HIERARCHIE_URL . "=" . $row['hierarchie_level'] . "&" . POST_PARENTFORUM_URL . "=" . $row['forum_id']),
				'L_SUBINDEX' => $row['hierarchie_title'])
			);
		}
	}

	//
	// Okay, let's build the index
	//
	for($i = 0; $i < $total_categories; $i++)
	{
		$cat_id = $category_rows[$i]['cat_id'];

		//
		// Should we display this category/forum set?
		//
		$display_forums = false;
		for($j = 0; $j < $total_forums; $j++)
		{
			if ( $is_auth_ary[$forum_data[$j]['forum_id']]['auth_view'] && $forum_data[$j]['cat_id'] == $cat_id )
			{
				$display_forums = true;
			}
		}

		//
		// Yes, we should, so first dump out the category
		// title, then, if appropriate the forum list
		//
		if ( $display_forums )
		{
			if ($category_rows[$i]['cat_icon'] != '')
			{
				$cat_icon = '&nbsp;<img src="' . $category_rows[$i]['cat_icon'] . '" alt="" />&nbsp;';
			}
                  else 
			{
				$cat_icon = '';
			}

			$template->assign_block_vars('catrow', array(
				'CAT_ID' => $cat_id,
				'CAT_DESC' => $category_rows[$i]['cat_title'],
				'CAT_ICON' => $cat_icon,
				'SPONSOR' => ( $category_rows[$i]['cat_sponsor_img'] ? ( $category_rows[$i]['cat_sponsor_url'] ? '<a href="' . $category_rows[$i]['cat_sponsor_url'] . '" target="_blank">' : '' ) . '<img src="' . $category_rows[$i]['cat_sponsor_img'] . '" border="0" alt="' . $category_rows[$i]['cat_sponsor_alt'] . '" />' : '' ), 
				'U_VIEWCAT' => append_sid("index.$phpEx?"  . POST_HIERARCHIE_URL . "=$hierarchie_level&" . POST_PARENTFORUM_URL . "=$parent_forum&" . POST_CAT_URL . "=$cat_id"))
			);

			if ( $viewcat == $cat_id || $viewcat == -1 )
			{
				for($j = 0; $j < $total_forums; $j++)
				{
					if ( $forum_data[$j]['cat_id'] == $cat_id )
					{
						$forum_id = $forum_data[$j]['forum_id'];

						if ( $is_auth_ary[$forum_id]['auth_view'] )
						{
							if ( $forum_data[$j]['forum_status'] == FORUM_LOCKED )
							{
								$folder_image = $images['forum_locked']; 
								$folder_alt = $lang['Forum_locked'];
							}
							// Admin only forum
							elseif ( $forum_data[$j]['auth_view'] == '5' )
							{
								$folder_image = $images['forum_admin']; 
								$folder_alt = $lang['Forum_admin'];
							}
							else
							{
								$unread_topics = false;
								if ( $userdata['session_logged_in'] )
								{
									if ( !empty($new_topic_data[$forum_id]) )
									{
										$forum_last_post_time = 0;

										while( list($check_topic_id, $check_post_time) = @each($new_topic_data[$forum_id]) )
										{
											if ( empty($tracking_topics[$check_topic_id]) )
											{
												$unread_topics = true;
												$forum_last_post_time = max($check_post_time, $forum_last_post_time);

											}
											else
											{
												if ( $tracking_topics[$check_topic_id] < $check_post_time )
												{
													$unread_topics = true;
													$forum_last_post_time = max($check_post_time, $forum_last_post_time);
												}
											}
										}

										if ( !empty($tracking_forums[$forum_id]) )
										{
											if ( $tracking_forums[$forum_id] > $forum_last_post_time )
											{
												$unread_topics = false;
											}
										}

										if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all']) )
										{
											if ( $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f_all'] > $forum_last_post_time )
											{
												$unread_topics = false;
											}
										}

									}
								}
									
								$forum_is_sub = $forum_data[$j]['forum_issub'];
								if ( $forum_is_sub == TRUE)
								{
									$folder_image = ( $unread_topics ) ? $images['forum_subforum_new'] : $images['forum_subforum'];
									$folder_alt = ( $unread_topics ) ? $lang['New_posts'] : $lang['No_new_posts'];
								}
								else
								{
								$folder_image = ( $unread_topics ) ? $images['forum_new'] : $images['forum']; 
								$folder_alt = ( $unread_topics ) ? $lang['New_posts'] : $lang['No_new_posts']; 
							}
						}

							$posts = $forum_data[$j]['forum_posts'];
							$topics = $forum_data[$j]['forum_topics'];

						if ( $forum_data[$j]['forum_last_post_id'] )
							{
								$topic_title = $forum_data[$j]['topic_title'];
								$topic_title2 = $forum_data[$j]['topic_title'];
		
								//
								// Censor topic title
								//
								if ( count($orig_word) )
								{
									$topic_title = preg_replace($orig_word, $replacement_word, $topic_title);
									$topic_title2 = preg_replace($orig_word, $replacement_word, $topic_title2);
								}
										
								if (strlen($topic_title)>22) {
									$topic_title = substr($topic_title,0,19) . '...';
								}

								$last_post_time = create_date($board_config['default_dateformat'], $forum_data[$j]['post_time'], $board_config['board_timezone']);
							
								$last_post = '<a href="' . append_sid("viewtopic.$phpEx?"  . POST_POST_URL . '=' . $forum_data[$j]['forum_last_post_id']) . '&no=1#' . $forum_data[$j]['forum_last_post_id'] . '" title="' . $topic_title2 . '">' . $topic_title . '</a><br />';
							
								if ( $board_config['time_today'] < $forum_data[$j]['post_time'])
								{ 
									$last_post .= sprintf($lang['Today_at'], create_date($board_config['default_timeformat'], $forum_data[$j]['post_time'], $board_config['board_timezone'])) . '<br />'; 
								}
								else if ( $board_config['time_yesterday'] < $forum_data[$j]['post_time'])
								{ 
									$last_post .= sprintf($lang['Yesterday_at'], create_date($board_config['default_timeformat'], $forum_data[$j]['post_time'], $board_config['board_timezone'])) . '<br />'; 
								}
								else
								{ 
									$last_post .= $last_post_time . '<br />'; 
								} 
							
								$last_post .= ( $forum_data[$j]['user_id'] == ANONYMOUS ) ? ( ($forum_data[$j]['post_username'] != '' ) ? $forum_data[$j]['post_username'] . ' ' : $lang['Guest'] . ' ' ) : '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '='  . $forum_data[$j]['user_id']) . '" class="gensmall">' . $forum_data[$j]['username'] . '</a> <a href="' . append_sid("viewtopic.$phpEx?"  . POST_POST_URL . '=' . $forum_data[$j]['forum_last_post_id']) . '&no=1#' . $forum_data[$j]['forum_last_post_id'] . '"><img src="' . $images['icon_latest_reply'] . '" border="0" alt="' . $lang['View_latest_post'] . '" title="' . $lang['View_latest_post'] . '"></a>';
							}
							else
							{
								$last_post = $lang['No_Posts'];
							}

							if ( count($forum_moderators[$forum_id]) > 0 )
							{
								$l_moderators = ( count($forum_moderators[$forum_id]) == 1 ) ? $lang['Moderator'] : $lang['Moderators'];
								$moderator_list = implode(', ', $forum_moderators[$forum_id]);
							}
							else
							{
								$l_moderators = '&nbsp;';
								$moderator_list = '&nbsp;';
							}

							$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
							$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

							if( $userdata['session_logged_in'] ) 
							{ 
							$sql = "SELECT COUNT(post_id) as total 
								FROM " . POSTS_TABLE . " 
								WHERE post_time >= " . $userdata['user_lastvisit'] . " 
								AND forum_id = " . $forum_id; 
								$result = $db->sql_query($sql); 
							if( $result ) 
							{ 
							$row = $db->sql_fetchrow($result); 
							$number_new_posts = $row['total']; 
							} 
							} 
							
							if ( $number_new_posts != "1" ) 
							{ 
								$temp = $number_new_posts; 
								$number_new_posts = "" . $temp . " new posts"; 
							} 
							else 
							{ 
								$temp = $number_new_posts; 
								$number_new_posts = "" . $temp . " new post"; 
							} 

							if( $userdata['session_logged_in'] ) 
							{ 
							$sql2 = "SELECT COUNT(topic_id) as total 
									FROM " . TOPICS_TABLE . " 
									WHERE topic_time >= " . $userdata['user_lastvisit'] . " 
									AND forum_id = " . $forum_id; 
									$result2 = $db->sql_query($sql2); 
								if( $result2 ) 
								{ 
									$row2 = $db->sql_fetchrow($result2); 
									$number_new_topics = $row2['total']; 
								} 
							} 

							if ( $number_new_topics != "1" ) 
							{ 
								$temp = $number_new_topics; 
								$number_new_topics = "" . $temp . " new topics"; 
							} 
							else 
							{ 
								$temp = $number_new_topics; 
								$number_new_topics = "" . $temp . " new topic"; 
							} 
	
							if( !$userdata['session_logged_in'] ) 
							{ 
								$number_new_topics = ""; 
								$number_new_posts = ""; 
							} 
			
							$user_forum_sql = ( !empty($forum_id) ) ? "AND s.session_page = $forum_id" : ''; 
							
									$sql = "SELECT u.username, u.user_id, u.user_allow_viewonline, u.user_level, s.session_logged_in, s.session_ip 
										FROM ".USERS_TABLE." u, ".SESSIONS_TABLE." s 
										WHERE u.user_id = s.session_user_id 
									      AND s.session_time >= ".( time() - 300 ) . " 
								      $user_forum_sql 
									   	ORDER BY u.username ASC, s.session_ip ASC"; 
		
									if( !($result = $db->sql_query($sql)) ) 
									{ 
										message_die(GENERAL_ERROR, 'Could not obtain user/online information', '', __LINE__, __FILE__, $sql); 
									} 
		
									$userlist_ary = array(); 
									$userlist_visible = array(); 
		
									$logged_visible_active = 0; 
									$logged_hidden_active = 0; 
									$guests_active= 0; 
									$active_userlist = ''; 
		
									$prev_user_id = 0; 
									$prev_user_ip = ''; 

									while( $row = $db->sql_fetchrow($result) ) 
									{ 
										if ( $row['session_logged_in'] ) 
										{ 
											if ( $row['user_id'] != $prev_user_id ) 
											{ 
												$style_color = ''; 
												if ( $row['user_level'] == ADMIN ) 
												{ 
													$row['username'] = '<b>' . $row['username'] . '</b>'; 
													$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"'; 
												} 
												else if ( $row['user_level'] == LESS_ADMIN ) 
												{ 
													$row['username'] = '<b>' . $row['username'] . '</b>'; 
													$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"'; 
												} 
												else if ( $row['user_level'] == MOD ) 
												{ 
													$row['username'] = '<b>' . $row['username'] . '</b>'; 
													$style_color = 'style="color:#' . $theme['modfontcolor'] . '"'; 
												} 
		
												if ( $row['user_allow_viewonline'] ) 
												{ 
													$user_active_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall">' . $row['username'] . '</a>'; 
													$logged_visible_active++; 
												} 
												else 
												{ 
											            $user_active_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall"><i>' . $row['username'] . '</i></a>'; 
											            $logged_hidden_active++; 
												} 
		          
												if ( $row['user_allow_viewonline'] || $userdata['user_level'] == ADMIN ) 
												{ 
													$active_userlist .= ( $active_userlist != '' ) ? ', ' . $user_active_link : $user_active_link; 
												} 
											}
											$prev_user_id = $row['user_id']; 
									} 
									else 
									{ 
										if ( $row['session_ip'] != $prev_session_ip ) 
										{ 
											$guests_active++; 
										} 
									} 
									$prev_session_ip = $row['session_ip']; 
							}
		
							$total_active_users = $logged_visible_active + $logged_hidden_active + $guests_active; 

							$l_t_user_s = ( $total_active_users == 0 ) ? $lang['Forum_no_active'] : ( ( $total_active_users == 1 ) ? $lang['Forum_one_active'] : $lang['Forum_more_active'] );
							$l_h_user_s = ( $logged_hidden_active == 0 || $userdata['user_level'] == ADMIN ) ? '' : ( ( $logged_hidden_active == 1 ) ? $lang['Forum_one_hidden_active'] : $lang['Forum_more_hidden_active'] );
							$l_g_user_s = ( $guests_active == 0 ) ? '' : ( ( $guests_active == 1 ) ? $lang['Forum_one_guest_active'] : $lang['Forum_more_guest_active'] );
	
							$l_active_users = sprintf($l_t_user_s, $total_active_users); 
							$l_active_users_extra = sprintf($l_h_user_s, $logged_hidden_active); 
							$l_active_users_extra .= sprintf($l_g_user_s, $guests_active); 
	
							$active_total = $l_active_users; 
							$active_info = $l_active_users_info; 
							$active = $active_userlist; 

							$view_forum_url = $forum_is_sub ? append_sid("index.$phpEx?" . POST_HIERARCHIE_URL . "=" . ($hierarchie_level+1) . "&" . POST_PARENTFORUM_URL . "=$forum_id") : append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id");

							if ($forum_data[$j]['forum_icon'] != '')
							{
								$forum_icon = '&nbsp;<img src="' . $forum_data[$j]['forum_icon'] . '" alt="" />&nbsp;';
							}
							else 
							{
								$forum_icon = '';
							}

							$template->assign_block_vars('catrow.forumrow',   array( 
								'WHO' => $active, 
								'WHO_TOTAL' => $active_total, 
							 	'WHO_EXTRA' => $active_info, 
								'ROW_COLOR' => '#' . $row_color,
								'ROW_CLASS' => $row_class,
								'FORUM_FOLDER_IMG' => $folder_image, 
								'FORUM_NAME' => $forum_data[$j]['forum_name'],
								'FORUM_DESC' => $forum_data[$j]['forum_desc'],
								'FORUM_ICON' => $forum_icon,
								'POSTS' => $forum_data[$j]['forum_posts'],
								'VIEWS' => $forum_data[$j]['forum_views'],
								'TOPICS' => $forum_data[$j]['forum_topics'],
								'LAST_POST' => $last_post,
								'MODERATORS' => $moderator_list,

								'NUM_NEW_TOPICS' => $number_new_topics, 
								'NUM_NEW_POSTS' => $number_new_posts, 
								
								'L_MODERATOR' => $l_moderators, 
								'L_FORUM_FOLDER_ALT' => $folder_alt, 

								'U_VIEWFORUM' => $view_forum_url)
							);
						}
					}
				}
			}
		}
	} // for ... categories

}// if ... total_categories
else
{
	message_die(GENERAL_MESSAGE, $lang['No_forums']);
}

include($phpbb_root_path . 'glance.'.$phpEx); 

//
// Display block modules 
//
$display_modules = $forums_config['forum_module_disable'];
$display_indexglance = $forums_config['forum_module_glance'];
$display_indexcalendar = $forums_config['forum_module_calendar'];
$display_indexphoto = $forums_config['forum_module_photo'];
$display_indexshoutbox = $forums_config['forum_module_shoutbox'];
$display_indexnewsbar = $forums_config['forum_module_newsbar'];
$display_indexlinks = $forums_config['forum_module_links'];
$display_indexweather = $forums_config['forum_module_weather'];

if ($display_modules)
{
	$template->assign_block_vars("displaymodules", array() );
}
if ($display_indexglance)
{
	$template->assign_block_vars("displayindexglance", array() );
}
if ($display_indexcalendar)
{
	$template->assign_block_vars("displayindexcalendar", array() );
}
if ($display_indexphoto)
{
	$template->assign_block_vars("displayindexphoto", array() );
}
if ($display_indexshoutbox)
{
	$template->assign_block_vars("displayindexshoutbox", array() );
}
if ($display_indexnewsbar)
{
	$template->assign_block_vars("displayindexnewsbar", array() );
}
if ($display_indexlinks)
{
	$template->assign_block_vars("displayindexlinks", array() );
}
if ($display_indexweather)
{
	$template->assign_block_vars("displayindexweather", array() );
}

//
// Generate the page
//
include($phpbb_root_path . 'calendar/mini_cal/mini_cal.'.$phpEx); 

	if($hierarchie_level > 0 && $total_categories > 0)
	{
		include("viewhier.php");
		$template->pparse('hier');
	}
	else {
		$template->pparse('body');
	}

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>