<?php
/***************************************************************************
 *                              page_header.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: page_header.php,v 1.106.2.20 2003/06/10 20:48:19 acydburn Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/11 21:50:12 mj
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

define('HEADER_INC', TRUE);
include($phpbb_root_path . 'includes/functions_news.'.$phpEx);

//
// gzip_compression
//
$do_gzip_compress = FALSE;
if ( $board_config['gzip_compress'] )
{
	$phpver = phpversion();

	$useragent = (isset($_SERVER["HTTP_USER_AGENT"]) ) ? $_SERVER["HTTP_USER_AGENT"] : $HTTP_USER_AGENT;

	if ( $phpver >= '4.0.4pl1' && ( strstr($useragent,'compatible') || strstr($useragent,'Gecko') ) )
	{
		if(extension_loaded("zlib")) 
		{ 
			if (headers_sent() != TRUE) 
			{ 
				$gz_possible = isset($HTTP_SERVER_VARS["HTTP_ACCEPT_ENCODING"]) && eregi("gzip, deflate",$HTTP_SERVER_VARS["HTTP_ACCEPT_ENCODING"]); 
				if ($gz_possible) ob_start("ob_gzhandler"); 
			} 
		} 
	}
	else if ( $phpver > '4.0' )
	{
		if ( strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip') )
		{
			if ( extension_loaded('zlib') )
			{
				$do_gzip_compress = TRUE;
				ob_start();
				ob_implicit_flush(0);

				header('Content-Encoding: gzip');
			}
		}
	}
}

//
//
// Enhanced IP logger
//
	$x  = @date("D-M-y - H:i:s"); 
	$host = @gethostbyaddr("$REMOTE_ADDR");

	$sql = "INSERT INTO " . IP_TABLE . " (host, ip, date, username, referrer, forum, browser) 
		VALUES ('$host','$REMOTE_ADDR','$x','" . str_replace("\'", "''", $userdata[username]) . "','$HTTP_REFERER','$PHP_SELF','$HTTP_USER_AGENT')";

	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not update ip information', '', __LINE__, __FILE__, $sql);
	}
	

//
// Visitor Counter 
//
$visit_counter = $board_config['visit_counter'];

if( $userdata['session_start'] >= (time()-1) )
{
	$sql = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '" . ($visit_counter + 1) . "'
			WHERE config_name = 'visit_counter'";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not update counter information', '', __LINE__, __FILE__, $sql);
	}

	$visit_counter++;
}

//
// Parse date format to get time format
//
$time_reg = '([gh][[:punct:][:space:]]{1,2}[i][[:punct:][:space:]]{0,2}[a]?[[:punct:][:space:]]{0,2}[S]?)';
eregi($time_reg, $board_config['default_dateformat'], $regs);
$board_config['default_timeformat'] = $regs[1];
unset($time_reg);
unset($regs);
// Get time, today & yesterday
$today_ary = explode('|', create_date('m|d|Y', time(),$board_config['board_timezone']));
$board_config['time_today'] = gmmktime(0 - $board_config['board_timezone'] - $board_config['dstime'],0,0,$today_ary[0],$today_ary[1],$today_ary[2]);
$board_config['time_yesterday'] = $board_config['time_today'] - 86400;
unset($today_ary);

//
// Parse and show the overall header.
//
$template->set_filenames(array(
	'overall_header' => ( empty($gen_simple_header) ) ? 'overall_header.tpl' : (($gen_simple_header < 0) ? 'slideshow_header.tpl' : 'simple_header.tpl') )
);

//
// Administration link
//
$admin_link = ( $userdata['user_level'] == ADMIN ) ? '&nbsp;<a href="admin/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" class="gensmall" target="_blank"><img src="' . $images['admin_panel'] . '" height="13" width="12" alt="' . $lang['Admin_panel'] . '" border="0" hspace="3" />' . $lang['Admin_panel'] . '</a>&nbsp;' : ''; 

//
// Generate logged in/logged out status
//
if ( $userdata['session_logged_in'] )
{
	$u_login_logout = 'login.'.$phpEx.'?logout=true&amp;sid=' . $userdata['session_id'];
	$l_login_logout = $lang['Logout'] . ' [ ' . $userdata['username'] . ' ]';
}
else
{
	$u_login_logout = 'login.'.$phpEx;
	$l_login_logout = $lang['Login'];
}

$s_last_visit = ( $userdata['session_logged_in'] ) ? create_date($board_config['default_dateformat'], $userdata['user_lastvisit'], $board_config['board_timezone']) : '';

//
// Get basic (usernames + totals) online
// situation
//
$logged_visible_online = 0;
$logged_hidden_online = 0;
$guests_online = 0;
$online_userlist = '';

if (defined('SHOW_ONLINE'))
{

	$user_forum_sql = ( !empty($topic_id) ) ? "AND s.session_topic = $topic_id" :(( !empty($forum_id) ) ? "AND s.session_page = $forum_id" : '');
	$sql = "SELECT u.username, u.user_id, u.user_allow_viewonline, u.user_level, s.session_logged_in, s.session_ip
		FROM ".USERS_TABLE." u, ".SESSIONS_TABLE." s
		WHERE u.user_id = s.session_user_id
			AND s.session_time >= ".( time() - 300 ) . "
			$user_forum_sql
		ORDER BY u.username ASC, s.session_ip ASC";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain user/online information', '', __LINE__, __FILE__, $sql);
	}

	$userlist_ary = array();
	$userlist_visible = array();

	$prillian_online = array();
	$online_array = array();

	$prev_user_id = 0;
	$prev_user_ip = '';

	while( $row = $db->sql_fetchrow($result) )
	{
		// User is logged in and therefor not a guest
		if ( $row['session_logged_in'] )
		{
			// Skip multiple sessions for one user
			if ( $row['user_id'] != $prev_user_id )
			{
				if( defined('IN_PRILLIAN') )
				{
					$prillian_online[] = $row;
				}
				$online_array[] = $row['user_id'];

				$style_color = '';
				if ( $row['user_level'] == ADMIN )
				{
					$row['username'] = '<b>' . $row['username'] . '</b>';
					$style_color = 'style="color:#' . $theme['adminfontcolor'] . '"';
				}
				else if ( $row['user_level'] == LESS_ADMIN )
				{
					$row['username'] = '<b>' . $row['username'] . '</b>';
					$style_color = 'style="color:#' . $theme['supermodfontcolor'] . '"';
				}	
				else if ( $row['user_level'] == MOD )
				{
					$row['username'] = '<b>' . $row['username'] . '</b>';
					$style_color = 'style="color:#' . $theme['modfontcolor'] . '"';
				}

				if ( $row['user_allow_viewonline'] )
				{
					$user_online_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall">' . $row['username'] . '</a>';
					$logged_visible_online++;
				}
				else
				{
					$user_online_link = '<a href="' . append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=" . $row['user_id']) . '"' . $style_color .' class="gensmall"><i>' . $row['username'] . '</i></a>';
					$logged_hidden_online++;
				}

				if ( $row['user_allow_viewonline'] || $userdata['user_level'] == ADMIN )
				{
					$online_userlist .= ( $online_userlist != '' ) ? ', ' . $user_online_link : $user_online_link;
				}
			}

			$prev_user_id = $row['user_id'];
		}
		else
		{
			// Skip multiple sessions for one user
			if ( $row['session_ip'] != $prev_session_ip )
			{
				$guests_online++;
			}
		}

		$prev_session_ip = $row['session_ip'];
	}
	$db->sql_freeresult($result);

	if ( empty($online_userlist) )
	{
		$online_userlist = $lang['None'];
	}
	$online_userlist = $lang['Registered_users'].' ' . $online_userlist;

	$total_online_users = $logged_visible_online + $logged_hidden_online + $guests_online;

	if ( $total_online_users > $board_config['record_online_users'])
	{
		$board_config['record_online_users'] = $total_online_users;
		$board_config['record_online_date'] = time();

		$sql = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '$total_online_users'
			WHERE config_name = 'record_online_users'";
		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not update online user record (nr of users)', '', __LINE__, __FILE__, $sql);
		}

		$sql = "UPDATE " . CONFIG_TABLE . "
			SET config_value = '" . $board_config['record_online_date'] . "'
			WHERE config_name = 'record_online_date'";
		if ( !$db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not update online user record (date)', '', __LINE__, __FILE__, $sql);
		}
	}

	if ( $total_online_users == 0 )
	{
		$l_t_user_s = ( ( isset($topic_id) ) ? $lang['Browsing_topic'] : ( ( isset($forum_id) ) ? $lang['Browsing_forum'] : $lang['Online_users_zero_total'] ) );
	}
	else
	{
		$l_t_user_s = ( ( isset($topic_id) ) ? $lang['Browsing_topic'] : ( ( isset($forum_id) ) ? $lang['Browsing_forum'] : $lang['Online_users_total'] ) );
	}
	
	if ( $logged_visible_online == 0 )
	{
		$l_r_user_s = $lang['Reg_users_zero_total'];
	}
	else if ( $logged_visible_online == 1 )
	{
		$l_r_user_s = $lang['Reg_user_total'];
	}
	else
	{
		$l_r_user_s = $lang['Reg_users_total'];
	}

	if ( $logged_hidden_online == 0 )
	{
		$l_h_user_s = $lang['Hidden_users_zero_total'];
	}
	else if ( $logged_hidden_online == 1 )
	{
		$l_h_user_s = $lang['Hidden_user_total'];
	}
	else
	{
		$l_h_user_s = $lang['Hidden_users_total'];
	}

	if ( $guests_online == 0 )
	{
		$l_g_user_s = $lang['Guest_users_zero_total'];
	}
	else if ( $guests_online == 1 )
	{
		$l_g_user_s = $lang['Guest_user_total'];
	}
	else
	{
		$l_g_user_s = $lang['Guest_users_total'];
	}

	$l_online_users = sprintf($l_t_user_s, $total_online_users);
	$l_online_users .= sprintf($l_r_user_s, $logged_visible_online);
	$l_online_users .= sprintf($l_h_user_s, $logged_hidden_online);
	$l_online_users .= sprintf($l_g_user_s, $guests_online);
}

//
// Obtain number of new private messages
// if user is logged in
//
if ( ($userdata['session_logged_in']) && (empty($gen_simple_header)) )
{
	// see if user has or have had birthday, also see if greeting are enabled 
	if ( $userdata['user_birthday']!=999999 && $board_config['birthday_greeting'] && create_date('Ymd', time(), $board_config['default_timezone']) >= $userdata['user_next_birthday_greeting'].realdate ('md',$userdata['user_birthday'] ) ) 
	{ 
	$sql = "UPDATE " . USERS_TABLE . " 
	SET user_next_birthday_greeting = " . (create_date('Y', time(), $board_config['board_timezone'])+1) . " 
	WHERE user_id = " . $userdata['user_id']; 
	if( !$status = $db->sql_query($sql) ) 
	{ 
	message_die(GENERAL_ERROR, "Could not update next_birthday_greeting for user.", "", __LINE__, __FILE__, $sql); 
	} 
	$template->assign_var("GREETING_POPUP", 
	"<script language=\"java*script\" type=\"text/java*script\"><!-- 
	window.open('".append_sid('birthday_popup.'.$phpEx)."', '_phpbbprivmsg', 'HEIGHT=225,resizable=yes,WIDTH=400'); 
	//--> 
	</script>"); 
	} //Sorry user shall not have a greeting this year 

	if ( $userdata['user_profile_view'] )
	{
		$template->assign_var("PROFILE_VIEW",
				"<script language=\"Javascript\" type=\"text/javascript\"><!--
				   window.open('".append_sid('profile_view_popup.'.$phpEx)."', '_phpbbprofileview', 'HEIGHT=225,resizable=yes,WIDTH=400');
				  //-->
		</script>");
	}

	if ( $userdata['user_new_privmsg'] && $userdata['user_sound_pm'] == 0 )
	{
	      $l_message_new = ( $userdata['user_new_privmsg'] == 1 ) ? $lang['New_nsnd_pm'] : $lang['New_nsnd_pms']; 
	      $l_privmsgs_text = sprintf($l_message_new, $userdata['user_new_privmsg']); 
	
	} 
	else if ( $userdata['user_new_privmsg'] && $userdata['user_sound_pm'] == 1 ) { 
	
	      $l_message_new = ( $userdata['user_new_privmsg'] == 1 ) ? $lang['New_pm'] : $lang['New_pms']; 
	      $l_privmsgs_text = sprintf($l_message_new, $userdata['user_new_privmsg']); 

		if ( $userdata['user_last_privmsg'] > $userdata['user_lastvisit'] )
		{
			$sql = "UPDATE " . USERS_TABLE . "
				SET user_last_privmsg = " . $userdata['user_lastvisit'] . "
				WHERE user_id = " . $userdata['user_id'];
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not update private message new/read time for user', '', __LINE__, __FILE__, $sql);
			}

			$s_privmsg_new = 1;
			$icon_pm = $images['pm_new_msg'];
		}
		else
		{
			$s_privmsg_new = 0;
			$icon_pm = $images['pm_new_msg'];
		}
	}
	else
	{
		$l_privmsgs_text = $lang['No_new_pm'];

		$s_privmsg_new = 0;
		$icon_pm = $images['pm_no_new_msg'];
	}

	if ( $userdata['user_unread_privmsg'] )
	{
		$l_message_unread = ( $userdata['user_unread_privmsg'] == 1 ) ? $lang['Unread_pm'] : $lang['Unread_pms'];
		$l_privmsgs_text_unread = sprintf($l_message_unread, $userdata['user_unread_privmsg']);
	}
	else
	{
		$l_privmsgs_text_unread = $lang['No_unread_pm'];
	}
}
else
{
	$icon_pm = $images['pm_no_new_msg'];
	$l_privmsgs_text = $lang['Login_check_pm'];
	$l_privmsgs_text_unread = '';
	$s_privmsg_new = 0;
}

//
// Generate HTML required for Mozilla Navigation bar
//
if (!isset($nav_links))
{
	$nav_links = array();
}

$nav_links_html = '';
$nav_link_proto = '<link rel="%s" href="%s" title="%s" />' . "\n";
while( list($nav_item, $nav_array) = @each($nav_links) )
{
	if ( !empty($nav_array['url']) )
	{
		$nav_links_html .= sprintf($nav_link_proto, $nav_item, append_sid($nav_array['url']), $nav_array['title']);
	}
	else
	{
		// We have a nested array, used for items like <link rel='chapter'> that can occur more than once.
		while( list(,$nested_array) = each($nav_array) )
		{
			$nav_links_html .= sprintf($nav_link_proto, $nav_item, $nested_array['url'], $nested_array['title']);
		}
	}
}

$points = ( $userdata['session_logged_in'] ) ? sprintf($lang['You_points'], $userdata['user_points'], $board_config['points_name']) : ''; 

//
// Complete banner
//
$time_now=time();
$hour_now=create_date('Hi',$time_now,$board_config['board_timezone']);
$date_now=create_date('Ymd',$time_now,$board_config['board_timezone']);
$week_now=create_date('w',$time_now,$board_config['board_timezone']);
$sql = "SELECT banner_id, banner_name, banner_spot, banner_description 
		FROM " . BANNERS_TABLE . "
		WHERE banner_active and (banner_timetype='0' 
		OR (( $hour_now BETWEEN time_begin AND time_end) AND ((banner_timetype='2'
		OR (( $week_now BETWEEN date_begin AND date_end) AND banner_timetype='4')
		OR (( $date_now BETWEEN date_begin AND date_end) AND banner_timetype='6')
		)))) ORDER BY banner_spot,SUBSTRING(RAND(),4,2)*banner_weigth";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Couldn't get banners data", "", __LINE__, __FILE__, $sql);
} 
while ($banner = $db->sql_fetchrow($result))
{
	$banner_spot=$banner['banner_spot'];	
	if ($banner_spot<>$last_spot)
	{
		$template->assign_vars(array('BANNER_'.$banner_spot.'_IMG' => '<a href="'.append_sid('redirect.'.$phpEx.'?banner_id='.$banner['banner_id']).'" target="_blank"><img src="'.$banner['banner_name'].'" border="0" alt="'.$banner['banner_description'].'" title="'.$banner['banner_description'].'"></a>'));
		$banner_show_list.= ', '.$banner['banner_id'];
	}
	$last_spot=$banner_spot;
}
$banner_show_list['0'] = ($banner_show_list) ? ' ':'';
// only apply the next lines, if view count is enabled
if ($last_spot)
{
$sql = "UPDATE " . BANNERS_TABLE . " 
		SET banner_view=banner_view+1 WHERE banner_id IN ($banner_show_list)"; 
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't get banners data", "", __LINE__, __FILE__, $sql);
	}
}

//
// Prillian
//
if( !isset($refresh_javascript) ) 
{
	$refresh_javascript = '';
}

if( !isset($meta_headers) ) 
{
	$meta_headers = '';
}

if ( !defined('IN_PRILLIAN_LANG') )
{
	include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_prillian.' . $phpEx);
}

$im_auto_popup = 0;

if( defined('IN_BUDDY') && defined('SHOW_ONLINE') )
{
	alert_check($buddy_list);
}

if ( !defined('IN_PRILLIAN') )
{
	$phpbb_im_path = $phpbb_root_path . 'mods/prillian/';
	define('IN_PRILLIAN', true);
	if( $userdata['user_id'] != ANONYMOUS )
	{
		if(!defined('PRILL_FUN'))
		{
			include($phpbb_im_path . 'functions_im.'.$phpEx);
		}
		if ( !isset($im_userdata) )
		{
			$im_userdata = init_imprefs($userdata['user_id']);
		}
		$im_auto_popup = auto_prill_check();
	}

	if ( $im_userdata['new_ims'] )
	{
		$l_phpbbim_msg = ( $im_userdata['new_ims'] > 1 ) ? $lang['New_ims']: $lang['New_im'];
		$l_phpbbim_text = sprintf($l_phpbbim_msg, $im_userdata['new_ims']);
	}
	elseif ( $im_userdata['unread_ims'] )
	{
		$l_phpbbim_msg = ( $im_userdata['unread_ims'] > 1 ) ? $lang['Unread_ims']: $lang['Unread_im'];
		$l_phpbbim_text = sprintf($l_phpbbim_msg, $im_userdata['unread_ims']);
	}
	else
	{
		$l_phpbbim_text = $lang['Launch_phpBB_IM'];
	}
}

//
// Admin nav-link configuration
//
$navlink_portal = $nav_config['navlink_portal'];
$navlink_index = $nav_config['navlink_index'];
$navlink_profile = $nav_config['navlink_profile'];
$navlink_pm = $nav_config['navlink_pm'];
$navlink_faq = $nav_config['navlink_faq'];
$navlink_search = $nav_config['navlink_search'];
$navlink_calendar = $nav_config['navlink_calendar'];
$navlink_members = $nav_config['navlink_members'];
$navlink_imlist = $nav_config['navlink_imlist'];
$navlink_imsg = $nav_config['navlink_imsg'];
$navlink_points = $nav_config['navlink_points'];
$navlink_album = $nav_config['navlink_album'];
$navlink_foing = $nav_config['navlink_foing'];
$navlink_charts = $nav_config['navlink_charts'];
$navlink_smilies = $nav_config['navlink_smilies'];
$navlink_groups = $nav_config['navlink_groups'];
$navlink_toplist = $nav_config['navlink_toplist'];
$navlink_links = $nav_config['navlink_links'];
$navlink_ircchat = $nav_config['navlink_ircchat'];
$navlink_pafiledb = $nav_config['navlink_pafiledb'];
$navlink_rating = $nav_config['navlink_rating'];
$navlink_stats = $nav_config['navlink_stats'];
$navlink_ban = $nav_config['navlink_ban'];
$navlink_staff = $nav_config['navlink_staff'];
$navlink_kb = $nav_config['navlink_kb'];
$navlink_radio = $nav_config['navlink_radio'];
if ($navlink_profile)
{
	$template->assign_block_vars("switch_navlink_profile", array() );
}
if ($navlink_pm)
{
	$template->assign_block_vars("switch_navlink_pm", array() );
}
if ($navlink_portal)
{
	$template->assign_block_vars("switch_navlink_portal", array() );
}
if ($navlink_index)
{
	$template->assign_block_vars("switch_navlink_index", array() );
}
if ($navlink_faq)
{
	$template->assign_block_vars("switch_navlink_faq", array() );
}
if ($navlink_search)
{
	$template->assign_block_vars("switch_navlink_search", array() );
}
if ($navlink_calendar)
{
	$template->assign_block_vars("switch_navlink_calendar", array() );
}
if ($navlink_members)
{
	$template->assign_block_vars("switch_navlink_members", array() );
}
if ($navlink_imlist)
{
	$template->assign_block_vars("switch_navlink_imlist", array() );
}
if ($navlink_imsg)
{
	$template->assign_block_vars("switch_navlink_imsg", array() );
}
if ($navlink_points)
{
	$template->assign_block_vars("switch_navlink_points", array() );
}
if ($navlink_album)
{
	$template->assign_block_vars("switch_navlink_album", array() );
}
if ($navlink_foing)
{
	$template->assign_block_vars("switch_navlink_foing", array() );
}
if ($navlink_charts)
{
	$template->assign_block_vars("switch_navlink_charts", array() );
}
if ($navlink_smilies)
{
	$template->assign_block_vars("switch_navlink_smilies", array() );
}
if ($navlink_groups)
{
	$template->assign_block_vars("switch_navlink_groups", array() );
}
if ($navlink_toplist)
{
	$template->assign_block_vars("switch_navlink_toplist", array() );
}
if ($navlink_links)
{
	$template->assign_block_vars("switch_navlink_links", array() );
}
if ($navlink_ircchat)
{
	$template->assign_block_vars("switch_navlink_ircchat", array() );
}
if ($navlink_pafiledb)
{
	$template->assign_block_vars("switch_navlink_pafiledb", array() );
}
if ($navlink_rating)
{
	$template->assign_block_vars("switch_navlink_rating", array() );
}
if ($navlink_stats)
{
	$template->assign_block_vars("switch_navlink_stats", array() );
}
if ($navlink_ban)
{
	$template->assign_block_vars("switch_navlink_ban", array() );
}
if ($navlink_staff)
{
	$template->assign_block_vars("switch_navlink_staff", array() );
}
if ($navlink_kb)
{
	$template->assign_block_vars("switch_navlink_kb", array() );
}
if ($navlink_radio)
{
	$template->assign_block_vars("switch_navlink_radio", array() );
}

$page_transition = $board_config['page_transition'];
$site_descs = explode("@@@",$board_config['site_desc']);

// Format Timezone. We are unable to use array_pop here, because of PHP3 compatibility
$l_timezone = explode('.', $board_config['board_timezone']);
$l_timezone = (count($l_timezone) > 1 && $l_timezone[count($l_timezone)-1] != 0) ? $lang[sprintf('%.1f', $board_config['board_timezone'])] : $lang[number_format($board_config['board_timezone'])];

//
// The following assigns all _common_ variables that may be used at any point
// in a template.
//
$template->assign_vars(array(
	'SITENAME' => $board_config['sitename'],
	'SITE_DESCRIPTION' => $site_descs[rand(0,count($site_descs) - 1)],
	'META_TAG' => '<META NAME="Keywords" content="' . $board_config['meta_keywords'] .'"><META NAME="Description" content="' . $board_config['meta_description'] .'"><META NAME="revisit-after" content="' . $board_config['meta_revisit'] .' days"><META NAME="author" content="' . $board_config['meta_author'] .'"><META NAME="owner" content="' . $board_config['meta_owner'] .'"><META NAME="distribution" content="' . $board_config['meta_distribution'] .'"><META NAME="robots" content="' . $board_config['meta_robots'] .'"><META NAME="abstract" content="' . $board_config['meta_abstract'] .'">',
	'SITE_LOGO' => $board_config['site_logo'],
	'CUSTOM_OVERALL_HEADER' => $board_config['custom_overall_header'],
	'CUSTOM_OVERALL_FOOTER' => $board_config['custom_overall_footer'],
	'CUSTOM_SIMPLE_HEADER' => $board_config['custom_simple_header'],
	'CUSTOM_SIMPLE_FOOTER' => $board_config['custom_simple_footer'],
	'PAGE_TITLE' => $page_title,
	'LAST_VISIT_DATE' => sprintf($lang['You_last_visit'], $s_last_visit),
	'CURRENT_TIME' => sprintf($lang['Current_time'], create_date($board_config['default_dateformat'], time(), $board_config['board_timezone'])),
	'TOTAL_USERS_ONLINE' => $l_online_users,
	'LOGGED_IN_USER_LIST' => $online_userlist,
	'RECORD_USERS' => sprintf($lang['Record_online_users'], $board_config['record_online_users'], create_date($board_config['default_dateformat'], $board_config['record_online_date'], $board_config['board_timezone'])),
	'RECORD_DAY_USERS' => sprintf($lang['Record_day_users'], $board_config['record_day_users'], create_date($board_config['default_dateformat'], $board_config['record_day_date'], $board_config['board_timezone'])),  	

	'PRIVATE_MESSAGE_INFO' => $l_privmsgs_text,
	'PRIVATE_MESSAGE_INFO_UNREAD' => $l_privmsgs_text_unread,
	'PRIVATE_MESSAGE_NEW_FLAG' => $s_privmsg_new,
	'PRIVMSG_IMG' => $icon_pm,

	'ADMIN_LINK' => $admin_link, 	
	'POINTS' => $points,
	'PAGE_TRANSITION' => $page_transition,
	'SERVER_NAME' => $board_config['server_name'],

 	'NEWS_TITLE' => $news_config['news_title'],
      'NEWS_COLOR' => $news_config['news_color'],
      'NEWS_BLOCK' => $news_config['news_block'],
      'NEWS_STYLE' => $news_config['news_style'],
      'NEWS_BOLD' => $news_config['news_bold'],
      'NEWS_ITAL' => $news_config['news_ital'],
      'NEWS_UNDER' => $news_config['news_under'],
      'NEWS_SIZE' => $news_config['news_size'],
      'SCROLL_SPEED' => $news_config['scroll_speed'],
      'SCROLL_ACTION' => $news_config['scroll_action'],
      'SCROLL_BEHAVIOR'=> $news_config['scroll_behavior'],
      'SCROLL_SIZE' => $news_config['scroll_size'],

	'L_USERNAME' => $lang['Username'],
	'L_PASSWORD' => $lang['Password'],
	'L_LOGIN_LOGOUT' => $l_login_logout,
	'L_LOGIN' => $lang['Login'],
	'L_LOG_ME_IN' => $lang['Log_me_in'],
	'L_AUTO_LOGIN' => $lang['Log_me_in_auto'],
	'L_INDEX' => $lang['Forum_Index'],
	'L_PORTAL' => $lang['Portal'],
	'L_REGISTER' => $lang['Register'],
	'L_PROFILE' => $lang['Edit_profile'],
	'L_SEARCH' => $lang['Search'],
	'L_PRIVATEMSGS' => $lang['Private_Messages'],
	'L_WHO_IS_ONLINE' => $lang['Who_is_Online'],
	'L_MEMBERLIST' => $lang['Memberlist'],
	'L_FAQ' => $lang['FAQ'],
	'L_USERGROUPS' => $lang['Usergroups'],
	'L_EMOTICONS' => $lang['Emoticons'],
	'L_LINKS' => $lang['Links'],
	'L_DOWNLOAD' => $lang['Download'], 
	'L_STAFF' => $lang['Staff'],
	'L_ADDTOFAVORITES' => $lang['Add_to_Favorites'], 
	'L_MAKEHOMEPAGE' => $lang['Make_Homepage'],
	'L_ATTACHMENTS' => $lang['Attachments'], 
	'L_PLAYER' => $lang['Player'], 
	'L_STATISTICS' => $lang['Stats'], 
	'L_CALENDAR' => $lang['Calendar'],
	'L_BANK' => $lang['Bank'],
	'L_SHOP' => $lang['Shop'],
	'L_RATINGS' => $lang['Rating'],
	'L_TOPLIST' => $lang ['Toplist'], 
	'L_SEARCH_NEW' => $lang['Search_new'],
	'L_SEARCH_FLAGS' => $lang['Search_flags'], 
	'L_SEARCH_UNANSWERED' => $lang['Search_unanswered'],
	'L_VIEW_LAST_24_HOURS' => $lang['View_last_24_hours'],
	'L_SEARCH_SELF' => $lang['Search_your_posts'],
	'L_SEARCH_TOPICS' => $lang['View_your_topics'], 
	'L_VIEW_RANDOM_TOPIC' => $lang['View_random_topic'], 
	'L_WHOSONLINE_ADMIN' => sprintf($lang['Admin_online_color'], '<span style="color:#' . $theme['adminfontcolor'] . '">', '</span>'),
	'L_WHOSONLINE_SUPERMOD' => sprintf($lang['Super_Mod_online_color'], '<span style="color:#' . $theme['supermodfontcolor'] . '">', '</span>'),
	'L_WHOSONLINE_MOD' => sprintf($lang['Mod_online_color'], '<span style="color:#' . $theme['modfontcolor'] . '">', '</span>'),
	'L_CHANGE_NOW' => $lang['Go'], 
	'L_STYLE' => $lang['Style'],
	'L_USERCP' => $lang['User_CP'],
	'L_PROFILE_SETTINGS' => $lang['Profile_settings'],
	'L_BUDDY_LIST' => $lang['Buddy_list'],
	'L_PERSONAL_GALLERY' => $lang['Personal_gallery'],
	'L_USER_ACP' => $lang['User_acp_title'],
	'L_ALL_FORUMS' => $lang['All_forums'],
	'L_IRC_CHAT' => $lang['IRC_chat'],
	'L_HANDLE' => $userdata['username'],
	'L_CHANGE_NICK' => $lang['Change_nick'],
	'L_VISITORS_SINCE' => $lang['Visitors_since'],
	'L_LATEST_PIC' => $lang['Latest_pic'],
	'L_POSTED' => $lang['Posted'],
	'L_BY' => $lang['By'],
	'L_SHOUTBOX' => $lang['Shoutbox'],
	'L_IMLIST' => $lang['IM_list'],
	'L_GAMES' => $lang['Online_games'],
	'L_CHARTS' => $lang['Charts'],
	'L_BAN' => $lang['Ban'],
	'L_KB' => $lang['KB_title'],
	'L_RADIO' => $lang['Radio1'],

	'L_CUSTOM_HEADER' => $advance_html['custom_header'],
	'L_CUSTOM_BODY' => $advance_html['custom_body'],
	'L_CUSTOM_BODY_HEADER' => $advance_html['custom_body_header'],
	'L_CUSTOM_FOOTER' => $advance_html['custom_footer'],

	'L_LOTTERY' => $lang['Lottery'],
	'L_LOTWINNER' => $lang['LotteryWinners'],
	'U_LOTTERY' => append_sid('lottery.'.$phpEx),
	'U_LOTWINNER' => append_sid('lotwin.'.$phpEx),

	'IM_AUTO_POPUP' => $im_auto_popup, 
	'IM_META' => $meta_headers,
	'IM_RELOAD' => $refresh_javascript,
	'IM_MAIN_HEIGHT' => $im_userdata['win_main_height'],
	'IM_MAIN_WIDTH' => $im_userdata['win_main_width'],
	'IM_ONLINE_HEIGHT' => $im_userdata['win_online_height'],
	'IM_ONLINE_WIDTH' => $im_userdata['win_online_width'],
	'U_IM_LAUNCH' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=frames&oldmode=main"),
	'U_IM_WO_LAUNCH' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=frames&oldmode=who"),
	'U_IM_MINI_LAUNCH' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=mini"),
	'L_IM_LAUNCH' => $l_phpbbim_text,

	'L_ALBUM' => $lang['Album'], 
	'L_NEWEST_PIC' => $lang['Newest_pic'],
	'L_PIC_TITLE' => $lang['Pic_Title'],
	'L_POSTER' => $lang['Poster'],
	'L_POSTED' => $lang['Posted'],
	'L_COMMENT' => $lang['Post_comment'],
	'U_ALBUM' => append_sid('album.'.$phpEx),

	'U_SEARCH_UNANSWERED' => append_sid('search.'.$phpEx.'?search_id=unanswered'),
	'U_SEARCH_SELF' => append_sid('search.'.$phpEx.'?search_id=egosearch'),
	'U_SEARCH_NEW' => append_sid('search.'.$phpEx.'?search_id=newposts'),
	'U_SEARCH_TOPICS' => append_sid('topics.'.$phpEx),
	'U_SEARCH_FLAGS' => append_sid('search.'.$phpEx.'?search_id=flagsearch'), 
	'U_VIEW_RANDOM_TOPIC' => append_sid('viewtopic.'.$phpEx.'?view=random'), 
	'U_PORTAL' => append_sid('portal.'.$phpEx),
	'U_INDEX' => append_sid('index.'.$phpEx),
	'U_REGISTER' => append_sid('profile.'.$phpEx.'?mode=register'),
	'U_PROFILE' => append_sid('profile.'.$phpEx.'?mode=editprofile'),
	'U_PRIVATEMSGS' => append_sid('privmsg.'.$phpEx.'?folder=inbox'),
	'U_PRIVATEMSGS_POPUP' => append_sid('privmsg.'.$phpEx.'?mode=newpm'),
	'U_SEARCH' => append_sid('search.'.$phpEx),
	'U_MEMBERLIST' => append_sid('memberlist.'.$phpEx),
	'U_MODCP' => append_sid('modcp.'.$phpEx),
	'U_FAQ' => append_sid('faq.'.$phpEx),
	'U_VIEWONLINE' => append_sid('viewonline.'.$phpEx),
	'U_LOGIN_LOGOUT' => append_sid($u_login_logout),
	'U_GROUP_CP' => append_sid('groupcp.'.$phpEx),
	'U_EMOTICONS' => append_sid('smilies.'.$phpEx),
	'U_LINKS' => append_sid('links.'.$phpEx),
	'U_LINKS1' => append_sid('link.'.$phpEx), 
	'U_DOWNLOAD' => append_sid('dload.'.$phpEx),
	'U_STAFF' => append_sid('staff.'.$phpEx),
	'U_ATTACHMENTS' => append_sid('attachments.'.$phpEx),
	'U_PLAYER' => append_sid('player/index.'.$phpEx),
	'U_STATISTICS' => append_sid('statistics.'.$phpEx),
	'U_CALENDAR' => append_sid('calendar.'.$phpEx),
	'U_BANK' => append_sid('bank.'.$phpEx),
	'U_SHOP' => append_sid('shop.'.$phpEx),
	'U_SHOP_TRANSACTION' => append_sid('shop_transactions.'.$phpEx),
	'U_RATINGS' => append_sid('ratings.'.$phpEx),
	'U_USERCP' => append_sid('usercp.'.$phpEx),
	'U_BID' => append_sid('bid.'.$phpEx.'?mode=show&type=buddy'),
	'U_USERCP_GALLERY' => append_sid('album_personal.'.$phpEx.'?user_id=' . $userdata[user_id]),
	'U_UACP' => append_sid('uacp.'.$phpEx . '?u=' . $userdata['user_id'] . '&amp;sid=' . $userdata['session_id']),
	'U_ALL_FORUMS' => append_sid('allforums.'.$phpEx),
	'U_IRC_CHAT' => append_sid('chatroom.'.$phpEx),
	'U_IMLIST' => append_sid('imlist.'.$phpEx),
	'U_TOPLIST' => append_sid('toplist.'.$phpEx),
	'U_GAMES' => append_sid('activity.'.$phpEx),
	'U_CHARTS' => append_sid('charts.'.$phpEx.'?action=list'),
	'U_BAN' => append_sid('banlist.'.$phpEx),
	'U_KB' => append_sid('kb.'.$phpEx),

	'U_MY_TRANS' => append_sid('mytransfer.'.$phpEx),
	'U_VIEW_TRANS_TO' => append_sid('viewtransto.'.$phpEx),
	'U_VIEW_TRANS_FROM' => append_sid('viewtransfrom.'.$phpEx),
	'U_GLOBAL_TRANS' => append_sid('transaction.'.$phpEx),
	'L_MY_TRANS' => $lang['My_Trans'],
	'L_GLOBAL_TRANS' => $lang['Global_Trans'],	

	'S_CONTENT_DIRECTION' => $lang['DIRECTION'],
	'S_CONTENT_ENCODING' => $lang['ENCODING'],
	'S_CONTENT_DIR_LEFT' => $lang['LEFT'],
	'S_CONTENT_DIR_RIGHT' => $lang['RIGHT'],
	'S_TIMEZONE' => sprintf($lang['All_times'], $l_timezone),
	'S_LOGIN_ACTION' => append_sid('login.'.$phpEx),

	'T_HEAD_STYLESHEET' => $theme['head_stylesheet'],
	'T_BODY_BACKGROUND' => $theme['body_background'],
	'T_BODY_BGCOLOR' => '#'.$theme['body_bgcolor'],
	'T_BODY_TEXT' => '#'.$theme['body_text'],
	'T_BODY_LINK' => '#'.$theme['body_link'],
	'T_BODY_VLINK' => '#'.$theme['body_vlink'],
	'T_BODY_ALINK' => '#'.$theme['body_alink'],
	'T_BODY_HLINK' => '#'.$theme['body_hlink'],
	'T_TR_COLOR1' => '#'.$theme['tr_color1'],
	'T_TR_COLOR2' => '#'.$theme['tr_color2'],
	'T_TR_COLOR3' => '#'.$theme['tr_color3'],
	'T_TR_CLASS1' => $theme['tr_class1'],
	'T_TR_CLASS2' => $theme['tr_class2'],
	'T_TR_CLASS3' => $theme['tr_class3'],
	'T_TH_COLOR1' => '#'.$theme['th_color1'],
	'T_TH_COLOR2' => '#'.$theme['th_color2'],
	'T_TH_COLOR3' => '#'.$theme['th_color3'],
	'T_TH_CLASS1' => $theme['th_class1'],
	'T_TH_CLASS2' => $theme['th_class2'],
	'T_TH_CLASS3' => $theme['th_class3'],
	'T_TD_COLOR1' => '#'.$theme['td_color1'],
	'T_TD_COLOR2' => '#'.$theme['td_color2'],
	'T_TD_COLOR3' => '#'.$theme['td_color3'],
	'T_TD_CLASS1' => $theme['td_class1'],
	'T_TD_CLASS2' => $theme['td_class2'],
	'T_TD_CLASS3' => $theme['td_class3'],
	'T_FONTFACE1' => $theme['fontface1'],
	'T_FONTFACE2' => $theme['fontface2'],
	'T_FONTFACE3' => $theme['fontface3'],
	'T_FONTSIZE1' => $theme['fontsize1'],
	'T_FONTSIZE2' => $theme['fontsize2'],
	'T_FONTSIZE3' => $theme['fontsize3'],
	'T_FONTCOLOR1' => '#'.$theme['fontcolor1'],
	'T_FONTCOLOR2' => '#'.$theme['fontcolor2'],
	'T_FONTCOLOR3' => '#'.$theme['fontcolor3'],
	'T_ADMINFONTCOLOR' => '#'.$theme['adminfontcolor'], 
	'T_SUPERMODFONTCOLOR' => '#'.$theme['supermodfontcolor'], 
	'T_MODFONTCOLOR' => '#'.$theme['modfontcolor'], 
	'T_SPAN_CLASS1' => $theme['span_class1'],
	'T_SPAN_CLASS2' => $theme['span_class2'],
	'T_SPAN_CLASS3' => $theme['span_class3'],

	'VISIT_COUNTER' => sprintf($lang['Visit_counter'], $visit_counter),
	'NAV_LINKS' => $nav_links_html)
);

//
// Login box?
//
if ( !$userdata['session_logged_in'] )
{
	$template->assign_block_vars('switch_user_logged_out', array());
}
else
{
	$template->assign_block_vars('switch_user_logged_in', array());

	if ( !empty($userdata['user_popup_pm']) )
	{
		$template->assign_block_vars('switch_enable_pm_popup', array());
	}
}

// Add no-cache control for cookies if they are set
//$c_no_cache = (isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid']) || isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_data'])) ? 'no-cache="set-cookie", ' : '';

// Work around for "current" Apache 2 + PHP module which seems to not
// cope with private cache control setting
if (!empty($_SERVER['SERVER_SOFTWARE']) && strstr($_SERVER['SERVER_SOFTWARE'], 'Apache/2'))
{
	header ('Cache-Control: no-cache, pre-check=0, post-check=0');
}
else
{
	header ('Cache-Control: private, pre-check=0, post-check=0, max-age=0');
}
header ('Expires: 0');
header ('Pragma: no-cache');

// Split topic types

// split global announce (Not used yet!)
// $switch_split_global_announce = isset($lang['Post_global_announcement']);
// if ( isset($lang['Post_global_announcement']) && !isset( $board_config['split_global_announce'] ) )
// {
// 	$sqlw = "INSERT INTO ".CONFIG_TABLE." (config_name,config_value) VALUES('split_global_announce','" . $switch_split_global_announce . "')";
// 	if ( !($resultw = $db->sql_query($sqlw)) ) message_die(GENERAL_ERROR, 'Could not add key split_global_annonce in config table', '', __LINE__, __FILE__, $sql);
// 	$board_config['split_global_announce'] = $switch_split_global_announce;
// }
// if ( isset($lang['Post_global_announcement']) && isset( $board_config['split_global_announce'] ) )
// {
//	$switch_split_global_announce = $board_config['split_global_announce'];
// }

// split standard announce
$switch_split_announce = true;
if ( !isset( $board_config['split_announce'] ) )
{
	$sqlw = "INSERT INTO ".CONFIG_TABLE." (config_name,config_value) VALUES('split_announce','" . $switch_split_announce . "')";
	if ( !($resultw = $db->sql_query($sqlw)) ) message_die(GENERAL_ERROR, 'Could not add key split_annonce in config table', '', __LINE__, __FILE__, $sql);
	$board_config['split_announce'] = $switch_split_announce;
}
if ( isset( $board_config['split_announce'] ) )
{
	$switch_split_announce = $board_config['split_announce'];
}

// split sticky
$switch_split_sticky = true;
if ( !isset( $board_config['split_sticky'] ) )
{
	$sqlw = "INSERT INTO ".CONFIG_TABLE." (config_name,config_value) VALUES('split_sticky','" . $switch_split_sticky . "')";
	if ( !($resultw = $db->sql_query($sqlw)) ) message_die(GENERAL_ERROR, 'Could not add key split_sticky in config table', '', __LINE__, __FILE__, $sql);
	$board_config['split_sticky'] = $switch_split_sticky;
}
if ( isset( $board_config['split_sticky'] ) )
{
	$switch_split_sticky = $board_config['split_sticky'];
}

$template->pparse('overall_header');

?>