<?php
/***************************************************************************
*                                 move.php
*                            -------------------
*   begin                : Thursday, June 14, 2001
*   copyright            : (C) 2001 The phpBB Group
*   email                : support@phpbb.com
*
*   $Id: move.php,v 1.00 2003/01/13 11:16:00 psotfx Exp $
*
*
***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
   die("Hacking attempt");
}

require($phpbb_root_path . 'includes/functions_search.'.$phpEx);

function move($forum_id, $move_date, $destination_id)
{
	global $db, $lang;

	$sql_topics = '';
	$new_forum_id = $destination_id;
	$old_forum_id = $forum_id;

	//
	// Those without polls ...
	//
	$sql = "SELECT t.topic_id 
		FROM " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t
		WHERE t.forum_id = $forum_id
			AND t.topic_vote = 0 
			AND t.topic_type <> " . POST_ANNOUNCE . " 
			AND ( p.post_id = t.topic_last_post_id 
				OR t.topic_last_post_id = 0 )";
	if ( $move_date != '' )
	{
		$sql .= " AND p.post_time < $move_date";
	}

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain lists of topics to move', '', __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		$sql_topics .= ( ( $sql_topics != '' ) ? ', ' : '' ) . $row['topic_id'];
	}
		
	if( $sql_topics != '' )
	{
		$sql = "SELECT post_id
			FROM " . POSTS_TABLE . " 
			WHERE forum_id = $forum_id 
				AND topic_id IN ($sql_topics)";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain list of posts to move', '', __LINE__, __FILE__, $sql);
		}

		$sql_post = '';
		while ( $row = $db->sql_fetchrow($result) )
		{
			$sql_post .= ( ( $sql_post != '' ) ? ', ' : '' ) . $row['post_id'];
		}

		if ( $sql_post != '' )
		{
			$sql = "UPDATE " . TOPICS_TABLE . " 
				SET forum_id = $new_forum_id 
				WHERE topic_id IN ($sql_topics)";

			if ( !$db->sql_query($sql, BEGIN_TRANSACTION) )
			{
				message_die(GENERAL_ERROR, 'Could not move topics during move', '', __LINE__, __FILE__, $sql);
			}

			$moved_topics = $db->sql_affectedrows();

			$sql = "UPDATE " . POSTS_TABLE . " 
				SET forum_id = $new_forum_id 
				WHERE post_id IN ($sql_post)";

			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not move post_text during move', '', __LINE__, __FILE__, $sql);
			}

			$moved_posts = $db->sql_affectedrows();

			return array ('topics' => $moved_topics, 'posts' => $moved_posts);
		}
	}

	return array('topics' => 0, 'posts' => 0);
}
?>