<?php
/***************************************************************************
 *                                imlist.php
 *                            -------------------
 *   begin                : Friday, Aug 31, 2002
 *   copyright            : (C) 2003 Jeremy Rogers
 *   email                : thoul@users.sourceforge.net
 *
 *   $Id: imlist.php,v 1.4.0 2003/02/12 17:00:00 Thoul Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/
/***************************************************************************
 *								THOUL SAYS
 *   A lot of the code in this file is lifted from or based on the original
 *   memberlist.php, which is (C) The phpBB Group.
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/07/31 21:26:45 mj 
 *
 ***************************************************************************/

// Configuration Variables - these determine how the IM List behaves

// $cfg['notall'] - determines if all members are displayed or only members with
// a value in the user database table for the specified Instant Messenger
//
// Possible settings: TRUE - displays only members with the IM information
//						FALSE - displays all members
// Example: $cfg['notall'] = TRUE;

$cfg['notall'] = TRUE; 

// $cfg['notall_string'] - string used to limit sql query if $cfg['notall'] is TRUE.
// The string should contain comma separated values. Any strings (words) should be 
// enclosed in single 'quotes'. Constants, like NULL should not.
// Example: $cfg['notall'] = "' ','none',NULL";
//
// If you wanted to "ban" a certain IM name, you could add it here. The person with
// the IM name would not appear in listings of that IM program. It's recommended to
// leave the defaults in the list.
// Example: $cfg['notall'] = "' ','none',NULL,'SexyChick'";

$cfg['notall_string'] = "' ','none',NULL";

// $cfg['default_im'] - determines the default Instant Messenger that will be
// displayed when the page is first loaded. Never leave this blank (but if you do,
// ICQ will be used).
//
// Examples of possible values: 
// $cfg['default_im'] = 'all';   // Display all types by default
// $cfg['default_im'] = 'icq';   // Display ICQ by default
// $cfg['default_im'] = 'yim';   // Display Yahoo by default
// $cfg['default_im'] = 'aim';   // Display AOL by default
// $cfg['default_im'] = 'msnm';  // Display MSN by default

 $cfg['default_im'] = 'all';   // Display ICQ by default

// $cfg['registered'] - determines if users must be logged in to view the list.
//
// Possible settings: TRUE - Users must be logged in (Guests cannot see the list)
//						FALSE - Users don't have to be logged in (Guests can see it)
// Example: $cfg['notall'] = TRUE;

$cfg['registered'] = TRUE;

// End Configuration Variables



define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_IMLIST);
init_userprefs($userdata);
//
// End session management
//

if( $cfg['registered'] && !$userdata['session_logged_in'] )
{
	if( $board_config['version'] >= '.0.4' )
	{
		redirect(append_sid("login.$phpEx?redirect=imlist.php", true));
	}
	else
	{
		$header_location = ( @preg_match("/Microsoft|WebSTAR|Xitami/", getenv("SERVER_SOFTWARE")) ) ? "Refresh: 0; URL=" : "Location: ";
		header($header_location . append_sid("login.$phpEx?redirect=imlist.php", true));
		exit;
	}
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

$im_type = '';

if( !empty( $HTTP_GET_VARS['im_type'] ) || $HTTP_POST_VARS['im_type'] )
{
	$temp_type = ( $HTTP_GET_VARS['im_type'] ) ? $HTTP_GET_VARS['im_type'] : $HTTP_POST_VARS['im_type'];
}
else
{
	$temp_type = $cfg['default_im'];
}

switch( $temp_type )
{
	case "all":
		$im_type['sql'] = 'user_yim, user_aim, user_msnm, user_icq';
		$im_type['name']['user_yim'] = $lang['YIM'];
		$im_type['name']['user_aim'] = $lang['AIM'];
		$im_type['name']['user_msnm'] = $lang['MSNM'];
		$im_type['name']['user_icq'] = $lang['ICQ'];
		$im_type['limit'] = array('user_yim', 'user_aim', 'user_msnm', 'user_icq');
		$im_type['type'] = 'all';
		break;
	case "yim":
		$im_type['sql'] = 'user_yim';
		$im_type['name'] = $lang['YIM'];
		$im_type['type'] = 'yim';
		break;
	case "aim":
		$im_type['sql'] = 'user_aim';
		$im_type['name'] = $lang['AIM'];
		$im_type['type'] = 'aim';
		break;
	case "msnm":
		$im_type['sql'] = 'user_msnm';
		$im_type['name'] = $lang['MSNM'];
		$im_type['type'] = 'msnm';
		break;
	case "icq":
	default:
		$im_type['sql'] = 'user_icq';
		$im_type['name'] = $lang['ICQ'];
		$im_type['type'] = 'icq';
		break;
}


if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if( $cfg['notall'] )
{
	$sort_order = 'ASC';
}
else
{
	$sort_order = 'DESC';
}

//
// Instant Messenger list sorting
//
$mode_types_text = array($lang['Select_imtype_method'], $lang['Sort_Username']);
$mode_types = array('im_type', 'username');

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';


$mode_im_types_text = array($lang['All'], $lang['AIM'], $lang['ICQ'], $lang['MSNM'], $lang['YIM']);
$mode_im_types = array('all', 'aim', 'icq', 'msnm', 'yim');

$select_im_type_mode = '<select name="im_type">';
for($i = 0; $i < count($mode_im_types_text); $i++)
{
	$selected = ( $im_type['type'] == $mode_im_types[$i] ) ? ' selected="selected"' : '';
	$select_im_type_mode .= '<option value="' . $mode_im_types[$i] . '"' . $selected . '>' . $mode_im_types_text[$i] . '</option>';
}
$select_im_type_mode .= '</select>';

//
// Generate page
//
$page_title = $lang['Instant_messenger_list'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'imlist_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$order_by = '';

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];

	switch( $mode )
	{
		case 'username':
			$order_by = " ORDER BY username $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'im_type':
		default:
			$order_by = ' ORDER BY ' . $im_type['sql'] . " $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
	}
}
else
{
	$order_by = ' ORDER BY ' . $im_type['sql'] . " $sort_order LIMIT $start, " . $board_config['topics_per_page'];
}

$sql = 'SELECT username, user_id, ' . $im_type['sql'] . ' 
	FROM ' . USERS_TABLE . '
	WHERE user_id <> ' . ANONYMOUS;

if ( $cfg['notall'] && $im_type['type'] != 'all' )
{
	$sql .= ' AND ' .  $im_type['sql'] . ' NOT IN (' . $cfg['notall_string'] .')';
}
elseif( $cfg['notall'] )
{
	$sql .= ' AND ( ';

	while(list($key, $val) = each($im_type['limit']))
	{
		$sql .= '(' . $val . ' NOT IN (' . $cfg['notall_string'] .')) OR ';
	}

	$sql =  substr($sql, 0, -4) . ' )';
}


$sql .=	$order_by;

if( !($result = $db->sql_query($sql)) )
{
	$str = "sql: $im_type[sql] type:  $im_type[type] name:  $im_type[name] ";
	message_die(GENERAL_ERROR, $str, '', __LINE__, __FILE__, $sql);
}

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_SELECT_IMTYPE_METHOD' => $lang['Select_imtype_method'],
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],
	'L_SUBMIT' => $lang['Sort'],

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_IMTYPE_SELECT' => $select_im_type_mode,
	'S_MODE_ACTION' => append_sid("imlist.$phpEx"))
);


if( $im_type['type'] == 'all' )
{
	$template->assign_block_vars('switch_all_top', array(
		"L_IMTYPE_user_yim" => $im_type['name']['user_yim'],
		"L_IMTYPE_user_aim" => $im_type['name']['user_aim'],
		"L_IMTYPE_user_msnm" => $im_type['name']['user_msnm'],
		"L_IMTYPE_user_icq" => $im_type['name']['user_icq'])
	);
}
else
{
	$template->assign_block_vars('switch_single_top', array(
		'L_IMTYPE' => $im_type['name']
	));
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$username = $row['username'];
		$user_id = $row['user_id'];

		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id");

		$im_type['img'] = array();
		$im_type['str'] = array();

		if( !empty($row['user_yim']) )
		{
			$im_type['img']['user_yim'] = '<a href="ymsgr:sendIM?' . $row['user_yim'] . '&__you+there?"><img src="http://opi.yahoo.com/online?u=' . $row['user_yim'] . '&m=g&t=1" alt="' . $lang['YIM'] . '" title="' . $lang['YIM'] . '" border="0" /></a>';
			$im_type['str']['user_yim'] = '<a href="ymsgr:sendIM?' . $row['user_yim'] . '&__you+there?">' . $lang['YIM'] . '</a>';
		}
		else		
		{
			$im_type['img']['user_yim'] = '';
			$im_type['str']['user_yim'] = '';
		}

		if( !empty($row['user_aim']) )
		{
			$im_type['img']['user_aim'] = '<a href="aim:goim?screenname=' . $row['user_aim'] . '&amp;message=Hello+Are+you+there?"><img src="http://big.oscar.aol.com/' . $row['user_aim'] . '?on_url='.$images['icon_aim_online'].'&off_url='.$images['icon_aim_offline'].'" alt="' . $lang['AIM'] . '" title="' . $lang['AIM'] . '" border="0" /></a>';
			$im_type['str']['user_aim'] = '<a href="aim:goim?screenname=' . $row['user_aim'] . '&amp;message=Hello+Are+you+there?">' . $lang['AIM'] . '</a>';
		}
		else		
		{
			$im_type['img']['user_aim'] = '';
			$im_type['str']['user_aim'] = '';
		}

		if( !empty($row['user_msnm']) )
		{
                  $im_type['img']['user_msnm'] = '<a href=\'javascript:DoInstantMessage("'.$row['user_msnm'].'","'.$row['username'].'");\'><img src="' . $images['icon_msnm'] . '" alt="' . $lang['MSNM'] . '" title="' . $lang['MSNM'] . '" border="0" /></a>';
                  $im_type['str']['user_msnm'] = '<a href=\'javascript:DoInstantMessage("'.$row['user_msnm'].'","'.$row['username'].'");\'>' . $lang['MSNM'] . '</a>';
		}
		else		
		{
			$im_type['img']['user_msnm'] = '';
			$im_type['str']['user_msnm'] = '';
		}

		if ( !empty($row['user_icq']) )
		{
			$im_type['img']['user_icq'] = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $row['user_icq'] . '"><img src="' . $images['icon_icq'] . '" alt="' . $lang['ICQ'] . '" title="' . $lang['ICQ'] . '" border="0" /></a>';
			$im_type['str']['user_icq'] =  '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $row['user_icq'] . '">' . $lang['ICQ'] . '</a>';
		}
		else		
		{
			$im_type['img']['user_icq'] = '';
			$im_type['str']['user_icq'] = '';
		}
		

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars('memberrow', array(
			'ROW_NUMBER' => $i + ( $start + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'USERNAME' => $username,
			'U_VIEWPROFILE' => $temp_url)
		);

		if( $im_type['type'] == 'all' )
		{
			$template->assign_block_vars('memberrow.switch_all_list', array(
				"IMTYPE_IMG_user_yim" => $im_type['img']['user_yim'],
				"IMTYPE_user_yim" => $im_type['str']['user_yim'],
				"IMTYPE_IMG_user_aim" => $im_type['img']['user_aim'],
				"IMTYPE_user_aim" => $im_type['str']['user_aim'],
				"IMTYPE_IMG_user_msnm" => $im_type['img']['user_msnm'],
				"IMTYPE_user_msnm" => $im_type['str']['user_msnm'],
				"IMTYPE_IMG_user_icq" => $im_type['img']['user_icq'],
				"IMTYPE_user_icq" => $im_type['str']['user_icq'])
			);
		}
		else
		{
			$template->assign_block_vars('memberrow.switch_single_list', array(
				'IMTYPE_IMG' => $im_type['img'][$im_type['sql']],
				'IMTYPE' => $im_type['str'][$im_type['sql']])
			);
		}

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}




if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = 'SELECT count(*) AS total
			FROM ' . USERS_TABLE . '
			WHERE user_id <> ' . ANONYMOUS;

	if ( $cfg['notall'] && $im_type['type'] != 'all' )
	{
		$sql .= ' AND ' .  $im_type['sql'] . ' NOT IN (' . $cfg['notall_string'] .')';
	}
	elseif( $cfg['notall'] )
	{
		$sql .= ' AND ( ';

		reset($im_type['limit']);
		while(list($key, $val) = each($im_type['limit']))
		{
			$sql .= '(' . $val . ' NOT IN (' . $cfg['notall_string'] .')) OR ';
		}

		$sql =  substr($sql, 0, -4) . ' )';
	}
	
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	}
	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_members = $total['total'];

		$pagination = generate_pagination("imlist.$phpEx?mode=$mode&amp;order=$sort_order&amp;im_type=" . $im_type['type'], $total_members, $board_config['topics_per_page'], $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_members = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_members / $board_config['topics_per_page'] )), 

	'L_GOTO_PAGE' => $lang['Goto_page'])
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>