<?php
/***************************************************************************
 *                               imclient.php
 *                            -------------------
 *   begin                : Wednesday, Nov 6, 2002
 *   version              : 0.6.0
 *   date                 : 2003/06/08 16:29
 ***************************************************************************/

define('IN_PHPBB', true);
define('IN_PRILLIAN', true);
define('IN_BUDDY', true);

$phpbb_root_path = './';

// Path to Instant Messenger files other than imclient.php
$phpbb_im_path = $phpbb_root_path . 'mods/prillian/';
// Path to BID files other than bid.php
$phpbb_bid_path = $phpbb_root_path . 'mods/bid/';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

// Use simple header to avoid extra images and 
// error messages that don't fit the window.
$gen_simple_header = TRUE; 

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_PRILLIAN);
init_userprefs($userdata);
//
// End session management
//

// Old mode check - oldmode will be the mode of the IM Client before clicking a
// preferences link.
if ( !empty($HTTP_POST_VARS['oldmode']) || !empty($HTTP_GET_VARS['oldmode']) )
{
	$oldmode = ( !empty($HTTP_POST_VARS['oldmode']) ) ? $HTTP_POST_VARS['oldmode'] : $HTTP_GET_VARS['oldmode'];
}
else
{
	$oldmode = 'main';
}

// mode check
if ( !empty($HTTP_POST_VARS['mode']) || !empty($HTTP_GET_VARS['mode']) )
{
	$mode = ( !empty($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = 'frames';
}

include($phpbb_im_path . 'functions_im.'.$phpEx);

//
// Not logged in? Then go to the login page.
//
if ( !$userdata['session_logged_in'] )
{
	thoul_redirect('login.' . $phpEx . '?simple=1&redirect=imclient.' . $phpEx . '&mode=' . $mode);
}

include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_prillian.' . $phpEx);
include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_bid.' . $phpEx);

// session id check
if (!empty($HTTP_POST_VARS['sid']) || !empty($HTTP_GET_VARS['sid']))
{
	$sid = (!empty($HTTP_POST_VARS['sid'])) ? $HTTP_POST_VARS['sid'] : $HTTP_GET_VARS['sid'];
}
else
{
	$sid = '';
}

//
// Are instant messages disabled?
//
if ( !$board_config['im_allow_ims'] )
{
	$message = $lang['IM_disabled'] . $lang['Close_window_link'];
	message_die(GENERAL_MESSAGE, $message);
}

// Include commonly used files
include($phpbb_bid_path . 'functions_bid.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);

// Get user's IM Preferences
$im_userdata = array();
$im_userdata = init_imprefs($userdata['user_id'], true);

//
// Have IM privs for the user been turned off by admin?
//
if ( !$im_userdata['admin_allow_ims'] )
{
	$message = $lang['Cannot_send_im_admin'] . $lang['Close_window_link'];
	message_die(GENERAL_MESSAGE, $message);
}

//
// Have IM privs for the user been turned off by user?
//http://127.0.0.1/~phpbb/204/imclient.php?mode=editprofile&oldmode=main
if ( !$im_userdata['user_allow_ims'] && $mode !='editprofile')
{
	$message = sprintf($lang['Cannot_send_im'], '<a href="' . append_sid("imclient.$phpEx?mode=editprofile&oldmode=" . $mode . '_' . $oldmode) . '" onClick="javascript:window.open(\'' . append_sid("imclient.$phpEx?mode=editprofile&oldmode=" . $mode . '_' . $oldmode) . '\', \'im_prefs\', \'scrollbars, resizable, height=' . $im_userdata['win_online_height'] . ', innerHeight=' . $im_userdata['win_online_height'] . ', innerWidth=' . $im_userdata['win_online_width'] . ', width=' . $im_userdata['win_online_width'] . '\'); return false">', '</a>');
	$message .= $lang['Close_window_link'];
	message_die(GENERAL_MESSAGE, $message);
}

// Initialize some common variables we my need.

$submit = ( isset($HTTP_POST_VARS['post']) ) ? TRUE : 0;
$saveclose = ( isset($HTTP_POST_VARS['saveclose']) ) ? TRUE : 0;
$savereply = ( isset($HTTP_POST_VARS['savereply']) ) ? TRUE : 0;
$save_sent_im = ( isset($HTTP_POST_VARS['save_sent']) ) ? TRUE : 0;
$mark_read = ( isset($HTTP_GET_VARS['mark_read']) ) ? TRUE : 0;
$delete = ( isset($HTTP_POST_VARS['delete']) ) ? TRUE : 0;
$mark_list = ( !empty($HTTP_POST_VARS['mark']) ) ? $HTTP_POST_VARS['mark'] : 0;

$error = FALSE;
$meta_headers = '';
$refresh_javascript = '';
$mode_append = '';
$read_mark = '';
$include_footer = false;

// Default page title - displayed on every phpBB IM window
// Extra stuff may be added later in the script
$page_title = $lang['Prillian'];

// Default phpBB IM message subject - we have this so you don't need a subject
// on every message.
$default_im_subject = $lang['phpBB_IM_default_subject'];

switch($mode)
{
	case 'frames':
		// Frames of IM Client
		if( empty($oldmode) )
		{
			$oldmode = 'main';
		}

		$template->set_filenames(array(
			'body' => 'imclient_frameset.tpl')
		);

		$u_refresher = append_sid($phpbb_root_path . 'imclient.' . $phpEx . '?mode=' . $oldmode);
		$u_control = append_sid($phpbb_root_path . 'imclient.' . $phpEx . '?mode=controls&oldmode=' . $oldmode);
		$template->assign_vars(array(
			'L_PRILLIAN' => $page_title,
			'U_IM_PATH' => $phpbb_im_path,
			'U_REFRESHER' => $u_refresher,
			'U_CONTROL' => $u_control
		));

		$include_footer = false;
		break;
	case 'controls':
		// Print Controls frame
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);

		$template->set_filenames(array(
			'body' => 'imclient_controls_frame.tpl')
		);

		$template->assign_vars(array(
			'IMG_LOGO' => $images['prill_logo'],
			'L_PRILLIAN' => $lang['Prillian']
		));

		print_controls('?mode=' . $oldmode,  'frames_' . $oldmode);
		break;
	case 'read':
		// Read a message
		include($phpbb_im_path . 'im_read.'.$phpEx);
		break;
	case 'editprofile':
		// Has admin set board to override user settings?
		if( $board_config['im_override_users'] )
		{
			// Yes? Then tell them and offer to close the window.
			$message = $lang['Admin_override'] . $lang['Close_window_link'];
			message_die(GENERAL_MESSAGE, $message);
		}
		else
		{
			// No? Then edit the profile.
			include($phpbb_im_path . 'usercp_imprefs.'.$phpEx);
		}
		break;
	case 'post':
	case 'reply':
		// Send or reply to a message
		include($phpbb_root_path . 'includes/functions_post.'.$phpEx);
		include($phpbb_im_path . 'im_send.'.$phpEx);
		break;
	case 'who':
	case 'main':
		// Start and/or update IM Client sessions
		im_session_update();

		// Main IM Client or Who's Online Client
		include($phpbb_im_path . 'im_main.'.$phpEx);
		break;
//	case 'mini':
		// Start and/or update IM Client sessions
//		im_session_update();
//
		// And I shall call him... mini mode!
//		include($phpbb_im_path . 'im_mini.'.$phpEx);
		// I've never actually seen that movie.
//		break;
	case 'log':
		// View the Message Log
		include($phpbb_im_path . 'im_log.'.$phpEx);
		break;
}

$template->pparse('body');

if( $include_footer )
{
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}
else
{
	$db->sql_close();
}
?>