<?php 
/***************************************************************************
 *                              glance.php
 *                            -------------------
 *   begin                : Monday, Apr 07, 2001
 *   copyright            : blulegend, Jack Kan
 *   contact              : www.phpbb.com, member: blulegend
 *   version              : 2.2.1
 *
 *   $FMId: 2003/04/29 19:07:45 mj 
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

define('IN_GLANCE', true);

include('glance_config.php');

	//
	// GET USER LAST VISIT
	//
	$glance_last_visit = $userdata['user_lastvisit'];
	
	//
	// MESSAGE TRACKING
	//
	if ( !isset($tracking_topics) && $glance_track ) $tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : '';
	
	// CHECK FOR BAD WORDS
	//
	// Define censored word matches
	//
	$orig_word = array();
	$replacement_word = array();
	obtain_word_list($orig_word, $replacement_word);
	
	//
	// GET THE LATEST NEWS TOPIC
	//
	if ( $glance_num_news )
	{
		$news_data = $db->sql_fetchrow($result);
		if ( 1 )
		{
			$sql_select = ", p.post_time";
			$sql_from = ", " . POSTS_TABLE . " p";
			$sql_where = " AND p.post_id = t.topic_last_post_id";
		}
		$sql = "SELECT t.topic_id, t.topic_title, t.topic_time" . $sql_select . "
			FROM " . TOPICS_TABLE . " t" . $sql_from . "
			WHERE t.forum_id = " . $glance_news_forum_id . $sql_where . "
				AND t.topic_moved_id = 0
			ORDER BY t.topic_last_post_id DESC
			LIMIT " . $glance_num_news;
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Could not query new news information", "", __LINE__, __FILE__, $sql);
		}
		$latest_news = array();
		while ( $topic_row = $db->sql_fetchrow($result) )
		{
			$topic_row['topic_title'] = ( count($orig_word) ) ? preg_replace($orig_word, $replacement_word, $topic_row['topic_title']) : $topic_row['topic_title'];
			$latest_news[] = $topic_row;
		}
		$db->sql_freeresult($result);
	}
	
	//
	// GET THE LAST 5 TOPICS
	//
	if ( $glance_num_recent )
	{
		$unauthed_forums = array();
		$sql = "SELECT forum_id, auth_view FROM " . FORUMS_TABLE . " WHERE forum_id <> " . $glance_news_forum_id;
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Could not query new topic information", "", __LINE__, __FILE__, $sql);
		}
		$glance_auth_level = ( $glance_auth_read ) ? AUTH_VIEW : AUTH_ALL;

		$is_auth_ary = auth($glance_auth_level, AUTH_LIST_ALL, $userdata);
		
		$forumsignore = '';

		if ( $num_forums = count($is_auth_ary) )
		{
			while ( list($forum_id, $auth_mod) = each($is_auth_ary) )
			{
				$unauthed = false;
				if ( !$auth_mod['auth_view'] && $auth_mod['forum_id'] != $glance_news_forum_id )
				{
					$unauthed = true;
				}
				if ( !$glance_auth_read && !$auth_mod['auth_read'] && $auth_mod['forum_id'] != $glance_news_forum_id )
				{
					$unauthed = true;
				}
				if ( !$glance_auth_read && !$auth_mod['auth_read'] && !$auth_mod['auth_view'] ) 
				{ 
					$unauthed = true; 
				} 
				if ( $unauthed )
				{
					$forumsignore .= $forum_id . ', ';
				}
			}
		}
		
		$sql = "SELECT t.topic_title, t.topic_id, p2.post_time
			FROM " . POSTS_TABLE . " p, " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p2 
			WHERE t.forum_id NOT IN (" . $forumsignore . $glance_news_forum_id . ") 
				AND p.post_id = t.topic_first_post_id
				AND p2.post_id = t.topic_last_post_id
				AND t.topic_type <> " . POST_ANNOUNCE . "
				AND t.topic_moved_id = 0
			ORDER BY t.topic_last_post_id DESC
			LIMIT " . $glance_num_recent;
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Could not query latest topic information", "", __LINE__, __FILE__, $sql);
		}
		$latest_topics = array();
		while ( $topic_row = $db->sql_fetchrow($result) )
		{
			$topic_row['topic_title'] = ( count($orig_word) ) ? preg_replace($orig_word, $replacement_word, $topic_row['topic_title']) : $topic_row['topic_title'];
			$latest_topics[] = $topic_row;
		}
		$db->sql_freeresult($result);
	}
	
	//
	// BEGIN OUTPUT
	//
	$template->set_filenames(array(
		'glance_output' => 'forum_glance_body.tpl')
	);
	
	if ( $glance_num_news )
	{
		if ( !empty($latest_news) )
		{
			$bullet_pre = 'glance_news_bullet';
			
			for ( $i = 0; $i < count($latest_news); $i++ )
			{
				if ( $userdata['session_logged_in'] )
				{
					$unread_topics = false;
					$topic_id = $latest_news[$i]['topic_id'];
					if ( $latest_news[$i]['post_time'] > $glance_last_visit )
					{
						$unread_topics = true;
						if( !empty($tracking_topics[$topic_id]) && $glance_track )
						{
							if( $tracking_topics[$topic_id] >= $latest_news[$i]['post_time'] )
							{
								$unread_topics = false;
							}
						}
					}
					$shownew = $unread_topics;
				}
				else
				{
					$unread_topics = false;
					$shownew = true;
				}

				$bullet_full = $bullet_pre . ( ( $shownew && $glance_show_new_bullets ) ? '_new' : '_old' );

				$newest_code = ( $unread_topics && $glance_show_new_bullets ) ? '&amp;view=newest' : '';
				
				$topic_link = $glance_forum_dir . 'viewtopic.php?t=' . $latest_news[$i]['topic_id'] . $newest_code;
				
				$template->assign_block_vars('news', array(
					'BULLET' => $$bullet_full,					
					'TOPIC_TITLE' => $latest_news[$i]['topic_title'],
					'TOPIC_LINK' => $topic_link,
					
					'TOPIC_TIME' => create_date($lang['DATE_FORMAT'], $latest_news[$i]['post_time'], $board_config['board_timezone']))
					);
			}
		}
		else
		{
			$template->assign_block_vars('news', array(
			'BULLET' => $glance_recent_bullet_old,
					
			'TOPIC_TITLE' => $lang['None'])
			);
		}
	}
	
	if ( $glance_num_recent )
	{
		$glance_info = 'counted recent';
		$bullet_pre = 'glance_recent_bullet';

		if ( !empty($latest_topics) )
		{
			for ( $i = 0; $i < count($latest_topics); $i++ )
			{
				if ( $userdata['session_logged_in'] )
				{
					$unread_topics = false;
					$topic_id = $latest_topics[$i]['topic_id'];
					if ( $latest_topics[$i]['post_time'] > $glance_last_visit )
					{
						$unread_topics = true;
						if( !empty($tracking_topics[$topic_id]) && $glance_track )
						{
							if( $tracking_topics[$topic_id] >= $latest_topics[$i]['post_time'] )
							{
								$unread_topics = false;
							}
						}
					}
					$shownew = $unread_topics;
				}
				else
				{
					$unread_topics = false;
					$shownew = true;
				}

				$bullet_full = $bullet_pre . ( ( $shownew && $glance_show_new_bullets ) ? '_new' : '_old' );

				$newest_code = ( $unread_topics && $glance_show_new_bullets ) ? '&amp;view=newest' : '';
				
				$topic_link = $glance_forum_dir . 'viewtopic.php?t=' . $latest_topics[$i]['topic_id'] . $newest_code;
				
				$template->assign_block_vars('recent', array(
					'BULLET' => $$bullet_full,
					'TOPIC_LINK' => $topic_link,
					
					'TOPIC_TITLE' => $latest_topics[$i]['topic_title'])
				);
			}
		}
		else
		{
			$template->assign_block_vars('recent', array(
			'BULLET' => $glance_recent_bullet_old,
					
			'TOPIC_TITLE' => $lang['None'])
			);
		}
	}
	
	if ( $glance_num_news )
	{
		$template->assign_block_vars('switch_glance_news', array());
	}
	if ( $glance_num_recent )
	{
		$template->assign_block_vars('switch_glance_recent', array());
	}

	$template->assign_vars(array(
		'NEWS_HEADING' => $lang['glance_news_heading'], 
		'RECENT_HEADING' => $lang['glance_recent_heading']) 
	);
		
	$template->assign_var_from_handle('GLANCE_OUTPUT', 'glance_output');
	
?>
