<?php
/***************************************************************************
 *                                dload.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: index.php,v 1.99.2.1 2002/12/19 17:17:40 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
define('IN_DOWNLOAD', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_DOWNLOAD);
init_userprefs($userdata);
//
// End session management
//

//===================================================
// Include the common file
//===================================================

include($phpbb_root_path . 'pafiledb/pafiledb_common.'.$phpEx);

//===================================================
// Get action variable other wise set it to the main
//===================================================

if ( isset($_REQUEST['action']) )
{
	$action = $_REQUEST['action'];
}
else
{
	$action = 'main';
}

//===================================================
// if the database disabled give them a nice message
//===================================================

if($pafiledb_config['settings_disable'])
{
	message_die(GENERAL_MESSAGE, $lang['pafiledb_disable']);        
}

//===================================================
// Get pafiledb
//===================================================

$pafiledb = new pafiledb();

//===================================================
// an array of all expected actions
//===================================================

$actions = array('download' => 'download',
				 'category' => 'category', 
				 'file' => 'file', 
				 'viewall' => 'viewall', 
				 'search' => 'search', 
				 'license' => 'license', 
				 'rate' => 'rate', 
				 'email' => 'email', 
				 'stats' => 'stats', 
				 'toplist' => 'toplist', 
				 'user_upload' => 'user_upload', 
				 'post_comment' => 'post_comment',
				 'main' => 'main');


//===================================================
// Lets Build the page
//===================================================


$page_title = $lang['Download'];
if($action != 'download')
{
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
}

$pafiledb->module($actions[$action]);
$pafiledb->modules[$actions[$action]]->main($action);

if($action != 'download')
{
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}


//===================================================
// pafiledb class
//===================================================
				 
class pafiledb
{
	var $modules = array();
	var $error = array();

	function module($module_name)
	{
		if (!class_exists('pafiledb_' . $module_name))
		{
			$this->loadfile('pafiledb/modules/pa_' . $module_name);
			eval('$this->modules[' . $module_name . '] = new pafiledb_' . $module_name . '();');
		}
	}

	function loadfile($filename)
	{
		global $phpbb_root_path, $phpEx;

		return require($phpbb_root_path . $filename . '.' . $phpEx);
	}

	function main($module_id = false)
	{
		return false;
	}

	function output(&$page_title, $tpl_name)
	{
		global $pafiledb_config, $db, $pafiledb_template, $phpEx, $board_config, $phpbb_root_path;
		
		pafiledb_page_header($page_title);
		
		$pafiledb_template->set_filenames(array(
			'body' => $tpl_name)
		);

		pafiledb_page_footer();
	}
}
?>
