<?php
/***************************************************************************
 *                             mini_cal.php
 *                            -------------------
 *   Author  		: 	netclectic - Adrian Cockburn - adrian@netclectic.com
 *   Created 		: 	Sunday, July 14, 2002
 *	 Last Updated	:	Friday, May 09, 2003
 *
 *	 Version		: 	MINI_CAL - 1.1.11
 *
 ***************************************************************************/
if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}
define ('IN_MINI_CAL', 1);

	include($phpbb_root_path . 'calendar/mini_cal/mini_cal_config.'.$phpEx);
	include($phpbb_root_path . 'calendar/mini_cal/calendarSuite.'.$phpEx);

    // initialise our calendarsuite class
	$mini_cal = new calendarSuite();
    
    // setup our mini_cal template
	$template->set_filenames(array(
		'usercp_mini_cal_body' => 'usercp_mini_cal_body.tpl')
	);

    // initialise some variables
    $cal_month = 0;
    $mini_cal_today = create_date('Ymd', time(), $board_config['board_timezone']);
    if( isset($HTTP_GET_VARS['month']) || isset($HTTP_POST_VARS['month']) )
    {
    	$cal_month = ( isset($HTTP_POST_VARS['month']) ) ? intval($HTTP_POST_VARS['month']) : intval($HTTP_GET_VARS['month']);
    }
    $s_cal_month = ($cal_month != 0) ? $cal_month . ' month' : $mini_cal_today;
	$mini_cal->getMonth($s_cal_month);
	$mini_cal_count=MINI_CAL_FDOW;
    $mini_cal_this_year = $mini_cal->dateYYYY;
    $mini_cal_this_month = $mini_cal->dateMM;
    $mini_cal_month_days = $mini_cal->daysMonth;

    if ( MINI_CAL_MYCAL_VERSION != 'NONE' )
    {
        // initialise our forums auth list
    	$mini_cal_auth_ary = array();
    	$mini_cal_auth_ary = auth(AUTH_ALL, AUTH_LIST_ALL, $userdata);
    
        $auth_view_forums = '';
        $auth_post_forums = '';
        while ( list($mini_cal_forum_id, $mini_cal_auth_level) = each($mini_cal_auth_ary) )
        {
            if ( $mini_cal_auth_level['auth_view'] )
            {
               $auth_view_forums .= ($auth_view_forums == '') ? $mini_cal_forum_id : ', ' . $mini_cal_forum_id;
            }
    
            if ( ($mini_cal_auth_level['auth_post']) && ((MINI_CAL_MYCAL_VERSION == 'PLUS' ) ? $mini_cal_auth_level['auth_calendar'] : true) )
            {
               $auth_post_forums .= ($auth_post_forums == '') ? $mini_cal_forum_id : ', ' . $mini_cal_forum_id;
            }
        }
    
    
    // if MINI_CAL_DATE_SEARCH = EVENTS 
    // then we need to get a list of dates which have events in the current month
        if ( (MINI_CAL_DATE_SEARCH == 'EVENTS') && ($auth_view_forums != '') )
    {
        $mini_cal_event_days = array();
            $sql = "SELECT DAYOFMONTH(c.cal_date) as event_day 
                FROM " . MYCALENDAR_TABLE . " c, " . FORUMS_TABLE . " f 
                WHERE f.forum_id = c.forum_id
                   AND f.forum_id IN ($auth_view_forums) 
                   AND YEAR(cal_date) = $mini_cal_this_year 
                   AND MONTH(cal_date) = $mini_cal_this_month";
    	if( $result = $db->sql_query($sql) )
        {
            while( $row = $db->sql_fetchrow($result) )
            {
                $mini_cal_event_days[] = $row['event_day'];
            }
        }
    }
    }
    
    // output the days for the current month 
    // if MINI_CAL_DATE_SEARCH = POSTS then hyperlink any days which have already past
    // if MINI_CAL_DATE_SEARCH = EVENTS then hyperkink any which have events
	for($i=0; $i < $mini_cal_month_days;) 
	{
        // is this the first day of the week?
		if($mini_cal_count==MINI_CAL_FDOW)
		{
			$template->assign_block_vars('mini_cal_row', array());
		}
        
        // is this a valid weekday?
		if($mini_cal_count==($mini_cal->day[$i][7])) 
		{
            $mini_cal_this_day = $mini_cal->day[$i][0];
        
            $d_mini_cal_today = $mini_cal_this_year . ( ($mini_cal_this_month <= 9) ? '0' . $mini_cal_this_month : $mini_cal_this_month ) . ( ($mini_cal_this_day <= 9) ? '0' . $mini_cal_this_day : $mini_cal_this_day );
            $mini_cal_day = ( $mini_cal_today == $d_mini_cal_today ) ? '<span class="topicTitle">'.$mini_cal_this_day.'</span>' : $mini_cal_this_day;
            if ( MINI_CAL_DATE_SEARCH == 'EVENTS' )
            {
                $mini_cal_day = ( in_array($mini_cal_this_day, $mini_cal_event_days) ) ? '<a href="' . append_sid($phpbb_root_path . "search.$phpEx?search_id=mini_cal_events&amp;d=" . $d_mini_cal_today) . '" class="genmed">' . ( $mini_cal_day ) . '</a>' : $mini_cal_day;
            }
            else
            {
                $nix_mini_cal_today = mktime (0, 0, 0, $mini_cal_this_month, $mini_cal_this_day, $mini_cal_this_year);
                $mini_cal_day = ( $mini_cal_today >= $d_mini_cal_today ) ? '<a href="' . append_sid($phpbb_root_path . "search.$phpEx?search_id=mini_cal&amp;d=" . $nix_mini_cal_today) . '" class="genmed">' . ( $mini_cal_day ) . '</a>' : $mini_cal_day;   
           }
			$template->assign_block_vars('mini_cal_row.mini_cal_days', array(
				'MINI_CAL_DAY' => $mini_cal_day
				)
			); 
			$i++;
		} 
        // no day
		else 
		{
			$template->assign_block_vars('mini_cal_row.mini_cal_days', array(
				'MINI_CAL_DAY' => ' ')
			); 
		}

        // is this the last day of the week?
        if ($mini_cal_count==6)
        {
            // if so the reset the count
            $mini_cal_count=0;
        }
        else
        {
            // otherwise increment the count
            $mini_cal_count++;
        }
	}
	
    
    if ( MINI_CAL_MYCAL_VERSION != 'NONE' )
        {
    // initialise some sql bits
    $mini_cal_auth_sql = ($auth_view_forums != '') ? ' AND t.forum_id in (' . $auth_view_forums . ') ' : '';
    $days_ahead_sql = (MINI_CAL_DAYS_AHEAD > 0) ? " AND (c.cal_date <= DATE_ADD(CURDATE(), INTERVAL " . MINI_CAL_DAYS_AHEAD . " DAY)) " : '';
    
    // get the events 
	$sql = "SELECT 
              c.topic_id, c.cal_date, c.forum_id, 
              MONTH(c.cal_date) as cal_month, 
              DAYOFWEEK(DATE_SUB(c.cal_date, INTERVAL " . MINI_CAL_FDOW . " DAY)) as cal_weekday, 
              DAYOFMONTH(c.cal_date) as cal_monthday, 
              YEAR(c.cal_date) as cal_year, 
              HOUR(c.cal_date) as cal_hour, 
              MINUTE(c.cal_date) as cal_min, 
              SECOND(c.cal_date) as cal_sec, 
              t.topic_title 
	        FROM 
	          " . MYCALENDAR_TABLE . " as c,
	          " . TOPICS_TABLE . " as t
	        WHERE 
              c.topic_id = t.topic_id 
              AND (c.cal_date >= CURDATE()) 
              $days_ahead_sql
              $mini_cal_auth_sql
	        ORDER BY 
	          c.cal_date ASC
	        LIMIT 
	          0," . MINI_CAL_LIMIT;

    // did we get a result? 
    // if not then the user does not have MyCalendar installed
    // so just die quielty don't bother to output an error message
	if( $result = $db->sql_query($sql) )
	{
       // ok we've got MyCalendar
       $template->assign_block_vars('switch_mini_cal_events', array());
       if ( $db->sql_numrows($result) > 0 )
       {
           // we've even got some events
           // initialise out date formatting patterns
               $cal_date_pattern = array('/%a/', '/%b/', '/%c/', '/%d/', '/%e/', '/%m/', '/%y/', '/%Y/', '/%H/', '/%k/', '/%h/', '/%l/', '/%i/', '/%s/', '/%p/');

           // output our events in the given date format for the current language
   	       while ($row = $db->sql_fetchrow($result))
           {
                $cal_date_replace = array( 
                    $lang['mini_cal']['day'][$row['cal_weekday']], 
                    $lang['mini_cal']['month'][$row['cal_month']], 
                    $row['cal_month'], 
                    ( (strlen($row['cal_monthday']) < 2 ) ?  '0' : '' ) . $row['cal_monthday'], 
                    $row['cal_monthday'], 
                    ( (strlen($row['cal_month']) < 2 ) ?  '0' : '' ) . $row['cal_month'], 
                    substr($row['cal_year'], -2),
                    $row['cal_year'],
                    ( (strlen($row['cal_hour']) < 2 ) ?  '0' : '' ) . $row['cal_hour'],
                    $row['cal_hour'],
                    ( (strlen($row['cal_hour']) < 2 ) ?  '0' : '' ) . ( ( $row['cal_hour'] > 12 ) ? $row['cal_hour']-12 : $row['cal_hour'] ),
                    ( $row['cal_hour'] > 12 ) ? $row['cal_hour']-12 : $row['cal_hour'],
                    $row['cal_min'],
                    $row['cal_sec'],
                    ( $row['cal_hour'] < 12 ) ? 'AM' : 'PM'                
			);
                    
                $cal_date = preg_replace($cal_date_pattern, $cal_date_replace, $lang['Mini_Cal_date_format']); 
    			$template->assign_block_vars('mini_cal_events', array(
    					'MINI_CAL_EVENT_DATE' => $cal_date,
                      		'S_MINI_CAL_EVENT' => $row['topic_title'], 
    					'U_MINI_CAL_EVENT' => append_sid( $phpbb_root_path . "viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $row['topic_id'] )
                        )
    			); 
           }
       }
       else
       {
            // no events :(
            $template->assign_block_vars('mini_cal_no_events', array());
       }
       $db->sql_freeresult($result);

       // output a list of events forums depending on the users auth level
       if ($auth_post_forums != '')
       {
           // get a list of events forums
               $standard_auth = ( MINI_CAL_MYCAL_VERSION == 'STANDARD' ) ? ' AND events_forum=1' : '';
           $sql = 'SELECT forum_id, forum_name 
                FROM '  . FORUMS_TABLE . '
                    WHERE forum_id IN (' . $auth_post_forums . ')' . $standard_auth;
           if( $result = $db->sql_query($sql) )
    	   {
               $num_rows = $db->sql_numrows($result);
               if ( $num_rows > 0 )
               {
                   $template->assign_block_vars('switch_mini_cal_add_events', array());
        
                   $forums_list = '<select name="' . POST_FORUM_URL . '" onchange="if(this.options[this.selectedIndex].value != -1){ forms[\'mini_cal\'].submit() }">';
                   // if we've only got one events forum then don't bother with the select a forum bit
                   $forums_list .= ( $num_rows > 1 ) ? '<option value="-1">' . $lang['Select_forum'] . '</option><option value="-1">----------------</option>' : '';
                        
           	       while ($row = $db->sql_fetchrow($result))
                   {
                        $forums_list .=  '<option value="' . $row['forum_id'] . '"' . $selected . '>' . $row['forum_name'] . '</option>';
                   }
                   $forums_list .= '</select>';
                   
                   $template->assign_vars( array(
                        'S_MINI_CAL_ACTION' => append_sid( $phpbb_root_path . 'posting.' . $phpEx ),
                        'S_MINI_CAL_EVENTS_FORUMS_LIST' => $forums_list 
                        )
                   );
               }    
               $db->sql_freeresult($result);
           }
       }
	}
    }
    
    // output our general calendar bits
    $prev_month = '<a href="' . append_sid($_SERVER["PHP_SELF"] . "?month=" . ($cal_month - 1)) . '" class="gen">' . (( MINI_CAL_USE_IMAGES ) ? '<img src="' . $images['icon_left_arrow'] . '" title="' . $lang['View_previous_month'] . '" border="0" alt="&lt;&lt;">' : '&lt;&lt;') . '</a>';
    $next_month = '<a href="' . append_sid($_SERVER["PHP_SELF"] . "?month=" . ($cal_month + 1)) . '" class="gen">' . (( MINI_CAL_USE_IMAGES ) ? '<img src="' . $images['icon_right_arrow'] . '" title="' . $lang['View_next_month'] . '" border="0" alt="&gt;&gt;">' : '&gt;&gt;') . '</a>';
	$template->assign_vars(array(
		'L_MINI_CAL_MONTH' => $lang['mini_cal']['long_month'][$mini_cal->day[0][4]] . " " . $mini_cal->day[0][5],
		'L_MINI_CAL_ADD_EVENT' => $lang['Mini_Cal_add_event'],
		'L_MINI_CAL_CALENDAR' => $lang['Calendar'], 
		'L_MINI_CAL_EVENTS' => $lang['Mini_Cal_events'], 
        	'L_MINI_CAL_NO_EVENTS' => $lang['None'],
		'L_MINI_CAL_SUN' => $lang['mini_cal']['day'][1], 
		'L_MINI_CAL_MON' => $lang['mini_cal']['day'][2], 
		'L_MINI_CAL_TUE' => $lang['mini_cal']['day'][3], 
		'L_MINI_CAL_WED' => $lang['mini_cal']['day'][4], 
		'L_MINI_CAL_THU' => $lang['mini_cal']['day'][5], 
		'L_MINI_CAL_FRI' => $lang['mini_cal']['day'][6], 
		'L_MINI_CAL_SAT' => $lang['mini_cal']['day'][7], 
		'U_MINI_CAL_CALENDAR' => append_sid($phpbb_root_path . 'mycalendar.' . $phpEx),
		'U_MINI_CAL_ADD_EVENT' => append_sid($phpbb_root_path . 'posting.' . $phpEx . '?mode=newtopic&f=' . MINI_CAL_EVENTS_FORUM ), 
        'U_PREV_MONTH' => $prev_month,
        'U_NEXT_MONTH' => $next_month,
        )
    );
    
    // check for birthdays mod
    if ( isset($template->_tpldata['.'][0]['L_WHOSBIRTHDAY_TODAY']) || isset($template->vars['L_WHOSBIRTHDAY_TODAY']) )
    {
        $template->assign_block_vars( 'switch_mini_cal_birthdays', array());
    }
    
    // finally assign our mini_cal stuff to the template engine for output
    $template->assign_var_from_handle('MINI_CAL_OUTPUT', 'usercp_mini_cal_body');
?>
