<?php
/***************************************************************************
 *                                  calendar.php
 *                            -------------------
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/13 15:12:45 mj
 *
 ***************************************************************************/

$phpbb_root_path = './';
define('IN_PHPBB', true);
include_once $phpbb_root_path . 'extension.inc';
include_once $phpbb_root_path . 'common.'.$phpEx;
include_once $phpbb_root_path . 'includes/bbcode.'.$phpEx;

// Start session management
$userdata = session_pagestart($user_ip, PAGE_CALENDAR);
init_userprefs($userdata);

// determine the information for the current date
list($today['year'], $today['month'], $today['day']) = explode('-', create_date('Y-m-d', time(), $board_config['board_timezone']));

// get the month/year offset from the get variables, or else use first day of this month
if (isset($HTTP_GET_VARS['month']) && isset($HTTP_GET_VARS['year'])) {
    $view_isodate = sprintf('%04d', $HTTP_GET_VARS['year']) . '-' . sprintf('%02d', $HTTP_GET_VARS['month']) . '-01 00:00:00';
} 
// get the first day of the month as an isodate
else {
    $view_isodate = $today['year'] . '-' . $today['month'] . '-01 00:00:00';
}

// setup the current view information
$query = "SELECT
             MONTHNAME('$view_isodate') as monthName,
             DATE_FORMAT('$view_isodate', '%m') as month,
             YEAR('$view_isodate') as year,
             DATE_FORMAT(CONCAT(YEAR('$view_isodate'), '-', MONTH('$view_isodate' + INTERVAL 1 MONTH), '-01') - INTERVAL 1 DAY, '%e') as numDays,
             WEEKDAY('$view_isodate') as offset";
$result = $db->sql_query($query);
$monthView = $db->sql_fetchrow($result);
$monthView['monthName'] = $lang['datetime'][$monthView['monthName']];

// [*] is this going to give us a negative number ever?? [*]
if (!$lang['Calendar_start_monday']) {
    $monthView['offset']++;
}

// set the page title and include the page header
$page_title = $lang['Calendar'];
include ($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
    'body' => 'calendar_body.tpl')
);

make_jumpbox('viewforum.'.$phpEx, $forum_id);

// prepare the loops for running through the calendar for the current month
$numRows = ceil(($monthView['numDays'] + $monthView['offset']) / 7);
$day = 1;
$eventStack = array();
$topicCache = array();
$unsetOnNextDay = array();
if ($monthView['offset'] >= 7) $monthView['offset'] = 0;
foreach(range(1, $numRows) as $row) {

    $template->assign_block_vars('date_row', array());
    foreach (range(1, 7) as $weekIndex) {
        // we are before the first date
        if ( ($row == 1 && $weekIndex <= $monthView['offset'] && $monthView['offset'] < 7) ) {
            if ( $weekIndex == 1 ) 
			{
                $template->assign_block_vars('date_row.date_cell', array(
                    'BLANK_COLSPAN' => $monthView['offset'])
                );
                $template->assign_block_vars('date_row.date_cell.switch_blank_cells', array());
            }
        }
        // we are after the last date
        elseif ($day > $monthView['numDays']) {

            if ($day == ($monthView['numDays'] + 1)) {
                $template->assign_block_vars('date_row.date_cell', array(
                    'BLANK_COLSPAN' => ($row * 7) - ($monthView['numDays'] + $monthView['offset']))
                );
                $template->assign_block_vars('date_row.date_cell.switch_blank_cells', array());

                // We have to now increment the day so that we don't repeat this cell
                $day++;
            }
        }
        // we are on a date
        else {
			$format = str_replace("y", "Y", $lang['DATE_INPUT_FORMAT']);
			$eventDate = date($format, mktime( 0, 0, 0, $monthView["month"], $day, $monthView["year"]));


            $template->assign_block_vars('date_row.date_cell', array(
                'TODAY_STYLE' => $today_style, 
                'DATE_CLASS' => ($row % 2) ? 'row2' : 'row3',
                'DATE' => $day,
				'EVENT_DATE' => $eventDate)
            );
            $template->assign_block_vars('date_row.date_cell.switch_date_cells', array());

            // allow the template to handle how to treat the day
            if ($today['day'] == $day && $today['month'] == $monthView['month'] && $today['year'] == $monthView['year']) {
                $template->assign_block_vars('date_row.date_cell.switch_date_cells.switch_date_today', array());
            }
            else {
                $template->assign_block_vars('date_row.date_cell.switch_date_cells.switch_date_otherday', array());
            }

            // set the isodate for our current mark in the calendar (padding day appropriately)
            $current_isodate = $monthView['year'] . '-' . $monthView['month'] . '-' . sprintf('%02d', $day) . ' 00:00:00';

			// Chek if only one type of events needs to be shown
			if (isset($forum_id) && isset($event_type_id))
				$isolateEvent = "ec.forum_id = $forum_id AND ec.event_type_id = $event_type_id AND ";
			else
				$isolateEvent = "";

            $query = "SELECT
                          c.*,
                          t.topic_title,
                          pt.post_text,
                          pt.bbcode_uid,
                          t.topic_views,
                          t.topic_replies,
                          f.forum_name,
                          f.auth_read,
						 ec.*,
                          (cal_interval_units = 'DAY' && cal_interval = 1 && '$current_isodate' = INTERVAL (cal_interval * (cal_repeat - 1)) DAY + cal_date) as block_end
                      FROM
                          " . MYCALENDAR_TABLE . " as c,
                          " . TOPICS_TABLE . " as t,
                          " . FORUMS_TABLE . " as f,
                          " . POSTS_TEXT_TABLE . " as pt,
						  " . MYCALENDAR_EVENT_TYPES_TABLE . " as ec
                      WHERE
						  $isolateEvent
						  ec.forum_id = c.forum_id
						  AND
						  ec.event_type_id = c.event_type_id
						  AND
                          c.forum_id = f.forum_id 
                          AND
                          c.topic_id = t.topic_id 
                          AND
                          f.events_forum > 0 
                          AND
                          pt.post_id = t.topic_first_post_id
                          AND
                          '$current_isodate' >= cal_date
                          AND 
                          (
                              # If the repeat is forever just continue here
                              cal_repeat = 0 
                              OR
                              (
                                  # If the repeat is limited, then make sure we are not past the end
                                  cal_repeat > 0 
                                  AND 
                                  (
                                      (cal_interval_units = 'DAY' AND ('$current_isodate' <= INTERVAL (cal_interval * (cal_repeat - 1)) DAY + cal_date))
                                      OR
                                      (cal_interval_units = 'WEEK' AND ('$current_isodate' <= INTERVAL ((cal_interval * (cal_repeat - 1)) * 7) DAY + cal_date))
                                      OR
                                      (cal_interval_units = 'MONTH' AND ('$current_isodate' <= INTERVAL (cal_interval * (cal_repeat - 1)) MONTH + cal_date))
                                      OR
                                      (cal_interval_units = 'YEAR' AND ('$current_isodate' <= INTERVAL (cal_interval * (cal_repeat - 1)) YEAR + cal_date))
                                  )
                              )
                          )
                          AND 
                          (
                              (
                                  cal_interval_units = 'DAY' 
                                  AND 
                                  (TO_DAYS('$current_isodate') - TO_DAYS(cal_date)) % cal_interval = 0
                              ) 
                              OR 
                              (
                                  cal_interval_units = 'WEEK' 
                                  AND
                                  (TO_DAYS('$current_isodate') - TO_DAYS(cal_date)) % (7 * cal_interval) = 0
                              )
                              OR 
                              (
                                  cal_interval_units = 'MONTH' 
                                  AND
                                  DAYOFMONTH(cal_date) = DAYOFMONTH('$current_isodate') 
                                  AND
                                  PERIOD_DIFF(DATE_FORMAT('$current_isodate', '%Y%m'), DATE_FORMAT(cal_date, '%Y%m')) % cal_interval = 0
                              )
                              OR 
                              (
                                  cal_interval_units = 'YEAR' 
                                  AND
                                  DATE_FORMAT(cal_date, '%m%d') = DATE_FORMAT('$current_isodate', '%m%d') 
                                  AND
                                  (YEAR('$current_isodate') - YEAR(cal_date)) % cal_interval = 0
                              )
                          )
                      ORDER BY
                          cal_interval_units ASC,
                          cal_date ASC,
                          cal_repeat DESC";
 
			 if (!$result = $db->sql_query($query)) {
                message_die(GENERAL_ERROR, 'Error querying dates for calendar.');
            }

            $numEvents = 0;
			// Unset event stack for those events that ended
			for ($i = 0; $i < count($unsetOnNextStep); $i++)
			{
				if ($unsetOnNextStep[$i] != -1) 
				{
					unset($eventStack[$unsetOnNextStep[$i]]);
					$unsetOnNextStep[$i] = -1;
				}
			}
            while ($topic = $db->sql_fetchrow($result)) {

                $is_auth = array();
                $is_auth = auth(AUTH_ALL, $topic['forum_id'], $userdata);
                if ( $is_auth['auth_read'] ) { 
					// If viewer cannot post then he shouldn't see suggested events on calendar
					if (!$is_auth['auth_post'] && $topic['confirmed'] == 'N')
						continue;
                    $topic_id = $topic['topic_id'];
                    // prepare the first post text if it has not already been cached
                    if (!isset($topicCache[$topic_id])) {
                        $post_text = $topic['post_text'];
                        // if we are spilling over, reduce size...[!] should be configurable [!]
                        if (strlen($post_text) > 200) {
                            $post_text = substr($post_text, 0, 199) . '...';
                        }
                        $post_text = bbencode_second_pass($post_text, $topic['bbcode_uid']);
                        $post_text = smilies_pass($post_text); 
                        $post_text = preg_replace("/[\n\r]{1,2}/", '<br />', $post_text);

                        // prepare the popup text, escaping quotes for javascript
                        $title_text = '<b>' . $lang['Topic'] . ':</b> ' . $topic['topic_title'] . '<br /><b>' . $lang['Forum'] . ':</b> <i>' . $topic['forum_name'] . '</i><br /><b>' . $lang['Views'] . ':</b> ' . $topic['topic_views'] . '<br /><b>' . $lang['Replies'] . ':</b> ' . $topic['topic_replies'];
                        // tack on the interval and repeat if this is a repeated event
                        if ($topic['cal_repeat'] != 1) {
                            $title_text .= '<br /><b>' . $lang['Calendar_interval'] . ':</b> ' . $topic['cal_interval'] . ' ' . (($topic['cal_interval'] == 1) ? $lang['interval'][strtolower($topic['cal_interval_units'])] : $lang['interval'][strtolower($topic['cal_interval_units']) . 's']). '<br /><b>' . $lang['Calendar_repeat'] . ':</b> ' . ($topic['cal_repeat'] ? $topic['cal_repeat'] . 'x' : 'always');
                        }

                        $title_text .= '<br />' . $post_text;
                        $title_text = str_replace(array('"', '\''), array('&quot;', '\\\''), $title_text);
                        // make the url for the topic
                        $topic_url = append_sid('viewtopic.' . $phpEx . '?' . POST_TOPIC_URL . '=' . $topic_id);
                        $topicCache[$topic_id] = array(
                            'first_post' => $title_text,
                            'topic_url'  => $topic_url,
                        );
                    }


					$bgColor = ($topic["confirmed"] == 'Y' ? $topic["highlight_color"] : "#C8C8C8");
					$color = ($topic["confirmed"] == 'Y' ? "" : "color: #8D8D8D");
					// Now make sure color stands out on dark backgrounds
					$colorR = hexdec(substr($bgColor, 1, 2));
					$colorG = hexdec(substr($bgColor, 3, 2));
					$colorB = hexdec(substr($bgColor, 5, 2));
					if (($colorR + $colorG + $colorB) / 3.0 < 140.0)
					{
						$color = "color: White"; 
					}

					$class = "";
                    // if we have a block event running (interval = 1 day) with this topic ID, then output our line
                    if (isset($eventStack[$topic_id])) {
                        $first_date = '';
                        $topic_text = "<FONT COLOR = '$bgColor'>".(strlen($topic['topic_title']) > 50 ? substr($topic['topic_title'], 0, 48) . '...' : $topic['topic_title'])."</FONT>";
                        // we have to determine if we are in the right row...which is the value
                        // in the eventStack array
                        $offset = $eventStack[$topic_id] - $numEvents;
                        // if this block was running in a position other than the first, we need
                        // to correct the offset so the line keeps running along the same axis..
                        // even though the upper block has stopped.  We are going to get a 
                        // cascading effect from this until all overlapping block events stop
                        for ($offsetCount = 0; $offsetCount < $offset; $offsetCount++ ) 
						{
							$template->assign_block_vars('date_row.date_cell.switch_date_cells.date_event', array(
								'U_EVENT' => "<div class='transparent'>".$textStack[$numEvents]."</div>\n\t<div style='height: 1px;'><IMG SRC='dot.gif' WIDTH='1' HEIGHT='1' BORDER=0></div>")
							);
							$numEvents++;
						}
                    }
                    // this is either a single day event or the start of a new block event
                    else 
					{
                        $topic_text = strlen($topic['topic_title']) > 50 ? substr($topic['topic_title'], 0, 48) . '...' : $topic['topic_title'];
						$class = "class = 'block_start'";
                    }
					if ($topic['block_end']) $class = ($class == "" ? "class = 'block_end'" : "class = 'block_single'");


                    $template->assign_block_vars('date_row.date_cell.switch_date_cells.date_event', array(
                        'U_EVENT' => "<a href=\"" . $topicCache[$topic_id]['topic_url']."&back_to_calendar=calendar.$phpEx?month=".$monthView["month"]."%26year=".$monthView["year"]. "\" onMouseOver=\"createTitle(this, '" . $topicCache[$topic_id]['first_post'] . "', event.pageX, event.pageY);\" onMouseOut=\"destroyTitle();\" class=\"gensmall\"><div BGCOLOR = '$bgColor' ALIGN = 'left' $class style='background-color: $bgColor;$color'>$topic_text</div></a>\n\t<div style='height: 1px;'><IMG SRC='dot.gif' WIDTH='1' HEIGHT='1' BORDER=0></div>")
                    );
                    $numEvents++;

                    // Here I use a stack of sorts to keep track of block events which are
                    // still running...I sort the block start dates by date, so the overlaps
                    // will always appear in the same order...if a block ends while a lower block
                    // continues, I keep a place holder so that the line continues along the same
                    // path

                    // we are at the end of a block event
					$unsetOnNextStep[$numEvents-1] = -1;
                    if ($topic['block_end']) {
						// It is important to unset stack on the NEXT STEP, NOT NOW, since it would create
						// problems in alignment
						$unsetOnNextStep[$numEvents-1] = $topic_id;
                    }
                    // we place an entry in the event stack, key as the topic, value as the row
                    // number the event should fall in, for visual block events (interval = 1 day)
                    if (!isset($eventStack[$topic_id]) && $topic['cal_interval_units'] == 'DAY' && $topic['cal_interval'] == 1) {
                        $eventStack[$topic_id] = empty($eventStack) ? 0 : sizeof($eventStack);
						$textStack[$eventStack[$topic_id]] = strlen($topic['topic_title']) > 50 ? substr($topic['topic_title'], 0, 48) . '...' : $topic['topic_title'];
                    }
                }
            }
			// This is to fix Mac IE bug that expands cell if there is nothing in it
			if ($numEvents == 0)
			{
                    $template->assign_block_vars('date_row.date_cell.switch_date_cells.date_event', array(
                        'U_EVENT' => "&nbsp;")
                    );
			}

		// User Birthdays
		$query = "select user_id, username, DATE_FORMAT(FROM_DAYS(TO_DAYS(NOW())-TO_DAYS(date_add(\"1970-01-01\", interval(user_birthday) day))), '%Y')+1 as birthday 
		FROM ".USERS_TABLE." u
		WHERE month(date_add(\"1970-01-01\", interval(user_birthday) day)) = '".$monthView['month']."'
	      AND	dayofmonth(date_add(\"1970-01-01\", interval(user_birthday) day)) = '$day'
	      AND user_birthday < '999999';";

		if (!$result = $db->sql_query($query)) 
		{ 
			message_die(GENERAL_ERROR, 'Error querying birthdays for calendar.'); 
		} 

		while ($topic = $db->sql_fetchrow($result)) { 
		$topic_text = $lang['Birthday']; 
		$username = $topic['username']; 
		$user_id = $topic['user_id']; 
		$birthday = $topic['birthday']; 
	
		$template->assign_block_vars('date_row.date_cell.switch_date_cells.date_event', array( 
			'U_EVENT' => "$first_date<a href=\"profile.php?mode=viewprofile&u=$user_id\" onMouseOver=\"createTitle(this, '<b>$topic_text:</b> $username<br>Congratulations to $username on your birthday.', event.pageX, event.pageY);\" onMouseOut=\"destroyTitle();\" class=\"gensmall\">$topic_text: $username</a>") 
			); 
		} 
            // Increment the day
            $day++;
        }
    }
}

if ($monthView['month'] == '12') {
    $nextmonth = 1;
    $nextyear = $monthView['year'] + 1; 
} 
else {
    $nextmonth = sprintf('%02d', $monthView['month'] + 1);
    $nextyear = $monthView['year'];
}

if ($monthView['month'] == '01') {
    $previousmonth = '12';
    $previousyear = $monthView['year'] - 1;
} 
else {
    $previousmonth = sprintf('%02d', $monthView['month'] - 1); 
    $previousyear = $monthView['year'];
}

// prepare images and links for month navigation
$image_prev_month = "<img src=\"" . $images['icon_left_arrow'] . "\" align=\"middle\" border=\"0\" title=\"{$lang['View_previous_month']}\" alt=\"" . $lang['View_previous_month'] . "\" />";
$image_next_month = "<img src=\"" . $images['icon_right_arrow'] . "\" align=\"middle\" border=\"0\" title=\"{$lang['View_next_month']}\" alt=\"" . $lang['View_next_month'] . "\" />";
$url_prev_month = append_sid('calendar.' . $phpEx . "?month=$previousmonth&amp;year=$previousyear");
$url_next_month = append_sid('calendar.' . $phpEx . "?month=$nextmonth&amp;year=$nextyear");

$image_prev_year = "<img src=\"" . $images['icon_double_left_arrow'] . "\" align=\"middle\" border=\"0\" title=\"{$lang['View_previous_year']}\" alt=\"" . $lang['View_previous_year'] . "\" />";
$image_next_year = "<img src=\"" . $images['icon_double_right_arrow'] . "\" align=\"middle\" border=\"0\" title=\"{$lang['View_next_year']}\" alt=\"" . $lang['View_next_year'] . "\" />";
$url_prev_year = append_sid('calendar.' . $phpEx . '?month=' . $monthView['month'] . '&amp;year=' . ($monthView['year'] - 1));
$url_next_year = append_sid('calendar.' . $phpEx . '?month=' . $monthView['month'] . '&amp;year=' . ($monthView['year'] + 1));

if ($lang['Calendar_start_monday']) {
    $template->assign_block_vars('switch_sunday_end', array());
}
else {
    $template->assign_block_vars('switch_sunday_beginning', array());
}

$template->assign_vars(array(
    'L_SUNDAY' => $lang['datetime']['Sunday'],
    'L_MONDAY' => $lang['datetime']['Monday'],
    'L_TUESDAY' => $lang['datetime']['Tuesday'],
    'L_WEDNESDAY' => $lang['datetime']['Wednesday'],
    'L_THURSDAY' => $lang['datetime']['Thursday'],
    'L_FRIDAY' => $lang['datetime']['Friday'],
    'L_SATURDAY' => $lang['datetime']['Saturday'],
    'L_CURRENT_MONTH' => $monthView['monthName'],
    'L_CURRENT_YEAR' => $monthView['year'],
    'L_ADD_EVENT' => $lang['Calendar_add_event'],
    'I_PREV_MONTH' => $image_prev_month,
    'I_NEXT_MONTH' => $image_next_month,
    'U_PREV_MONTH' => $url_prev_month,
    'U_NEXT_MONTH' => $url_next_month,
    'I_PREV_YEAR'  => $image_prev_year,
    'I_NEXT_YEAR'  => $image_next_year,
    'U_PREV_YEAR'  => $url_prev_year,
    'U_NEXT_YEAR'  => $url_next_year,
    )
);

// Add event type legend now
$query = "SELECT * FROM " . MYCALENDAR_EVENT_TYPES_TABLE . "";
if (!$result = $db->sql_query($query)) {
	message_die(GENERAL_ERROR, 'Error retrieving event type information.');
}

$legend = "<TABLE style='border: 0px solid Black;' border='0' cellpadding='0' cellspacing='0'><TR><TD class=\"gensmall\"><A class=\"nav\" HREF = \"".append_sid("calendar.$phpEx?month=".$monthView["month"]."&year=".$monthView["year"])."\">Legend:</A>&nbsp;&nbsp;</TD><TD><TABLE  style='border-bottom: 1px solid Black;border-left: 1px solid Black;border-right: 0px solid Black;border-top: 1px solid Black;' border='1' cellpadding='1' cellspacing='0'><TR>";
while ($row = $db->sql_fetchrow($result)) 
{
	$event_type_text = str_replace(" ", "&nbsp;", $row["event_type_text"]);
	$event_type_text = str_replace("\n", "&nbsp;", $event_type_text);
	$event_type_text = str_replace("\t", "&nbsp;", $event_type_text);
	// Now make sure color stands out on dark backgrounds
	$colorR = hexdec(substr($row["highlight_color"], 1, 2));
	$colorG = hexdec(substr($row["highlight_color"], 3, 2));
	$colorB = hexdec(substr($row["highlight_color"], 5, 2));
	if (($colorR + $colorG + $colorB) / 3.0 < 140.0)
		$color = "color: White"; 
	else
		$color = "";
	$bgColor = $row["highlight_color"];

	$isolate_forum_id = $row["forum_id"];
	$isolate_event_type_id = $row["event_type_id"];
	if (isset($forum_id) && isset($event_type_id))
	{
		if (!($isolate_forum_id == $forum_id) || !($isolate_event_type_id == $event_type_id))
		{
			$color = "color: White"; 
			$bgColor = "#A6A6A6";
		}
	}

	$legend .= "<TD style='border-bottom: 0px solid Black;border-left: 0px solid Black;border-right: 1px solid Black;border-top: 0px solid Black;' class=\"gensmall\" BGCOLOR = '$bgColor'><A class=\"gensmall\" HREF = \"".append_sid("calendar.$phpEx?month=".$monthView["month"]."&year=".$monthView["year"]."&forum_id=$isolate_forum_id&event_type_id=$isolate_event_type_id")."\"><div BGCOLOR = '$bgColor' ALIGN = 'left' style='background-color: $bgColor;$color'>$event_type_text</DIV></A></TD>\n";
}
$legend .= "</TR></TABLE></TD></TR></TABLE>";

// Now set up forum chooser
//<INPUT TYPE = "hidden" name = "f" value = "{FORUM_ID}">
$forumOptions = "$lang[Calendar_post_event] <SELECT NAME = \"f\">\n";
$query = "SELECT * FROM ". FORUMS_TABLE. " WHERE events_forum = 1";
if (!$result = $db->sql_query($query)) {
	message_die(GENERAL_ERROR, 'Error retrieving list of event forums.');
}
$flag = true;
while ($row = $db->sql_fetchrow($result))
{
	$forum_id = $row["forum_id"];
	$forum_name = $row["forum_name"];
	$forumOptions .= "<OPTION VALUE = \"$forum_id\" ";
	if ($flag)
	{
		$forumOptions .= "SELECTED ";
		$flag = false;
	}
	$forumOptions .= ">$forum_name</OPTION>\n";
}
$forumOptions .= "</SELECT>&nbsp;&nbsp;&nbsp;\n";


$template->assign_vars(array(
      'LEGEND'  => $legend,
	'FORUM_CHOOSER' => $forumOptions,
	'SESSION_ID' => $sid,
	'BACK_TO_CALENDAR' => "calendar.$phpEx?month=".$monthView["month"]."&year=".$monthView["year"],
	'FORUM_NAME' => $row["forum_name"]
	)
);


$template->pparse('body');
 
include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
?>
