<?php
/***************************************************************************
 *                              banlist.php
 *                            -------------------
 *   begin                : Friday, May 11, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: banlist.php,v 1.36.2.2 2002/07/29 05:04:03 dougk_ff7 Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/06/29 15:33:45 krystal
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_BANLIST);
init_userprefs($userdata);
//
// End session management
//

if ( !$userdata['session_logged_in'] ) 
{ 
	redirect("login.".$phpEx."?redirect=banlist.".$phpEx); 
	exit; 
} 

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = 'ban_userid';
}

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

//
// Banlist sorting
//
$mode_types_text = array($lang['Sort_Username'], $lang['Reason'], $lang['Ban_By'], $lang['Date'], $lang['Time']);
$mode_types = array('username', 'reason', 'banedby', 'date', 'time');

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

//
// Generate page
//
$page_title = $lang['Ban'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'banlist_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],
	'L_SUBMIT' => $lang['Sort'],

	'L_BAN_REASON' => $lang['Reason'],
	'L_BAN_BY' => $lang['Ban_By'],
	'L_BANNED' => $lang['When_Banned'],
	'L_DATE' => $lang['Date'],
	'L_TIME' => $lang['Time'],

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_MODE_ACTION' => append_sid("banlist.$phpEx"))
);

switch( $mode )
{
	case 'username':
		$order_by = "user_name $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'reason':
		$order_by = "reason $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'banedby':
		$order_by = "baned_by $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'date':
		$order_by = "date $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'time':
		$order_by = "time $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	default:
		$order_by = "ban_userid $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
}

$sql = "SELECT ban_userid, user_name, reason, baned_by, date, time
	FROM " . BANLIST_TABLE . "
	WHERE ban_userid <> 0
	ORDER BY $order_by";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
        if ($row['reason'] == "")
        $reason = $lang['No_reason'];
        else
        $reason = $row['reason'];
        $by = $row['baned_by'];
	  $in = $lang['Date'].": ".$row['date']."<br />".$lang['Time'].": ".$row['time'];
	  $row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
	  $row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

  	  $template->assign_block_vars('banlistrow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'USERNAME' => $row['user_name'],
			'BY' => $by,
			'IN' => $in,
			'REASON' => $reason,
			'U_VIEWPROFILE2' => append_sid("profile.$phpEx?mode=viewprofile&".POST_USERS_URL."=".$row['baned_by']),
			'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&".POST_USERS_URL."=".$row['ban_userid']))
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . BANLIST_TABLE . "
		WHERE ban_userid <> 0";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_members = $total['total'];

		$pagination = generate_pagination("banlist.$phpEx?mode=$mode&amp;order=$sort_order", $total_members, $board_config['topics_per_page'], $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_members = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_members / $board_config['topics_per_page'] )),

	'L_GOTO_PAGE' => $lang['Goto_page'])
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>