<?php
/***************************************************************************
 *                              admin_referral_log.php
 *                            -------------------
 *   begin                : Friday, June 8, 2002
 *   copyright           : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *   created by         : John B. Abela <abela@phpbb.com>
 *
 *
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/**************************************************************************
*	This file will be used for displaying the referrals log
**************************************************************************/
define('IN_PHPBB', 1);
//
// First we do the setmodules stuff for the admin cp.
//
if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Referrals']['User_referals'] = $file;
	return;
}
//
// load default header
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
//
// load language file
//
if ( !empty($board_config['default_lang']) )
{
    include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_referral.'.$phpEx);
}
else
{
    include($phpbb_root_path . 'language/lang_english/lang_referral.'.$phpEx);
}
//
// start switch
//
if( $mode != "" )
{
	if( $mode == "edit" || $mode == "add" )
	{
		$word_id = ( isset($HTTP_GET_VARS['id']) ) ? $HTTP_GET_VARS['id'] : 0;

		$template->pparse("body");

		include('./page_footer_admin.'.$phpEx);
	}
}
else
{
	$template->set_filenames(array(
		"body" => "admin/referral_list_body.tpl")
	);

	$sql = "SELECT * 
		FROM " . REFERRAL_TABLE . " 
		ORDER BY referral_id DESC";
	if( !$result = $db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Could not query referral table", $lang['Error'], __LINE__, __FILE__, $sql);
	}

	$referral_rows = $db->sql_fetchrowset($result);
	$referral_count = count($referral_rows);

	$template->assign_vars(array(
		"L_REFERRAL_TITLE" => $lang['Referral_Admin_Title'],
		"L_REFERRAL_DESCRIPTION" => $lang['Referral_Admin_Explain'],
		"L_REFERRAL_R_NAME" => $lang['Referral_Admin_Referral_Name'],
        "L_REFERRAL_N_NAME" => $lang['Referral_Admin_New_Name'],
		"L_REFERRAL_DATETIME" => $lang['Referral_Admin_DateTime']
        )
	);

	for($i = 0; $i < $referral_count; $i++)
	{
        // GET REFERRAL USER DATA
        $ruid = $referral_rows[$i]['ruid'];
        settype($ruid, "integer");
        //
        $this_userdata = get_userdata($ruid);
		if( !$this_userdata )
		{
			$referred_username = $lang['Referral_Admin_User_Delete'];
		}
		else
		{
			$temp_url = append_sid("../profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=".$this_userdata['user_id']."");
			$referred_username = '<a href="' . $temp_url . '">' . $this_userdata['username'] . '</a>'. ' (' .$lang['Referral_Admin_User_ID'] . ' ' . $this_userdata['user_id'] . ')';
		}
        //
        // GET NEW USER DATA
        $nuid = $referral_rows[$i]['nuid'];
        settype($nuid, "integer");
        //
        $new_userdata = get_userdata($nuid);
		if( !$new_userdata )
		{
			$new_username = $lang['Referral_Admin_User_Delete'];
		}
		else
		{
			$temp_url = append_sid("../profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=".$new_userdata['user_id']."");
			$new_username = '<a href="' . $temp_url . '">' . $new_userdata['username'] . '</a>'. ' (' .$lang['Referral_Admin_User_ID'] . ' ' . $new_userdata['user_id'] . ')';
		}
        //
        //
        //
        $referral_date = create_date($board_config['default_dateformat'], $referral_rows[$i]['referral_time'], $board_config['board_timezone']);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars("words", array(
			"ROW_COLOR" => "#" . $row_color,
			"ROW_CLASS" => $row_class,
			"REFERRED_USER" => $referred_username,
            "NEW_USER" => $new_username,
			"REPLACEMENT" => $referral_date
            )
		);
	}
}

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>