<?php
/***************************************************************************
 *                              admin_referral_config.php
 *                            -------------------
 *   begin                : Wednesday, June, 2003
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : abela@phpbb.com
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Referrals']['Referral_Settings'] = $file;
    return;
}

//
// Load default header
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);

//
// set language file
//
if ( !empty($board_config['default_lang']) )
{
    include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_referral.'.$phpEx);
}
else
{
    include($phpbb_root_path . 'language/lang_english/lang_referral.'.$phpEx);
}

//
// begin mode
//
if( $mode != "" )
{
    if( $mode == "update" )
	{        
        //
        // Pull all config data
        //
        $sql = "SELECT *
            FROM " . CONFIG_TABLE;
        if(!$result = $db->sql_query($sql))
        {
            message_die(CRITICAL_ERROR, "Could not query config information.", "", __LINE__, __FILE__, $sql);
        }
        else
        {
            while( $row = $db->sql_fetchrow($result) )
            {
                $config_name = $row['config_name'];
                $config_value = $row['config_value'];
                $default_config[$config_name] = $config_value;
                
                $new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

                if( isset($HTTP_POST_VARS['submit']) )
                {
                    $sql = "UPDATE " . CONFIG_TABLE . " SET
                        config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
                        WHERE config_name = '$config_name'";
                    if( !$db->sql_query($sql) )
                    {
                        message_die(GENERAL_ERROR, "Failed to update general configuration for $config_name within the Referral Settings MOD", "", __LINE__, __FILE__, $sql);
                    }
                }
            }

            if( isset($HTTP_POST_VARS['submit']) )
            {
                $message .= "" . sprintf($lang['Click_return_referral_settings'], "<a href=\"" . append_sid("admin_referral_config.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

                message_die(GENERAL_MESSAGE, $message);
            }
        }

    }
}
else
{
    //
    // build page
    //    
    $template->set_filenames(array(
		"body" => "admin/referral_config_body.tpl")
	);
    //
    //
    if ($board_config['referral_enable'] == '0')
    {
        $Referral_value_text = $lang['Yes'];
        $Referral_value = '0';
    }
    else
    {
        $Referral_value_text = $lang['No'];
        $Referral_value = '1';
    }

    $template->assign_vars(array(
        "L_REFERRAL_ENABLE" => $lang['Referral_Enable'],
        "L_REFERRAL_TITLE" => $lang['Referral_Admin_Title'],
	  "L_REFERRAL_TITLE_EXPLAIN" => $lang['Referral_Admin_Title_Explain'],
	  "L_REFERRAL_DEFAULT_USER_ID" => $lang['Referral_Default_user_id'],
        "L_REFERRAL_DEFAULT_USER_ID_EXPLAIN" => $lang['Referral_Default_user_id_Explain'],
        //
        "REFERRAL_VALUE" => $Referral_value,
        "REFERRAL_DEFAULT_USER_ID" => $board_config['referral_id'],
        "REFERRAL_VALUE_TEXT" => $Referral_value_text,
        "L_REFERRAL_VALUE_TEXT_NO" => $lang['No'],
        "L_REFERRAL_VALUE_TEXT_YES" => $lang['Yes'],
        "L_SUBMIT" => $lang['Submit'],
        //
	  "S_WORDS_ACTION" => append_sid("admin_referral_config.$phpEx"),
	  "S_HIDDEN_FIELDS" => '<input type="hidden" name="mode" value="update" />')
	);

}

$template->pparse("body");

include('./page_footer_admin.'.$phpEx);

?>