<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

define('IN_PHPBB', 1);
define('IN_PA_CONFIG_ADMIN', 1);
if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Download'][$lang['Settings']] = "$file";
	return;
}

$phpbb_root_path = "./../";

require($phpbb_root_path . 'extension.inc');

require('./pagestart.' . $phpEx);

include($phpbb_root_path . 'pafiledb/pafiledb_common.'.$phpEx);

$template->set_filenames(array(
	'admin' => 'admin/pa_admin_settings.tpl')
);  

if ( isset($HTTP_GET_VARS['settings']) || isset($HTTP_POST_VARS['settings']) )
{
	$settings = ( isset($HTTP_GET_VARS['settings']) ) ? $HTTP_GET_VARS['settings'] : $HTTP_POST_VARS['settings'];
}


$sql = "SELECT *
	FROM " . PA_CONFIG_TABLE;

if(!$result = $db->sql_query($sql))
{
	message_die(CRITICAL_ERROR, "Could not query config information in admin_board", "", __LINE__, __FILE__, $sql);
}
else
{
	while( $row = $db->sql_fetchrow($result) )
	{
		$config_name = $row['config_name'];
		$config_value = $row['config_value'];
		$default_config[$config_name] = $config_value;
				
		$new[$config_name] = ( isset($HTTP_POST_VARS[$config_name]) ) ? $HTTP_POST_VARS[$config_name] : $default_config[$config_name];

		if( isset($HTTP_POST_VARS['submit']) )
		{
			$sql = "UPDATE " . PA_CONFIG_TABLE . " SET
				config_value = '" . str_replace("\'", "''", $new[$config_name]) . "'
				WHERE config_name = '$config_name'";
			if( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, "Failed to update pafiledb configuration for $config_name", "", __LINE__, __FILE__, $sql);
			}
		}
	}
	if( isset($HTTP_POST_VARS['submit']) )
	{

		$message = $lang['Settings_changed'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_settings.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

		message_die(GENERAL_MESSAGE, $message); 
	}
}

$pafiledb_template->compile_cache_clear();

$cache_dir = $phpbb_root_path . 'pafiledb/cache';
$cache_file = $cache_dir . '/pafiledb_config.php';

if ((file_exists($cache_dir)) && (is_dir($cache_dir)))
{
	if (file_exists($cache_file))
	{
		@unlink($cache_file);
	}
}

if (empty($settings)) 
{
	$view_all_yes = ($new['settings_viewall']) ? ' selected' : '';
	$view_all_no = (!$new['settings_viewall']) ? ' selected' : '';
	
	$download_disable_yes = ($new['settings_disable']) ? ' selected' : '';
	$download_disable_no = (!$new['settings_disable']) ? ' selected' : '';

	$hotlink_prevent_yes = ($new['hotlink_prevent']) ? ' selected' : '';
	$hotlink_prevent_no = (!$new['hotlink_prevent']) ? ' selected' : '';	

	$php_template_yes = ($new['settings_tpl_php']) ? ' selected' : '';
	$php_template_no = (!$new['settings_tpl_php']) ? ' selected' : '';	
	
	$allow_html_yes = ($new['allow_html']) ? ' selected' : '';
	$allow_html_no = (!$new['allow_html']) ? ' selected' : '';
	
	$allow_bbcode_yes = ($new['allow_bbcode']) ? ' selected' : '';
	$allow_bbcode_no = (!$new['allow_bbcode']) ? ' selected' : '';
	
	$allow_smilies_yes = ($new['allow_smilies']) ? ' selected' : '';
	$allow_smilies_no = (!$new['allow_smilies']) ? ' selected' : '';	

	$allow_comment_links_yes = ($new['allow_comment_links']) ? ' selected' : '';
	$allow_comment_links_no = (!$new['allow_comment_links']) ? ' selected' : '';
	
	$allow_comment_images_yes = ($new['allow_comment_images']) ? ' selected' : '';
	$allow_comment_images_no = (!$new['allow_comment_images']) ? ' selected' : '';
	
	$template->assign_vars(array(
		'S_SETTINGS_ACTION' => append_sid("admin_pa_settings.$phpEx"),
		'L_FILE_IN_PAGE' => $lang['File_per_page'],
		'L_FILE_IN_PAGE_INFO' => $lang['File_per_page_info'],
		'L_HOTLINK' => $lang['Hotlink_prevent'],
		'L_HOTLINK_INFO' => $lang['Hotlinl_prevent_info'],
		'L_HOTLINK_ALLOWED' => $lang['Hotlink_allowed'],
		'L_HOTLINK_ALLOWED_INFO' => $lang['Hotlink_allowed_info'],
		'L_SETTINGS' => $lang['Settings'],
		'L_SETTINGSTITLE' => $lang['Settingstitle'],
		'L_SETTINGSEXPLAIN' => $lang['Settingsexplain'],
		'L_PHP_TPL' => $lang['Php_template'],
		'L_PHP_TPL_INFO' => $lang['Php_template_info'],
		'L_DBNAME' => $lang['Dbname'],
		'L_DBNAMEINFO' => $lang['Dbnameinfo'],
		'L_TOPNUM' => $lang['Topnum'],
		'L_TOPNUMINFO' => $lang['Topnuminfo'],
		'L_NFDAYS' => $lang['Nfdays'],
		'L_NFDAYSINFO' => $lang['Nfdaysinfo'],
		'L_COMMENT_SETTINGS' => $lang['Com_settings'],
		'L_SHOW_VIEWALL' => $lang['Showva'],
		'L_VIEWALL_INFO' => $lang['Showvainfo'],
		'L_DISABLE' => $lang['Dbdl'],
		'L_DISABLE_INFO' => $lang['Dbdlinfo'],
		'L_ALLOW_HTML' => $lang['Com_allowh'],
		'L_ALLOW_BBCODE' => $lang['Com_allowb'],
		'L_ALLOW_SMILIES' => $lang['Com_allows'],
		'L_ALLOW_LINKS' => $lang['Com_allowl'],
		'L_LINKS_MESSAGE' => $lang['Com_messagel'],
		'L_LINKS_MESSAGE_INFO' => $lang['Com_messagel_info'],
		'L_ALLOW_IMAGE' => $lang['Com_allowi'],
		'L_IMAGE_MESSAGE' => $lang['Com_messagei'],
		'L_MAX_CHAR' => $lang['Max_char'],
		'L_MAX_CHAR_INFO' => $lang['Max_char_info'],
		'L_IMAGE_MESSAGE_INFO' => $lang['Com_messagei_info'],
		'L_RESET' => $lang['Reset'],
		'L_SUBMIT' => $lang['Submit'],
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_DEFAULT_SORT_METHOD' => $lang['Default_sort_method'],
		'L_DEFAULT_SORT_ORDER' => $lang['Default_sort_order'],
		'L_RATING' => $lang['DlRating'],
		'L_DOWNLOADS' => $lang['Dls'],
		'L_DATE' => $lang['Date'],
		'L_NAME' => $lang['Name'],
		'L_UPDATE_TIME' => $lang['Update_time'],
		'L_ASC' => $lang['Sort_Ascending'],
		'L_DESC' => $lang['Sort_Descending'],

		'SETTINGS_DBNAME' => $new['settings_dbname'],
		'SETTINGS_FILE_PAGE' => $new['settings_file_page'],
		'HOTLINK_ALLOWED' => $new['hotlink_allowed'],
		'SETTINGS_TOPNUMBER' => $new['settings_topnumber'],
		'SETTINGS_NEWDAYS' => $new['settings_newdays'],
		'SETTINGS_TOPNUMBER' => $new['settings_topnumber'],
		'MESSAGE_LINK' => $new['no_comment_link_message'],
		'MAX_CHAR' => $new['max_comment_chars'],
		'MESSAGE_IMAGE' => $new['no_comment_image_message'],
		
		'SORT_NAME' => ($new['sort_method'] == 'file_name') ? 'selected="selected"' : '',
		'SORT_TIME' => ($new['sort_method'] == 'file_time') ? 'selected="selected"' : '',
		'SORT_RATING' => ($new['sort_method'] == 'file_rating') ? 'selected="selected"' : '',
		'SORT_DOWNLOADS' => ($new['sort_method'] == 'file_dls') ? 'selected="selected"' : '',
		'SORT_UPDATE_TIME' => ($new['sort_method'] == 'file_update_time') ? 'selected="selected"' : '',

		'SORT_ASC' => ($new['sort_order'] == 'ASC') ? 'selected="selected"' : '',
		'SORT_DESC' => ($new['sort_order'] == 'DESC') ? 'selected="selected"' : '',

		'S_VIEW_ALL_YES' => $view_all_yes,
		'S_VIEW_ALL_NO' => $view_all_no,
		'S_DISABLE_YES' => $download_disable_yes,
		'S_DISABLE_NO' => $download_disable_no,
		'S_PHP_TPL_YES' => $php_template_yes,
		'S_PHP_TPL_NO' => $php_template_no,
		'S_HOTLINK_YES' => $hotlink_prevent_yes,
		'S_HOTLINK_NO' => $hotlink_prevent_no,
		'S_ALLOW_HTML_YES' => $allow_html_yes,
		'S_ALLOW_HTML_NO' => $allow_html_no,
		'S_ALLOW_BBCODE_YES' => $allow_bbcode_yes,
		'S_ALLOW_BBCODE_NO' => $allow_bbcode_no,
		'S_ALLOW_SMILIES_YES' => $allow_smilies_yes,
		'S_ALLOW_SMILIES_NO' => $allow_smilies_no,
		'S_ALLOW_LINKS_YES' => $allow_comment_links_yes,
		'S_ALLOW_LINKS_NO' => $allow_comment_links_no,
		'S_ALLOW_IMAGES_YES' => $allow_comment_images_yes,
		'S_ALLOW_IMAGES_NO' => $allow_comment_images_no)
	);                 
}

$template->pparse('admin');

include('./page_footer_admin.'.$phpEx);
?>
